<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/accessapproval/v1/accessapproval.proto

namespace Google\Cloud\AccessApproval\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request for the customer to approve access to a resource.
 *
 * Generated from protobuf message <code>google.cloud.accessapproval.v1.ApprovalRequest</code>
 */
class ApprovalRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request_id}".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     *
     * Generated from protobuf field <code>string requested_resource_name = 2;</code>
     */
    private $requested_resource_name = '';
    /**
     * Properties related to the resource represented by requested_resource_name.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;</code>
     */
    private $requested_resource_properties = null;
    /**
     * The justification for which approval is being requested.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    private $requested_reason = null;
    /**
     * The locations for which approval is being requested.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    private $requested_locations = null;
    /**
     * The time at which approval was requested.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    private $request_time = null;
    /**
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    private $requested_expiration = null;
    protected $decision;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the request. Format is
     *           "{projects|folders|organizations}/{id}/approvalRequests/{approval_request_id}".
     *     @type string $requested_resource_name
     *           The resource for which approval is being requested. The format of the
     *           resource name is defined at
     *           https://cloud.google.com/apis/design/resource_names. The resource name here
     *           may either be a "full" resource name (e.g.
     *           "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     *           resource name (e.g. "shelves/shelf1/books/book2") as described in the
     *           resource name specification.
     *     @type \Google\Cloud\AccessApproval\V1\ResourceProperties $requested_resource_properties
     *           Properties related to the resource represented by requested_resource_name.
     *     @type \Google\Cloud\AccessApproval\V1\AccessReason $requested_reason
     *           The justification for which approval is being requested.
     *     @type \Google\Cloud\AccessApproval\V1\AccessLocations $requested_locations
     *           The locations for which approval is being requested.
     *     @type \Google\Protobuf\Timestamp $request_time
     *           The time at which approval was requested.
     *     @type \Google\Protobuf\Timestamp $requested_expiration
     *           The requested expiration for the approval. If the request is approved,
     *           access will be granted from the time of approval until the expiration time.
     *     @type \Google\Cloud\AccessApproval\V1\ApproveDecision $approve
     *           Access was approved.
     *     @type \Google\Cloud\AccessApproval\V1\DismissDecision $dismiss
     *           The request was dismissed.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Accessapproval\V1\Accessapproval::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request_id}".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request_id}".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     *
     * Generated from protobuf field <code>string requested_resource_name = 2;</code>
     * @return string
     */
    public function getRequestedResourceName()
    {
        return $this->requested_resource_name;
    }

    /**
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     *
     * Generated from protobuf field <code>string requested_resource_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRequestedResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->requested_resource_name = $var;

        return $this;
    }

    /**
     * Properties related to the resource represented by requested_resource_name.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;</code>
     * @return \Google\Cloud\AccessApproval\V1\ResourceProperties|null
     */
    public function getRequestedResourceProperties()
    {
        return isset($this->requested_resource_properties) ? $this->requested_resource_properties : null;
    }

    public function hasRequestedResourceProperties()
    {
        return isset($this->requested_resource_properties);
    }

    public function clearRequestedResourceProperties()
    {
        unset($this->requested_resource_properties);
    }

    /**
     * Properties related to the resource represented by requested_resource_name.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;</code>
     * @param \Google\Cloud\AccessApproval\V1\ResourceProperties $var
     * @return $this
     */
    public function setRequestedResourceProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AccessApproval\V1\ResourceProperties::class);
        $this->requested_resource_properties = $var;

        return $this;
    }

    /**
     * The justification for which approval is being requested.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     * @return \Google\Cloud\AccessApproval\V1\AccessReason|null
     */
    public function getRequestedReason()
    {
        return isset($this->requested_reason) ? $this->requested_reason : null;
    }

    public function hasRequestedReason()
    {
        return isset($this->requested_reason);
    }

    public function clearRequestedReason()
    {
        unset($this->requested_reason);
    }

    /**
     * The justification for which approval is being requested.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     * @param \Google\Cloud\AccessApproval\V1\AccessReason $var
     * @return $this
     */
    public function setRequestedReason($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AccessApproval\V1\AccessReason::class);
        $this->requested_reason = $var;

        return $this;
    }

    /**
     * The locations for which approval is being requested.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     * @return \Google\Cloud\AccessApproval\V1\AccessLocations|null
     */
    public function getRequestedLocations()
    {
        return isset($this->requested_locations) ? $this->requested_locations : null;
    }

    public function hasRequestedLocations()
    {
        return isset($this->requested_locations);
    }

    public function clearRequestedLocations()
    {
        unset($this->requested_locations);
    }

    /**
     * The locations for which approval is being requested.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     * @param \Google\Cloud\AccessApproval\V1\AccessLocations $var
     * @return $this
     */
    public function setRequestedLocations($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AccessApproval\V1\AccessLocations::class);
        $this->requested_locations = $var;

        return $this;
    }

    /**
     * The time at which approval was requested.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp request_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRequestTime()
    {
        return isset($this->request_time) ? $this->request_time : null;
    }

    public function hasRequestTime()
    {
        return isset($this->request_time);
    }

    public function clearRequestTime()
    {
        unset($this->request_time);
    }

    /**
     * The time at which approval was requested.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp request_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRequestTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->request_time = $var;

        return $this;
    }

    /**
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRequestedExpiration()
    {
        return isset($this->requested_expiration) ? $this->requested_expiration : null;
    }

    public function hasRequestedExpiration()
    {
        return isset($this->requested_expiration);
    }

    public function clearRequestedExpiration()
    {
        unset($this->requested_expiration);
    }

    /**
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRequestedExpiration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->requested_expiration = $var;

        return $this;
    }

    /**
     * Access was approved.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     * @return \Google\Cloud\AccessApproval\V1\ApproveDecision|null
     */
    public function getApprove()
    {
        return $this->readOneof(7);
    }

    public function hasApprove()
    {
        return $this->hasOneof(7);
    }

    /**
     * Access was approved.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     * @param \Google\Cloud\AccessApproval\V1\ApproveDecision $var
     * @return $this
     */
    public function setApprove($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AccessApproval\V1\ApproveDecision::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * The request was dismissed.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     * @return \Google\Cloud\AccessApproval\V1\DismissDecision|null
     */
    public function getDismiss()
    {
        return $this->readOneof(8);
    }

    public function hasDismiss()
    {
        return $this->hasOneof(8);
    }

    /**
     * The request was dismissed.
     *
     * Generated from protobuf field <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     * @param \Google\Cloud\AccessApproval\V1\DismissDecision $var
     * @return $this
     */
    public function setDismiss($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AccessApproval\V1\DismissDecision::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getDecision()
    {
        return $this->whichOneof("decision");
    }

}

