<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Include to use an existing data crypto key wrapped by KMS.
 * The wrapped key must be a 128-, 192-, or 256-bit key.
 * Authorization requires the following IAM permissions when sending a request
 * to perform a crypto transformation using a KMS-wrapped crypto key:
 * dlp.kms.encrypt
 * For more information, see [Creating a wrapped key]
 * (https://cloud.google.com/dlp/docs/create-wrapped-key).
 * Note: When you use Cloud KMS for cryptographic operations,
 * [charges apply](https://cloud.google.com/kms/pricing).
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.KmsWrappedCryptoKey</code>
 */
class KmsWrappedCryptoKey extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The wrapped data crypto key.
     *
     * Generated from protobuf field <code>bytes wrapped_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $wrapped_key = '';
    /**
     * Required. The resource name of the KMS CryptoKey to use for unwrapping.
     *
     * Generated from protobuf field <code>string crypto_key_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $crypto_key_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $wrapped_key
     *           Required. The wrapped data crypto key.
     *     @type string $crypto_key_name
     *           Required. The resource name of the KMS CryptoKey to use for unwrapping.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The wrapped data crypto key.
     *
     * Generated from protobuf field <code>bytes wrapped_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getWrappedKey()
    {
        return $this->wrapped_key;
    }

    /**
     * Required. The wrapped data crypto key.
     *
     * Generated from protobuf field <code>bytes wrapped_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setWrappedKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->wrapped_key = $var;

        return $this;
    }

    /**
     * Required. The resource name of the KMS CryptoKey to use for unwrapping.
     *
     * Generated from protobuf field <code>string crypto_key_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCryptoKeyName()
    {
        return $this->crypto_key_name;
    }

    /**
     * Required. The resource name of the KMS CryptoKey to use for unwrapping.
     *
     * Generated from protobuf field <code>string crypto_key_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCryptoKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->crypto_key_name = $var;

        return $this;
    }

}

