<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datacatalog/v1/datacatalog.proto

namespace Google\Cloud\DataCatalog\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [LookupEntry][google.cloud.datacatalog.v1.DataCatalog.LookupEntry].
 *
 * Generated from protobuf message <code>google.cloud.datacatalog.v1.LookupEntryRequest</code>
 */
class LookupEntryRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Project where the lookup should be performed. Required to lookup
     * entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     * using its `fully_qualified_name`. Ignored in other cases.
     *
     * Generated from protobuf field <code>string project = 6;</code>
     */
    private $project = '';
    /**
     * Location where the lookup should be performed. Required to lookup
     * entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     * using its `fully_qualified_name`. Ignored in other cases.
     *
     * Generated from protobuf field <code>string location = 7;</code>
     */
    private $location = '';
    protected $target_name;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $linked_resource
     *           The full name of the Google Cloud Platform resource the Data Catalog
     *           entry represents. For more information, see [Full Resource Name]
     *           (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     *           Full names are case-sensitive. For example:
     *            * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     *            * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
     *     @type string $sql_resource
     *           The SQL name of the entry. SQL names are case-sensitive.
     *           Examples:
     *           * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
     *           * `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
     *           * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
     *           * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
     *           * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
     *           Identifiers (`*_ID`) should comply with the
     *           [Lexical structure in Standard SQL]
     *           (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
     *     @type string $fully_qualified_name
     *           [Fully Qualified Name
     *           (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-names)
     *           of the resource.
     *           FQNs take two forms:
     *           * For non-regionalized resources:
     *             `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *           * For regionalized resources:
     *             `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *           Example for a DPMS table:
     *           `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *     @type string $project
     *           Project where the lookup should be performed. Required to lookup
     *           entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     *           using its `fully_qualified_name`. Ignored in other cases.
     *     @type string $location
     *           Location where the lookup should be performed. Required to lookup
     *           entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     *           using its `fully_qualified_name`. Ignored in other cases.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datacatalog\V1\Datacatalog::initOnce();
        parent::__construct($data);
    }

    /**
     * The full name of the Google Cloud Platform resource the Data Catalog
     * entry represents. For more information, see [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * Full names are case-sensitive. For example:
     *  * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     *  * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
     *
     * Generated from protobuf field <code>string linked_resource = 1;</code>
     * @return string
     */
    public function getLinkedResource()
    {
        return $this->readOneof(1);
    }

    public function hasLinkedResource()
    {
        return $this->hasOneof(1);
    }

    /**
     * The full name of the Google Cloud Platform resource the Data Catalog
     * entry represents. For more information, see [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * Full names are case-sensitive. For example:
     *  * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     *  * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
     *
     * Generated from protobuf field <code>string linked_resource = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setLinkedResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The SQL name of the entry. SQL names are case-sensitive.
     * Examples:
     * * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
     * * `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
     * * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
     * * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
     * * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
     * Identifiers (`*_ID`) should comply with the
     * [Lexical structure in Standard SQL]
     * (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
     *
     * Generated from protobuf field <code>string sql_resource = 3;</code>
     * @return string
     */
    public function getSqlResource()
    {
        return $this->readOneof(3);
    }

    public function hasSqlResource()
    {
        return $this->hasOneof(3);
    }

    /**
     * The SQL name of the entry. SQL names are case-sensitive.
     * Examples:
     * * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
     * * `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
     * * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
     * * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
     * * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
     * Identifiers (`*_ID`) should comply with the
     * [Lexical structure in Standard SQL]
     * (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
     *
     * Generated from protobuf field <code>string sql_resource = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSqlResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * [Fully Qualified Name
     * (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-names)
     * of the resource.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *
     * Generated from protobuf field <code>string fully_qualified_name = 5;</code>
     * @return string
     */
    public function getFullyQualifiedName()
    {
        return $this->readOneof(5);
    }

    public function hasFullyQualifiedName()
    {
        return $this->hasOneof(5);
    }

    /**
     * [Fully Qualified Name
     * (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-names)
     * of the resource.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *
     * Generated from protobuf field <code>string fully_qualified_name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setFullyQualifiedName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Project where the lookup should be performed. Required to lookup
     * entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     * using its `fully_qualified_name`. Ignored in other cases.
     *
     * Generated from protobuf field <code>string project = 6;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * Project where the lookup should be performed. Required to lookup
     * entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     * using its `fully_qualified_name`. Ignored in other cases.
     *
     * Generated from protobuf field <code>string project = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * Location where the lookup should be performed. Required to lookup
     * entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     * using its `fully_qualified_name`. Ignored in other cases.
     *
     * Generated from protobuf field <code>string location = 7;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Location where the lookup should be performed. Required to lookup
     * entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
     * using its `fully_qualified_name`. Ignored in other cases.
     *
     * Generated from protobuf field <code>string location = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTargetName()
    {
        return $this->whichOneof("target_name");
    }

}

