<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/resources.proto

namespace Google\Cloud\Video\LiveStream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Clip is a sub-resource under channel. Each clip represents a clipping
 * operation that generates a VOD playlist from its channel given a set of
 * timestamp ranges.
 *
 * Generated from protobuf message <code>google.cloud.video.livestream.v1.Clip</code>
 */
class Clip extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the clip, in the following format:
     * `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
     * `{clipId}` is a user-specified resource id that conforms to the following
     * criteria:
     * 1. 1 character minimum, 63 characters maximum
     * 2. Only contains letters, digits, underscores, and hyphens
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. The creation timestamp of the clip resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the clip request starts to be processed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $start_time = null;
    /**
     * Output only. The update timestamp of the clip resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * The labels associated with this resource. Each label is a key-value pair.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     */
    private $labels;
    /**
     * Output only. The state of the clip.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Clip.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Specify the `output_uri` to determine where to place the clip segments and
     * clip manifest files in Cloud Storage. The manifests specified in
     * `clip_manifests` fields will be placed under this URI. The exact URI of the
     * generated manifests will be provided in `clip_manifests.output_uri` for
     * each manifest.
     * Example:
     * "output_uri": "gs://my-bucket/clip-outputs"
     * "clip_manifests.output_uri": "gs://my-bucket/clip-outputs/main.m3u8"
     *
     * Generated from protobuf field <code>string output_uri = 7;</code>
     */
    protected $output_uri = '';
    /**
     * Output only. An error object that describes the reason for the failure.
     * This property only presents when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $error = null;
    /**
     * The specified ranges of segments to generate a clip.
     *
     * Generated from protobuf field <code>repeated .google.cloud.video.livestream.v1.Clip.Slice slices = 10;</code>
     */
    private $slices;
    /**
     * Required. A list of clip manifests. Currently only one clip manifest is
     * allowed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.video.livestream.v1.Clip.ClipManifest clip_manifests = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $clip_manifests;
    /**
     * Optional. OutputType of the clip. If not specified, the default value is
     * MANIFEST.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Clip.OutputType output_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $output_type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the clip, in the following format:
     *           `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
     *           `{clipId}` is a user-specified resource id that conforms to the following
     *           criteria:
     *           1. 1 character minimum, 63 characters maximum
     *           2. Only contains letters, digits, underscores, and hyphens
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of the clip resource.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Output only. The timestamp when the clip request starts to be processed.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update timestamp of the clip resource.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels associated with this resource. Each label is a key-value pair.
     *     @type int $state
     *           Output only. The state of the clip.
     *     @type string $output_uri
     *           Specify the `output_uri` to determine where to place the clip segments and
     *           clip manifest files in Cloud Storage. The manifests specified in
     *           `clip_manifests` fields will be placed under this URI. The exact URI of the
     *           generated manifests will be provided in `clip_manifests.output_uri` for
     *           each manifest.
     *           Example:
     *           "output_uri": "gs://my-bucket/clip-outputs"
     *           "clip_manifests.output_uri": "gs://my-bucket/clip-outputs/main.m3u8"
     *     @type \Google\Rpc\Status $error
     *           Output only. An error object that describes the reason for the failure.
     *           This property only presents when `state` is `FAILED`.
     *     @type array<\Google\Cloud\Video\LiveStream\V1\Clip\Slice>|\Google\Protobuf\Internal\RepeatedField $slices
     *           The specified ranges of segments to generate a clip.
     *     @type array<\Google\Cloud\Video\LiveStream\V1\Clip\ClipManifest>|\Google\Protobuf\Internal\RepeatedField $clip_manifests
     *           Required. A list of clip manifests. Currently only one clip manifest is
     *           allowed.
     *     @type int $output_type
     *           Optional. OutputType of the clip. If not specified, the default value is
     *           MANIFEST.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Livestream\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the clip, in the following format:
     * `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
     * `{clipId}` is a user-specified resource id that conforms to the following
     * criteria:
     * 1. 1 character minimum, 63 characters maximum
     * 2. Only contains letters, digits, underscores, and hyphens
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the clip, in the following format:
     * `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
     * `{clipId}` is a user-specified resource id that conforms to the following
     * criteria:
     * 1. 1 character minimum, 63 characters maximum
     * 2. Only contains letters, digits, underscores, and hyphens
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The creation timestamp of the clip resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of the clip resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the clip request starts to be processed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Output only. The timestamp when the clip request starts to be processed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Output only. The update timestamp of the clip resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update timestamp of the clip resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The labels associated with this resource. Each label is a key-value pair.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels associated with this resource. Each label is a key-value pair.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The state of the clip.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Clip.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the clip.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Clip.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Clip\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Specify the `output_uri` to determine where to place the clip segments and
     * clip manifest files in Cloud Storage. The manifests specified in
     * `clip_manifests` fields will be placed under this URI. The exact URI of the
     * generated manifests will be provided in `clip_manifests.output_uri` for
     * each manifest.
     * Example:
     * "output_uri": "gs://my-bucket/clip-outputs"
     * "clip_manifests.output_uri": "gs://my-bucket/clip-outputs/main.m3u8"
     *
     * Generated from protobuf field <code>string output_uri = 7;</code>
     * @return string
     */
    public function getOutputUri()
    {
        return $this->output_uri;
    }

    /**
     * Specify the `output_uri` to determine where to place the clip segments and
     * clip manifest files in Cloud Storage. The manifests specified in
     * `clip_manifests` fields will be placed under this URI. The exact URI of the
     * generated manifests will be provided in `clip_manifests.output_uri` for
     * each manifest.
     * Example:
     * "output_uri": "gs://my-bucket/clip-outputs"
     * "clip_manifests.output_uri": "gs://my-bucket/clip-outputs/main.m3u8"
     *
     * Generated from protobuf field <code>string output_uri = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setOutputUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->output_uri = $var;

        return $this;
    }

    /**
     * Output only. An error object that describes the reason for the failure.
     * This property only presents when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. An error object that describes the reason for the failure.
     * This property only presents when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * The specified ranges of segments to generate a clip.
     *
     * Generated from protobuf field <code>repeated .google.cloud.video.livestream.v1.Clip.Slice slices = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSlices()
    {
        return $this->slices;
    }

    /**
     * The specified ranges of segments to generate a clip.
     *
     * Generated from protobuf field <code>repeated .google.cloud.video.livestream.v1.Clip.Slice slices = 10;</code>
     * @param array<\Google\Cloud\Video\LiveStream\V1\Clip\Slice>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSlices($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Video\LiveStream\V1\Clip\Slice::class);
        $this->slices = $arr;

        return $this;
    }

    /**
     * Required. A list of clip manifests. Currently only one clip manifest is
     * allowed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.video.livestream.v1.Clip.ClipManifest clip_manifests = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getClipManifests()
    {
        return $this->clip_manifests;
    }

    /**
     * Required. A list of clip manifests. Currently only one clip manifest is
     * allowed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.video.livestream.v1.Clip.ClipManifest clip_manifests = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Video\LiveStream\V1\Clip\ClipManifest>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setClipManifests($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Video\LiveStream\V1\Clip\ClipManifest::class);
        $this->clip_manifests = $arr;

        return $this;
    }

    /**
     * Optional. OutputType of the clip. If not specified, the default value is
     * MANIFEST.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Clip.OutputType output_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getOutputType()
    {
        return $this->output_type;
    }

    /**
     * Optional. OutputType of the clip. If not specified, the default value is
     * MANIFEST.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Clip.OutputType output_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setOutputType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Clip\OutputType::class);
        $this->output_type = $var;

        return $this;
    }

}

