<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/location.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `Tablet` represents a single replica of a `Group`. A tablet is served by a
 * single server at a time, and can move between servers due to server death or
 * simply load balancing.
 *
 * Generated from protobuf message <code>google.spanner.v1.Tablet</code>
 */
class Tablet extends \Google\Protobuf\Internal\Message
{
    /**
     * The UID of the tablet, unique within the database. Matches the
     * `tablet_uids` and `leader_tablet_uid` fields in `Group`.
     *
     * Generated from protobuf field <code>uint64 tablet_uid = 1;</code>
     */
    protected $tablet_uid = 0;
    /**
     * The address of the server that is serving this tablet -- either an IP
     * address or DNS hostname and a port number.
     *
     * Generated from protobuf field <code>string server_address = 2;</code>
     */
    protected $server_address = '';
    /**
     * Where this tablet is located. In the Spanner managed service, this is the
     * name of a region, such as "us-central1". In Spanner Omni, this is a
     * previously created location.
     *
     * Generated from protobuf field <code>string location = 3;</code>
     */
    protected $location = '';
    /**
     * The role of the tablet.
     *
     * Generated from protobuf field <code>.google.spanner.v1.Tablet.Role role = 4;</code>
     */
    protected $role = 0;
    /**
     * `incarnation` indicates the freshness of the tablet information contained
     * in this proto. Incarnations can be compared lexicographically; if
     * incarnation A is greater than incarnation B, then the `Tablet`
     * corresponding to A is newer than the `Tablet` corresponding to B, and
     * should be used preferentially.
     *
     * Generated from protobuf field <code>bytes incarnation = 5;</code>
     */
    protected $incarnation = '';
    /**
     * Distances help the client pick the closest tablet out of the list of
     * tablets for a given request. Tablets with lower distances should generally
     * be preferred. Tablets with the same distance are approximately equally
     * close; the client can choose arbitrarily.
     * Distances do not correspond precisely to expected latency, geographical
     * distance, or anything else. Distances should be compared only between
     * tablets of the same group; they are not meaningful between different
     * groups.
     * A value of zero indicates that the tablet may be in the same zone as
     * the client, and have minimum network latency. A value less than or equal to
     * five indicates that the tablet is thought to be in the same region as the
     * client, and may have a few milliseconds of network latency. Values greater
     * than five are most likely in a different region, with non-trivial network
     * latency.
     * Clients should use the following algorithm:
     *   * If the request is using a directed read, eliminate any tablets that
     *     do not match the directed read's target zone and/or replica type.
     *   * (Read-write transactions only) Choose leader tablet if it has an
     *     distance <=5.
     *   * Group and sort tablets by distance. Choose a random
     *     tablet with the lowest distance. If the request
     *     is not a directed read, only consider replicas with distances <=5.
     *   * Send the request to the fallback endpoint.
     * The tablet picked by this algorithm may be skipped, either because it is
     * marked as `skip` by the server or because the corresponding server is
     * unreachable, flow controlled, etc. Skipped tablets should be added to the
     * `skipped_tablet_uid` field in `RoutingHint`; the algorithm above should
     * then be re-run without including the skipped tablet(s) to pick the next
     * best tablet.
     *
     * Generated from protobuf field <code>uint32 distance = 6;</code>
     */
    protected $distance = 0;
    /**
     * If true, the tablet should not be chosen by the client. Typically, this
     * signals that the tablet is unhealthy in some way. Tablets with `skip`
     * set to true should be reported back to the server in
     * `RoutingHint.skipped_tablet_uid`; this cues the server to send updated
     * information for this tablet should it become usable again.
     *
     * Generated from protobuf field <code>bool skip = 7;</code>
     */
    protected $skip = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $tablet_uid
     *           The UID of the tablet, unique within the database. Matches the
     *           `tablet_uids` and `leader_tablet_uid` fields in `Group`.
     *     @type string $server_address
     *           The address of the server that is serving this tablet -- either an IP
     *           address or DNS hostname and a port number.
     *     @type string $location
     *           Where this tablet is located. In the Spanner managed service, this is the
     *           name of a region, such as "us-central1". In Spanner Omni, this is a
     *           previously created location.
     *     @type int $role
     *           The role of the tablet.
     *     @type string $incarnation
     *           `incarnation` indicates the freshness of the tablet information contained
     *           in this proto. Incarnations can be compared lexicographically; if
     *           incarnation A is greater than incarnation B, then the `Tablet`
     *           corresponding to A is newer than the `Tablet` corresponding to B, and
     *           should be used preferentially.
     *     @type int $distance
     *           Distances help the client pick the closest tablet out of the list of
     *           tablets for a given request. Tablets with lower distances should generally
     *           be preferred. Tablets with the same distance are approximately equally
     *           close; the client can choose arbitrarily.
     *           Distances do not correspond precisely to expected latency, geographical
     *           distance, or anything else. Distances should be compared only between
     *           tablets of the same group; they are not meaningful between different
     *           groups.
     *           A value of zero indicates that the tablet may be in the same zone as
     *           the client, and have minimum network latency. A value less than or equal to
     *           five indicates that the tablet is thought to be in the same region as the
     *           client, and may have a few milliseconds of network latency. Values greater
     *           than five are most likely in a different region, with non-trivial network
     *           latency.
     *           Clients should use the following algorithm:
     *             * If the request is using a directed read, eliminate any tablets that
     *               do not match the directed read's target zone and/or replica type.
     *             * (Read-write transactions only) Choose leader tablet if it has an
     *               distance <=5.
     *             * Group and sort tablets by distance. Choose a random
     *               tablet with the lowest distance. If the request
     *               is not a directed read, only consider replicas with distances <=5.
     *             * Send the request to the fallback endpoint.
     *           The tablet picked by this algorithm may be skipped, either because it is
     *           marked as `skip` by the server or because the corresponding server is
     *           unreachable, flow controlled, etc. Skipped tablets should be added to the
     *           `skipped_tablet_uid` field in `RoutingHint`; the algorithm above should
     *           then be re-run without including the skipped tablet(s) to pick the next
     *           best tablet.
     *     @type bool $skip
     *           If true, the tablet should not be chosen by the client. Typically, this
     *           signals that the tablet is unhealthy in some way. Tablets with `skip`
     *           set to true should be reported back to the server in
     *           `RoutingHint.skipped_tablet_uid`; this cues the server to send updated
     *           information for this tablet should it become usable again.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Location::initOnce();
        parent::__construct($data);
    }

    /**
     * The UID of the tablet, unique within the database. Matches the
     * `tablet_uids` and `leader_tablet_uid` fields in `Group`.
     *
     * Generated from protobuf field <code>uint64 tablet_uid = 1;</code>
     * @return int|string
     */
    public function getTabletUid()
    {
        return $this->tablet_uid;
    }

    /**
     * The UID of the tablet, unique within the database. Matches the
     * `tablet_uids` and `leader_tablet_uid` fields in `Group`.
     *
     * Generated from protobuf field <code>uint64 tablet_uid = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTabletUid($var)
    {
        GPBUtil::checkUint64($var);
        $this->tablet_uid = $var;

        return $this;
    }

    /**
     * The address of the server that is serving this tablet -- either an IP
     * address or DNS hostname and a port number.
     *
     * Generated from protobuf field <code>string server_address = 2;</code>
     * @return string
     */
    public function getServerAddress()
    {
        return $this->server_address;
    }

    /**
     * The address of the server that is serving this tablet -- either an IP
     * address or DNS hostname and a port number.
     *
     * Generated from protobuf field <code>string server_address = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setServerAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_address = $var;

        return $this;
    }

    /**
     * Where this tablet is located. In the Spanner managed service, this is the
     * name of a region, such as "us-central1". In Spanner Omni, this is a
     * previously created location.
     *
     * Generated from protobuf field <code>string location = 3;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Where this tablet is located. In the Spanner managed service, this is the
     * name of a region, such as "us-central1". In Spanner Omni, this is a
     * previously created location.
     *
     * Generated from protobuf field <code>string location = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * The role of the tablet.
     *
     * Generated from protobuf field <code>.google.spanner.v1.Tablet.Role role = 4;</code>
     * @return int
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * The role of the tablet.
     *
     * Generated from protobuf field <code>.google.spanner.v1.Tablet.Role role = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setRole($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Spanner\V1\Tablet\Role::class);
        $this->role = $var;

        return $this;
    }

    /**
     * `incarnation` indicates the freshness of the tablet information contained
     * in this proto. Incarnations can be compared lexicographically; if
     * incarnation A is greater than incarnation B, then the `Tablet`
     * corresponding to A is newer than the `Tablet` corresponding to B, and
     * should be used preferentially.
     *
     * Generated from protobuf field <code>bytes incarnation = 5;</code>
     * @return string
     */
    public function getIncarnation()
    {
        return $this->incarnation;
    }

    /**
     * `incarnation` indicates the freshness of the tablet information contained
     * in this proto. Incarnations can be compared lexicographically; if
     * incarnation A is greater than incarnation B, then the `Tablet`
     * corresponding to A is newer than the `Tablet` corresponding to B, and
     * should be used preferentially.
     *
     * Generated from protobuf field <code>bytes incarnation = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setIncarnation($var)
    {
        GPBUtil::checkString($var, False);
        $this->incarnation = $var;

        return $this;
    }

    /**
     * Distances help the client pick the closest tablet out of the list of
     * tablets for a given request. Tablets with lower distances should generally
     * be preferred. Tablets with the same distance are approximately equally
     * close; the client can choose arbitrarily.
     * Distances do not correspond precisely to expected latency, geographical
     * distance, or anything else. Distances should be compared only between
     * tablets of the same group; they are not meaningful between different
     * groups.
     * A value of zero indicates that the tablet may be in the same zone as
     * the client, and have minimum network latency. A value less than or equal to
     * five indicates that the tablet is thought to be in the same region as the
     * client, and may have a few milliseconds of network latency. Values greater
     * than five are most likely in a different region, with non-trivial network
     * latency.
     * Clients should use the following algorithm:
     *   * If the request is using a directed read, eliminate any tablets that
     *     do not match the directed read's target zone and/or replica type.
     *   * (Read-write transactions only) Choose leader tablet if it has an
     *     distance <=5.
     *   * Group and sort tablets by distance. Choose a random
     *     tablet with the lowest distance. If the request
     *     is not a directed read, only consider replicas with distances <=5.
     *   * Send the request to the fallback endpoint.
     * The tablet picked by this algorithm may be skipped, either because it is
     * marked as `skip` by the server or because the corresponding server is
     * unreachable, flow controlled, etc. Skipped tablets should be added to the
     * `skipped_tablet_uid` field in `RoutingHint`; the algorithm above should
     * then be re-run without including the skipped tablet(s) to pick the next
     * best tablet.
     *
     * Generated from protobuf field <code>uint32 distance = 6;</code>
     * @return int
     */
    public function getDistance()
    {
        return $this->distance;
    }

    /**
     * Distances help the client pick the closest tablet out of the list of
     * tablets for a given request. Tablets with lower distances should generally
     * be preferred. Tablets with the same distance are approximately equally
     * close; the client can choose arbitrarily.
     * Distances do not correspond precisely to expected latency, geographical
     * distance, or anything else. Distances should be compared only between
     * tablets of the same group; they are not meaningful between different
     * groups.
     * A value of zero indicates that the tablet may be in the same zone as
     * the client, and have minimum network latency. A value less than or equal to
     * five indicates that the tablet is thought to be in the same region as the
     * client, and may have a few milliseconds of network latency. Values greater
     * than five are most likely in a different region, with non-trivial network
     * latency.
     * Clients should use the following algorithm:
     *   * If the request is using a directed read, eliminate any tablets that
     *     do not match the directed read's target zone and/or replica type.
     *   * (Read-write transactions only) Choose leader tablet if it has an
     *     distance <=5.
     *   * Group and sort tablets by distance. Choose a random
     *     tablet with the lowest distance. If the request
     *     is not a directed read, only consider replicas with distances <=5.
     *   * Send the request to the fallback endpoint.
     * The tablet picked by this algorithm may be skipped, either because it is
     * marked as `skip` by the server or because the corresponding server is
     * unreachable, flow controlled, etc. Skipped tablets should be added to the
     * `skipped_tablet_uid` field in `RoutingHint`; the algorithm above should
     * then be re-run without including the skipped tablet(s) to pick the next
     * best tablet.
     *
     * Generated from protobuf field <code>uint32 distance = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setDistance($var)
    {
        GPBUtil::checkUint32($var);
        $this->distance = $var;

        return $this;
    }

    /**
     * If true, the tablet should not be chosen by the client. Typically, this
     * signals that the tablet is unhealthy in some way. Tablets with `skip`
     * set to true should be reported back to the server in
     * `RoutingHint.skipped_tablet_uid`; this cues the server to send updated
     * information for this tablet should it become usable again.
     *
     * Generated from protobuf field <code>bool skip = 7;</code>
     * @return bool
     */
    public function getSkip()
    {
        return $this->skip;
    }

    /**
     * If true, the tablet should not be chosen by the client. Typically, this
     * signals that the tablet is unhealthy in some way. Tablets with `skip`
     * set to true should be reported back to the server in
     * `RoutingHint.skipped_tablet_uid`; this cues the server to send updated
     * information for this tablet should it become usable again.
     *
     * Generated from protobuf field <code>bool skip = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setSkip($var)
    {
        GPBUtil::checkBool($var);
        $this->skip = $var;

        return $this;
    }

}

