<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/location.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `RoutingHint` can be optionally added to location-aware Spanner
 * requests. It gives the server hints that can be used to route the request to
 * an appropriate server, potentially significantly decreasing latency and
 * improving throughput. To achieve improved performance, most fields must be
 * filled in with accurate values.
 * The presence of a valid `RoutingHint` tells the server that the client
 * is location-aware.
 * `RoutingHint` does not change the semantics of the request; it is
 * purely a performance hint; the request will perform the same actions on the
 * database's data as if `RoutingHint` were not present. However, if
 * the `RoutingHint` is incomplete or incorrect, the response may include
 * a `CacheUpdate` the client can use to correct its location cache.
 *
 * Generated from protobuf message <code>google.spanner.v1.RoutingHint</code>
 */
class RoutingHint extends \Google\Protobuf\Internal\Message
{
    /**
     * A session-scoped unique ID for the operation, computed client-side.
     * Requests with the same `operation_uid` should have a shared 'shape',
     * meaning that some fields are expected to be the same, such as the SQL
     * query, the target table/columns (for reads) etc. Requests with the same
     * `operation_uid` are meant to differ only in fields like keys/key
     * ranges/query parameters, transaction IDs, etc.
     * `operation_uid` must be non-zero for `RoutingHint` to be valid.
     *
     * Generated from protobuf field <code>uint64 operation_uid = 1;</code>
     */
    protected $operation_uid = 0;
    /**
     * The database ID of the database being accessed, see
     * `CacheUpdate.database_id`. Should match the cache entries that were used
     * to generate the rest of the fields in this `RoutingHint`.
     *
     * Generated from protobuf field <code>uint64 database_id = 2;</code>
     */
    protected $database_id = 0;
    /**
     * The schema generation of the recipe that was used to generate `key` and
     * `limit_key`. See also `RecipeList.schema_generation`.
     *
     * Generated from protobuf field <code>bytes schema_generation = 3;</code>
     */
    protected $schema_generation = '';
    /**
     * The key / key range that this request accesses. For operations that
     * access a single key, `key` should be set and `limit_key` should be empty.
     * For operations that access a key range, `key` and `limit_key` should both
     * be set, to the inclusive start and exclusive end of the range respectively.
     * The keys are encoded in "sortable string format" (ssformat), using a
     * `KeyRecipe` that is appropriate for the request. See `KeyRecipe` for more
     * details.
     *
     * Generated from protobuf field <code>bytes key = 4;</code>
     */
    protected $key = '';
    /**
     * If this request targets a key range, this is the exclusive end of the
     * range. See `key` for more details.
     *
     * Generated from protobuf field <code>bytes limit_key = 5;</code>
     */
    protected $limit_key = '';
    /**
     * The group UID of the group that the client believes serves the range
     * defined by `key` and `limit_key`. See `Range.group_uid` for more details.
     *
     * Generated from protobuf field <code>uint64 group_uid = 6;</code>
     */
    protected $group_uid = 0;
    /**
     * The split ID of the split that the client believes contains the range
     * defined by `key` and `limit_key`. See `Range.split_id` for more details.
     *
     * Generated from protobuf field <code>uint64 split_id = 7;</code>
     */
    protected $split_id = 0;
    /**
     * The tablet UID of the tablet from group `group_uid` that the client
     * believes is best to serve this request. See `Group.local_tablet_uids` and
     * `Group.leader_tablet_uid`.
     *
     * Generated from protobuf field <code>uint64 tablet_uid = 8;</code>
     */
    protected $tablet_uid = 0;
    /**
     * If the client had multiple options for tablet selection, and some of its
     * first choices were unhealthy (e.g., the server is unreachable, or
     * `Tablet.skip` is true), this field will contain the tablet UIDs of those
     * tablets, with their incarnations. The server may include a `CacheUpdate`
     * with new locations for those tablets.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.RoutingHint.SkippedTablet skipped_tablet_uid = 9;</code>
     */
    private $skipped_tablet_uid;
    /**
     * If present, the client's current location. In the Spanner managed service,
     * this should be the name of a Google Cloud zone or region, such as
     * "us-central1". In Spanner Omni, this should correspond to a previously
     * created location.
     * If absent, the client's location will be assumed to be the same as the
     * location of the server the client ends up connected to.
     * Locations are primarily valuable for clients that connect from regions
     * other than the ones that contain the Spanner database.
     *
     * Generated from protobuf field <code>string client_location = 10;</code>
     */
    protected $client_location = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $operation_uid
     *           A session-scoped unique ID for the operation, computed client-side.
     *           Requests with the same `operation_uid` should have a shared 'shape',
     *           meaning that some fields are expected to be the same, such as the SQL
     *           query, the target table/columns (for reads) etc. Requests with the same
     *           `operation_uid` are meant to differ only in fields like keys/key
     *           ranges/query parameters, transaction IDs, etc.
     *           `operation_uid` must be non-zero for `RoutingHint` to be valid.
     *     @type int|string $database_id
     *           The database ID of the database being accessed, see
     *           `CacheUpdate.database_id`. Should match the cache entries that were used
     *           to generate the rest of the fields in this `RoutingHint`.
     *     @type string $schema_generation
     *           The schema generation of the recipe that was used to generate `key` and
     *           `limit_key`. See also `RecipeList.schema_generation`.
     *     @type string $key
     *           The key / key range that this request accesses. For operations that
     *           access a single key, `key` should be set and `limit_key` should be empty.
     *           For operations that access a key range, `key` and `limit_key` should both
     *           be set, to the inclusive start and exclusive end of the range respectively.
     *           The keys are encoded in "sortable string format" (ssformat), using a
     *           `KeyRecipe` that is appropriate for the request. See `KeyRecipe` for more
     *           details.
     *     @type string $limit_key
     *           If this request targets a key range, this is the exclusive end of the
     *           range. See `key` for more details.
     *     @type int|string $group_uid
     *           The group UID of the group that the client believes serves the range
     *           defined by `key` and `limit_key`. See `Range.group_uid` for more details.
     *     @type int|string $split_id
     *           The split ID of the split that the client believes contains the range
     *           defined by `key` and `limit_key`. See `Range.split_id` for more details.
     *     @type int|string $tablet_uid
     *           The tablet UID of the tablet from group `group_uid` that the client
     *           believes is best to serve this request. See `Group.local_tablet_uids` and
     *           `Group.leader_tablet_uid`.
     *     @type array<\Google\Cloud\Spanner\V1\RoutingHint\SkippedTablet>|\Google\Protobuf\Internal\RepeatedField $skipped_tablet_uid
     *           If the client had multiple options for tablet selection, and some of its
     *           first choices were unhealthy (e.g., the server is unreachable, or
     *           `Tablet.skip` is true), this field will contain the tablet UIDs of those
     *           tablets, with their incarnations. The server may include a `CacheUpdate`
     *           with new locations for those tablets.
     *     @type string $client_location
     *           If present, the client's current location. In the Spanner managed service,
     *           this should be the name of a Google Cloud zone or region, such as
     *           "us-central1". In Spanner Omni, this should correspond to a previously
     *           created location.
     *           If absent, the client's location will be assumed to be the same as the
     *           location of the server the client ends up connected to.
     *           Locations are primarily valuable for clients that connect from regions
     *           other than the ones that contain the Spanner database.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Location::initOnce();
        parent::__construct($data);
    }

    /**
     * A session-scoped unique ID for the operation, computed client-side.
     * Requests with the same `operation_uid` should have a shared 'shape',
     * meaning that some fields are expected to be the same, such as the SQL
     * query, the target table/columns (for reads) etc. Requests with the same
     * `operation_uid` are meant to differ only in fields like keys/key
     * ranges/query parameters, transaction IDs, etc.
     * `operation_uid` must be non-zero for `RoutingHint` to be valid.
     *
     * Generated from protobuf field <code>uint64 operation_uid = 1;</code>
     * @return int|string
     */
    public function getOperationUid()
    {
        return $this->operation_uid;
    }

    /**
     * A session-scoped unique ID for the operation, computed client-side.
     * Requests with the same `operation_uid` should have a shared 'shape',
     * meaning that some fields are expected to be the same, such as the SQL
     * query, the target table/columns (for reads) etc. Requests with the same
     * `operation_uid` are meant to differ only in fields like keys/key
     * ranges/query parameters, transaction IDs, etc.
     * `operation_uid` must be non-zero for `RoutingHint` to be valid.
     *
     * Generated from protobuf field <code>uint64 operation_uid = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setOperationUid($var)
    {
        GPBUtil::checkUint64($var);
        $this->operation_uid = $var;

        return $this;
    }

    /**
     * The database ID of the database being accessed, see
     * `CacheUpdate.database_id`. Should match the cache entries that were used
     * to generate the rest of the fields in this `RoutingHint`.
     *
     * Generated from protobuf field <code>uint64 database_id = 2;</code>
     * @return int|string
     */
    public function getDatabaseId()
    {
        return $this->database_id;
    }

    /**
     * The database ID of the database being accessed, see
     * `CacheUpdate.database_id`. Should match the cache entries that were used
     * to generate the rest of the fields in this `RoutingHint`.
     *
     * Generated from protobuf field <code>uint64 database_id = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDatabaseId($var)
    {
        GPBUtil::checkUint64($var);
        $this->database_id = $var;

        return $this;
    }

    /**
     * The schema generation of the recipe that was used to generate `key` and
     * `limit_key`. See also `RecipeList.schema_generation`.
     *
     * Generated from protobuf field <code>bytes schema_generation = 3;</code>
     * @return string
     */
    public function getSchemaGeneration()
    {
        return $this->schema_generation;
    }

    /**
     * The schema generation of the recipe that was used to generate `key` and
     * `limit_key`. See also `RecipeList.schema_generation`.
     *
     * Generated from protobuf field <code>bytes schema_generation = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSchemaGeneration($var)
    {
        GPBUtil::checkString($var, False);
        $this->schema_generation = $var;

        return $this;
    }

    /**
     * The key / key range that this request accesses. For operations that
     * access a single key, `key` should be set and `limit_key` should be empty.
     * For operations that access a key range, `key` and `limit_key` should both
     * be set, to the inclusive start and exclusive end of the range respectively.
     * The keys are encoded in "sortable string format" (ssformat), using a
     * `KeyRecipe` that is appropriate for the request. See `KeyRecipe` for more
     * details.
     *
     * Generated from protobuf field <code>bytes key = 4;</code>
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * The key / key range that this request accesses. For operations that
     * access a single key, `key` should be set and `limit_key` should be empty.
     * For operations that access a key range, `key` and `limit_key` should both
     * be set, to the inclusive start and exclusive end of the range respectively.
     * The keys are encoded in "sortable string format" (ssformat), using a
     * `KeyRecipe` that is appropriate for the request. See `KeyRecipe` for more
     * details.
     *
     * Generated from protobuf field <code>bytes key = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->key = $var;

        return $this;
    }

    /**
     * If this request targets a key range, this is the exclusive end of the
     * range. See `key` for more details.
     *
     * Generated from protobuf field <code>bytes limit_key = 5;</code>
     * @return string
     */
    public function getLimitKey()
    {
        return $this->limit_key;
    }

    /**
     * If this request targets a key range, this is the exclusive end of the
     * range. See `key` for more details.
     *
     * Generated from protobuf field <code>bytes limit_key = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setLimitKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->limit_key = $var;

        return $this;
    }

    /**
     * The group UID of the group that the client believes serves the range
     * defined by `key` and `limit_key`. See `Range.group_uid` for more details.
     *
     * Generated from protobuf field <code>uint64 group_uid = 6;</code>
     * @return int|string
     */
    public function getGroupUid()
    {
        return $this->group_uid;
    }

    /**
     * The group UID of the group that the client believes serves the range
     * defined by `key` and `limit_key`. See `Range.group_uid` for more details.
     *
     * Generated from protobuf field <code>uint64 group_uid = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setGroupUid($var)
    {
        GPBUtil::checkUint64($var);
        $this->group_uid = $var;

        return $this;
    }

    /**
     * The split ID of the split that the client believes contains the range
     * defined by `key` and `limit_key`. See `Range.split_id` for more details.
     *
     * Generated from protobuf field <code>uint64 split_id = 7;</code>
     * @return int|string
     */
    public function getSplitId()
    {
        return $this->split_id;
    }

    /**
     * The split ID of the split that the client believes contains the range
     * defined by `key` and `limit_key`. See `Range.split_id` for more details.
     *
     * Generated from protobuf field <code>uint64 split_id = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSplitId($var)
    {
        GPBUtil::checkUint64($var);
        $this->split_id = $var;

        return $this;
    }

    /**
     * The tablet UID of the tablet from group `group_uid` that the client
     * believes is best to serve this request. See `Group.local_tablet_uids` and
     * `Group.leader_tablet_uid`.
     *
     * Generated from protobuf field <code>uint64 tablet_uid = 8;</code>
     * @return int|string
     */
    public function getTabletUid()
    {
        return $this->tablet_uid;
    }

    /**
     * The tablet UID of the tablet from group `group_uid` that the client
     * believes is best to serve this request. See `Group.local_tablet_uids` and
     * `Group.leader_tablet_uid`.
     *
     * Generated from protobuf field <code>uint64 tablet_uid = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTabletUid($var)
    {
        GPBUtil::checkUint64($var);
        $this->tablet_uid = $var;

        return $this;
    }

    /**
     * If the client had multiple options for tablet selection, and some of its
     * first choices were unhealthy (e.g., the server is unreachable, or
     * `Tablet.skip` is true), this field will contain the tablet UIDs of those
     * tablets, with their incarnations. The server may include a `CacheUpdate`
     * with new locations for those tablets.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.RoutingHint.SkippedTablet skipped_tablet_uid = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSkippedTabletUid()
    {
        return $this->skipped_tablet_uid;
    }

    /**
     * If the client had multiple options for tablet selection, and some of its
     * first choices were unhealthy (e.g., the server is unreachable, or
     * `Tablet.skip` is true), this field will contain the tablet UIDs of those
     * tablets, with their incarnations. The server may include a `CacheUpdate`
     * with new locations for those tablets.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.RoutingHint.SkippedTablet skipped_tablet_uid = 9;</code>
     * @param array<\Google\Cloud\Spanner\V1\RoutingHint\SkippedTablet>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSkippedTabletUid($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\RoutingHint\SkippedTablet::class);
        $this->skipped_tablet_uid = $arr;

        return $this;
    }

    /**
     * If present, the client's current location. In the Spanner managed service,
     * this should be the name of a Google Cloud zone or region, such as
     * "us-central1". In Spanner Omni, this should correspond to a previously
     * created location.
     * If absent, the client's location will be assumed to be the same as the
     * location of the server the client ends up connected to.
     * Locations are primarily valuable for clients that connect from regions
     * other than the ones that contain the Spanner database.
     *
     * Generated from protobuf field <code>string client_location = 10;</code>
     * @return string
     */
    public function getClientLocation()
    {
        return $this->client_location;
    }

    /**
     * If present, the client's current location. In the Spanner managed service,
     * this should be the name of a Google Cloud zone or region, such as
     * "us-central1". In Spanner Omni, this should correspond to a previously
     * created location.
     * If absent, the client's location will be assumed to be the same as the
     * location of the server the client ends up connected to.
     * Locations are primarily valuable for clients that connect from regions
     * other than the ones that contain the Spanner database.
     *
     * Generated from protobuf field <code>string client_location = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setClientLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_location = $var;

        return $this;
    }

}

