<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/location.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `Group` represents a paxos group in a database. A group is a set of
 * tablets that are replicated across multiple servers. Groups may have a leader
 * tablet. Groups store one (or sometimes more) ranges of keys.
 *
 * Generated from protobuf message <code>google.spanner.v1.Group</code>
 */
class Group extends \Google\Protobuf\Internal\Message
{
    /**
     * The UID of the paxos group, unique within the database. Matches the
     * `group_uid` field in `Range`.
     *
     * Generated from protobuf field <code>uint64 group_uid = 1;</code>
     */
    protected $group_uid = 0;
    /**
     * A list of tablets that are part of the group. Note that this list may not
     * be exhaustive; it will only include tablets the server considers useful
     * to the client. The returned list is ordered ascending by distance.
     * Tablet UIDs reference `Tablet.tablet_uid`.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.Tablet tablets = 2;</code>
     */
    private $tablets;
    /**
     * The last known leader tablet of the group as an index into `tablets`. May
     * be negative if the group has no known leader.
     *
     * Generated from protobuf field <code>int32 leader_index = 3;</code>
     */
    protected $leader_index = 0;
    /**
     * `generation` indicates the freshness of the group information (including
     * leader information) contained in this proto. Generations can be compared
     * lexicographically; if generation A is greater than generation B, then the
     * `Group` corresponding to A is newer than the `Group` corresponding to B,
     * and should be used preferentially.
     *
     * Generated from protobuf field <code>bytes generation = 4;</code>
     */
    protected $generation = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $group_uid
     *           The UID of the paxos group, unique within the database. Matches the
     *           `group_uid` field in `Range`.
     *     @type array<\Google\Cloud\Spanner\V1\Tablet>|\Google\Protobuf\Internal\RepeatedField $tablets
     *           A list of tablets that are part of the group. Note that this list may not
     *           be exhaustive; it will only include tablets the server considers useful
     *           to the client. The returned list is ordered ascending by distance.
     *           Tablet UIDs reference `Tablet.tablet_uid`.
     *     @type int $leader_index
     *           The last known leader tablet of the group as an index into `tablets`. May
     *           be negative if the group has no known leader.
     *     @type string $generation
     *           `generation` indicates the freshness of the group information (including
     *           leader information) contained in this proto. Generations can be compared
     *           lexicographically; if generation A is greater than generation B, then the
     *           `Group` corresponding to A is newer than the `Group` corresponding to B,
     *           and should be used preferentially.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Location::initOnce();
        parent::__construct($data);
    }

    /**
     * The UID of the paxos group, unique within the database. Matches the
     * `group_uid` field in `Range`.
     *
     * Generated from protobuf field <code>uint64 group_uid = 1;</code>
     * @return int|string
     */
    public function getGroupUid()
    {
        return $this->group_uid;
    }

    /**
     * The UID of the paxos group, unique within the database. Matches the
     * `group_uid` field in `Range`.
     *
     * Generated from protobuf field <code>uint64 group_uid = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setGroupUid($var)
    {
        GPBUtil::checkUint64($var);
        $this->group_uid = $var;

        return $this;
    }

    /**
     * A list of tablets that are part of the group. Note that this list may not
     * be exhaustive; it will only include tablets the server considers useful
     * to the client. The returned list is ordered ascending by distance.
     * Tablet UIDs reference `Tablet.tablet_uid`.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.Tablet tablets = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTablets()
    {
        return $this->tablets;
    }

    /**
     * A list of tablets that are part of the group. Note that this list may not
     * be exhaustive; it will only include tablets the server considers useful
     * to the client. The returned list is ordered ascending by distance.
     * Tablet UIDs reference `Tablet.tablet_uid`.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.Tablet tablets = 2;</code>
     * @param array<\Google\Cloud\Spanner\V1\Tablet>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTablets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\Tablet::class);
        $this->tablets = $arr;

        return $this;
    }

    /**
     * The last known leader tablet of the group as an index into `tablets`. May
     * be negative if the group has no known leader.
     *
     * Generated from protobuf field <code>int32 leader_index = 3;</code>
     * @return int
     */
    public function getLeaderIndex()
    {
        return $this->leader_index;
    }

    /**
     * The last known leader tablet of the group as an index into `tablets`. May
     * be negative if the group has no known leader.
     *
     * Generated from protobuf field <code>int32 leader_index = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setLeaderIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->leader_index = $var;

        return $this;
    }

    /**
     * `generation` indicates the freshness of the group information (including
     * leader information) contained in this proto. Generations can be compared
     * lexicographically; if generation A is greater than generation B, then the
     * `Group` corresponding to A is newer than the `Group` corresponding to B,
     * and should be used preferentially.
     *
     * Generated from protobuf field <code>bytes generation = 4;</code>
     * @return string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * `generation` indicates the freshness of the group information (including
     * leader information) contained in this proto. Generations can be compared
     * lexicographically; if generation A is greater than generation B, then the
     * `Group` corresponding to A is newer than the `Group` corresponding to B,
     * and should be used preferentially.
     *
     * Generated from protobuf field <code>bytes generation = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkString($var, False);
        $this->generation = $var;

        return $this;
    }

}

