<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request for [Commit][google.spanner.v1.Spanner.Commit].
 *
 * Generated from protobuf message <code>google.spanner.v1.CommitRequest</code>
 */
class CommitRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The session in which the transaction to be committed is running.
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $session = '';
    /**
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    private $mutations;
    /**
     * If `true`, then statistics related to the transaction is included in
     * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     * Default value is `false`.
     *
     * Generated from protobuf field <code>bool return_commit_stats = 5;</code>
     */
    protected $return_commit_stats = false;
    /**
     * Optional. The amount of latency this request is configured to incur in
     * order to improve throughput. If this field isn't set, Spanner assumes
     * requests are relatively latency sensitive and automatically determines an
     * appropriate delay time. You can specify a commit delay value between 0 and
     * 500 ms.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_commit_delay = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $max_commit_delay = null;
    /**
     * Common options for this request.
     *
     * Generated from protobuf field <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    protected $request_options = null;
    /**
     * Optional. If the read-write transaction was executed on a multiplexed
     * session, then you must include the precommit token with the highest
     * sequence number received in this transaction attempt. Failing to do so
     * results in a `FailedPrecondition` error.
     *
     * Generated from protobuf field <code>.google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $precommit_token = null;
    protected $transaction;

    /**
     * @param string                              $session       Required. The session in which the transaction to be committed is running. Please see
     *                                                           {@see SpannerClient::sessionName()} for help formatting this field.
     * @param string                              $transactionId Commit a previously-started transaction.
     * @param \Google\Cloud\Spanner\V1\Mutation[] $mutations     The mutations to be executed when this transaction commits. All
     *                                                           mutations are applied atomically, in the order they appear in
     *                                                           this list.
     *
     * @return \Google\Cloud\Spanner\V1\CommitRequest
     *
     * @experimental
     */
    public static function build(string $session, string $transactionId, array $mutations): self
    {
        return (new self())
            ->setSession($session)
            ->setTransactionId($transactionId)
            ->setMutations($mutations);
    }

    /**
     * @param string                                      $session              Required. The session in which the transaction to be committed is running. Please see
     *                                                                          {@see SpannerClient::sessionName()} for help formatting this field.
     * @param \Google\Cloud\Spanner\V1\TransactionOptions $singleUseTransaction Execute mutations in a temporary transaction. Note that unlike
     *                                                                          commit of a previously-started transaction, commit with a
     *                                                                          temporary transaction is non-idempotent. That is, if the
     *                                                                          `CommitRequest` is sent to Cloud Spanner more than once (for
     *                                                                          instance, due to retries in the application, or in the
     *                                                                          transport library), it's possible that the mutations are
     *                                                                          executed more than once. If this is undesirable, use
     *                                                                          [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     *                                                                          [Commit][google.spanner.v1.Spanner.Commit] instead.
     * @param \Google\Cloud\Spanner\V1\Mutation[]         $mutations            The mutations to be executed when this transaction commits. All
     *                                                                          mutations are applied atomically, in the order they appear in
     *                                                                          this list.
     *
     * @return \Google\Cloud\Spanner\V1\CommitRequest
     *
     * @experimental
     */
    public static function buildFromSessionSingleUseTransactionMutations(string $session, \Google\Cloud\Spanner\V1\TransactionOptions $singleUseTransaction, array $mutations): self
    {
        return (new self())
            ->setSession($session)
            ->setSingleUseTransaction($singleUseTransaction)
            ->setMutations($mutations);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $session
     *           Required. The session in which the transaction to be committed is running.
     *     @type string $transaction_id
     *           Commit a previously-started transaction.
     *     @type \Google\Cloud\Spanner\V1\TransactionOptions $single_use_transaction
     *           Execute mutations in a temporary transaction. Note that unlike
     *           commit of a previously-started transaction, commit with a
     *           temporary transaction is non-idempotent. That is, if the
     *           `CommitRequest` is sent to Cloud Spanner more than once (for
     *           instance, due to retries in the application, or in the
     *           transport library), it's possible that the mutations are
     *           executed more than once. If this is undesirable, use
     *           [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     *           [Commit][google.spanner.v1.Spanner.Commit] instead.
     *     @type array<\Google\Cloud\Spanner\V1\Mutation>|\Google\Protobuf\Internal\RepeatedField $mutations
     *           The mutations to be executed when this transaction commits. All
     *           mutations are applied atomically, in the order they appear in
     *           this list.
     *     @type bool $return_commit_stats
     *           If `true`, then statistics related to the transaction is included in
     *           the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     *           Default value is `false`.
     *     @type \Google\Protobuf\Duration $max_commit_delay
     *           Optional. The amount of latency this request is configured to incur in
     *           order to improve throughput. If this field isn't set, Spanner assumes
     *           requests are relatively latency sensitive and automatically determines an
     *           appropriate delay time. You can specify a commit delay value between 0 and
     *           500 ms.
     *     @type \Google\Cloud\Spanner\V1\RequestOptions $request_options
     *           Common options for this request.
     *     @type \Google\Cloud\Spanner\V1\MultiplexedSessionPrecommitToken $precommit_token
     *           Optional. If the read-write transaction was executed on a multiplexed
     *           session, then you must include the precommit token with the highest
     *           sequence number received in this transaction attempt. Failing to do so
     *           results in a `FailedPrecondition` error.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Spanner::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The session in which the transaction to be committed is running.
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Required. The session in which the transaction to be committed is running.
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSession($var)
    {
        GPBUtil::checkString($var, True);
        $this->session = $var;

        return $this;
    }

    /**
     * Commit a previously-started transaction.
     *
     * Generated from protobuf field <code>bytes transaction_id = 2;</code>
     * @return string
     */
    public function getTransactionId()
    {
        return $this->readOneof(2);
    }

    public function hasTransactionId()
    {
        return $this->hasOneof(2);
    }

    /**
     * Commit a previously-started transaction.
     *
     * Generated from protobuf field <code>bytes transaction_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setTransactionId($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it's possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionOptions|null
     */
    public function getSingleUseTransaction()
    {
        return $this->readOneof(3);
    }

    public function hasSingleUseTransaction()
    {
        return $this->hasOneof(3);
    }

    /**
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it's possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionOptions $var
     * @return $this
     */
    public function setSingleUseTransaction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionOptions::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMutations()
    {
        return $this->mutations;
    }

    /**
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     * @param array<\Google\Cloud\Spanner\V1\Mutation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMutations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\Mutation::class);
        $this->mutations = $arr;

        return $this;
    }

    /**
     * If `true`, then statistics related to the transaction is included in
     * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     * Default value is `false`.
     *
     * Generated from protobuf field <code>bool return_commit_stats = 5;</code>
     * @return bool
     */
    public function getReturnCommitStats()
    {
        return $this->return_commit_stats;
    }

    /**
     * If `true`, then statistics related to the transaction is included in
     * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     * Default value is `false`.
     *
     * Generated from protobuf field <code>bool return_commit_stats = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setReturnCommitStats($var)
    {
        GPBUtil::checkBool($var);
        $this->return_commit_stats = $var;

        return $this;
    }

    /**
     * Optional. The amount of latency this request is configured to incur in
     * order to improve throughput. If this field isn't set, Spanner assumes
     * requests are relatively latency sensitive and automatically determines an
     * appropriate delay time. You can specify a commit delay value between 0 and
     * 500 ms.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_commit_delay = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMaxCommitDelay()
    {
        return $this->max_commit_delay;
    }

    public function hasMaxCommitDelay()
    {
        return isset($this->max_commit_delay);
    }

    public function clearMaxCommitDelay()
    {
        unset($this->max_commit_delay);
    }

    /**
     * Optional. The amount of latency this request is configured to incur in
     * order to improve throughput. If this field isn't set, Spanner assumes
     * requests are relatively latency sensitive and automatically determines an
     * appropriate delay time. You can specify a commit delay value between 0 and
     * 500 ms.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_commit_delay = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxCommitDelay($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->max_commit_delay = $var;

        return $this;
    }

    /**
     * Common options for this request.
     *
     * Generated from protobuf field <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     * @return \Google\Cloud\Spanner\V1\RequestOptions|null
     */
    public function getRequestOptions()
    {
        return $this->request_options;
    }

    public function hasRequestOptions()
    {
        return isset($this->request_options);
    }

    public function clearRequestOptions()
    {
        unset($this->request_options);
    }

    /**
     * Common options for this request.
     *
     * Generated from protobuf field <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     * @param \Google\Cloud\Spanner\V1\RequestOptions $var
     * @return $this
     */
    public function setRequestOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\RequestOptions::class);
        $this->request_options = $var;

        return $this;
    }

    /**
     * Optional. If the read-write transaction was executed on a multiplexed
     * session, then you must include the precommit token with the highest
     * sequence number received in this transaction attempt. Failing to do so
     * results in a `FailedPrecondition` error.
     *
     * Generated from protobuf field <code>.google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Spanner\V1\MultiplexedSessionPrecommitToken|null
     */
    public function getPrecommitToken()
    {
        return $this->precommit_token;
    }

    public function hasPrecommitToken()
    {
        return isset($this->precommit_token);
    }

    public function clearPrecommitToken()
    {
        unset($this->precommit_token);
    }

    /**
     * Optional. If the read-write transaction was executed on a multiplexed
     * session, then you must include the precommit token with the highest
     * sequence number received in this transaction attempt. Failing to do so
     * results in a `FailedPrecondition` error.
     *
     * Generated from protobuf field <code>.google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Spanner\V1\MultiplexedSessionPrecommitToken $var
     * @return $this
     */
    public function setPrecommitToken($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\MultiplexedSessionPrecommitToken::class);
        $this->precommit_token = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTransaction()
    {
        return $this->whichOneof("transaction");
    }

}

