<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/notifications/v1/notificationsapi.proto

namespace Google\Shopping\Merchant\Notifications\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a notification subscription owned by a Merchant account.
 *
 * Generated from protobuf message <code>google.shopping.merchant.notifications.v1.NotificationSubscription</code>
 */
class NotificationSubscription extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The `name` of the notification configuration. Generated by the
     * Content API upon creation of a new `NotificationSubscription`. The
     * `account` represents the merchant ID of the merchant that owns the
     * configuration. Format:
     * `accounts/{account}/notificationsubscriptions/{notification_subscription}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * The event that the merchant wants to be notified about.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.notifications.v1.NotificationSubscription.NotificationEventType registered_event = 2;</code>
     */
    protected $registered_event = 0;
    /**
     * URL to be used to push the notification to the merchant.
     *
     * Generated from protobuf field <code>string call_back_uri = 5;</code>
     */
    protected $call_back_uri = '';
    protected $interested_in;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $all_managed_accounts
     *           If this value is true, the requesting account is notified of the
     *           specified event for all managed accounts (can be subaccounts or other
     *           linked accounts) including newly added accounts on a daily basis.
     *     @type string $target_account
     *           The `name` of the account you want to receive notifications for.
     *           Format: `accounts/{account}`
     *     @type string $name
     *           Output only. The `name` of the notification configuration. Generated by the
     *           Content API upon creation of a new `NotificationSubscription`. The
     *           `account` represents the merchant ID of the merchant that owns the
     *           configuration. Format:
     *           `accounts/{account}/notificationsubscriptions/{notification_subscription}`
     *     @type int $registered_event
     *           The event that the merchant wants to be notified about.
     *     @type string $call_back_uri
     *           URL to be used to push the notification to the merchant.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Notifications\V1\Notificationsapi::initOnce();
        parent::__construct($data);
    }

    /**
     * If this value is true, the requesting account is notified of the
     * specified event for all managed accounts (can be subaccounts or other
     * linked accounts) including newly added accounts on a daily basis.
     *
     * Generated from protobuf field <code>bool all_managed_accounts = 3;</code>
     * @return bool
     */
    public function getAllManagedAccounts()
    {
        return $this->readOneof(3);
    }

    public function hasAllManagedAccounts()
    {
        return $this->hasOneof(3);
    }

    /**
     * If this value is true, the requesting account is notified of the
     * specified event for all managed accounts (can be subaccounts or other
     * linked accounts) including newly added accounts on a daily basis.
     *
     * Generated from protobuf field <code>bool all_managed_accounts = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllManagedAccounts($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The `name` of the account you want to receive notifications for.
     * Format: `accounts/{account}`
     *
     * Generated from protobuf field <code>string target_account = 4;</code>
     * @return string
     */
    public function getTargetAccount()
    {
        return $this->readOneof(4);
    }

    public function hasTargetAccount()
    {
        return $this->hasOneof(4);
    }

    /**
     * The `name` of the account you want to receive notifications for.
     * Format: `accounts/{account}`
     *
     * Generated from protobuf field <code>string target_account = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setTargetAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Output only. The `name` of the notification configuration. Generated by the
     * Content API upon creation of a new `NotificationSubscription`. The
     * `account` represents the merchant ID of the merchant that owns the
     * configuration. Format:
     * `accounts/{account}/notificationsubscriptions/{notification_subscription}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The `name` of the notification configuration. Generated by the
     * Content API upon creation of a new `NotificationSubscription`. The
     * `account` represents the merchant ID of the merchant that owns the
     * configuration. Format:
     * `accounts/{account}/notificationsubscriptions/{notification_subscription}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The event that the merchant wants to be notified about.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.notifications.v1.NotificationSubscription.NotificationEventType registered_event = 2;</code>
     * @return int
     */
    public function getRegisteredEvent()
    {
        return $this->registered_event;
    }

    /**
     * The event that the merchant wants to be notified about.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.notifications.v1.NotificationSubscription.NotificationEventType registered_event = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setRegisteredEvent($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Notifications\V1\NotificationSubscription\NotificationEventType::class);
        $this->registered_event = $var;

        return $this;
    }

    /**
     * URL to be used to push the notification to the merchant.
     *
     * Generated from protobuf field <code>string call_back_uri = 5;</code>
     * @return string
     */
    public function getCallBackUri()
    {
        return $this->call_back_uri;
    }

    /**
     * URL to be used to push the notification to the merchant.
     *
     * Generated from protobuf field <code>string call_back_uri = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setCallBackUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->call_back_uri = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getInterestedIn()
    {
        return $this->whichOneof("interested_in");
    }

}

