<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/http_route.proto

namespace Google\Cloud\NetworkServices\V1\HttpRoute;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The specification for redirecting traffic.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.HttpRoute.Redirect</code>
 */
class Redirect extends \Google\Protobuf\Internal\Message
{
    /**
     * The host that will be used in the redirect response instead of the one
     * that was supplied in the request.
     *
     * Generated from protobuf field <code>string host_redirect = 1;</code>
     */
    protected $host_redirect = '';
    /**
     * The path that will be used in the redirect response instead of the one
     * that was supplied in the request.
     * path_redirect can not be supplied together with prefix_redirect. Supply
     * one alone or neither. If neither is supplied, the path of the original
     * request will be used for the redirect.
     *
     * Generated from protobuf field <code>string path_redirect = 2;</code>
     */
    protected $path_redirect = '';
    /**
     * Indicates that during redirection, the matched prefix (or path) should be
     * swapped with this value. This option allows URLs be dynamically created
     * based on the request.
     *
     * Generated from protobuf field <code>string prefix_rewrite = 3;</code>
     */
    protected $prefix_rewrite = '';
    /**
     * The HTTP Status code to use for the redirect.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.HttpRoute.Redirect.ResponseCode response_code = 4;</code>
     */
    protected $response_code = 0;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool https_redirect = 5;</code>
     */
    protected $https_redirect = false;
    /**
     * if set to true, any accompanying query portion of the original URL is
     * removed prior to redirecting the request. If set to false, the query
     * portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool strip_query = 6;</code>
     */
    protected $strip_query = false;
    /**
     * The port that will be used in the redirected request instead of the one
     * that was supplied in the request.
     *
     * Generated from protobuf field <code>int32 port_redirect = 7;</code>
     */
    protected $port_redirect = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host_redirect
     *           The host that will be used in the redirect response instead of the one
     *           that was supplied in the request.
     *     @type string $path_redirect
     *           The path that will be used in the redirect response instead of the one
     *           that was supplied in the request.
     *           path_redirect can not be supplied together with prefix_redirect. Supply
     *           one alone or neither. If neither is supplied, the path of the original
     *           request will be used for the redirect.
     *     @type string $prefix_rewrite
     *           Indicates that during redirection, the matched prefix (or path) should be
     *           swapped with this value. This option allows URLs be dynamically created
     *           based on the request.
     *     @type int $response_code
     *           The HTTP Status code to use for the redirect.
     *     @type bool $https_redirect
     *           If set to true, the URL scheme in the redirected request is set to https.
     *           If set to false, the URL scheme of the redirected request will remain the
     *           same as that of the request.
     *           The default is set to false.
     *     @type bool $strip_query
     *           if set to true, any accompanying query portion of the original URL is
     *           removed prior to redirecting the request. If set to false, the query
     *           portion of the original URL is retained.
     *           The default is set to false.
     *     @type int $port_redirect
     *           The port that will be used in the redirected request instead of the one
     *           that was supplied in the request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\HttpRoute::initOnce();
        parent::__construct($data);
    }

    /**
     * The host that will be used in the redirect response instead of the one
     * that was supplied in the request.
     *
     * Generated from protobuf field <code>string host_redirect = 1;</code>
     * @return string
     */
    public function getHostRedirect()
    {
        return $this->host_redirect;
    }

    /**
     * The host that will be used in the redirect response instead of the one
     * that was supplied in the request.
     *
     * Generated from protobuf field <code>string host_redirect = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setHostRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_redirect = $var;

        return $this;
    }

    /**
     * The path that will be used in the redirect response instead of the one
     * that was supplied in the request.
     * path_redirect can not be supplied together with prefix_redirect. Supply
     * one alone or neither. If neither is supplied, the path of the original
     * request will be used for the redirect.
     *
     * Generated from protobuf field <code>string path_redirect = 2;</code>
     * @return string
     */
    public function getPathRedirect()
    {
        return $this->path_redirect;
    }

    /**
     * The path that will be used in the redirect response instead of the one
     * that was supplied in the request.
     * path_redirect can not be supplied together with prefix_redirect. Supply
     * one alone or neither. If neither is supplied, the path of the original
     * request will be used for the redirect.
     *
     * Generated from protobuf field <code>string path_redirect = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setPathRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->path_redirect = $var;

        return $this;
    }

    /**
     * Indicates that during redirection, the matched prefix (or path) should be
     * swapped with this value. This option allows URLs be dynamically created
     * based on the request.
     *
     * Generated from protobuf field <code>string prefix_rewrite = 3;</code>
     * @return string
     */
    public function getPrefixRewrite()
    {
        return $this->prefix_rewrite;
    }

    /**
     * Indicates that during redirection, the matched prefix (or path) should be
     * swapped with this value. This option allows URLs be dynamically created
     * based on the request.
     *
     * Generated from protobuf field <code>string prefix_rewrite = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPrefixRewrite($var)
    {
        GPBUtil::checkString($var, True);
        $this->prefix_rewrite = $var;

        return $this;
    }

    /**
     * The HTTP Status code to use for the redirect.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.HttpRoute.Redirect.ResponseCode response_code = 4;</code>
     * @return int
     */
    public function getResponseCode()
    {
        return $this->response_code;
    }

    /**
     * The HTTP Status code to use for the redirect.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.HttpRoute.Redirect.ResponseCode response_code = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setResponseCode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\HttpRoute\Redirect\ResponseCode::class);
        $this->response_code = $var;

        return $this;
    }

    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool https_redirect = 5;</code>
     * @return bool
     */
    public function getHttpsRedirect()
    {
        return $this->https_redirect;
    }

    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool https_redirect = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setHttpsRedirect($var)
    {
        GPBUtil::checkBool($var);
        $this->https_redirect = $var;

        return $this;
    }

    /**
     * if set to true, any accompanying query portion of the original URL is
     * removed prior to redirecting the request. If set to false, the query
     * portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool strip_query = 6;</code>
     * @return bool
     */
    public function getStripQuery()
    {
        return $this->strip_query;
    }

    /**
     * if set to true, any accompanying query portion of the original URL is
     * removed prior to redirecting the request. If set to false, the query
     * portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool strip_query = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setStripQuery($var)
    {
        GPBUtil::checkBool($var);
        $this->strip_query = $var;

        return $this;
    }

    /**
     * The port that will be used in the redirected request instead of the one
     * that was supplied in the request.
     *
     * Generated from protobuf field <code>int32 port_redirect = 7;</code>
     * @return int
     */
    public function getPortRedirect()
    {
        return $this->port_redirect;
    }

    /**
     * The port that will be used in the redirected request instead of the one
     * that was supplied in the request.
     *
     * Generated from protobuf field <code>int32 port_redirect = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setPortRedirect($var)
    {
        GPBUtil::checkInt32($var);
        $this->port_redirect = $var;

        return $this;
    }

}


