<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/grpc_route.proto

namespace Google\Cloud\NetworkServices\V1\GrpcRoute;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The destination to which traffic will be routed.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.GrpcRoute.Destination</code>
 */
class Destination extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Specifies the proportion of requests forwarded to the backend
     * referenced by the serviceName field. This is computed as:
     * - weight/Sum(weights in this destination list).
     * For non-zero values, there may be some epsilon from the exact proportion
     * defined here depending on the precision an implementation supports.
     * If only one serviceName is specified and it has a weight greater than 0,
     * 100% of the traffic is forwarded to that backend.
     * If weights are specified for any one service name, they need to be
     * specified for all of them.
     * If weights are unspecified for all services, then, traffic is distributed
     * in equal proportions to all of them.
     *
     * Generated from protobuf field <code>optional int32 weight = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $weight = null;
    protected $destination_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_name
     *           Required. The URL of a destination service to which to route traffic.
     *           Must refer to either a BackendService or ServiceDirectoryService.
     *     @type int $weight
     *           Optional. Specifies the proportion of requests forwarded to the backend
     *           referenced by the serviceName field. This is computed as:
     *           - weight/Sum(weights in this destination list).
     *           For non-zero values, there may be some epsilon from the exact proportion
     *           defined here depending on the precision an implementation supports.
     *           If only one serviceName is specified and it has a weight greater than 0,
     *           100% of the traffic is forwarded to that backend.
     *           If weights are specified for any one service name, they need to be
     *           specified for all of them.
     *           If weights are unspecified for all services, then, traffic is distributed
     *           in equal proportions to all of them.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\GrpcRoute::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The URL of a destination service to which to route traffic.
     * Must refer to either a BackendService or ServiceDirectoryService.
     *
     * Generated from protobuf field <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServiceName()
    {
        return $this->readOneof(1);
    }

    public function hasServiceName()
    {
        return $this->hasOneof(1);
    }

    /**
     * Required. The URL of a destination service to which to route traffic.
     * Must refer to either a BackendService or ServiceDirectoryService.
     *
     * Generated from protobuf field <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServiceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Optional. Specifies the proportion of requests forwarded to the backend
     * referenced by the serviceName field. This is computed as:
     * - weight/Sum(weights in this destination list).
     * For non-zero values, there may be some epsilon from the exact proportion
     * defined here depending on the precision an implementation supports.
     * If only one serviceName is specified and it has a weight greater than 0,
     * 100% of the traffic is forwarded to that backend.
     * If weights are specified for any one service name, they need to be
     * specified for all of them.
     * If weights are unspecified for all services, then, traffic is distributed
     * in equal proportions to all of them.
     *
     * Generated from protobuf field <code>optional int32 weight = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getWeight()
    {
        return isset($this->weight) ? $this->weight : 0;
    }

    public function hasWeight()
    {
        return isset($this->weight);
    }

    public function clearWeight()
    {
        unset($this->weight);
    }

    /**
     * Optional. Specifies the proportion of requests forwarded to the backend
     * referenced by the serviceName field. This is computed as:
     * - weight/Sum(weights in this destination list).
     * For non-zero values, there may be some epsilon from the exact proportion
     * defined here depending on the precision an implementation supports.
     * If only one serviceName is specified and it has a weight greater than 0,
     * 100% of the traffic is forwarded to that backend.
     * If weights are specified for any one service name, they need to be
     * specified for all of them.
     * If weights are unspecified for all services, then, traffic is distributed
     * in equal proportions to all of them.
     *
     * Generated from protobuf field <code>optional int32 weight = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setWeight($var)
    {
        GPBUtil::checkInt32($var);
        $this->weight = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationType()
    {
        return $this->whichOneof("destination_type");
    }

}


