<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/monitoring/v3/service_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Monitoring\V3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Monitoring\V3\CreateServiceLevelObjectiveRequest;
use Google\Cloud\Monitoring\V3\CreateServiceRequest;
use Google\Cloud\Monitoring\V3\DeleteServiceLevelObjectiveRequest;
use Google\Cloud\Monitoring\V3\DeleteServiceRequest;
use Google\Cloud\Monitoring\V3\GetServiceLevelObjectiveRequest;
use Google\Cloud\Monitoring\V3\GetServiceRequest;
use Google\Cloud\Monitoring\V3\ListServiceLevelObjectivesRequest;
use Google\Cloud\Monitoring\V3\ListServicesRequest;
use Google\Cloud\Monitoring\V3\Service;
use Google\Cloud\Monitoring\V3\ServiceLevelObjective;
use Google\Cloud\Monitoring\V3\UpdateServiceLevelObjectiveRequest;
use Google\Cloud\Monitoring\V3\UpdateServiceRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The Cloud Monitoring Service-Oriented Monitoring API has endpoints for
 * managing and querying aspects of a Metrics Scope's services. These include
 * the `Service`'s monitored resources, its Service-Level Objectives, and a
 * taxonomy of categorized Health Metrics.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Service> createServiceAsync(CreateServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceLevelObjective> createServiceLevelObjectiveAsync(CreateServiceLevelObjectiveRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteServiceAsync(DeleteServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteServiceLevelObjectiveAsync(DeleteServiceLevelObjectiveRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Service> getServiceAsync(GetServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceLevelObjective> getServiceLevelObjectiveAsync(GetServiceLevelObjectiveRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceLevelObjectivesAsync(ListServiceLevelObjectivesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServicesAsync(ListServicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Service> updateServiceAsync(UpdateServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceLevelObjective> updateServiceLevelObjectiveAsync(UpdateServiceLevelObjectiveRequest $request, array $optionalArgs = [])
 */
final class ServiceMonitoringServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.monitoring.v3.ServiceMonitoringService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'monitoring.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'monitoring.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/monitoring',
        'https://www.googleapis.com/auth/monitoring.read',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/service_monitoring_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/service_monitoring_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/service_monitoring_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/service_monitoring_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_service resource.
     *
     * @param string $folder
     * @param string $service
     *
     * @return string The formatted folder_service resource.
     */
    public static function folderServiceName(string $folder, string $service): string
    {
        return self::getPathTemplate('folderService')->render([
            'folder' => $folder,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_service_service_level_objective resource.
     *
     * @param string $folder
     * @param string $service
     * @param string $serviceLevelObjective
     *
     * @return string The formatted folder_service_service_level_objective resource.
     */
    public static function folderServiceServiceLevelObjectiveName(
        string $folder,
        string $service,
        string $serviceLevelObjective
    ): string {
        return self::getPathTemplate('folderServiceServiceLevelObjective')->render([
            'folder' => $folder,
            'service' => $service,
            'service_level_objective' => $serviceLevelObjective,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_service resource.
     *
     * @param string $organization
     * @param string $service
     *
     * @return string The formatted organization_service resource.
     */
    public static function organizationServiceName(string $organization, string $service): string
    {
        return self::getPathTemplate('organizationService')->render([
            'organization' => $organization,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_service_service_level_objective resource.
     *
     * @param string $organization
     * @param string $service
     * @param string $serviceLevelObjective
     *
     * @return string The formatted organization_service_service_level_objective resource.
     */
    public static function organizationServiceServiceLevelObjectiveName(
        string $organization,
        string $service,
        string $serviceLevelObjective
    ): string {
        return self::getPathTemplate('organizationServiceServiceLevelObjective')->render([
            'organization' => $organization,
            'service' => $service,
            'service_level_objective' => $serviceLevelObjective,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_service resource.
     *
     * @param string $project
     * @param string $service
     *
     * @return string The formatted project_service resource.
     */
    public static function projectServiceName(string $project, string $service): string
    {
        return self::getPathTemplate('projectService')->render([
            'project' => $project,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_service_service_level_objective resource.
     *
     * @param string $project
     * @param string $service
     * @param string $serviceLevelObjective
     *
     * @return string The formatted project_service_service_level_objective resource.
     */
    public static function projectServiceServiceLevelObjectiveName(
        string $project,
        string $service,
        string $serviceLevelObjective
    ): string {
        return self::getPathTemplate('projectServiceServiceLevelObjective')->render([
            'project' => $project,
            'service' => $service,
            'service_level_objective' => $serviceLevelObjective,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName(string $project, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_level_objective resource.
     *
     * @param string $project
     * @param string $service
     * @param string $serviceLevelObjective
     *
     * @return string The formatted service_level_objective resource.
     */
    public static function serviceLevelObjectiveName(
        string $project,
        string $service,
        string $serviceLevelObjective
    ): string {
        return self::getPathTemplate('serviceLevelObjective')->render([
            'project' => $project,
            'service' => $service,
            'service_level_objective' => $serviceLevelObjective,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - folderService: folders/{folder}/services/{service}
     * - folderServiceServiceLevelObjective: folders/{folder}/services/{service}/serviceLevelObjectives/{service_level_objective}
     * - organizationService: organizations/{organization}/services/{service}
     * - organizationServiceServiceLevelObjective: organizations/{organization}/services/{service}/serviceLevelObjectives/{service_level_objective}
     * - projectService: projects/{project}/services/{service}
     * - projectServiceServiceLevelObjective: projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}
     * - service: projects/{project}/services/{service}
     * - serviceLevelObjective: projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'monitoring.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Monitoring\V3\ServiceMonitoringServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ServiceMonitoringServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create a `Service`.
     *
     * The async variant is {@see ServiceMonitoringServiceClient::createServiceAsync()}
     * .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/create_service.php
     *
     * @param CreateServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Service
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createService(CreateServiceRequest $request, array $callOptions = []): Service
    {
        return $this->startApiCall('CreateService', $request, $callOptions)->wait();
    }

    /**
     * Create a `ServiceLevelObjective` for the given `Service`.
     *
     * The async variant is
     * {@see ServiceMonitoringServiceClient::createServiceLevelObjectiveAsync()} .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/create_service_level_objective.php
     *
     * @param CreateServiceLevelObjectiveRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceLevelObjective
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServiceLevelObjective(
        CreateServiceLevelObjectiveRequest $request,
        array $callOptions = []
    ): ServiceLevelObjective {
        return $this->startApiCall('CreateServiceLevelObjective', $request, $callOptions)->wait();
    }

    /**
     * Soft delete this `Service`.
     *
     * The async variant is {@see ServiceMonitoringServiceClient::deleteServiceAsync()}
     * .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/delete_service.php
     *
     * @param DeleteServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteService(DeleteServiceRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteService', $request, $callOptions)->wait();
    }

    /**
     * Delete the given `ServiceLevelObjective`.
     *
     * The async variant is
     * {@see ServiceMonitoringServiceClient::deleteServiceLevelObjectiveAsync()} .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/delete_service_level_objective.php
     *
     * @param DeleteServiceLevelObjectiveRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceLevelObjective(
        DeleteServiceLevelObjectiveRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteServiceLevelObjective', $request, $callOptions)->wait();
    }

    /**
     * Get the named `Service`.
     *
     * The async variant is {@see ServiceMonitoringServiceClient::getServiceAsync()} .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/get_service.php
     *
     * @param GetServiceRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Service
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getService(GetServiceRequest $request, array $callOptions = []): Service
    {
        return $this->startApiCall('GetService', $request, $callOptions)->wait();
    }

    /**
     * Get a `ServiceLevelObjective` by name.
     *
     * The async variant is
     * {@see ServiceMonitoringServiceClient::getServiceLevelObjectiveAsync()} .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/get_service_level_objective.php
     *
     * @param GetServiceLevelObjectiveRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceLevelObjective
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceLevelObjective(
        GetServiceLevelObjectiveRequest $request,
        array $callOptions = []
    ): ServiceLevelObjective {
        return $this->startApiCall('GetServiceLevelObjective', $request, $callOptions)->wait();
    }

    /**
     * List the `ServiceLevelObjective`s for the given `Service`.
     *
     * The async variant is
     * {@see ServiceMonitoringServiceClient::listServiceLevelObjectivesAsync()} .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/list_service_level_objectives.php
     *
     * @param ListServiceLevelObjectivesRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceLevelObjectives(
        ListServiceLevelObjectivesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListServiceLevelObjectives', $request, $callOptions);
    }

    /**
     * List `Service`s for this Metrics Scope.
     *
     * The async variant is {@see ServiceMonitoringServiceClient::listServicesAsync()}
     * .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/list_services.php
     *
     * @param ListServicesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServices(ListServicesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListServices', $request, $callOptions);
    }

    /**
     * Update this `Service`.
     *
     * The async variant is {@see ServiceMonitoringServiceClient::updateServiceAsync()}
     * .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/update_service.php
     *
     * @param UpdateServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Service
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateService(UpdateServiceRequest $request, array $callOptions = []): Service
    {
        return $this->startApiCall('UpdateService', $request, $callOptions)->wait();
    }

    /**
     * Update the given `ServiceLevelObjective`.
     *
     * The async variant is
     * {@see ServiceMonitoringServiceClient::updateServiceLevelObjectiveAsync()} .
     *
     * @example samples/V3/ServiceMonitoringServiceClient/update_service_level_objective.php
     *
     * @param UpdateServiceLevelObjectiveRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceLevelObjective
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateServiceLevelObjective(
        UpdateServiceLevelObjectiveRequest $request,
        array $callOptions = []
    ): ServiceLevelObjective {
        return $this->startApiCall('UpdateServiceLevelObjective', $request, $callOptions)->wait();
    }
}
