<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/v1/managed_kafka_connect.proto

namespace Google\Cloud\ManagedKafka\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for CreateConnector.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.v1.CreateConnectorRequest</code>
 */
class CreateConnectorRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent Connect cluster in which to create the connector.
     * Structured like
     * `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The ID to use for the connector, which will become the final
     * component of the connector's name. The ID must be 1-63 characters long, and
     * match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     * RFC 1035.
     * This value is structured like: `my-connector-id`.
     *
     * Generated from protobuf field <code>string connector_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $connector_id = '';
    /**
     * Required. The connector to create.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.Connector connector = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $connector = null;

    /**
     * @param string                                  $parent      Required. The parent Connect cluster in which to create the connector.
     *                                                             Structured like
     *                                                             `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`. Please see
     *                                                             {@see ManagedKafkaConnectClient::connectClusterName()} for help formatting this field.
     * @param \Google\Cloud\ManagedKafka\V1\Connector $connector   Required. The connector to create.
     * @param string                                  $connectorId Required. The ID to use for the connector, which will become the final
     *                                                             component of the connector's name. The ID must be 1-63 characters long, and
     *                                                             match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     *                                                             RFC 1035.
     *
     *                                                             This value is structured like: `my-connector-id`.
     *
     * @return \Google\Cloud\ManagedKafka\V1\CreateConnectorRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\ManagedKafka\V1\Connector $connector, string $connectorId): self
    {
        return (new self())
            ->setParent($parent)
            ->setConnector($connector)
            ->setConnectorId($connectorId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent Connect cluster in which to create the connector.
     *           Structured like
     *           `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
     *     @type string $connector_id
     *           Required. The ID to use for the connector, which will become the final
     *           component of the connector's name. The ID must be 1-63 characters long, and
     *           match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     *           RFC 1035.
     *           This value is structured like: `my-connector-id`.
     *     @type \Google\Cloud\ManagedKafka\V1\Connector $connector
     *           Required. The connector to create.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\V1\ManagedKafkaConnect::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent Connect cluster in which to create the connector.
     * Structured like
     * `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent Connect cluster in which to create the connector.
     * Structured like
     * `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The ID to use for the connector, which will become the final
     * component of the connector's name. The ID must be 1-63 characters long, and
     * match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     * RFC 1035.
     * This value is structured like: `my-connector-id`.
     *
     * Generated from protobuf field <code>string connector_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getConnectorId()
    {
        return $this->connector_id;
    }

    /**
     * Required. The ID to use for the connector, which will become the final
     * component of the connector's name. The ID must be 1-63 characters long, and
     * match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     * RFC 1035.
     * This value is structured like: `my-connector-id`.
     *
     * Generated from protobuf field <code>string connector_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setConnectorId($var)
    {
        GPBUtil::checkString($var, True);
        $this->connector_id = $var;

        return $this;
    }

    /**
     * Required. The connector to create.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.Connector connector = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ManagedKafka\V1\Connector|null
     */
    public function getConnector()
    {
        return $this->connector;
    }

    public function hasConnector()
    {
        return isset($this->connector);
    }

    public function clearConnector()
    {
        unset($this->connector);
    }

    /**
     * Required. The connector to create.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.Connector connector = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ManagedKafka\V1\Connector $var
     * @return $this
     */
    public function setConnector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ManagedKafka\V1\Connector::class);
        $this->connector = $var;

        return $this;
    }

}

