<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/iam/v2/deny.proto

namespace Google\Cloud\Iam\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A deny rule in an IAM deny policy.
 *
 * Generated from protobuf message <code>google.iam.v2.DenyRule</code>
 */
class DenyRule extends \Google\Protobuf\Internal\Message
{
    /**
     * The identities that are prevented from using one or more permissions on
     * Google Cloud resources. This field can contain the following values:
     * * `principalSet://goog/public:all`: A special identifier that represents
     *   any principal that is on the internet, even if they do not have a Google
     *   Account or are not logged in.
     * * `principal://goog/subject/{email_id}`: A specific Google Account.
     *   Includes Gmail, Cloud Identity, and Google Workspace user accounts. For
     *   example, `principal://goog/subject/alice&#64;example.com`.
     * * `deleted:principal://goog/subject/{email_id}?uid={uid}`: A specific
     *   Google Account that was deleted recently. For example,
     *   `deleted:principal://goog/subject/alice&#64;example.com?uid=1234567890`. If
     *   the Google Account is recovered, this identifier reverts to the standard
     *   identifier for a Google Account.
     * * `principalSet://goog/group/{group_id}`: A Google group. For example,
     *   `principalSet://goog/group/admins&#64;example.com`.
     * * `deleted:principalSet://goog/group/{group_id}?uid={uid}`: A Google group
     *   that was deleted recently. For example,
     *   `deleted:principalSet://goog/group/admins&#64;example.com?uid=1234567890`. If
     *   the Google group is restored, this identifier reverts to the standard
     *   identifier for a Google group.
     * * `principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}`:
     *   A Google Cloud service account. For example,
     *   `principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com`.
     * * `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}?uid={uid}`:
     *   A Google Cloud service account that was deleted recently. For example,
     *   `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com?uid=1234567890`.
     *   If the service account is undeleted, this identifier reverts to the
     *   standard identifier for a service account.
     * * `principalSet://goog/cloudIdentityCustomerId/{customer_id}`: All of the
     *   principals associated with the specified Google Workspace or Cloud
     *   Identity customer ID. For example,
     *   `principalSet://goog/cloudIdentityCustomerId/C01Abc35`.
     *
     * Generated from protobuf field <code>repeated string denied_principals = 1;</code>
     */
    private $denied_principals;
    /**
     * The identities that are excluded from the deny rule, even if they are
     * listed in the `denied_principals`. For example, you could add a Google
     * group to the `denied_principals`, then exclude specific users who belong to
     * that group.
     * This field can contain the same values as the `denied_principals` field,
     * excluding `principalSet://goog/public:all`, which represents all users on
     * the internet.
     *
     * Generated from protobuf field <code>repeated string exception_principals = 2;</code>
     */
    private $exception_principals;
    /**
     * The permissions that are explicitly denied by this rule. Each permission
     * uses the format `{service_fqdn}/{resource}.{verb}`, where `{service_fqdn}`
     * is the fully qualified domain name for the service. For example,
     * `iam.googleapis.com/roles.list`.
     *
     * Generated from protobuf field <code>repeated string denied_permissions = 3;</code>
     */
    private $denied_permissions;
    /**
     * Specifies the permissions that this rule excludes from the set of denied
     * permissions given by `denied_permissions`. If a permission appears in
     * `denied_permissions` _and_ in `exception_permissions` then it will _not_ be
     * denied.
     * The excluded permissions can be specified using the same syntax as
     * `denied_permissions`.
     *
     * Generated from protobuf field <code>repeated string exception_permissions = 4;</code>
     */
    private $exception_permissions;
    /**
     * The condition that determines whether this deny rule applies to a request.
     * If the condition expression evaluates to `true`, then the deny rule is
     * applied; otherwise, the deny rule is not applied.
     * Each deny rule is evaluated independently. If this deny rule does not apply
     * to a request, other deny rules might still apply.
     * The condition can use CEL functions that evaluate
     * [resource
     * tags](https://cloud.google.com/iam/help/conditions/resource-tags). Other
     * functions and operators are not supported.
     *
     * Generated from protobuf field <code>.google.type.Expr denial_condition = 5;</code>
     */
    protected $denial_condition = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $denied_principals
     *           The identities that are prevented from using one or more permissions on
     *           Google Cloud resources. This field can contain the following values:
     *           * `principalSet://goog/public:all`: A special identifier that represents
     *             any principal that is on the internet, even if they do not have a Google
     *             Account or are not logged in.
     *           * `principal://goog/subject/{email_id}`: A specific Google Account.
     *             Includes Gmail, Cloud Identity, and Google Workspace user accounts. For
     *             example, `principal://goog/subject/alice&#64;example.com`.
     *           * `deleted:principal://goog/subject/{email_id}?uid={uid}`: A specific
     *             Google Account that was deleted recently. For example,
     *             `deleted:principal://goog/subject/alice&#64;example.com?uid=1234567890`. If
     *             the Google Account is recovered, this identifier reverts to the standard
     *             identifier for a Google Account.
     *           * `principalSet://goog/group/{group_id}`: A Google group. For example,
     *             `principalSet://goog/group/admins&#64;example.com`.
     *           * `deleted:principalSet://goog/group/{group_id}?uid={uid}`: A Google group
     *             that was deleted recently. For example,
     *             `deleted:principalSet://goog/group/admins&#64;example.com?uid=1234567890`. If
     *             the Google group is restored, this identifier reverts to the standard
     *             identifier for a Google group.
     *           * `principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}`:
     *             A Google Cloud service account. For example,
     *             `principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com`.
     *           * `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}?uid={uid}`:
     *             A Google Cloud service account that was deleted recently. For example,
     *             `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com?uid=1234567890`.
     *             If the service account is undeleted, this identifier reverts to the
     *             standard identifier for a service account.
     *           * `principalSet://goog/cloudIdentityCustomerId/{customer_id}`: All of the
     *             principals associated with the specified Google Workspace or Cloud
     *             Identity customer ID. For example,
     *             `principalSet://goog/cloudIdentityCustomerId/C01Abc35`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $exception_principals
     *           The identities that are excluded from the deny rule, even if they are
     *           listed in the `denied_principals`. For example, you could add a Google
     *           group to the `denied_principals`, then exclude specific users who belong to
     *           that group.
     *           This field can contain the same values as the `denied_principals` field,
     *           excluding `principalSet://goog/public:all`, which represents all users on
     *           the internet.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $denied_permissions
     *           The permissions that are explicitly denied by this rule. Each permission
     *           uses the format `{service_fqdn}/{resource}.{verb}`, where `{service_fqdn}`
     *           is the fully qualified domain name for the service. For example,
     *           `iam.googleapis.com/roles.list`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $exception_permissions
     *           Specifies the permissions that this rule excludes from the set of denied
     *           permissions given by `denied_permissions`. If a permission appears in
     *           `denied_permissions` _and_ in `exception_permissions` then it will _not_ be
     *           denied.
     *           The excluded permissions can be specified using the same syntax as
     *           `denied_permissions`.
     *     @type \Google\Type\Expr $denial_condition
     *           The condition that determines whether this deny rule applies to a request.
     *           If the condition expression evaluates to `true`, then the deny rule is
     *           applied; otherwise, the deny rule is not applied.
     *           Each deny rule is evaluated independently. If this deny rule does not apply
     *           to a request, other deny rules might still apply.
     *           The condition can use CEL functions that evaluate
     *           [resource
     *           tags](https://cloud.google.com/iam/help/conditions/resource-tags). Other
     *           functions and operators are not supported.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Iam\V2\Deny::initOnce();
        parent::__construct($data);
    }

    /**
     * The identities that are prevented from using one or more permissions on
     * Google Cloud resources. This field can contain the following values:
     * * `principalSet://goog/public:all`: A special identifier that represents
     *   any principal that is on the internet, even if they do not have a Google
     *   Account or are not logged in.
     * * `principal://goog/subject/{email_id}`: A specific Google Account.
     *   Includes Gmail, Cloud Identity, and Google Workspace user accounts. For
     *   example, `principal://goog/subject/alice&#64;example.com`.
     * * `deleted:principal://goog/subject/{email_id}?uid={uid}`: A specific
     *   Google Account that was deleted recently. For example,
     *   `deleted:principal://goog/subject/alice&#64;example.com?uid=1234567890`. If
     *   the Google Account is recovered, this identifier reverts to the standard
     *   identifier for a Google Account.
     * * `principalSet://goog/group/{group_id}`: A Google group. For example,
     *   `principalSet://goog/group/admins&#64;example.com`.
     * * `deleted:principalSet://goog/group/{group_id}?uid={uid}`: A Google group
     *   that was deleted recently. For example,
     *   `deleted:principalSet://goog/group/admins&#64;example.com?uid=1234567890`. If
     *   the Google group is restored, this identifier reverts to the standard
     *   identifier for a Google group.
     * * `principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}`:
     *   A Google Cloud service account. For example,
     *   `principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com`.
     * * `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}?uid={uid}`:
     *   A Google Cloud service account that was deleted recently. For example,
     *   `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com?uid=1234567890`.
     *   If the service account is undeleted, this identifier reverts to the
     *   standard identifier for a service account.
     * * `principalSet://goog/cloudIdentityCustomerId/{customer_id}`: All of the
     *   principals associated with the specified Google Workspace or Cloud
     *   Identity customer ID. For example,
     *   `principalSet://goog/cloudIdentityCustomerId/C01Abc35`.
     *
     * Generated from protobuf field <code>repeated string denied_principals = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDeniedPrincipals()
    {
        return $this->denied_principals;
    }

    /**
     * The identities that are prevented from using one or more permissions on
     * Google Cloud resources. This field can contain the following values:
     * * `principalSet://goog/public:all`: A special identifier that represents
     *   any principal that is on the internet, even if they do not have a Google
     *   Account or are not logged in.
     * * `principal://goog/subject/{email_id}`: A specific Google Account.
     *   Includes Gmail, Cloud Identity, and Google Workspace user accounts. For
     *   example, `principal://goog/subject/alice&#64;example.com`.
     * * `deleted:principal://goog/subject/{email_id}?uid={uid}`: A specific
     *   Google Account that was deleted recently. For example,
     *   `deleted:principal://goog/subject/alice&#64;example.com?uid=1234567890`. If
     *   the Google Account is recovered, this identifier reverts to the standard
     *   identifier for a Google Account.
     * * `principalSet://goog/group/{group_id}`: A Google group. For example,
     *   `principalSet://goog/group/admins&#64;example.com`.
     * * `deleted:principalSet://goog/group/{group_id}?uid={uid}`: A Google group
     *   that was deleted recently. For example,
     *   `deleted:principalSet://goog/group/admins&#64;example.com?uid=1234567890`. If
     *   the Google group is restored, this identifier reverts to the standard
     *   identifier for a Google group.
     * * `principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}`:
     *   A Google Cloud service account. For example,
     *   `principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com`.
     * * `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_id}?uid={uid}`:
     *   A Google Cloud service account that was deleted recently. For example,
     *   `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account&#64;iam.gserviceaccount.com?uid=1234567890`.
     *   If the service account is undeleted, this identifier reverts to the
     *   standard identifier for a service account.
     * * `principalSet://goog/cloudIdentityCustomerId/{customer_id}`: All of the
     *   principals associated with the specified Google Workspace or Cloud
     *   Identity customer ID. For example,
     *   `principalSet://goog/cloudIdentityCustomerId/C01Abc35`.
     *
     * Generated from protobuf field <code>repeated string denied_principals = 1;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDeniedPrincipals($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->denied_principals = $arr;

        return $this;
    }

    /**
     * The identities that are excluded from the deny rule, even if they are
     * listed in the `denied_principals`. For example, you could add a Google
     * group to the `denied_principals`, then exclude specific users who belong to
     * that group.
     * This field can contain the same values as the `denied_principals` field,
     * excluding `principalSet://goog/public:all`, which represents all users on
     * the internet.
     *
     * Generated from protobuf field <code>repeated string exception_principals = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExceptionPrincipals()
    {
        return $this->exception_principals;
    }

    /**
     * The identities that are excluded from the deny rule, even if they are
     * listed in the `denied_principals`. For example, you could add a Google
     * group to the `denied_principals`, then exclude specific users who belong to
     * that group.
     * This field can contain the same values as the `denied_principals` field,
     * excluding `principalSet://goog/public:all`, which represents all users on
     * the internet.
     *
     * Generated from protobuf field <code>repeated string exception_principals = 2;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExceptionPrincipals($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->exception_principals = $arr;

        return $this;
    }

    /**
     * The permissions that are explicitly denied by this rule. Each permission
     * uses the format `{service_fqdn}/{resource}.{verb}`, where `{service_fqdn}`
     * is the fully qualified domain name for the service. For example,
     * `iam.googleapis.com/roles.list`.
     *
     * Generated from protobuf field <code>repeated string denied_permissions = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDeniedPermissions()
    {
        return $this->denied_permissions;
    }

    /**
     * The permissions that are explicitly denied by this rule. Each permission
     * uses the format `{service_fqdn}/{resource}.{verb}`, where `{service_fqdn}`
     * is the fully qualified domain name for the service. For example,
     * `iam.googleapis.com/roles.list`.
     *
     * Generated from protobuf field <code>repeated string denied_permissions = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDeniedPermissions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->denied_permissions = $arr;

        return $this;
    }

    /**
     * Specifies the permissions that this rule excludes from the set of denied
     * permissions given by `denied_permissions`. If a permission appears in
     * `denied_permissions` _and_ in `exception_permissions` then it will _not_ be
     * denied.
     * The excluded permissions can be specified using the same syntax as
     * `denied_permissions`.
     *
     * Generated from protobuf field <code>repeated string exception_permissions = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExceptionPermissions()
    {
        return $this->exception_permissions;
    }

    /**
     * Specifies the permissions that this rule excludes from the set of denied
     * permissions given by `denied_permissions`. If a permission appears in
     * `denied_permissions` _and_ in `exception_permissions` then it will _not_ be
     * denied.
     * The excluded permissions can be specified using the same syntax as
     * `denied_permissions`.
     *
     * Generated from protobuf field <code>repeated string exception_permissions = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExceptionPermissions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->exception_permissions = $arr;

        return $this;
    }

    /**
     * The condition that determines whether this deny rule applies to a request.
     * If the condition expression evaluates to `true`, then the deny rule is
     * applied; otherwise, the deny rule is not applied.
     * Each deny rule is evaluated independently. If this deny rule does not apply
     * to a request, other deny rules might still apply.
     * The condition can use CEL functions that evaluate
     * [resource
     * tags](https://cloud.google.com/iam/help/conditions/resource-tags). Other
     * functions and operators are not supported.
     *
     * Generated from protobuf field <code>.google.type.Expr denial_condition = 5;</code>
     * @return \Google\Type\Expr|null
     */
    public function getDenialCondition()
    {
        return $this->denial_condition;
    }

    public function hasDenialCondition()
    {
        return isset($this->denial_condition);
    }

    public function clearDenialCondition()
    {
        unset($this->denial_condition);
    }

    /**
     * The condition that determines whether this deny rule applies to a request.
     * If the condition expression evaluates to `true`, then the deny rule is
     * applied; otherwise, the deny rule is not applied.
     * Each deny rule is evaluated independently. If this deny rule does not apply
     * to a request, other deny rules might still apply.
     * The condition can use CEL functions that evaluate
     * [resource
     * tags](https://cloud.google.com/iam/help/conditions/resource-tags). Other
     * functions and operators are not supported.
     *
     * Generated from protobuf field <code>.google.type.Expr denial_condition = 5;</code>
     * @param \Google\Type\Expr $var
     * @return $this
     */
    public function setDenialCondition($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Expr::class);
        $this->denial_condition = $var;

        return $this;
    }

}

