<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: grafeas/v1/attestation.proto

namespace Grafeas\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Occurrence that represents a single "attestation". The authenticity of an
 * attestation can be verified using the attached signature. If the verifier
 * trusts the public key of the signer, then verifying the signature is
 * sufficient to establish trust. In this circumstance, the authority to which
 * this attestation is attached is primarily useful for lookup (how to find
 * this attestation if you already know the authority and artifact to be
 * verified) and intent (for which authority this attestation was intended to
 * sign.
 *
 * Generated from protobuf message <code>grafeas.v1.AttestationOccurrence</code>
 */
class AttestationOccurrence extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The serialized payload that is verified by one or more
     * `signatures`.
     *
     * Generated from protobuf field <code>bytes serialized_payload = 1;</code>
     */
    protected $serialized_payload = '';
    /**
     * One or more signatures over `serialized_payload`.  Verifier implementations
     * should consider this attestation message verified if at least one
     * `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     * for more details on signature structure and verification.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Signature signatures = 2;</code>
     */
    private $signatures;
    /**
     * One or more JWTs encoding a self-contained attestation.
     * Each JWT encodes the payload that it verifies within the JWT itself.
     * Verifier implementation SHOULD ignore the `serialized_payload` field
     * when verifying these JWTs.
     * If only JWTs are present on this AttestationOccurrence, then the
     * `serialized_payload` SHOULD be left empty.
     * Each JWT SHOULD encode a claim specific to the `resource_uri` of this
     * Occurrence, but this is not validated by Grafeas metadata API
     * implementations.  The JWT itself is opaque to Grafeas.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Jwt jwts = 3;</code>
     */
    private $jwts;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $serialized_payload
     *           Required. The serialized payload that is verified by one or more
     *           `signatures`.
     *     @type array<\Grafeas\V1\Signature>|\Google\Protobuf\Internal\RepeatedField $signatures
     *           One or more signatures over `serialized_payload`.  Verifier implementations
     *           should consider this attestation message verified if at least one
     *           `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     *           for more details on signature structure and verification.
     *     @type array<\Grafeas\V1\Jwt>|\Google\Protobuf\Internal\RepeatedField $jwts
     *           One or more JWTs encoding a self-contained attestation.
     *           Each JWT encodes the payload that it verifies within the JWT itself.
     *           Verifier implementation SHOULD ignore the `serialized_payload` field
     *           when verifying these JWTs.
     *           If only JWTs are present on this AttestationOccurrence, then the
     *           `serialized_payload` SHOULD be left empty.
     *           Each JWT SHOULD encode a claim specific to the `resource_uri` of this
     *           Occurrence, but this is not validated by Grafeas metadata API
     *           implementations.  The JWT itself is opaque to Grafeas.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Grafeas\V1\Attestation::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The serialized payload that is verified by one or more
     * `signatures`.
     *
     * Generated from protobuf field <code>bytes serialized_payload = 1;</code>
     * @return string
     */
    public function getSerializedPayload()
    {
        return $this->serialized_payload;
    }

    /**
     * Required. The serialized payload that is verified by one or more
     * `signatures`.
     *
     * Generated from protobuf field <code>bytes serialized_payload = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSerializedPayload($var)
    {
        GPBUtil::checkString($var, False);
        $this->serialized_payload = $var;

        return $this;
    }

    /**
     * One or more signatures over `serialized_payload`.  Verifier implementations
     * should consider this attestation message verified if at least one
     * `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     * for more details on signature structure and verification.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Signature signatures = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSignatures()
    {
        return $this->signatures;
    }

    /**
     * One or more signatures over `serialized_payload`.  Verifier implementations
     * should consider this attestation message verified if at least one
     * `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     * for more details on signature structure and verification.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Signature signatures = 2;</code>
     * @param array<\Grafeas\V1\Signature>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSignatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\Signature::class);
        $this->signatures = $arr;

        return $this;
    }

    /**
     * One or more JWTs encoding a self-contained attestation.
     * Each JWT encodes the payload that it verifies within the JWT itself.
     * Verifier implementation SHOULD ignore the `serialized_payload` field
     * when verifying these JWTs.
     * If only JWTs are present on this AttestationOccurrence, then the
     * `serialized_payload` SHOULD be left empty.
     * Each JWT SHOULD encode a claim specific to the `resource_uri` of this
     * Occurrence, but this is not validated by Grafeas metadata API
     * implementations.  The JWT itself is opaque to Grafeas.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Jwt jwts = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getJwts()
    {
        return $this->jwts;
    }

    /**
     * One or more JWTs encoding a self-contained attestation.
     * Each JWT encodes the payload that it verifies within the JWT itself.
     * Verifier implementation SHOULD ignore the `serialized_payload` field
     * when verifying these JWTs.
     * If only JWTs are present on this AttestationOccurrence, then the
     * `serialized_payload` SHOULD be left empty.
     * Each JWT SHOULD encode a claim specific to the `resource_uri` of this
     * Occurrence, but this is not validated by Grafeas metadata API
     * implementations.  The JWT itself is opaque to Grafeas.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Jwt jwts = 3;</code>
     * @param array<\Grafeas\V1\Jwt>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setJwts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\Jwt::class);
        $this->jwts = $arr;

        return $this;
    }

}

