<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request message for Instances.Update. See the method description for details.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.UpdateInstanceRequest</code>
 */
class UpdateInstanceRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the instance resource to update.
     *
     * Generated from protobuf field <code>string instance = 18257045 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $instance = '';
    /**
     * The body resource for this request
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance instance_resource = 215988344 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $instance_resource = null;
    /**
     * Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
     * Check the MinimalAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string minimal_action = 270567060;</code>
     */
    protected $minimal_action = null;
    /**
     * Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string most_disruptive_allowed_action = 66103053;</code>
     */
    protected $most_disruptive_allowed_action = null;
    /**
     * Project ID for this request.
     *
     * Generated from protobuf field <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];</code>
     */
    protected $project = '';
    /**
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>optional string request_id = 37109963;</code>
     */
    protected $request_id = null;
    /**
     * The name of the zone for this request.
     *
     * Generated from protobuf field <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];</code>
     */
    protected $zone = '';

    /**
     * @param string                            $project          Project ID for this request.
     * @param string                            $zone             The name of the zone for this request.
     * @param string                            $instance         Name of the instance resource to update.
     * @param \Google\Cloud\Compute\V1\Instance $instanceResource The body resource for this request
     *
     * @return \Google\Cloud\Compute\V1\UpdateInstanceRequest
     *
     * @experimental
     */
    public static function build(string $project, string $zone, string $instance, \Google\Cloud\Compute\V1\Instance $instanceResource): self
    {
        return (new self())
            ->setProject($project)
            ->setZone($zone)
            ->setInstance($instance)
            ->setInstanceResource($instanceResource);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $instance
     *           Name of the instance resource to update.
     *     @type \Google\Cloud\Compute\V1\Instance $instance_resource
     *           The body resource for this request
     *     @type string $minimal_action
     *           Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
     *           Check the MinimalAction enum for the list of possible values.
     *     @type string $most_disruptive_allowed_action
     *           Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
     *           Check the MostDisruptiveAllowedAction enum for the list of possible values.
     *     @type string $project
     *           Project ID for this request.
     *     @type string $request_id
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type string $zone
     *           The name of the zone for this request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the instance resource to update.
     *
     * Generated from protobuf field <code>string instance = 18257045 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * Name of the instance resource to update.
     *
     * Generated from protobuf field <code>string instance = 18257045 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance = $var;

        return $this;
    }

    /**
     * The body resource for this request
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance instance_resource = 215988344 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Compute\V1\Instance|null
     */
    public function getInstanceResource()
    {
        return $this->instance_resource;
    }

    public function hasInstanceResource()
    {
        return isset($this->instance_resource);
    }

    public function clearInstanceResource()
    {
        unset($this->instance_resource);
    }

    /**
     * The body resource for this request
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance instance_resource = 215988344 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Compute\V1\Instance $var
     * @return $this
     */
    public function setInstanceResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Instance::class);
        $this->instance_resource = $var;

        return $this;
    }

    /**
     * Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
     * Check the MinimalAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string minimal_action = 270567060;</code>
     * @return string
     */
    public function getMinimalAction()
    {
        return isset($this->minimal_action) ? $this->minimal_action : '';
    }

    public function hasMinimalAction()
    {
        return isset($this->minimal_action);
    }

    public function clearMinimalAction()
    {
        unset($this->minimal_action);
    }

    /**
     * Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
     * Check the MinimalAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string minimal_action = 270567060;</code>
     * @param string $var
     * @return $this
     */
    public function setMinimalAction($var)
    {
        GPBUtil::checkString($var, True);
        $this->minimal_action = $var;

        return $this;
    }

    /**
     * Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string most_disruptive_allowed_action = 66103053;</code>
     * @return string
     */
    public function getMostDisruptiveAllowedAction()
    {
        return isset($this->most_disruptive_allowed_action) ? $this->most_disruptive_allowed_action : '';
    }

    public function hasMostDisruptiveAllowedAction()
    {
        return isset($this->most_disruptive_allowed_action);
    }

    public function clearMostDisruptiveAllowedAction()
    {
        unset($this->most_disruptive_allowed_action);
    }

    /**
     * Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string most_disruptive_allowed_action = 66103053;</code>
     * @param string $var
     * @return $this
     */
    public function setMostDisruptiveAllowedAction($var)
    {
        GPBUtil::checkString($var, True);
        $this->most_disruptive_allowed_action = $var;

        return $this;
    }

    /**
     * Project ID for this request.
     *
     * Generated from protobuf field <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * Project ID for this request.
     *
     * Generated from protobuf field <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>optional string request_id = 37109963;</code>
     * @return string
     */
    public function getRequestId()
    {
        return isset($this->request_id) ? $this->request_id : '';
    }

    public function hasRequestId()
    {
        return isset($this->request_id);
    }

    public function clearRequestId()
    {
        unset($this->request_id);
    }

    /**
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>optional string request_id = 37109963;</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * The name of the zone for this request.
     *
     * Generated from protobuf field <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * The name of the zone for this request.
     *
     * Generated from protobuf field <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

}

