<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/membership.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for listing memberships.
 *
 * Generated from protobuf message <code>google.chat.v1.ListMembershipsRequest</code>
 */
class ListMembershipsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the space for which to fetch a membership
     * list.
     * Format: spaces/{space}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The maximum number of memberships to return. The service might
     * return fewer than this value.
     * If unspecified, at most 100 memberships are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * Negative values return an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';
    /**
     * Optional. A query filter.
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     * For example, the following queries are valid:
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     * member.type != "BOT"
     * ```
     * The following queries are invalid:
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $filter = '';
    /**
     * Optional. When `true`, also returns memberships associated with a
     * [Google Group][google.chat.v1.Membership.group_member], in
     * addition to other types of memberships. If a
     * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     * [Google Group][google.chat.v1.Membership.group_member]
     * memberships that don't match the filter criteria aren't returned.
     *
     * Generated from protobuf field <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $show_groups = false;
    /**
     * Optional. When `true`, also returns memberships associated with
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     * addition to other types of memberships. If a
     * filter is set,
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     * that don't match the filter criteria aren't returned.
     * Currently requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *
     * Generated from protobuf field <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $show_invited = false;
    /**
     * Optional. When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires either the `chat.admin.memberships.readonly` or
     * `chat.admin.memberships` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * Listing app memberships in a space isn't supported when using admin access.
     *
     * Generated from protobuf field <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $use_admin_access = false;

    /**
     * @param string $parent Required. The resource name of the space for which to fetch a membership
     *                       list.
     *
     *                       Format: spaces/{space}
     *                       Please see {@see ChatServiceClient::spaceName()} for help formatting this field.
     *
     * @return \Google\Apps\Chat\V1\ListMembershipsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the space for which to fetch a membership
     *           list.
     *           Format: spaces/{space}
     *     @type int $page_size
     *           Optional. The maximum number of memberships to return. The service might
     *           return fewer than this value.
     *           If unspecified, at most 100 memberships are returned.
     *           The maximum value is 1000. If you use a value more than 1000, it's
     *           automatically changed to 1000.
     *           Negative values return an `INVALID_ARGUMENT` error.
     *     @type string $page_token
     *           Optional. A page token, received from a previous call to list memberships.
     *           Provide this parameter to retrieve the subsequent page.
     *           When paginating, all other parameters provided should match the call that
     *           provided the page token. Passing different values to the other parameters
     *           might lead to unexpected results.
     *     @type string $filter
     *           Optional. A query filter.
     *           You can filter memberships by a member's role
     *           ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     *           and type
     *           ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     *           To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     *           To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     *           filter for `member.type` using the `!=` operator.
     *           To filter by both role and type, use the `AND` operator. To filter by
     *           either role or type, use the `OR` operator.
     *           Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     *           when `use_admin_access` is set to true. Other member type filters will be
     *           rejected.
     *           For example, the following queries are valid:
     *           ```
     *           role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     *           member.type = "HUMAN" AND role = "ROLE_MANAGER"
     *           member.type != "BOT"
     *           ```
     *           The following queries are invalid:
     *           ```
     *           member.type = "HUMAN" AND member.type = "BOT"
     *           role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     *           ```
     *           Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     *           error.
     *     @type bool $show_groups
     *           Optional. When `true`, also returns memberships associated with a
     *           [Google Group][google.chat.v1.Membership.group_member], in
     *           addition to other types of memberships. If a
     *           [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     *           [Google Group][google.chat.v1.Membership.group_member]
     *           memberships that don't match the filter criteria aren't returned.
     *     @type bool $show_invited
     *           Optional. When `true`, also returns memberships associated with
     *           [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     *           addition to other types of memberships. If a
     *           filter is set,
     *           [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     *           that don't match the filter criteria aren't returned.
     *           Currently requires [user
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *     @type bool $use_admin_access
     *           Optional. When `true`, the method runs using the user's Google Workspace
     *           administrator privileges.
     *           The calling user must be a Google Workspace administrator with the
     *           [manage chat and spaces conversations
     *           privilege](https://support.google.com/a/answer/13369245).
     *           Requires either the `chat.admin.memberships.readonly` or
     *           `chat.admin.memberships` [OAuth 2.0
     *           scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *           Listing app memberships in a space isn't supported when using admin access.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Membership::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the space for which to fetch a membership
     * list.
     * Format: spaces/{space}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the space for which to fetch a membership
     * list.
     * Format: spaces/{space}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The maximum number of memberships to return. The service might
     * return fewer than this value.
     * If unspecified, at most 100 memberships are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * Negative values return an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of memberships to return. The service might
     * return fewer than this value.
     * If unspecified, at most 100 memberships are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * Negative values return an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Optional. A query filter.
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     * For example, the following queries are valid:
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     * member.type != "BOT"
     * ```
     * The following queries are invalid:
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Optional. A query filter.
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     * For example, the following queries are valid:
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     * member.type != "BOT"
     * ```
     * The following queries are invalid:
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Optional. When `true`, also returns memberships associated with a
     * [Google Group][google.chat.v1.Membership.group_member], in
     * addition to other types of memberships. If a
     * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     * [Google Group][google.chat.v1.Membership.group_member]
     * memberships that don't match the filter criteria aren't returned.
     *
     * Generated from protobuf field <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getShowGroups()
    {
        return $this->show_groups;
    }

    /**
     * Optional. When `true`, also returns memberships associated with a
     * [Google Group][google.chat.v1.Membership.group_member], in
     * addition to other types of memberships. If a
     * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     * [Google Group][google.chat.v1.Membership.group_member]
     * memberships that don't match the filter criteria aren't returned.
     *
     * Generated from protobuf field <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setShowGroups($var)
    {
        GPBUtil::checkBool($var);
        $this->show_groups = $var;

        return $this;
    }

    /**
     * Optional. When `true`, also returns memberships associated with
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     * addition to other types of memberships. If a
     * filter is set,
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     * that don't match the filter criteria aren't returned.
     * Currently requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *
     * Generated from protobuf field <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getShowInvited()
    {
        return $this->show_invited;
    }

    /**
     * Optional. When `true`, also returns memberships associated with
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     * addition to other types of memberships. If a
     * filter is set,
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     * that don't match the filter criteria aren't returned.
     * Currently requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *
     * Generated from protobuf field <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setShowInvited($var)
    {
        GPBUtil::checkBool($var);
        $this->show_invited = $var;

        return $this;
    }

    /**
     * Optional. When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires either the `chat.admin.memberships.readonly` or
     * `chat.admin.memberships` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * Listing app memberships in a space isn't supported when using admin access.
     *
     * Generated from protobuf field <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getUseAdminAccess()
    {
        return $this->use_admin_access;
    }

    /**
     * Optional. When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires either the `chat.admin.memberships.readonly` or
     * `chat.admin.memberships` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * Listing app memberships in a space isn't supported when using admin access.
     *
     * Generated from protobuf field <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setUseAdminAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->use_admin_access = $var;

        return $this;
    }

}

