<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/resources.proto

namespace Google\Cloud\AlloyDb\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A cluster is a collection of regional AlloyDB resources. It can include a
 * primary instance and one or more read pool instances.
 * All cluster resources share a storage layer, which scales as needed.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.Cluster</code>
 */
class Cluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the cluster resource with the format:
     *  * projects/{project}/locations/{region}/clusters/{cluster_id}
     * where the cluster ID segment should satisfy the regex expression
     * `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     * The prefix of the cluster resource name is the name of the parent resource:
     *  * projects/{project}/locations/{region}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * User-settable and human-readable display name for the Cluster.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * Output only. The system-generated UID of the resource. The UID is assigned
     * when the resource is created, and it is retained until it is deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. Delete time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    /**
     * Output only. The current serving state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The type of the cluster. This is an output-only field and it's
     * populated at the Cluster creation time or the Cluster promotion
     * time. The cluster type is determined by which RPC was used to create
     * the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.ClusterType cluster_type = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $cluster_type = 0;
    /**
     * Optional. The database engine major version. This is an optional field and
     * it is populated at the Cluster creation time. If a database version is not
     * supplied at cluster creation time, then a default database version will
     * be used.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.DatabaseVersion database_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $database_version = 0;
    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.NetworkConfig network_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $network_config = null;
    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: `projects/{project}/global/networks/{network_id}`. This is required
     * to create a cluster. Deprecated, use network_config.network instead.
     *
     * Generated from protobuf field <code>string network = 10 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @deprecated
     */
    protected $network = '';
    /**
     * For Resource freshness validation (https://google.aip.dev/154)
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     */
    protected $etag = '';
    /**
     * Annotations to allow client tools to store small amount of arbitrary data.
     * This is distinct from labels.
     * https://google.aip.dev/128
     *
     * Generated from protobuf field <code>map<string, string> annotations = 12;</code>
     */
    private $annotations;
    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of Cluster does not match the user's
     * intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Input only. Initial user to setup during cluster creation. Required.
     * If used in `RestoreCluster` this is ignored.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.UserPassword initial_user = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $initial_user = null;
    /**
     * The automated backup policy for this cluster.
     * If no policy is provided then the default policy will be used. If backups
     * are supported for the cluster, the default policy takes one backup a day,
     * has a backup window of 1 hour, and retains backups for 14 days.
     * For more information on the defaults, consult the
     * documentation for the message type.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy automated_backup_policy = 17;</code>
     */
    protected $automated_backup_policy = null;
    /**
     * SSL configuration for this AlloyDB cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SslConfig ssl_config = 18 [deprecated = true];</code>
     * @deprecated
     */
    protected $ssl_config = null;
    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionConfig encryption_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $encryption_config = null;
    /**
     * Output only. The encryption information for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionInfo encryption_info = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $encryption_info = null;
    /**
     * Optional. Continuous backup configuration for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ContinuousBackupConfig continuous_backup_config = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $continuous_backup_config = null;
    /**
     * Output only. Continuous backup properties for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ContinuousBackupInfo continuous_backup_info = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $continuous_backup_info = null;
    /**
     * Cross Region replication config specific to SECONDARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.SecondaryConfig secondary_config = 22;</code>
     */
    protected $secondary_config = null;
    /**
     * Output only. Cross Region replication config specific to PRIMARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.PrimaryConfig primary_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $primary_config = null;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Optional. The configuration for Private Service Connect (PSC) for the
     * cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.PscConfig psc_config = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $psc_config = null;
    /**
     * Optional. The maintenance update policy determines when to allow or deny
     * updates.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MaintenanceUpdatePolicy maintenance_update_policy = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $maintenance_update_policy = null;
    /**
     * Output only. The maintenance schedule for the cluster, generated for a
     * specific rollout if a maintenance window is set.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MaintenanceSchedule maintenance_schedule = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $maintenance_schedule = null;
    /**
     * Optional. Subscription type of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SubscriptionType subscription_type = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $subscription_type = 0;
    /**
     * Output only. Metadata for free trial clusters
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.TrialMetadata trial_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $trial_metadata = null;
    /**
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * ```
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * ```
     *
     * Generated from protobuf field <code>map<string, string> tags = 41 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $tags;
    protected $source;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AlloyDb\V1\BackupSource $backup_source
     *           Output only. Cluster created from backup.
     *     @type \Google\Cloud\AlloyDb\V1\MigrationSource $migration_source
     *           Output only. Cluster created via DMS migration.
     *     @type \Google\Cloud\AlloyDb\V1\CloudSQLBackupRunSource $cloudsql_backup_run_source
     *           Output only. Cluster created from CloudSQL snapshot.
     *     @type string $name
     *           Output only. The name of the cluster resource with the format:
     *            * projects/{project}/locations/{region}/clusters/{cluster_id}
     *           where the cluster ID segment should satisfy the regex expression
     *           `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     *           The prefix of the cluster resource name is the name of the parent resource:
     *            * projects/{project}/locations/{region}
     *     @type string $display_name
     *           User-settable and human-readable display name for the Cluster.
     *     @type string $uid
     *           Output only. The system-generated UID of the resource. The UID is assigned
     *           when the resource is created, and it is retained until it is deleted.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Create time stamp
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Update time stamp
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. Delete time stamp
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels as key value pairs
     *     @type int $state
     *           Output only. The current serving state of the cluster.
     *     @type int $cluster_type
     *           Output only. The type of the cluster. This is an output-only field and it's
     *           populated at the Cluster creation time or the Cluster promotion
     *           time. The cluster type is determined by which RPC was used to create
     *           the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *     @type int $database_version
     *           Optional. The database engine major version. This is an optional field and
     *           it is populated at the Cluster creation time. If a database version is not
     *           supplied at cluster creation time, then a default database version will
     *           be used.
     *     @type \Google\Cloud\AlloyDb\V1\Cluster\NetworkConfig $network_config
     *     @type string $network
     *           Required. The resource link for the VPC network in which cluster resources
     *           are created and from which they are accessible via Private IP. The network
     *           must belong to the same project as the cluster. It is specified in the
     *           form: `projects/{project}/global/networks/{network_id}`. This is required
     *           to create a cluster. Deprecated, use network_config.network instead.
     *     @type string $etag
     *           For Resource freshness validation (https://google.aip.dev/154)
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Annotations to allow client tools to store small amount of arbitrary data.
     *           This is distinct from labels.
     *           https://google.aip.dev/128
     *     @type bool $reconciling
     *           Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     *           Set to true if the current state of Cluster does not match the user's
     *           intended state, and the service is actively updating the resource to
     *           reconcile them. This can happen due to user-triggered updates or
     *           system actions like failover or maintenance.
     *     @type \Google\Cloud\AlloyDb\V1\UserPassword $initial_user
     *           Input only. Initial user to setup during cluster creation. Required.
     *           If used in `RestoreCluster` this is ignored.
     *     @type \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy $automated_backup_policy
     *           The automated backup policy for this cluster.
     *           If no policy is provided then the default policy will be used. If backups
     *           are supported for the cluster, the default policy takes one backup a day,
     *           has a backup window of 1 hour, and retains backups for 14 days.
     *           For more information on the defaults, consult the
     *           documentation for the message type.
     *     @type \Google\Cloud\AlloyDb\V1\SslConfig $ssl_config
     *           SSL configuration for this AlloyDB cluster.
     *     @type \Google\Cloud\AlloyDb\V1\EncryptionConfig $encryption_config
     *           Optional. The encryption config can be specified to encrypt the data disks
     *           and other persistent data resources of a cluster with a
     *           customer-managed encryption key (CMEK). When this field is not
     *           specified, the cluster will then use default encryption scheme to
     *           protect the user data.
     *     @type \Google\Cloud\AlloyDb\V1\EncryptionInfo $encryption_info
     *           Output only. The encryption information for the cluster.
     *     @type \Google\Cloud\AlloyDb\V1\ContinuousBackupConfig $continuous_backup_config
     *           Optional. Continuous backup configuration for this cluster.
     *     @type \Google\Cloud\AlloyDb\V1\ContinuousBackupInfo $continuous_backup_info
     *           Output only. Continuous backup properties for this cluster.
     *     @type \Google\Cloud\AlloyDb\V1\Cluster\SecondaryConfig $secondary_config
     *           Cross Region replication config specific to SECONDARY cluster.
     *     @type \Google\Cloud\AlloyDb\V1\Cluster\PrimaryConfig $primary_config
     *           Output only. Cross Region replication config specific to PRIMARY cluster.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use.
     *     @type \Google\Cloud\AlloyDb\V1\Cluster\PscConfig $psc_config
     *           Optional. The configuration for Private Service Connect (PSC) for the
     *           cluster.
     *     @type \Google\Cloud\AlloyDb\V1\MaintenanceUpdatePolicy $maintenance_update_policy
     *           Optional. The maintenance update policy determines when to allow or deny
     *           updates.
     *     @type \Google\Cloud\AlloyDb\V1\MaintenanceSchedule $maintenance_schedule
     *           Output only. The maintenance schedule for the cluster, generated for a
     *           specific rollout if a maintenance window is set.
     *     @type int $subscription_type
     *           Optional. Subscription type of the cluster.
     *     @type \Google\Cloud\AlloyDb\V1\Cluster\TrialMetadata $trial_metadata
     *           Output only. Metadata for free trial clusters
     *     @type array|\Google\Protobuf\Internal\MapField $tags
     *           Optional. Input only. Immutable. Tag keys/values directly bound to this
     *           resource. For example:
     *           ```
     *           "123/environment": "production",
     *           "123/costCenter": "marketing"
     *           ```
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Cluster created from backup.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.BackupSource backup_source = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\BackupSource|null
     */
    public function getBackupSource()
    {
        return $this->readOneof(15);
    }

    public function hasBackupSource()
    {
        return $this->hasOneof(15);
    }

    /**
     * Output only. Cluster created from backup.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.BackupSource backup_source = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\BackupSource $var
     * @return $this
     */
    public function setBackupSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\BackupSource::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Output only. Cluster created via DMS migration.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MigrationSource migration_source = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\MigrationSource|null
     */
    public function getMigrationSource()
    {
        return $this->readOneof(16);
    }

    public function hasMigrationSource()
    {
        return $this->hasOneof(16);
    }

    /**
     * Output only. Cluster created via DMS migration.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MigrationSource migration_source = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\MigrationSource $var
     * @return $this
     */
    public function setMigrationSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\MigrationSource::class);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * Output only. Cluster created from CloudSQL snapshot.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.CloudSQLBackupRunSource cloudsql_backup_run_source = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\CloudSQLBackupRunSource|null
     */
    public function getCloudsqlBackupRunSource()
    {
        return $this->readOneof(42);
    }

    public function hasCloudsqlBackupRunSource()
    {
        return $this->hasOneof(42);
    }

    /**
     * Output only. Cluster created from CloudSQL snapshot.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.CloudSQLBackupRunSource cloudsql_backup_run_source = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\CloudSQLBackupRunSource $var
     * @return $this
     */
    public function setCloudsqlBackupRunSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\CloudSQLBackupRunSource::class);
        $this->writeOneof(42, $var);

        return $this;
    }

    /**
     * Output only. The name of the cluster resource with the format:
     *  * projects/{project}/locations/{region}/clusters/{cluster_id}
     * where the cluster ID segment should satisfy the regex expression
     * `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     * The prefix of the cluster resource name is the name of the parent resource:
     *  * projects/{project}/locations/{region}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the cluster resource with the format:
     *  * projects/{project}/locations/{region}/clusters/{cluster_id}
     * where the cluster ID segment should satisfy the regex expression
     * `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     * The prefix of the cluster resource name is the name of the parent resource:
     *  * projects/{project}/locations/{region}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User-settable and human-readable display name for the Cluster.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * User-settable and human-readable display name for the Cluster.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The system-generated UID of the resource. The UID is assigned
     * when the resource is created, and it is retained until it is deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. The system-generated UID of the resource. The UID is assigned
     * when the resource is created, and it is retained until it is deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Delete time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. Delete time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The current serving state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current serving state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1\Cluster\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The type of the cluster. This is an output-only field and it's
     * populated at the Cluster creation time or the Cluster promotion
     * time. The cluster type is determined by which RPC was used to create
     * the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.ClusterType cluster_type = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getClusterType()
    {
        return $this->cluster_type;
    }

    /**
     * Output only. The type of the cluster. This is an output-only field and it's
     * populated at the Cluster creation time or the Cluster promotion
     * time. The cluster type is determined by which RPC was used to create
     * the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.ClusterType cluster_type = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setClusterType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1\Cluster\ClusterType::class);
        $this->cluster_type = $var;

        return $this;
    }

    /**
     * Optional. The database engine major version. This is an optional field and
     * it is populated at the Cluster creation time. If a database version is not
     * supplied at cluster creation time, then a default database version will
     * be used.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.DatabaseVersion database_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDatabaseVersion()
    {
        return $this->database_version;
    }

    /**
     * Optional. The database engine major version. This is an optional field and
     * it is populated at the Cluster creation time. If a database version is not
     * supplied at cluster creation time, then a default database version will
     * be used.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.DatabaseVersion database_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1\DatabaseVersion::class);
        $this->database_version = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.NetworkConfig network_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1\Cluster\NetworkConfig|null
     */
    public function getNetworkConfig()
    {
        return $this->network_config;
    }

    public function hasNetworkConfig()
    {
        return isset($this->network_config);
    }

    public function clearNetworkConfig()
    {
        unset($this->network_config);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.NetworkConfig network_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1\Cluster\NetworkConfig $var
     * @return $this
     */
    public function setNetworkConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\Cluster\NetworkConfig::class);
        $this->network_config = $var;

        return $this;
    }

    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: `projects/{project}/global/networks/{network_id}`. This is required
     * to create a cluster. Deprecated, use network_config.network instead.
     *
     * Generated from protobuf field <code>string network = 10 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     * @deprecated
     */
    public function getNetwork()
    {
        if ($this->network !== '') {
            @trigger_error('network is deprecated.', E_USER_DEPRECATED);
        }
        return $this->network;
    }

    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: `projects/{project}/global/networks/{network_id}`. This is required
     * to create a cluster. Deprecated, use network_config.network instead.
     *
     * Generated from protobuf field <code>string network = 10 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setNetwork($var)
    {
        @trigger_error('network is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * For Resource freshness validation (https://google.aip.dev/154)
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * For Resource freshness validation (https://google.aip.dev/154)
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Annotations to allow client tools to store small amount of arbitrary data.
     * This is distinct from labels.
     * https://google.aip.dev/128
     *
     * Generated from protobuf field <code>map<string, string> annotations = 12;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Annotations to allow client tools to store small amount of arbitrary data.
     * This is distinct from labels.
     * https://google.aip.dev/128
     *
     * Generated from protobuf field <code>map<string, string> annotations = 12;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of Cluster does not match the user's
     * intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of Cluster does not match the user's
     * intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Input only. Initial user to setup during cluster creation. Required.
     * If used in `RestoreCluster` this is ignored.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.UserPassword initial_user = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\UserPassword|null
     */
    public function getInitialUser()
    {
        return $this->initial_user;
    }

    public function hasInitialUser()
    {
        return isset($this->initial_user);
    }

    public function clearInitialUser()
    {
        unset($this->initial_user);
    }

    /**
     * Input only. Initial user to setup during cluster creation. Required.
     * If used in `RestoreCluster` this is ignored.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.UserPassword initial_user = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\UserPassword $var
     * @return $this
     */
    public function setInitialUser($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\UserPassword::class);
        $this->initial_user = $var;

        return $this;
    }

    /**
     * The automated backup policy for this cluster.
     * If no policy is provided then the default policy will be used. If backups
     * are supported for the cluster, the default policy takes one backup a day,
     * has a backup window of 1 hour, and retains backups for 14 days.
     * For more information on the defaults, consult the
     * documentation for the message type.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy automated_backup_policy = 17;</code>
     * @return \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy|null
     */
    public function getAutomatedBackupPolicy()
    {
        return $this->automated_backup_policy;
    }

    public function hasAutomatedBackupPolicy()
    {
        return isset($this->automated_backup_policy);
    }

    public function clearAutomatedBackupPolicy()
    {
        unset($this->automated_backup_policy);
    }

    /**
     * The automated backup policy for this cluster.
     * If no policy is provided then the default policy will be used. If backups
     * are supported for the cluster, the default policy takes one backup a day,
     * has a backup window of 1 hour, and retains backups for 14 days.
     * For more information on the defaults, consult the
     * documentation for the message type.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy automated_backup_policy = 17;</code>
     * @param \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy $var
     * @return $this
     */
    public function setAutomatedBackupPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy::class);
        $this->automated_backup_policy = $var;

        return $this;
    }

    /**
     * SSL configuration for this AlloyDB cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SslConfig ssl_config = 18 [deprecated = true];</code>
     * @return \Google\Cloud\AlloyDb\V1\SslConfig|null
     * @deprecated
     */
    public function getSslConfig()
    {
        if (isset($this->ssl_config)) {
            @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        }
        return $this->ssl_config;
    }

    public function hasSslConfig()
    {
        if (isset($this->ssl_config)) {
            @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->ssl_config);
    }

    public function clearSslConfig()
    {
        @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        unset($this->ssl_config);
    }

    /**
     * SSL configuration for this AlloyDB cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SslConfig ssl_config = 18 [deprecated = true];</code>
     * @param \Google\Cloud\AlloyDb\V1\SslConfig $var
     * @return $this
     * @deprecated
     */
    public function setSslConfig($var)
    {
        @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\SslConfig::class);
        $this->ssl_config = $var;

        return $this;
    }

    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionConfig encryption_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1\EncryptionConfig|null
     */
    public function getEncryptionConfig()
    {
        return $this->encryption_config;
    }

    public function hasEncryptionConfig()
    {
        return isset($this->encryption_config);
    }

    public function clearEncryptionConfig()
    {
        unset($this->encryption_config);
    }

    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionConfig encryption_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1\EncryptionConfig $var
     * @return $this
     */
    public function setEncryptionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\EncryptionConfig::class);
        $this->encryption_config = $var;

        return $this;
    }

    /**
     * Output only. The encryption information for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionInfo encryption_info = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\EncryptionInfo|null
     */
    public function getEncryptionInfo()
    {
        return $this->encryption_info;
    }

    public function hasEncryptionInfo()
    {
        return isset($this->encryption_info);
    }

    public function clearEncryptionInfo()
    {
        unset($this->encryption_info);
    }

    /**
     * Output only. The encryption information for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionInfo encryption_info = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\EncryptionInfo $var
     * @return $this
     */
    public function setEncryptionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\EncryptionInfo::class);
        $this->encryption_info = $var;

        return $this;
    }

    /**
     * Optional. Continuous backup configuration for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ContinuousBackupConfig continuous_backup_config = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1\ContinuousBackupConfig|null
     */
    public function getContinuousBackupConfig()
    {
        return $this->continuous_backup_config;
    }

    public function hasContinuousBackupConfig()
    {
        return isset($this->continuous_backup_config);
    }

    public function clearContinuousBackupConfig()
    {
        unset($this->continuous_backup_config);
    }

    /**
     * Optional. Continuous backup configuration for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ContinuousBackupConfig continuous_backup_config = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1\ContinuousBackupConfig $var
     * @return $this
     */
    public function setContinuousBackupConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\ContinuousBackupConfig::class);
        $this->continuous_backup_config = $var;

        return $this;
    }

    /**
     * Output only. Continuous backup properties for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ContinuousBackupInfo continuous_backup_info = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\ContinuousBackupInfo|null
     */
    public function getContinuousBackupInfo()
    {
        return $this->continuous_backup_info;
    }

    public function hasContinuousBackupInfo()
    {
        return isset($this->continuous_backup_info);
    }

    public function clearContinuousBackupInfo()
    {
        unset($this->continuous_backup_info);
    }

    /**
     * Output only. Continuous backup properties for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ContinuousBackupInfo continuous_backup_info = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\ContinuousBackupInfo $var
     * @return $this
     */
    public function setContinuousBackupInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\ContinuousBackupInfo::class);
        $this->continuous_backup_info = $var;

        return $this;
    }

    /**
     * Cross Region replication config specific to SECONDARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.SecondaryConfig secondary_config = 22;</code>
     * @return \Google\Cloud\AlloyDb\V1\Cluster\SecondaryConfig|null
     */
    public function getSecondaryConfig()
    {
        return $this->secondary_config;
    }

    public function hasSecondaryConfig()
    {
        return isset($this->secondary_config);
    }

    public function clearSecondaryConfig()
    {
        unset($this->secondary_config);
    }

    /**
     * Cross Region replication config specific to SECONDARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.SecondaryConfig secondary_config = 22;</code>
     * @param \Google\Cloud\AlloyDb\V1\Cluster\SecondaryConfig $var
     * @return $this
     */
    public function setSecondaryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\Cluster\SecondaryConfig::class);
        $this->secondary_config = $var;

        return $this;
    }

    /**
     * Output only. Cross Region replication config specific to PRIMARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.PrimaryConfig primary_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\Cluster\PrimaryConfig|null
     */
    public function getPrimaryConfig()
    {
        return $this->primary_config;
    }

    public function hasPrimaryConfig()
    {
        return isset($this->primary_config);
    }

    public function clearPrimaryConfig()
    {
        unset($this->primary_config);
    }

    /**
     * Output only. Cross Region replication config specific to PRIMARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.PrimaryConfig primary_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\Cluster\PrimaryConfig $var
     * @return $this
     */
    public function setPrimaryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\Cluster\PrimaryConfig::class);
        $this->primary_config = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Optional. The configuration for Private Service Connect (PSC) for the
     * cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.PscConfig psc_config = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1\Cluster\PscConfig|null
     */
    public function getPscConfig()
    {
        return $this->psc_config;
    }

    public function hasPscConfig()
    {
        return isset($this->psc_config);
    }

    public function clearPscConfig()
    {
        unset($this->psc_config);
    }

    /**
     * Optional. The configuration for Private Service Connect (PSC) for the
     * cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.PscConfig psc_config = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1\Cluster\PscConfig $var
     * @return $this
     */
    public function setPscConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\Cluster\PscConfig::class);
        $this->psc_config = $var;

        return $this;
    }

    /**
     * Optional. The maintenance update policy determines when to allow or deny
     * updates.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MaintenanceUpdatePolicy maintenance_update_policy = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1\MaintenanceUpdatePolicy|null
     */
    public function getMaintenanceUpdatePolicy()
    {
        return $this->maintenance_update_policy;
    }

    public function hasMaintenanceUpdatePolicy()
    {
        return isset($this->maintenance_update_policy);
    }

    public function clearMaintenanceUpdatePolicy()
    {
        unset($this->maintenance_update_policy);
    }

    /**
     * Optional. The maintenance update policy determines when to allow or deny
     * updates.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MaintenanceUpdatePolicy maintenance_update_policy = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1\MaintenanceUpdatePolicy $var
     * @return $this
     */
    public function setMaintenanceUpdatePolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\MaintenanceUpdatePolicy::class);
        $this->maintenance_update_policy = $var;

        return $this;
    }

    /**
     * Output only. The maintenance schedule for the cluster, generated for a
     * specific rollout if a maintenance window is set.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MaintenanceSchedule maintenance_schedule = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\MaintenanceSchedule|null
     */
    public function getMaintenanceSchedule()
    {
        return $this->maintenance_schedule;
    }

    public function hasMaintenanceSchedule()
    {
        return isset($this->maintenance_schedule);
    }

    public function clearMaintenanceSchedule()
    {
        unset($this->maintenance_schedule);
    }

    /**
     * Output only. The maintenance schedule for the cluster, generated for a
     * specific rollout if a maintenance window is set.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.MaintenanceSchedule maintenance_schedule = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\MaintenanceSchedule $var
     * @return $this
     */
    public function setMaintenanceSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\MaintenanceSchedule::class);
        $this->maintenance_schedule = $var;

        return $this;
    }

    /**
     * Optional. Subscription type of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SubscriptionType subscription_type = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getSubscriptionType()
    {
        return $this->subscription_type;
    }

    /**
     * Optional. Subscription type of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SubscriptionType subscription_type = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setSubscriptionType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1\SubscriptionType::class);
        $this->subscription_type = $var;

        return $this;
    }

    /**
     * Output only. Metadata for free trial clusters
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.TrialMetadata trial_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1\Cluster\TrialMetadata|null
     */
    public function getTrialMetadata()
    {
        return $this->trial_metadata;
    }

    public function hasTrialMetadata()
    {
        return isset($this->trial_metadata);
    }

    public function clearTrialMetadata()
    {
        unset($this->trial_metadata);
    }

    /**
     * Output only. Metadata for free trial clusters
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.Cluster.TrialMetadata trial_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1\Cluster\TrialMetadata $var
     * @return $this
     */
    public function setTrialMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\Cluster\TrialMetadata::class);
        $this->trial_metadata = $var;

        return $this;
    }

    /**
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * ```
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * ```
     *
     * Generated from protobuf field <code>map<string, string> tags = 41 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * ```
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * ```
     *
     * Generated from protobuf field <code>map<string, string> tags = 41 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

