<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/google/googleapis/blob/master/google/cloud/dialogflow/v2/fulfillment.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\V2\Fulfillment;
use Google\Cloud\Dialogflow\V2\GetFulfillmentRequest;
use Google\Cloud\Dialogflow\V2\UpdateFulfillmentRequest;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service for managing [Fulfillments][google.cloud.dialogflow.v2.Fulfillment].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $fulfillmentsClient = new FulfillmentsClient();
 * try {
 *     $formattedName = $fulfillmentsClient->fulfillmentName('[PROJECT]');
 *     $response = $fulfillmentsClient->getFulfillment($formattedName);
 * } finally {
 *     $fulfillmentsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assistwith these names, this class includes a format method for each type of
 * name, and additionallya parseName method to extract the individual identifiers
 * contained within formatted namesthat are returned by the API.
 */
class FulfillmentsGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.dialogflow.v2.Fulfillments';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $fulfillmentNameTemplate;

    private static $projectFulfillmentNameTemplate;

    private static $projectLocationFulfillmentNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/fulfillments_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/fulfillments_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/fulfillments_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/fulfillments_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getFulfillmentNameTemplate()
    {
        if (self::$fulfillmentNameTemplate == null) {
            self::$fulfillmentNameTemplate = new PathTemplate('projects/{project}/agent/fulfillment');
        }

        return self::$fulfillmentNameTemplate;
    }

    private static function getProjectFulfillmentNameTemplate()
    {
        if (self::$projectFulfillmentNameTemplate == null) {
            self::$projectFulfillmentNameTemplate = new PathTemplate('projects/{project}/agent/fulfillment');
        }

        return self::$projectFulfillmentNameTemplate;
    }

    private static function getProjectLocationFulfillmentNameTemplate()
    {
        if (self::$projectLocationFulfillmentNameTemplate == null) {
            self::$projectLocationFulfillmentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/fulfillment');
        }

        return self::$projectLocationFulfillmentNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'fulfillment' => self::getFulfillmentNameTemplate(),
                'projectFulfillment' => self::getProjectFulfillmentNameTemplate(),
                'projectLocationFulfillment' => self::getProjectLocationFulfillmentNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a fulfillment
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted fulfillment resource.
     */
    public static function fulfillmentName($project)
    {
        return self::getFulfillmentNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_fulfillment resource.
     *
     * @param string $project
     *
     * @return string The formatted project_fulfillment resource.
     */
    public static function projectFulfillmentName($project)
    {
        return self::getProjectFulfillmentNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_fulfillment resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted project_location_fulfillment resource.
     */
    public static function projectLocationFulfillmentName($project, $location)
    {
        return self::getProjectLocationFulfillmentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - fulfillment: projects/{project}/agent/fulfillment
     * - projectFulfillment: projects/{project}/agent/fulfillment
     * - projectLocationFulfillment: projects/{project}/locations/{location}/agent/fulfillment
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Retrieves the fulfillment.
     *
     * Sample code:
     * ```
     * $fulfillmentsClient = new FulfillmentsClient();
     * try {
     *     $formattedName = $fulfillmentsClient->fulfillmentName('[PROJECT]');
     *     $response = $fulfillmentsClient->getFulfillment($formattedName);
     * } finally {
     *     $fulfillmentsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the fulfillment.
     *                             Format: `projects/<Project ID>/agent/fulfillment`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\Fulfillment
     *
     * @throws ApiException if the remote call fails
     */
    public function getFulfillment($name, array $optionalArgs = [])
    {
        $request = new GetFulfillmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetFulfillment', Fulfillment::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the fulfillment.
     *
     * Sample code:
     * ```
     * $fulfillmentsClient = new FulfillmentsClient();
     * try {
     *     $fulfillment = new Fulfillment();
     *     $updateMask = new FieldMask();
     *     $response = $fulfillmentsClient->updateFulfillment($fulfillment, $updateMask);
     * } finally {
     *     $fulfillmentsClient->close();
     * }
     * ```
     *
     * @param Fulfillment $fulfillment  Required. The fulfillment to update.
     * @param FieldMask   $updateMask   Required. The mask to control which fields get updated. If the mask is not
     *                                  present, all fields will be updated.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\Fulfillment
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFulfillment($fulfillment, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateFulfillmentRequest();
        $requestParamHeaders = [];
        $request->setFulfillment($fulfillment);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['fulfillment.name'] = $fulfillment->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateFulfillment', Fulfillment::class, $optionalArgs, $request)->wait();
    }
}
