<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/video/stitcher/v1/video_stitcher_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Video\Stitcher\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Video\Stitcher\V1\CdnKey;
use Google\Cloud\Video\Stitcher\V1\CreateCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\CreateLiveConfigRequest;
use Google\Cloud\Video\Stitcher\V1\CreateLiveSessionRequest;
use Google\Cloud\Video\Stitcher\V1\CreateSlateRequest;
use Google\Cloud\Video\Stitcher\V1\CreateVodSessionRequest;
use Google\Cloud\Video\Stitcher\V1\DeleteCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\DeleteLiveConfigRequest;
use Google\Cloud\Video\Stitcher\V1\DeleteSlateRequest;
use Google\Cloud\Video\Stitcher\V1\GetCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\GetLiveAdTagDetailRequest;
use Google\Cloud\Video\Stitcher\V1\GetLiveConfigRequest;
use Google\Cloud\Video\Stitcher\V1\GetLiveSessionRequest;
use Google\Cloud\Video\Stitcher\V1\GetSlateRequest;
use Google\Cloud\Video\Stitcher\V1\GetVodAdTagDetailRequest;
use Google\Cloud\Video\Stitcher\V1\GetVodSessionRequest;
use Google\Cloud\Video\Stitcher\V1\GetVodStitchDetailRequest;
use Google\Cloud\Video\Stitcher\V1\ListCdnKeysRequest;
use Google\Cloud\Video\Stitcher\V1\ListLiveAdTagDetailsRequest;
use Google\Cloud\Video\Stitcher\V1\ListLiveConfigsRequest;
use Google\Cloud\Video\Stitcher\V1\ListSlatesRequest;
use Google\Cloud\Video\Stitcher\V1\ListVodAdTagDetailsRequest;
use Google\Cloud\Video\Stitcher\V1\ListVodStitchDetailsRequest;
use Google\Cloud\Video\Stitcher\V1\LiveAdTagDetail;
use Google\Cloud\Video\Stitcher\V1\LiveConfig;
use Google\Cloud\Video\Stitcher\V1\LiveSession;
use Google\Cloud\Video\Stitcher\V1\Slate;
use Google\Cloud\Video\Stitcher\V1\UpdateCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\UpdateSlateRequest;
use Google\Cloud\Video\Stitcher\V1\VodAdTagDetail;
use Google\Cloud\Video\Stitcher\V1\VodSession;
use Google\Cloud\Video\Stitcher\V1\VodStitchDetail;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Video-On-Demand content stitching API allows you to insert ads
 * into (VoD) video on demand files. You will be able to render custom
 * scrubber bars with highlighted ads, enforce ad policies, allow
 * seamless playback and tracking on native players and monetize
 * content with any standard VMAP compliant ad server.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Video\Stitcher\V1\VideoStitcherServiceClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createCdnKeyAsync(CreateCdnKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createLiveConfigAsync(CreateLiveConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createLiveSessionAsync(CreateLiveSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSlateAsync(CreateSlateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createVodSessionAsync(CreateVodSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCdnKeyAsync(DeleteCdnKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteLiveConfigAsync(DeleteLiveConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSlateAsync(DeleteSlateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCdnKeyAsync(GetCdnKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLiveAdTagDetailAsync(GetLiveAdTagDetailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLiveConfigAsync(GetLiveConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLiveSessionAsync(GetLiveSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSlateAsync(GetSlateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getVodAdTagDetailAsync(GetVodAdTagDetailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getVodSessionAsync(GetVodSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getVodStitchDetailAsync(GetVodStitchDetailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCdnKeysAsync(ListCdnKeysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLiveAdTagDetailsAsync(ListLiveAdTagDetailsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLiveConfigsAsync(ListLiveConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSlatesAsync(ListSlatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listVodAdTagDetailsAsync(ListVodAdTagDetailsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listVodStitchDetailsAsync(ListVodStitchDetailsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCdnKeyAsync(UpdateCdnKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSlateAsync(UpdateSlateRequest $request, array $optionalArgs = [])
 */
abstract class VideoStitcherServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.video.stitcher.v1.VideoStitcherService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'videostitcher.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/video_stitcher_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/video_stitcher_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/video_stitcher_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/video_stitcher_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cdn_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cdnKey
     *
     * @return string The formatted cdn_key resource.
     */
    public static function cdnKeyName(string $project, string $location, string $cdnKey): string
    {
        return self::getPathTemplate('cdnKey')->render([
            'project' => $project,
            'location' => $location,
            'cdn_key' => $cdnKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * live_ad_tag_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $liveSession
     * @param string $liveAdTagDetail
     *
     * @return string The formatted live_ad_tag_detail resource.
     */
    public static function liveAdTagDetailName(string $project, string $location, string $liveSession, string $liveAdTagDetail): string
    {
        return self::getPathTemplate('liveAdTagDetail')->render([
            'project' => $project,
            'location' => $location,
            'live_session' => $liveSession,
            'live_ad_tag_detail' => $liveAdTagDetail,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a live_config
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $liveConfig
     *
     * @return string The formatted live_config resource.
     */
    public static function liveConfigName(string $project, string $location, string $liveConfig): string
    {
        return self::getPathTemplate('liveConfig')->render([
            'project' => $project,
            'location' => $location,
            'live_config' => $liveConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a live_session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $liveSession
     *
     * @return string The formatted live_session resource.
     */
    public static function liveSessionName(string $project, string $location, string $liveSession): string
    {
        return self::getPathTemplate('liveSession')->render([
            'project' => $project,
            'location' => $location,
            'live_session' => $liveSession,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a slate
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $slate
     *
     * @return string The formatted slate resource.
     */
    public static function slateName(string $project, string $location, string $slate): string
    {
        return self::getPathTemplate('slate')->render([
            'project' => $project,
            'location' => $location,
            'slate' => $slate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vod_ad_tag_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vodSession
     * @param string $vodAdTagDetail
     *
     * @return string The formatted vod_ad_tag_detail resource.
     */
    public static function vodAdTagDetailName(string $project, string $location, string $vodSession, string $vodAdTagDetail): string
    {
        return self::getPathTemplate('vodAdTagDetail')->render([
            'project' => $project,
            'location' => $location,
            'vod_session' => $vodSession,
            'vod_ad_tag_detail' => $vodAdTagDetail,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a vod_session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vodSession
     *
     * @return string The formatted vod_session resource.
     */
    public static function vodSessionName(string $project, string $location, string $vodSession): string
    {
        return self::getPathTemplate('vodSession')->render([
            'project' => $project,
            'location' => $location,
            'vod_session' => $vodSession,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vod_stitch_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vodSession
     * @param string $vodStitchDetail
     *
     * @return string The formatted vod_stitch_detail resource.
     */
    public static function vodStitchDetailName(string $project, string $location, string $vodSession, string $vodStitchDetail): string
    {
        return self::getPathTemplate('vodStitchDetail')->render([
            'project' => $project,
            'location' => $location,
            'vod_session' => $vodSession,
            'vod_stitch_detail' => $vodStitchDetail,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cdnKey: projects/{project}/locations/{location}/cdnKeys/{cdn_key}
     * - liveAdTagDetail: projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}
     * - liveConfig: projects/{project}/locations/{location}/liveConfigs/{live_config}
     * - liveSession: projects/{project}/locations/{location}/liveSessions/{live_session}
     * - location: projects/{project}/locations/{location}
     * - slate: projects/{project}/locations/{location}/slates/{slate}
     * - vodAdTagDetail: projects/{project}/locations/{location}/vodSessions/{vod_session}/vodAdTagDetails/{vod_ad_tag_detail}
     * - vodSession: projects/{project}/locations/{location}/vodSessions/{vod_session}
     * - vodStitchDetail: projects/{project}/locations/{location}/vodSessions/{vod_session}/vodStitchDetails/{vod_stitch_detail}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'videostitcher.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new CDN key.
     *
     * The async variant is {@see self::createCdnKeyAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/create_cdn_key.php
     *
     * @param CreateCdnKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCdnKey(CreateCdnKeyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCdnKey', $request, $callOptions)->wait();
    }

    /**
     * Registers the live config with the provided unique ID in
     * the specified region.
     *
     * The async variant is {@see self::createLiveConfigAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/create_live_config.php
     *
     * @param CreateLiveConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createLiveConfig(CreateLiveConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateLiveConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new live session.
     *
     * The async variant is {@see self::createLiveSessionAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/create_live_session.php
     *
     * @param CreateLiveSessionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LiveSession
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createLiveSession(CreateLiveSessionRequest $request, array $callOptions = []): LiveSession
    {
        return $this->startApiCall('CreateLiveSession', $request, $callOptions)->wait();
    }

    /**
     * Creates a slate.
     *
     * The async variant is {@see self::createSlateAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/create_slate.php
     *
     * @param CreateSlateRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSlate(CreateSlateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSlate', $request, $callOptions)->wait();
    }

    /**
     * Creates a client side playback VOD session and returns the full
     * tracking and playback metadata of the session.
     *
     * The async variant is {@see self::createVodSessionAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/create_vod_session.php
     *
     * @param CreateVodSessionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VodSession
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVodSession(CreateVodSessionRequest $request, array $callOptions = []): VodSession
    {
        return $this->startApiCall('CreateVodSession', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified CDN key.
     *
     * The async variant is {@see self::deleteCdnKeyAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/delete_cdn_key.php
     *
     * @param DeleteCdnKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCdnKey(DeleteCdnKeyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCdnKey', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified live config.
     *
     * The async variant is {@see self::deleteLiveConfigAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/delete_live_config.php
     *
     * @param DeleteLiveConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteLiveConfig(DeleteLiveConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteLiveConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified slate.
     *
     * The async variant is {@see self::deleteSlateAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/delete_slate.php
     *
     * @param DeleteSlateRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSlate(DeleteSlateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSlate', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified CDN key.
     *
     * The async variant is {@see self::getCdnKeyAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_cdn_key.php
     *
     * @param GetCdnKeyRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CdnKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCdnKey(GetCdnKeyRequest $request, array $callOptions = []): CdnKey
    {
        return $this->startApiCall('GetCdnKey', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified ad tag detail for the specified live session.
     *
     * The async variant is {@see self::getLiveAdTagDetailAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_live_ad_tag_detail.php
     *
     * @param GetLiveAdTagDetailRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LiveAdTagDetail
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLiveAdTagDetail(GetLiveAdTagDetailRequest $request, array $callOptions = []): LiveAdTagDetail
    {
        return $this->startApiCall('GetLiveAdTagDetail', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified live config managed by the Video
     * Stitcher service.
     *
     * The async variant is {@see self::getLiveConfigAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_live_config.php
     *
     * @param GetLiveConfigRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LiveConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLiveConfig(GetLiveConfigRequest $request, array $callOptions = []): LiveConfig
    {
        return $this->startApiCall('GetLiveConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the details for the specified live session.
     *
     * The async variant is {@see self::getLiveSessionAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_live_session.php
     *
     * @param GetLiveSessionRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LiveSession
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLiveSession(GetLiveSessionRequest $request, array $callOptions = []): LiveSession
    {
        return $this->startApiCall('GetLiveSession', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified slate.
     *
     * The async variant is {@see self::getSlateAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_slate.php
     *
     * @param GetSlateRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Slate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSlate(GetSlateRequest $request, array $callOptions = []): Slate
    {
        return $this->startApiCall('GetSlate', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified ad tag detail for the specified VOD session.
     *
     * The async variant is {@see self::getVodAdTagDetailAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_vod_ad_tag_detail.php
     *
     * @param GetVodAdTagDetailRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VodAdTagDetail
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVodAdTagDetail(GetVodAdTagDetailRequest $request, array $callOptions = []): VodAdTagDetail
    {
        return $this->startApiCall('GetVodAdTagDetail', $request, $callOptions)->wait();
    }

    /**
     * Returns the full tracking, playback metadata, and relevant ad-ops
     * logs for the specified VOD session.
     *
     * The async variant is {@see self::getVodSessionAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_vod_session.php
     *
     * @param GetVodSessionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VodSession
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVodSession(GetVodSessionRequest $request, array $callOptions = []): VodSession
    {
        return $this->startApiCall('GetVodSession', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified stitching information for the specified VOD session.
     *
     * The async variant is {@see self::getVodStitchDetailAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/get_vod_stitch_detail.php
     *
     * @param GetVodStitchDetailRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VodStitchDetail
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVodStitchDetail(GetVodStitchDetailRequest $request, array $callOptions = []): VodStitchDetail
    {
        return $this->startApiCall('GetVodStitchDetail', $request, $callOptions)->wait();
    }

    /**
     * Lists all CDN keys in the specified project and location.
     *
     * The async variant is {@see self::listCdnKeysAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/list_cdn_keys.php
     *
     * @param ListCdnKeysRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCdnKeys(ListCdnKeysRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCdnKeys', $request, $callOptions);
    }

    /**
     * Return the list of ad tag details for the specified live session.
     *
     * The async variant is {@see self::listLiveAdTagDetailsAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/list_live_ad_tag_details.php
     *
     * @param ListLiveAdTagDetailsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLiveAdTagDetails(ListLiveAdTagDetailsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLiveAdTagDetails', $request, $callOptions);
    }

    /**
     * Lists all live configs managed by the Video Stitcher that
     * belong to the specified project and region.
     *
     * The async variant is {@see self::listLiveConfigsAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/list_live_configs.php
     *
     * @param ListLiveConfigsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLiveConfigs(ListLiveConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLiveConfigs', $request, $callOptions);
    }

    /**
     * Lists all slates in the specified project and location.
     *
     * The async variant is {@see self::listSlatesAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/list_slates.php
     *
     * @param ListSlatesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSlates(ListSlatesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSlates', $request, $callOptions);
    }

    /**
     * Return the list of ad tag details for the specified VOD session.
     *
     * The async variant is {@see self::listVodAdTagDetailsAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/list_vod_ad_tag_details.php
     *
     * @param ListVodAdTagDetailsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVodAdTagDetails(ListVodAdTagDetailsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVodAdTagDetails', $request, $callOptions);
    }

    /**
     * Returns a list of detailed stitching information of the specified VOD
     * session.
     *
     * The async variant is {@see self::listVodStitchDetailsAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/list_vod_stitch_details.php
     *
     * @param ListVodStitchDetailsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVodStitchDetails(ListVodStitchDetailsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVodStitchDetails', $request, $callOptions);
    }

    /**
     * Updates the specified CDN key. Only update fields specified
     * in the call method body.
     *
     * The async variant is {@see self::updateCdnKeyAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/update_cdn_key.php
     *
     * @param UpdateCdnKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCdnKey(UpdateCdnKeyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCdnKey', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified slate.
     *
     * The async variant is {@see self::updateSlateAsync()} .
     *
     * @example samples/V1/VideoStitcherServiceClient/update_slate.php
     *
     * @param UpdateSlateRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSlate(UpdateSlateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSlate', $request, $callOptions)->wait();
    }
}
