<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/google/googleapis/blob/master/google/cloud/dialogflow/v2/environment.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\V2\CreateEnvironmentRequest;
use Google\Cloud\Dialogflow\V2\DeleteEnvironmentRequest;
use Google\Cloud\Dialogflow\V2\Environment;
use Google\Cloud\Dialogflow\V2\EnvironmentHistory;
use Google\Cloud\Dialogflow\V2\GetEnvironmentHistoryRequest;
use Google\Cloud\Dialogflow\V2\GetEnvironmentRequest;
use Google\Cloud\Dialogflow\V2\ListEnvironmentsRequest;
use Google\Cloud\Dialogflow\V2\ListEnvironmentsResponse;
use Google\Cloud\Dialogflow\V2\UpdateEnvironmentRequest;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Service for managing [Environments][google.cloud.dialogflow.v2.Environment].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $environmentsClient = new EnvironmentsClient();
 * try {
 *     $formattedParent = $environmentsClient->agentName('[PROJECT]');
 *     $environment = new Environment();
 *     $environmentId = 'environment_id';
 *     $response = $environmentsClient->createEnvironment($formattedParent, $environment, $environmentId);
 * } finally {
 *     $environmentsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class EnvironmentsGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.dialogflow.v2.Environments';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $agentNameTemplate;

    private static $environmentNameTemplate;

    private static $projectAgentNameTemplate;

    private static $projectEnvironmentNameTemplate;

    private static $projectLocationAgentNameTemplate;

    private static $projectLocationEnvironmentNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/environments_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/environments_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/environments_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/environments_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAgentNameTemplate()
    {
        if (self::$agentNameTemplate == null) {
            self::$agentNameTemplate = new PathTemplate('projects/{project}/agent');
        }

        return self::$agentNameTemplate;
    }

    private static function getEnvironmentNameTemplate()
    {
        if (self::$environmentNameTemplate == null) {
            self::$environmentNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}');
        }

        return self::$environmentNameTemplate;
    }

    private static function getProjectAgentNameTemplate()
    {
        if (self::$projectAgentNameTemplate == null) {
            self::$projectAgentNameTemplate = new PathTemplate('projects/{project}/agent');
        }

        return self::$projectAgentNameTemplate;
    }

    private static function getProjectEnvironmentNameTemplate()
    {
        if (self::$projectEnvironmentNameTemplate == null) {
            self::$projectEnvironmentNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}');
        }

        return self::$projectEnvironmentNameTemplate;
    }

    private static function getProjectLocationAgentNameTemplate()
    {
        if (self::$projectLocationAgentNameTemplate == null) {
            self::$projectLocationAgentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent');
        }

        return self::$projectLocationAgentNameTemplate;
    }

    private static function getProjectLocationEnvironmentNameTemplate()
    {
        if (self::$projectLocationEnvironmentNameTemplate == null) {
            self::$projectLocationEnvironmentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/environments/{environment}');
        }

        return self::$projectLocationEnvironmentNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'agent' => self::getAgentNameTemplate(),
                'environment' => self::getEnvironmentNameTemplate(),
                'projectAgent' => self::getProjectAgentNameTemplate(),
                'projectEnvironment' => self::getProjectEnvironmentNameTemplate(),
                'projectLocationAgent' => self::getProjectLocationAgentNameTemplate(),
                'projectLocationEnvironment' => self::getProjectLocationEnvironmentNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted agent resource.
     */
    public static function agentName($project)
    {
        return self::getAgentNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName($project, $environment)
    {
        return self::getEnvironmentNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_agent resource.
     *
     * @param string $project
     *
     * @return string The formatted project_agent resource.
     */
    public static function projectAgentName($project)
    {
        return self::getProjectAgentNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment resource.
     *
     * @param string $project
     * @param string $environment
     *
     * @return string The formatted project_environment resource.
     */
    public static function projectEnvironmentName($project, $environment)
    {
        return self::getProjectEnvironmentNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted project_location_agent resource.
     */
    public static function projectLocationAgentName($project, $location)
    {
        return self::getProjectLocationAgentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     *
     * @return string The formatted project_location_environment resource.
     */
    public static function projectLocationEnvironmentName($project, $location, $environment)
    {
        return self::getProjectLocationEnvironmentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/agent
     * - environment: projects/{project}/agent/environments/{environment}
     * - projectAgent: projects/{project}/agent
     * - projectEnvironment: projects/{project}/agent/environments/{environment}
     * - projectLocationAgent: projects/{project}/locations/{location}/agent
     * - projectLocationEnvironment: projects/{project}/locations/{location}/agent/environments/{environment}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Creates an agent environment.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedParent = $environmentsClient->agentName('[PROJECT]');
     *     $environment = new Environment();
     *     $environmentId = 'environment_id';
     *     $response = $environmentsClient->createEnvironment($formattedParent, $environment, $environmentId);
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The agent to create an environment for.
     *                                   Supported formats:
     *                                   - `projects/<Project ID>/agent`
     *                                   - `projects/<Project ID>/locations/<Location ID>/agent`
     * @param Environment $environment   Required. The environment to create.
     * @param string      $environmentId Required. The unique id of the new environment.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\Environment
     *
     * @throws ApiException if the remote call fails
     */
    public function createEnvironment($parent, $environment, $environmentId, array $optionalArgs = [])
    {
        $request = new CreateEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEnvironment($environment);
        $request->setEnvironmentId($environmentId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateEnvironment', Environment::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the specified agent environment.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedName = $environmentsClient->environmentName('[PROJECT]', '[ENVIRONMENT]');
     *     $environmentsClient->deleteEnvironment($formattedName);
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the environment to delete.
     *                             / Format:
     *                             - `projects/<Project ID>/agent/environments/<Environment ID>`
     *                             - `projects/<Project ID>/locations/<Location
     *                             ID>/agent/environments/<Environment ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEnvironment($name, array $optionalArgs = [])
    {
        $request = new DeleteEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteEnvironment', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieves the specified agent environment.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedName = $environmentsClient->environmentName('[PROJECT]', '[ENVIRONMENT]');
     *     $response = $environmentsClient->getEnvironment($formattedName);
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the environment.
     *                             Supported formats:
     *                             - `projects/<Project ID>/agent/environments/<Environment ID>`
     *                             - `projects/<Project ID>/locations/<Location
     *                             ID>/agent/environments/<Environment ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\Environment
     *
     * @throws ApiException if the remote call fails
     */
    public function getEnvironment($name, array $optionalArgs = [])
    {
        $request = new GetEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEnvironment', Environment::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the history of the specified environment.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedParent = $environmentsClient->environmentName('[PROJECT]', '[ENVIRONMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $environmentsClient->getEnvironmentHistory($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $environmentsClient->getEnvironmentHistory($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the environment to retrieve history for.
     *                             Supported formats:
     *                             - `projects/<Project ID>/agent/environments/<Environment ID>`
     *                             - `projects/<Project ID>/locations/<Location
     *                             ID>/agent/environments/<Environment ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function getEnvironmentHistory($parent, array $optionalArgs = [])
    {
        $request = new GetEnvironmentHistoryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('GetEnvironmentHistory', $optionalArgs, EnvironmentHistory::class, $request);
    }

    /**
     * Returns the list of all non-draft environments of the specified agent.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedParent = $environmentsClient->agentName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $environmentsClient->listEnvironments($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $environmentsClient->listEnvironments($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The agent to list all environments from.
     *                             Format:
     *                             - `projects/<Project ID>/agent`
     *                             - `projects/<Project ID>/locations/<Location ID>/agent`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEnvironments($parent, array $optionalArgs = [])
    {
        $request = new ListEnvironmentsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEnvironments', $optionalArgs, ListEnvironmentsResponse::class, $request);
    }

    /**
     * Updates the specified agent environment.
     *
     * This method allows you to deploy new agent versions into the environment.
     * When an environment is pointed to a new agent version by setting
     * `environment.agent_version`, the environment is temporarily set to the
     * `LOADING` state. During that time, the environment keeps on serving the
     * previous version of the agent. After the new agent version is done loading,
     * the environment is set back to the `RUNNING` state.
     * You can use "-" as Environment ID in environment name to update version
     * in "draft" environment. WARNING: this will negate all recent changes to
     * draft and can't be undone. You may want to save the draft to a version
     * before calling this function.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $environment = new Environment();
     *     $updateMask = new FieldMask();
     *     $response = $environmentsClient->updateEnvironment($environment, $updateMask);
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param Environment $environment  Required. The environment to update.
     * @param FieldMask   $updateMask   Required. The mask to control which fields get updated.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowLoadToDraftAndDiscardChanges
     *           Optional. This field is used to prevent accidental overwrite of the draft
     *           environment, which is an operation that cannot be undone. To confirm that
     *           the caller desires this overwrite, this field must be explicitly set to
     *           true when updating the draft environment (environment ID = `-`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\Environment
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEnvironment($environment, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setEnvironment($environment);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['environment.name'] = $environment->getName();
        if (isset($optionalArgs['allowLoadToDraftAndDiscardChanges'])) {
            $request->setAllowLoadToDraftAndDiscardChanges($optionalArgs['allowLoadToDraftAndDiscardChanges']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateEnvironment', Environment::class, $optionalArgs, $request)->wait();
    }
}
