<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/automl/v1/io.proto

namespace Google\Cloud\AutoMl\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Output configuration for ModelExport Action.
 *
 * Generated from protobuf message <code>google.cloud.automl.v1.ModelExportOutputConfig</code>
 */
class ModelExportOutputConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite", "tf_saved_model", "tf_js".
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *           be used in the browser and in Node.js using JavaScript.x`
     * * core_ml - Used for iOS mobile devices.
     *
     * Generated from protobuf field <code>string model_format = 4;</code>
     */
    private $model_format = '';
    /**
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *
     * Generated from protobuf field <code>map<string, string> params = 2;</code>
     */
    private $params;
    protected $destination;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AutoMl\V1\GcsDestination $gcs_destination
     *           Required. The Google Cloud Storage location where the model is to be
     *           written to. This location may only be set for the following model
     *           formats:
     *             "tflite", "edgetpu_tflite", "tf_saved_model", "tf_js", "core_ml".
     *            Under the directory given as the destination a new one with name
     *            "model-export-<model-display-name>-<timestamp-of-export-call>",
     *            where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *            will be created. Inside the model and any of its supporting files
     *            will be written.
     *     @type string $model_format
     *           The format in which the model must be exported. The available, and default,
     *           formats depend on the problem and model type (if given problem and type
     *           combination doesn't have a format listed, it means its models are not
     *           exportable):
     *           *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *                  mobile-high-accuracy-1:
     *                "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js".
     *           *  For Image Classification mobile-core-ml-low-latency-1,
     *                  mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *                "core_ml" (default).
     *           *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *                  mobile-high-accuracy-1:
     *                "tflite", "tf_saved_model", "tf_js".
     *           Formats description:
     *           * tflite - Used for Android mobile devices.
     *           * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                              devices.
     *           * tf_saved_model - A tensorflow model in SavedModel format.
     *           * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *                     be used in the browser and in Node.js using JavaScript.x`
     *           * core_ml - Used for iOS mobile devices.
     *     @type array|\Google\Protobuf\Internal\MapField $params
     *           Additional model-type and format specific parameters describing the
     *           requirements for the to be exported model files, any string must be up to
     *           25000 characters long.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Automl\V1\Io::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The Google Cloud Storage location where the model is to be
     * written to. This location may only be set for the following model
     * formats:
     *   "tflite", "edgetpu_tflite", "tf_saved_model", "tf_js", "core_ml".
     *  Under the directory given as the destination a new one with name
     *  "model-export-<model-display-name>-<timestamp-of-export-call>",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     *
     * Generated from protobuf field <code>.google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AutoMl\V1\GcsDestination
     */
    public function getGcsDestination()
    {
        return $this->readOneof(1);
    }

    /**
     * Required. The Google Cloud Storage location where the model is to be
     * written to. This location may only be set for the following model
     * formats:
     *   "tflite", "edgetpu_tflite", "tf_saved_model", "tf_js", "core_ml".
     *  Under the directory given as the destination a new one with name
     *  "model-export-<model-display-name>-<timestamp-of-export-call>",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     *
     * Generated from protobuf field <code>.google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AutoMl\V1\GcsDestination $var
     * @return $this
     */
    public function setGcsDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AutoMl\V1\GcsDestination::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite", "tf_saved_model", "tf_js".
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *           be used in the browser and in Node.js using JavaScript.x`
     * * core_ml - Used for iOS mobile devices.
     *
     * Generated from protobuf field <code>string model_format = 4;</code>
     * @return string
     */
    public function getModelFormat()
    {
        return $this->model_format;
    }

    /**
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite", "tf_saved_model", "tf_js".
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *           be used in the browser and in Node.js using JavaScript.x`
     * * core_ml - Used for iOS mobile devices.
     *
     * Generated from protobuf field <code>string model_format = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setModelFormat($var)
    {
        GPBUtil::checkString($var, True);
        $this->model_format = $var;

        return $this;
    }

    /**
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *
     * Generated from protobuf field <code>map<string, string> params = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *
     * Generated from protobuf field <code>map<string, string> params = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParams($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->params = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}

