<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies the configuration for a cross-bucket replication job. Cross-bucket
 * replication copies new or updated objects from a source Cloud Storage bucket
 * to a destination Cloud Storage bucket. Existing objects in the source bucket
 * are not copied by a new cross-bucket replication job.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.ReplicationSpec</code>
 */
class ReplicationSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * Object conditions that determine which objects are transferred. For
     * replication jobs, only `include_prefixes` and `exclude_prefixes` are
     * supported.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 3;</code>
     */
    protected $object_conditions = null;
    /**
     * Specifies the metadata options to be applied during replication.
     * Delete options are not supported. If a delete option is specified, the
     * request fails with an [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]
     * error.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferOptions transfer_options = 4;</code>
     */
    protected $transfer_options = null;
    protected $data_source;
    protected $data_sink;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\StorageTransfer\V1\GcsData $gcs_data_source
     *           The Cloud Storage bucket from which to replicate objects.
     *     @type \Google\Cloud\StorageTransfer\V1\GcsData $gcs_data_sink
     *           The Cloud Storage bucket to which to replicate objects.
     *     @type \Google\Cloud\StorageTransfer\V1\ObjectConditions $object_conditions
     *           Object conditions that determine which objects are transferred. For
     *           replication jobs, only `include_prefixes` and `exclude_prefixes` are
     *           supported.
     *     @type \Google\Cloud\StorageTransfer\V1\TransferOptions $transfer_options
     *           Specifies the metadata options to be applied during replication.
     *           Delete options are not supported. If a delete option is specified, the
     *           request fails with an [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]
     *           error.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * The Cloud Storage bucket from which to replicate objects.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     * @return \Google\Cloud\StorageTransfer\V1\GcsData|null
     */
    public function getGcsDataSource()
    {
        return $this->readOneof(1);
    }

    public function hasGcsDataSource()
    {
        return $this->hasOneof(1);
    }

    /**
     * The Cloud Storage bucket from which to replicate objects.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     * @param \Google\Cloud\StorageTransfer\V1\GcsData $var
     * @return $this
     */
    public function setGcsDataSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\GcsData::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The Cloud Storage bucket to which to replicate objects.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 2;</code>
     * @return \Google\Cloud\StorageTransfer\V1\GcsData|null
     */
    public function getGcsDataSink()
    {
        return $this->readOneof(2);
    }

    public function hasGcsDataSink()
    {
        return $this->hasOneof(2);
    }

    /**
     * The Cloud Storage bucket to which to replicate objects.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 2;</code>
     * @param \Google\Cloud\StorageTransfer\V1\GcsData $var
     * @return $this
     */
    public function setGcsDataSink($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\GcsData::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Object conditions that determine which objects are transferred. For
     * replication jobs, only `include_prefixes` and `exclude_prefixes` are
     * supported.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 3;</code>
     * @return \Google\Cloud\StorageTransfer\V1\ObjectConditions|null
     */
    public function getObjectConditions()
    {
        return $this->object_conditions;
    }

    public function hasObjectConditions()
    {
        return isset($this->object_conditions);
    }

    public function clearObjectConditions()
    {
        unset($this->object_conditions);
    }

    /**
     * Object conditions that determine which objects are transferred. For
     * replication jobs, only `include_prefixes` and `exclude_prefixes` are
     * supported.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 3;</code>
     * @param \Google\Cloud\StorageTransfer\V1\ObjectConditions $var
     * @return $this
     */
    public function setObjectConditions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\ObjectConditions::class);
        $this->object_conditions = $var;

        return $this;
    }

    /**
     * Specifies the metadata options to be applied during replication.
     * Delete options are not supported. If a delete option is specified, the
     * request fails with an [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]
     * error.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferOptions transfer_options = 4;</code>
     * @return \Google\Cloud\StorageTransfer\V1\TransferOptions|null
     */
    public function getTransferOptions()
    {
        return $this->transfer_options;
    }

    public function hasTransferOptions()
    {
        return isset($this->transfer_options);
    }

    public function clearTransferOptions()
    {
        unset($this->transfer_options);
    }

    /**
     * Specifies the metadata options to be applied during replication.
     * Delete options are not supported. If a delete option is specified, the
     * request fails with an [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]
     * error.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferOptions transfer_options = 4;</code>
     * @param \Google\Cloud\StorageTransfer\V1\TransferOptions $var
     * @return $this
     */
    public function setTransferOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\TransferOptions::class);
        $this->transfer_options = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDataSource()
    {
        return $this->whichOneof("data_source");
    }

    /**
     * @return string
     */
    public function getDataSink()
    {
        return $this->whichOneof("data_sink");
    }

}

