<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storage/control/v2/storage_control.proto

namespace Google\Cloud\Storage\Control\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for CreateManagedFolder.
 *
 * Generated from protobuf message <code>google.storage.control.v2.CreateManagedFolderRequest</code>
 */
class CreateManagedFolderRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Name of the bucket this managed folder belongs to.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. Properties of the managed folder being created.
     * The bucket and managed folder names are specified in the `parent` and
     * `managed_folder_id` fields. Populating these fields in `managed_folder`
     * will result in an error.
     *
     * Generated from protobuf field <code>.google.storage.control.v2.ManagedFolder managed_folder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $managed_folder = null;
    /**
     * Required. The name of the managed folder. It uses a single `/` as delimiter
     * and leading and trailing `/` are allowed.
     *
     * Generated from protobuf field <code>string managed_folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $managed_folder_id = '';
    /**
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     */
    protected $request_id = '';

    /**
     * @param string                                         $parent          Required. Name of the bucket this managed folder belongs to. Please see
     *                                                                        {@see StorageControlClient::bucketName()} for help formatting this field.
     * @param \Google\Cloud\Storage\Control\V2\ManagedFolder $managedFolder   Required. Properties of the managed folder being created.
     *                                                                        The bucket and managed folder names are specified in the `parent` and
     *                                                                        `managed_folder_id` fields. Populating these fields in `managed_folder`
     *                                                                        will result in an error.
     * @param string                                         $managedFolderId Required. The name of the managed folder. It uses a single `/` as delimiter
     *                                                                        and leading and trailing `/` are allowed.
     *
     * @return \Google\Cloud\Storage\Control\V2\CreateManagedFolderRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Storage\Control\V2\ManagedFolder $managedFolder, string $managedFolderId): self
    {
        return (new self())
            ->setParent($parent)
            ->setManagedFolder($managedFolder)
            ->setManagedFolderId($managedFolderId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. Name of the bucket this managed folder belongs to.
     *     @type \Google\Cloud\Storage\Control\V2\ManagedFolder $managed_folder
     *           Required. Properties of the managed folder being created.
     *           The bucket and managed folder names are specified in the `parent` and
     *           `managed_folder_id` fields. Populating these fields in `managed_folder`
     *           will result in an error.
     *     @type string $managed_folder_id
     *           Required. The name of the managed folder. It uses a single `/` as delimiter
     *           and leading and trailing `/` are allowed.
     *     @type string $request_id
     *           Optional. A unique identifier for this request. UUID is the recommended
     *           format, but other formats are still accepted.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storage\Control\V2\StorageControl::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Name of the bucket this managed folder belongs to.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. Name of the bucket this managed folder belongs to.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. Properties of the managed folder being created.
     * The bucket and managed folder names are specified in the `parent` and
     * `managed_folder_id` fields. Populating these fields in `managed_folder`
     * will result in an error.
     *
     * Generated from protobuf field <code>.google.storage.control.v2.ManagedFolder managed_folder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Storage\Control\V2\ManagedFolder|null
     */
    public function getManagedFolder()
    {
        return $this->managed_folder;
    }

    public function hasManagedFolder()
    {
        return isset($this->managed_folder);
    }

    public function clearManagedFolder()
    {
        unset($this->managed_folder);
    }

    /**
     * Required. Properties of the managed folder being created.
     * The bucket and managed folder names are specified in the `parent` and
     * `managed_folder_id` fields. Populating these fields in `managed_folder`
     * will result in an error.
     *
     * Generated from protobuf field <code>.google.storage.control.v2.ManagedFolder managed_folder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Storage\Control\V2\ManagedFolder $var
     * @return $this
     */
    public function setManagedFolder($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Storage\Control\V2\ManagedFolder::class);
        $this->managed_folder = $var;

        return $this;
    }

    /**
     * Required. The name of the managed folder. It uses a single `/` as delimiter
     * and leading and trailing `/` are allowed.
     *
     * Generated from protobuf field <code>string managed_folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getManagedFolderId()
    {
        return $this->managed_folder_id;
    }

    /**
     * Required. The name of the managed folder. It uses a single `/` as delimiter
     * and leading and trailing `/` are allowed.
     *
     * Generated from protobuf field <code>string managed_folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setManagedFolderId($var)
    {
        GPBUtil::checkString($var, True);
        $this->managed_folder_id = $var;

        return $this;
    }

    /**
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

