<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/inventories/v1/localinventory.proto

namespace Google\Shopping\Merchant\Inventories\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Local inventory information for the product. Represents in-store information
 * for a specific product at the store specified by
 * [`storeCode`][google.shopping.merchant.inventories.v1.LocalInventory.store_code].
 * For a list of all accepted attribute values, see the [local product inventory
 * data specification](https://support.google.com/merchants/answer/3061342).
 *
 * Generated from protobuf message <code>google.shopping.merchant.inventories.v1.LocalInventory</code>
 */
class LocalInventory extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the `LocalInventory` resource.
     * Format:
     * `accounts/{account}/products/{product}/localInventories/{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. The account that owns the product. This field will be ignored
     * if set by the client.
     *
     * Generated from protobuf field <code>int64 account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $account = 0;
    /**
     * Required. Immutable. Store code (the store ID from your Business Profile)
     * of the physical store the product is sold in. See the [Local product
     * inventory data
     * specification](https://support.google.com/merchants/answer/3061342) for
     * more information.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $store_code = '';
    /**
     * Optional. A list of local inventory attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.inventories.v1.LocalInventoryAttributes local_inventory_attributes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $local_inventory_attributes = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The name of the `LocalInventory` resource.
     *           Format:
     *           `accounts/{account}/products/{product}/localInventories/{store_code}`
     *     @type int|string $account
     *           Output only. The account that owns the product. This field will be ignored
     *           if set by the client.
     *     @type string $store_code
     *           Required. Immutable. Store code (the store ID from your Business Profile)
     *           of the physical store the product is sold in. See the [Local product
     *           inventory data
     *           specification](https://support.google.com/merchants/answer/3061342) for
     *           more information.
     *     @type \Google\Shopping\Merchant\Inventories\V1\LocalInventoryAttributes $local_inventory_attributes
     *           Optional. A list of local inventory attributes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Inventories\V1\Localinventory::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The name of the `LocalInventory` resource.
     * Format:
     * `accounts/{account}/products/{product}/localInventories/{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the `LocalInventory` resource.
     * Format:
     * `accounts/{account}/products/{product}/localInventories/{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The account that owns the product. This field will be ignored
     * if set by the client.
     *
     * Generated from protobuf field <code>int64 account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Output only. The account that owns the product. This field will be ignored
     * if set by the client.
     *
     * Generated from protobuf field <code>int64 account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAccount($var)
    {
        GPBUtil::checkInt64($var);
        $this->account = $var;

        return $this;
    }

    /**
     * Required. Immutable. Store code (the store ID from your Business Profile)
     * of the physical store the product is sold in. See the [Local product
     * inventory data
     * specification](https://support.google.com/merchants/answer/3061342) for
     * more information.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getStoreCode()
    {
        return $this->store_code;
    }

    /**
     * Required. Immutable. Store code (the store ID from your Business Profile)
     * of the physical store the product is sold in. See the [Local product
     * inventory data
     * specification](https://support.google.com/merchants/answer/3061342) for
     * more information.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setStoreCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->store_code = $var;

        return $this;
    }

    /**
     * Optional. A list of local inventory attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.inventories.v1.LocalInventoryAttributes local_inventory_attributes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Inventories\V1\LocalInventoryAttributes|null
     */
    public function getLocalInventoryAttributes()
    {
        return $this->local_inventory_attributes;
    }

    public function hasLocalInventoryAttributes()
    {
        return isset($this->local_inventory_attributes);
    }

    public function clearLocalInventoryAttributes()
    {
        unset($this->local_inventory_attributes);
    }

    /**
     * Optional. A list of local inventory attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.inventories.v1.LocalInventoryAttributes local_inventory_attributes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Inventories\V1\LocalInventoryAttributes $var
     * @return $this
     */
    public function setLocalInventoryAttributes($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Inventories\V1\LocalInventoryAttributes::class);
        $this->local_inventory_attributes = $var;

        return $this;
    }

}

