<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/conversions/v1/conversionsources.proto

namespace Google\Shopping\Merchant\Conversions\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a conversion source owned by a Merchant account. A merchant
 * account can have up to 200 conversion sources.
 *
 * Generated from protobuf message <code>google.shopping.merchant.conversions.v1.ConversionSource</code>
 */
class ConversionSource extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. Generated by the Content API upon creation of a
     * new `ConversionSource`. Format: `[a-z]{4}:.+` The four characters before
     * the colon represent the type of conversion source. Content after the colon
     * represents the ID of the conversion source within that type. The ID of two
     * different conversion sources might be the same across different types. The
     * following type prefixes are supported:
     * * `galk`: For GoogleAnalyticsLink sources.
     * * `mcdn`: For MerchantCenterDestination sources.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. Current state of this conversion source. Can't be edited
     * through the API.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.ConversionSource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The time when an archived conversion source becomes
     * permanently deleted and is no longer available to undelete.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $expire_time = null;
    /**
     * Output only. Controller of the conversion source.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.ConversionSource.Controller controller = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $controller = 0;
    protected $source_data;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Shopping\Merchant\Conversions\V1\GoogleAnalyticsLink $google_analytics_link
     *           Immutable. Conversion Source of type "Link to Google Analytics Property".
     *     @type \Google\Shopping\Merchant\Conversions\V1\MerchantCenterDestination $merchant_center_destination
     *           Conversion Source of type "Merchant Center Tag Destination".
     *     @type string $name
     *           Output only. Identifier. Generated by the Content API upon creation of a
     *           new `ConversionSource`. Format: `[a-z]{4}:.+` The four characters before
     *           the colon represent the type of conversion source. Content after the colon
     *           represents the ID of the conversion source within that type. The ID of two
     *           different conversion sources might be the same across different types. The
     *           following type prefixes are supported:
     *           * `galk`: For GoogleAnalyticsLink sources.
     *           * `mcdn`: For MerchantCenterDestination sources.
     *     @type int $state
     *           Output only. Current state of this conversion source. Can't be edited
     *           through the API.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. The time when an archived conversion source becomes
     *           permanently deleted and is no longer available to undelete.
     *     @type int $controller
     *           Output only. Controller of the conversion source.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Conversions\V1\Conversionsources::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. Conversion Source of type "Link to Google Analytics Property".
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.GoogleAnalyticsLink google_analytics_link = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Shopping\Merchant\Conversions\V1\GoogleAnalyticsLink|null
     */
    public function getGoogleAnalyticsLink()
    {
        return $this->readOneof(3);
    }

    public function hasGoogleAnalyticsLink()
    {
        return $this->hasOneof(3);
    }

    /**
     * Immutable. Conversion Source of type "Link to Google Analytics Property".
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.GoogleAnalyticsLink google_analytics_link = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Shopping\Merchant\Conversions\V1\GoogleAnalyticsLink $var
     * @return $this
     */
    public function setGoogleAnalyticsLink($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Conversions\V1\GoogleAnalyticsLink::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Conversion Source of type "Merchant Center Tag Destination".
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.MerchantCenterDestination merchant_center_destination = 4;</code>
     * @return \Google\Shopping\Merchant\Conversions\V1\MerchantCenterDestination|null
     */
    public function getMerchantCenterDestination()
    {
        return $this->readOneof(4);
    }

    public function hasMerchantCenterDestination()
    {
        return $this->hasOneof(4);
    }

    /**
     * Conversion Source of type "Merchant Center Tag Destination".
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.MerchantCenterDestination merchant_center_destination = 4;</code>
     * @param \Google\Shopping\Merchant\Conversions\V1\MerchantCenterDestination $var
     * @return $this
     */
    public function setMerchantCenterDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Conversions\V1\MerchantCenterDestination::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Output only. Identifier. Generated by the Content API upon creation of a
     * new `ConversionSource`. Format: `[a-z]{4}:.+` The four characters before
     * the colon represent the type of conversion source. Content after the colon
     * represents the ID of the conversion source within that type. The ID of two
     * different conversion sources might be the same across different types. The
     * following type prefixes are supported:
     * * `galk`: For GoogleAnalyticsLink sources.
     * * `mcdn`: For MerchantCenterDestination sources.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. Generated by the Content API upon creation of a
     * new `ConversionSource`. Format: `[a-z]{4}:.+` The four characters before
     * the colon represent the type of conversion source. Content after the colon
     * represents the ID of the conversion source within that type. The ID of two
     * different conversion sources might be the same across different types. The
     * following type prefixes are supported:
     * * `galk`: For GoogleAnalyticsLink sources.
     * * `mcdn`: For MerchantCenterDestination sources.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Current state of this conversion source. Can't be edited
     * through the API.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.ConversionSource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Current state of this conversion source. Can't be edited
     * through the API.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.ConversionSource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Conversions\V1\ConversionSource\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The time when an archived conversion source becomes
     * permanently deleted and is no longer available to undelete.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. The time when an archived conversion source becomes
     * permanently deleted and is no longer available to undelete.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. Controller of the conversion source.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.ConversionSource.Controller controller = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * Output only. Controller of the conversion source.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.conversions.v1.ConversionSource.Controller controller = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setController($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Conversions\V1\ConversionSource\Controller::class);
        $this->controller = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSourceData()
    {
        return $this->whichOneof("source_data");
    }

}

