<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/accounts.proto

namespace Google\Shopping\Merchant\Accounts\V1\CreateAndConfigureAccountRequest;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Additional instructions to add account services during creation of the
 * account.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.CreateAndConfigureAccountRequest.AddAccountService</code>
 */
class AddAccountService extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The provider of the service. Either the reference to an account
     * such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $provider = null;
    protected $service_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Shopping\Merchant\Accounts\V1\AccountAggregation $account_aggregation
     *           The provider is an
     *           [aggregator](https://support.google.com/merchants/answer/188487) for
     *           the account. Payload for service type Account Aggregation.
     *     @type string $provider
     *           Required. The provider of the service. Either the reference to an account
     *           such as `providers/123` or a well-known service provider (one of
     *           `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Accounts::initOnce();
        parent::__construct($data);
    }

    /**
     * The provider is an
     * [aggregator](https://support.google.com/merchants/answer/188487) for
     * the account. Payload for service type Account Aggregation.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountAggregation account_aggregation = 103;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\AccountAggregation|null
     */
    public function getAccountAggregation()
    {
        return $this->readOneof(103);
    }

    public function hasAccountAggregation()
    {
        return $this->hasOneof(103);
    }

    /**
     * The provider is an
     * [aggregator](https://support.google.com/merchants/answer/188487) for
     * the account. Payload for service type Account Aggregation.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountAggregation account_aggregation = 103;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\AccountAggregation $var
     * @return $this
     */
    public function setAccountAggregation($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\AccountAggregation::class);
        $this->writeOneof(103, $var);

        return $this;
    }

    /**
     * Required. The provider of the service. Either the reference to an account
     * such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getProvider()
    {
        return isset($this->provider) ? $this->provider : '';
    }

    public function hasProvider()
    {
        return isset($this->provider);
    }

    public function clearProvider()
    {
        unset($this->provider);
    }

    /**
     * Required. The provider of the service. Either the reference to an account
     * such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setProvider($var)
    {
        GPBUtil::checkString($var, True);
        $this->provider = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getServiceType()
    {
        return $this->whichOneof("service_type");
    }

}


