<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/accountrelationships.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `AccountRelationship` message defines a formal connection between a
 * merchant's account and a service provider's account. This relationship
 * enables the provider to offer specific services to the business, such as
 * product management or campaign management. It specifies the access rights
 * and permissions to the business's data relevant to those services.
 * Establishing an account relationship involves linking the merchant's account
 * with a provider's account. The provider could be another Google account (like
 * Google Ads or Google My Business) or a third-party platform (such as Shopify
 * or WooCommerce).
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.AccountRelationship</code>
 */
class AccountRelationship extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the account relationship.
     * Format: `accounts/{account}/relationships/{relationship}`. For example,
     * `accounts/123456/relationships/567890`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Immutable. The provider of the service. Either the reference to an account
     * such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $provider = null;
    /**
     * Output only. The human-readable display name of the provider account.
     *
     * Generated from protobuf field <code>string provider_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $provider_display_name = '';
    /**
     * Optional. An optional alias you can assign to this account relationship.
     * This alias acts as a convenient identifier for your own reference and
     * management. It must be unique among all your account relationships with the
     * same provider.
     * For example, you might use `account_id_alias` to assign a friendly name
     * to this relationship for easier identification in your systems.
     *
     * Generated from protobuf field <code>string account_id_alias = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $account_id_alias = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the account relationship.
     *           Format: `accounts/{account}/relationships/{relationship}`. For example,
     *           `accounts/123456/relationships/567890`.
     *     @type string $provider
     *           Immutable. The provider of the service. Either the reference to an account
     *           such as `providers/123` or a well-known service provider (one of
     *           `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *     @type string $provider_display_name
     *           Output only. The human-readable display name of the provider account.
     *     @type string $account_id_alias
     *           Optional. An optional alias you can assign to this account relationship.
     *           This alias acts as a convenient identifier for your own reference and
     *           management. It must be unique among all your account relationships with the
     *           same provider.
     *           For example, you might use `account_id_alias` to assign a friendly name
     *           to this relationship for easier identification in your systems.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Accountrelationships::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the account relationship.
     * Format: `accounts/{account}/relationships/{relationship}`. For example,
     * `accounts/123456/relationships/567890`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the account relationship.
     * Format: `accounts/{account}/relationships/{relationship}`. For example,
     * `accounts/123456/relationships/567890`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Immutable. The provider of the service. Either the reference to an account
     * such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getProvider()
    {
        return isset($this->provider) ? $this->provider : '';
    }

    public function hasProvider()
    {
        return isset($this->provider);
    }

    public function clearProvider()
    {
        unset($this->provider);
    }

    /**
     * Immutable. The provider of the service. Either the reference to an account
     * such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setProvider($var)
    {
        GPBUtil::checkString($var, True);
        $this->provider = $var;

        return $this;
    }

    /**
     * Output only. The human-readable display name of the provider account.
     *
     * Generated from protobuf field <code>string provider_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProviderDisplayName()
    {
        return $this->provider_display_name;
    }

    /**
     * Output only. The human-readable display name of the provider account.
     *
     * Generated from protobuf field <code>string provider_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProviderDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->provider_display_name = $var;

        return $this;
    }

    /**
     * Optional. An optional alias you can assign to this account relationship.
     * This alias acts as a convenient identifier for your own reference and
     * management. It must be unique among all your account relationships with the
     * same provider.
     * For example, you might use `account_id_alias` to assign a friendly name
     * to this relationship for easier identification in your systems.
     *
     * Generated from protobuf field <code>string account_id_alias = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAccountIdAlias()
    {
        return $this->account_id_alias;
    }

    /**
     * Optional. An optional alias you can assign to this account relationship.
     * This alias acts as a convenient identifier for your own reference and
     * management. It must be unique among all your account relationships with the
     * same provider.
     * For example, you might use `account_id_alias` to assign a friendly name
     * to this relationship for easier identification in your systems.
     *
     * Generated from protobuf field <code>string account_id_alias = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAccountIdAlias($var)
    {
        GPBUtil::checkString($var, True);
        $this->account_id_alias = $var;

        return $this;
    }

}

