<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/cloudsecuritycompliance/v1/deployment.proto

namespace Google\Cloud\CloudSecurityCompliance\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Framework deployments represent the assignment of a framework to a target
 * resource. Supported target resources are organizations, folders, and
 * projects.
 *
 * Generated from protobuf message <code>google.cloud.cloudsecuritycompliance.v1.FrameworkDeployment</code>
 */
class FrameworkDeployment extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the framework deployment, in the format
     * `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
     * The only supported location is `global`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The details of the target resource that you want to deploy the
     * framework to. You can specify an existing resource, or create a new one.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.TargetResourceConfig target_resource_config = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_resource_config = null;
    /**
     * Output only. The target resource to deploy the framework to, in one  the
     * following formats:
     * - `organizations/{organizationID}`
     * - `folders/{folderID}`
     * - `projects/{projectID}`
     *
     * Generated from protobuf field <code>string computed_target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $computed_target_resource = '';
    /**
     * Required. A reference to the framework that you're deploying.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.FrameworkReference framework = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $framework = null;
    /**
     * Optional. A user-provided description of the framework deployment.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Required. The deployment mode and parameters for each of the cloud controls
     * in the framework. Every cloud control in the framework includes metadata.
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.CloudControlMetadata cloud_control_metadata = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $cloud_control_metadata;
    /**
     * Output only. The state for the framework deployment.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.DeploymentState deployment_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deployment_state = 0;
    /**
     * Output only. The time at which the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the resource last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. To prevent concurrent updates from overwriting each other, always
     * provide the `etag` when you update a framework deployment. You can also
     * provide the `etag` when you delete a framework deployment, to help
     * ensure that you're deleting the intended version of the
     * framework deployment.
     *
     * Generated from protobuf field <code>string etag = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Output only. The display name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource_display_name = '';
    /**
     * Output only. The references to the cloud control deployments. The reference
     * includes all the cloud control deployments that are in the framework or in
     * a cloud control group.
     * For example, if a framework deployment deploys two
     * cloud controls, `cc-deployment-1` and `cc-deployment-2`, then the
     * references are:
     * ```
     * {
     *  cloud_control_deployment_reference: {
     *    cloud_control_deployment:
     *    "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-1"
     *  },
     *  cloud_control_deployment_reference: {
     *   cloud_control_deployment:
     *   "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-2"
     *  }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.CloudControlDeploymentReference cloud_control_deployment_references = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $cloud_control_deployment_references;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the framework deployment, in the format
     *           `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
     *           The only supported location is `global`.
     *     @type \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig $target_resource_config
     *           Required. The details of the target resource that you want to deploy the
     *           framework to. You can specify an existing resource, or create a new one.
     *     @type string $computed_target_resource
     *           Output only. The target resource to deploy the framework to, in one  the
     *           following formats:
     *           - `organizations/{organizationID}`
     *           - `folders/{folderID}`
     *           - `projects/{projectID}`
     *     @type \Google\Cloud\CloudSecurityCompliance\V1\FrameworkReference $framework
     *           Required. A reference to the framework that you're deploying.
     *     @type string $description
     *           Optional. A user-provided description of the framework deployment.
     *     @type array<\Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata>|\Google\Protobuf\Internal\RepeatedField $cloud_control_metadata
     *           Required. The deployment mode and parameters for each of the cloud controls
     *           in the framework. Every cloud control in the framework includes metadata.
     *     @type int $deployment_state
     *           Output only. The state for the framework deployment.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the resource last updated.
     *     @type string $etag
     *           Optional. To prevent concurrent updates from overwriting each other, always
     *           provide the `etag` when you update a framework deployment. You can also
     *           provide the `etag` when you delete a framework deployment, to help
     *           ensure that you're deleting the intended version of the
     *           framework deployment.
     *     @type string $target_resource_display_name
     *           Output only. The display name of the target resource.
     *     @type array<\Google\Cloud\CloudSecurityCompliance\V1\CloudControlDeploymentReference>|\Google\Protobuf\Internal\RepeatedField $cloud_control_deployment_references
     *           Output only. The references to the cloud control deployments. The reference
     *           includes all the cloud control deployments that are in the framework or in
     *           a cloud control group.
     *           For example, if a framework deployment deploys two
     *           cloud controls, `cc-deployment-1` and `cc-deployment-2`, then the
     *           references are:
     *           ```
     *           {
     *            cloud_control_deployment_reference: {
     *              cloud_control_deployment:
     *              "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-1"
     *            },
     *            cloud_control_deployment_reference: {
     *             cloud_control_deployment:
     *             "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-2"
     *            }
     *           ```
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Cloudsecuritycompliance\V1\Deployment::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the framework deployment, in the format
     * `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
     * The only supported location is `global`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the framework deployment, in the format
     * `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
     * The only supported location is `global`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The details of the target resource that you want to deploy the
     * framework to. You can specify an existing resource, or create a new one.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.TargetResourceConfig target_resource_config = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig|null
     */
    public function getTargetResourceConfig()
    {
        return $this->target_resource_config;
    }

    public function hasTargetResourceConfig()
    {
        return isset($this->target_resource_config);
    }

    public function clearTargetResourceConfig()
    {
        unset($this->target_resource_config);
    }

    /**
     * Required. The details of the target resource that you want to deploy the
     * framework to. You can specify an existing resource, or create a new one.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.TargetResourceConfig target_resource_config = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig $var
     * @return $this
     */
    public function setTargetResourceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig::class);
        $this->target_resource_config = $var;

        return $this;
    }

    /**
     * Output only. The target resource to deploy the framework to, in one  the
     * following formats:
     * - `organizations/{organizationID}`
     * - `folders/{folderID}`
     * - `projects/{projectID}`
     *
     * Generated from protobuf field <code>string computed_target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getComputedTargetResource()
    {
        return $this->computed_target_resource;
    }

    /**
     * Output only. The target resource to deploy the framework to, in one  the
     * following formats:
     * - `organizations/{organizationID}`
     * - `folders/{folderID}`
     * - `projects/{projectID}`
     *
     * Generated from protobuf field <code>string computed_target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setComputedTargetResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->computed_target_resource = $var;

        return $this;
    }

    /**
     * Required. A reference to the framework that you're deploying.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.FrameworkReference framework = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\CloudSecurityCompliance\V1\FrameworkReference|null
     */
    public function getFramework()
    {
        return $this->framework;
    }

    public function hasFramework()
    {
        return isset($this->framework);
    }

    public function clearFramework()
    {
        unset($this->framework);
    }

    /**
     * Required. A reference to the framework that you're deploying.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.FrameworkReference framework = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\CloudSecurityCompliance\V1\FrameworkReference $var
     * @return $this
     */
    public function setFramework($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudSecurityCompliance\V1\FrameworkReference::class);
        $this->framework = $var;

        return $this;
    }

    /**
     * Optional. A user-provided description of the framework deployment.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A user-provided description of the framework deployment.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. The deployment mode and parameters for each of the cloud controls
     * in the framework. Every cloud control in the framework includes metadata.
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.CloudControlMetadata cloud_control_metadata = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCloudControlMetadata()
    {
        return $this->cloud_control_metadata;
    }

    /**
     * Required. The deployment mode and parameters for each of the cloud controls
     * in the framework. Every cloud control in the framework includes metadata.
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.CloudControlMetadata cloud_control_metadata = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCloudControlMetadata($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata::class);
        $this->cloud_control_metadata = $arr;

        return $this;
    }

    /**
     * Output only. The state for the framework deployment.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.DeploymentState deployment_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDeploymentState()
    {
        return $this->deployment_state;
    }

    /**
     * Output only. The state for the framework deployment.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.DeploymentState deployment_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDeploymentState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudSecurityCompliance\V1\DeploymentState::class);
        $this->deployment_state = $var;

        return $this;
    }

    /**
     * Output only. The time at which the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the resource last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the resource last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. To prevent concurrent updates from overwriting each other, always
     * provide the `etag` when you update a framework deployment. You can also
     * provide the `etag` when you delete a framework deployment, to help
     * ensure that you're deleting the intended version of the
     * framework deployment.
     *
     * Generated from protobuf field <code>string etag = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. To prevent concurrent updates from overwriting each other, always
     * provide the `etag` when you update a framework deployment. You can also
     * provide the `etag` when you delete a framework deployment, to help
     * ensure that you're deleting the intended version of the
     * framework deployment.
     *
     * Generated from protobuf field <code>string etag = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. The display name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTargetResourceDisplayName()
    {
        return $this->target_resource_display_name;
    }

    /**
     * Output only. The display name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetResourceDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_resource_display_name = $var;

        return $this;
    }

    /**
     * Output only. The references to the cloud control deployments. The reference
     * includes all the cloud control deployments that are in the framework or in
     * a cloud control group.
     * For example, if a framework deployment deploys two
     * cloud controls, `cc-deployment-1` and `cc-deployment-2`, then the
     * references are:
     * ```
     * {
     *  cloud_control_deployment_reference: {
     *    cloud_control_deployment:
     *    "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-1"
     *  },
     *  cloud_control_deployment_reference: {
     *   cloud_control_deployment:
     *   "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-2"
     *  }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.CloudControlDeploymentReference cloud_control_deployment_references = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCloudControlDeploymentReferences()
    {
        return $this->cloud_control_deployment_references;
    }

    /**
     * Output only. The references to the cloud control deployments. The reference
     * includes all the cloud control deployments that are in the framework or in
     * a cloud control group.
     * For example, if a framework deployment deploys two
     * cloud controls, `cc-deployment-1` and `cc-deployment-2`, then the
     * references are:
     * ```
     * {
     *  cloud_control_deployment_reference: {
     *    cloud_control_deployment:
     *    "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-1"
     *  },
     *  cloud_control_deployment_reference: {
     *   cloud_control_deployment:
     *   "organizations/{organization}/locations/{location}/cloudControlDeployments/cc-deployment-2"
     *  }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.CloudControlDeploymentReference cloud_control_deployment_references = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\CloudSecurityCompliance\V1\CloudControlDeploymentReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCloudControlDeploymentReferences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudSecurityCompliance\V1\CloudControlDeploymentReference::class);
        $this->cloud_control_deployment_references = $arr;

        return $this;
    }

}

