<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycentermanagement/v1/security_center_management.proto

namespace Google\Cloud\SecurityCenterManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The minimum set of fields needed to represent a simulated finding from a
 * Security Health Analytics custom module.
 *
 * Generated from protobuf message <code>google.cloud.securitycentermanagement.v1.SimulatedFinding</code>
 */
class SimulatedFinding extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The [relative resource name](https://google.aip.dev/122) of the
     * finding, in one of the following formats:
     * * `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
     * * `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
     * * `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * The [relative resource name](https://google.aip.dev/122) of the source the
     * finding belongs to. For example,
     * `organizations/{organization_id}/sources/{source_id}`. This field is
     * immutable after creation time.
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     */
    protected $parent = '';
    /**
     * For findings on Google Cloud resources, the
     * [full resource name](https://google.aip.dev/122#full-resource-names) of the
     * Google Cloud resource this finding is for. When the finding is for a
     * non-Google Cloud resource, the value can be a customer or partner defined
     * string. This field is immutable after creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     */
    protected $resource_name = '';
    /**
     * The additional taxonomy group within findings from a given source. For
     * example, `XSS_FLASH_INJECTION`. This field is immutable after creation
     * time.
     *
     * Generated from protobuf field <code>string category = 4;</code>
     */
    protected $category = '';
    /**
     * Output only. The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Source-specific properties. These properties are managed by the source
     * that writes the finding. The key names must be between 1 and 255
     * characters; they must start with a letter and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 6;</code>
     */
    private $source_properties;
    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred. If the finding is later
     * resolved, then this time reflects when the finding was resolved.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector.
     * The event time must not be set to a value greater than the current
     * timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 7;</code>
     */
    protected $event_time = null;
    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.Severity severity = 8;</code>
     */
    protected $severity = 0;
    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.FindingClass finding_class = 9;</code>
     */
    protected $finding_class = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The [relative resource name](https://google.aip.dev/122) of the
     *           finding, in one of the following formats:
     *           * `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
     *           * `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
     *           * `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
     *     @type string $parent
     *           The [relative resource name](https://google.aip.dev/122) of the source the
     *           finding belongs to. For example,
     *           `organizations/{organization_id}/sources/{source_id}`. This field is
     *           immutable after creation time.
     *     @type string $resource_name
     *           For findings on Google Cloud resources, the
     *           [full resource name](https://google.aip.dev/122#full-resource-names) of the
     *           Google Cloud resource this finding is for. When the finding is for a
     *           non-Google Cloud resource, the value can be a customer or partner defined
     *           string. This field is immutable after creation time.
     *     @type string $category
     *           The additional taxonomy group within findings from a given source. For
     *           example, `XSS_FLASH_INJECTION`. This field is immutable after creation
     *           time.
     *     @type int $state
     *           Output only. The state of the finding.
     *     @type array|\Google\Protobuf\Internal\MapField $source_properties
     *           Source-specific properties. These properties are managed by the source
     *           that writes the finding. The key names must be between 1 and 255
     *           characters; they must start with a letter and contain alphanumeric
     *           characters or underscores only.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           The time the finding was first detected. If an existing finding is updated,
     *           then this is the time the update occurred. If the finding is later
     *           resolved, then this time reflects when the finding was resolved.
     *           For example, if the finding represents an open firewall, this property
     *           captures the time the detector believes the firewall became open. The
     *           accuracy is determined by the detector.
     *           The event time must not be set to a value greater than the current
     *           timestamp.
     *     @type int $severity
     *           The severity of the finding. This field is managed by the source that
     *           writes the finding.
     *     @type int $finding_class
     *           The class of the finding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycentermanagement\V1\SecurityCenterManagement::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The [relative resource name](https://google.aip.dev/122) of the
     * finding, in one of the following formats:
     * * `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
     * * `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
     * * `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The [relative resource name](https://google.aip.dev/122) of the
     * finding, in one of the following formats:
     * * `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
     * * `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
     * * `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The [relative resource name](https://google.aip.dev/122) of the source the
     * finding belongs to. For example,
     * `organizations/{organization_id}/sources/{source_id}`. This field is
     * immutable after creation time.
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The [relative resource name](https://google.aip.dev/122) of the source the
     * finding belongs to. For example,
     * `organizations/{organization_id}/sources/{source_id}`. This field is
     * immutable after creation time.
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * For findings on Google Cloud resources, the
     * [full resource name](https://google.aip.dev/122#full-resource-names) of the
     * Google Cloud resource this finding is for. When the finding is for a
     * non-Google Cloud resource, the value can be a customer or partner defined
     * string. This field is immutable after creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * For findings on Google Cloud resources, the
     * [full resource name](https://google.aip.dev/122#full-resource-names) of the
     * Google Cloud resource this finding is for. When the finding is for a
     * non-Google Cloud resource, the value can be a customer or partner defined
     * string. This field is immutable after creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The additional taxonomy group within findings from a given source. For
     * example, `XSS_FLASH_INJECTION`. This field is immutable after creation
     * time.
     *
     * Generated from protobuf field <code>string category = 4;</code>
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * The additional taxonomy group within findings from a given source. For
     * example, `XSS_FLASH_INJECTION`. This field is immutable after creation
     * time.
     *
     * Generated from protobuf field <code>string category = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->category = $var;

        return $this;
    }

    /**
     * Output only. The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenterManagement\V1\SimulatedFinding\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Source-specific properties. These properties are managed by the source
     * that writes the finding. The key names must be between 1 and 255
     * characters; they must start with a letter and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSourceProperties()
    {
        return $this->source_properties;
    }

    /**
     * Source-specific properties. These properties are managed by the source
     * that writes the finding. The key names must be between 1 and 255
     * characters; they must start with a letter and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSourceProperties($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->source_properties = $arr;

        return $this;
    }

    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred. If the finding is later
     * resolved, then this time reflects when the finding was resolved.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector.
     * The event time must not be set to a value greater than the current
     * timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 7;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return $this->event_time;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred. If the finding is later
     * resolved, then this time reflects when the finding was resolved.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector.
     * The event time must not be set to a value greater than the current
     * timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.Severity severity = 8;</code>
     * @return int
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.Severity severity = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenterManagement\V1\SimulatedFinding\Severity::class);
        $this->severity = $var;

        return $this;
    }

    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.FindingClass finding_class = 9;</code>
     * @return int
     */
    public function getFindingClass()
    {
        return $this->finding_class;
    }

    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SimulatedFinding.FindingClass finding_class = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setFindingClass($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenterManagement\V1\SimulatedFinding\FindingClass::class);
        $this->finding_class = $var;

        return $this;
    }

}

