<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v2/backup_disaster_recovery.proto

namespace Google\Cloud\SecurityCenter\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information related to Google Cloud Backup and DR Service findings.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v2.BackupDisasterRecovery</code>
 */
class BackupDisasterRecovery extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     *
     * Generated from protobuf field <code>string backup_template = 1;</code>
     */
    protected $backup_template = '';
    /**
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     *
     * Generated from protobuf field <code>repeated string policies = 2;</code>
     */
    private $policies;
    /**
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     *
     * Generated from protobuf field <code>string host = 3;</code>
     */
    protected $host = '';
    /**
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     *
     * Generated from protobuf field <code>repeated string applications = 4;</code>
     */
    private $applications;
    /**
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     *
     * Generated from protobuf field <code>string storage_pool = 5;</code>
     */
    protected $storage_pool = '';
    /**
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     *
     * Generated from protobuf field <code>repeated string policy_options = 6;</code>
     */
    private $policy_options;
    /**
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     *
     * Generated from protobuf field <code>string profile = 7;</code>
     */
    protected $profile = '';
    /**
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     *
     * Generated from protobuf field <code>string appliance = 8;</code>
     */
    protected $appliance = '';
    /**
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     *
     * Generated from protobuf field <code>string backup_type = 9;</code>
     */
    protected $backup_type = '';
    /**
     * The timestamp at which the Backup and DR backup was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    protected $backup_create_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $backup_template
     *           The name of a Backup and DR template which comprises one or more backup
     *           policies. See the [Backup and DR
     *           documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     *           for more information. For example, `snap-ov`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $policies
     *           The names of Backup and DR policies that are associated with a template
     *           and that define when to run a backup, how frequently to run a backup, and
     *           how long to retain the backup image. For example, `onvaults`.
     *     @type string $host
     *           The name of a Backup and DR host, which is managed by the backup and
     *           recovery appliance and known to the management console. The host can be of
     *           type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     *           system, etc.), vCenter, or an ESX server. See the [Backup and DR
     *           documentation on
     *           hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     *           for more information. For example, `centos7-01`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $applications
     *           The names of Backup and DR applications. An application is a VM, database,
     *           or file system on a managed host monitored by a backup and recovery
     *           appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     *           `centos7-01-vol02`.
     *     @type string $storage_pool
     *           The name of the Backup and DR storage pool that the backup and recovery
     *           appliance is storing data in. The storage pool could be of type Cloud,
     *           Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     *           storage
     *           pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     *           For example, `DiskPoolOne`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $policy_options
     *           The names of Backup and DR advanced policy options of a policy applying to
     *           an application. See the [Backup and DR documentation on policy
     *           options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     *           For example, `skipofflineappsincongrp, nounmap`.
     *     @type string $profile
     *           The name of the Backup and DR resource profile that specifies the storage
     *           media for backups of application and VM data. See the [Backup and DR
     *           documentation on
     *           profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     *           For example, `GCP`.
     *     @type string $appliance
     *           The name of the Backup and DR appliance that captures, moves, and manages
     *           the lifecycle of backup data. For example, `backup-server-57137`.
     *     @type string $backup_type
     *           The backup type of the Backup and DR image.
     *           For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     *     @type \Google\Protobuf\Timestamp $backup_create_time
     *           The timestamp at which the Backup and DR backup was created.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V2\BackupDisasterRecovery::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     *
     * Generated from protobuf field <code>string backup_template = 1;</code>
     * @return string
     */
    public function getBackupTemplate()
    {
        return $this->backup_template;
    }

    /**
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     *
     * Generated from protobuf field <code>string backup_template = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setBackupTemplate($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_template = $var;

        return $this;
    }

    /**
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     *
     * Generated from protobuf field <code>repeated string policies = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPolicies()
    {
        return $this->policies;
    }

    /**
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     *
     * Generated from protobuf field <code>repeated string policies = 2;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->policies = $arr;

        return $this;
    }

    /**
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     *
     * Generated from protobuf field <code>string host = 3;</code>
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     *
     * Generated from protobuf field <code>string host = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setHost($var)
    {
        GPBUtil::checkString($var, True);
        $this->host = $var;

        return $this;
    }

    /**
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     *
     * Generated from protobuf field <code>repeated string applications = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApplications()
    {
        return $this->applications;
    }

    /**
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     *
     * Generated from protobuf field <code>repeated string applications = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApplications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->applications = $arr;

        return $this;
    }

    /**
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     *
     * Generated from protobuf field <code>string storage_pool = 5;</code>
     * @return string
     */
    public function getStoragePool()
    {
        return $this->storage_pool;
    }

    /**
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     *
     * Generated from protobuf field <code>string storage_pool = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setStoragePool($var)
    {
        GPBUtil::checkString($var, True);
        $this->storage_pool = $var;

        return $this;
    }

    /**
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     *
     * Generated from protobuf field <code>repeated string policy_options = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPolicyOptions()
    {
        return $this->policy_options;
    }

    /**
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     *
     * Generated from protobuf field <code>repeated string policy_options = 6;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPolicyOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->policy_options = $arr;

        return $this;
    }

    /**
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     *
     * Generated from protobuf field <code>string profile = 7;</code>
     * @return string
     */
    public function getProfile()
    {
        return $this->profile;
    }

    /**
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     *
     * Generated from protobuf field <code>string profile = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setProfile($var)
    {
        GPBUtil::checkString($var, True);
        $this->profile = $var;

        return $this;
    }

    /**
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     *
     * Generated from protobuf field <code>string appliance = 8;</code>
     * @return string
     */
    public function getAppliance()
    {
        return $this->appliance;
    }

    /**
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     *
     * Generated from protobuf field <code>string appliance = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setAppliance($var)
    {
        GPBUtil::checkString($var, True);
        $this->appliance = $var;

        return $this;
    }

    /**
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     *
     * Generated from protobuf field <code>string backup_type = 9;</code>
     * @return string
     */
    public function getBackupType()
    {
        return $this->backup_type;
    }

    /**
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     *
     * Generated from protobuf field <code>string backup_type = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setBackupType($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_type = $var;

        return $this;
    }

    /**
     * The timestamp at which the Backup and DR backup was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getBackupCreateTime()
    {
        return $this->backup_create_time;
    }

    public function hasBackupCreateTime()
    {
        return isset($this->backup_create_time);
    }

    public function clearBackupCreateTime()
    {
        unset($this->backup_create_time);
    }

    /**
     * The timestamp at which the Backup and DR backup was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setBackupCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->backup_create_time = $var;

        return $this;
    }

}

