<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/build.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Location of the source in an archive file in Google Cloud Storage.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.StorageSource</code>
 */
class StorageSource extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Google Cloud Storage bucket containing the source (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Generated from protobuf field <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $bucket = '';
    /**
     * Required. Google Cloud Storage object containing the source.
     * This object must be a gzipped archive file (`.tar.gz`) containing source to
     * build.
     *
     * Generated from protobuf field <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $object = '';
    /**
     * Optional. Google Cloud Storage generation for the object. If the generation
     * is omitted, the latest generation will be used.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $generation = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $bucket
     *           Required. Google Cloud Storage bucket containing the source (see
     *           [Bucket Name
     *           Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *     @type string $object
     *           Required. Google Cloud Storage object containing the source.
     *           This object must be a gzipped archive file (`.tar.gz`) containing source to
     *           build.
     *     @type int|string $generation
     *           Optional. Google Cloud Storage generation for the object. If the generation
     *           is omitted, the latest generation will be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\Build::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Google Cloud Storage bucket containing the source (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Generated from protobuf field <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getBucket()
    {
        return $this->bucket;
    }

    /**
     * Required. Google Cloud Storage bucket containing the source (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Generated from protobuf field <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setBucket($var)
    {
        GPBUtil::checkString($var, True);
        $this->bucket = $var;

        return $this;
    }

    /**
     * Required. Google Cloud Storage object containing the source.
     * This object must be a gzipped archive file (`.tar.gz`) containing source to
     * build.
     *
     * Generated from protobuf field <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * Required. Google Cloud Storage object containing the source.
     * This object must be a gzipped archive file (`.tar.gz`) containing source to
     * build.
     *
     * Generated from protobuf field <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setObject($var)
    {
        GPBUtil::checkString($var, True);
        $this->object = $var;

        return $this;
    }

    /**
     * Optional. Google Cloud Storage generation for the object. If the generation
     * is omitted, the latest generation will be used.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * Optional. Google Cloud Storage generation for the object. If the generation
     * is omitted, the latest generation will be used.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->generation = $var;

        return $this;
    }

}

