<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/search_service.proto

namespace Google\Cloud\Retail\V2\SearchRequest;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This field specifies all conversational related parameters addition to
 * traditional retail search.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec</code>
 */
class ConversationalSearchSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * This field specifies whether the customer would like to do conversational
     * search. If this field is set to true, conversational related extra
     * information will be returned from server side, including follow-up
     * question, answer options, etc.
     *
     * Generated from protobuf field <code>bool followup_conversation_requested = 1;</code>
     */
    protected $followup_conversation_requested = false;
    /**
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     *
     * Generated from protobuf field <code>string conversation_id = 2;</code>
     */
    protected $conversation_id = '';
    /**
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;</code>
     */
    protected $user_answer = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $followup_conversation_requested
     *           This field specifies whether the customer would like to do conversational
     *           search. If this field is set to true, conversational related extra
     *           information will be returned from server side, including follow-up
     *           question, answer options, etc.
     *     @type string $conversation_id
     *           This field specifies the conversation id, which maintains the state of
     *           the conversation between client side and server side. Use the value from
     *           the previous [ConversationalSearchResult.conversation_id][]. For the
     *           initial request, this should be empty.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec\UserAnswer $user_answer
     *           This field specifies the current user answer during the conversational
     *           search. This can be either user selected from suggested answers or user
     *           input plain text.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * This field specifies whether the customer would like to do conversational
     * search. If this field is set to true, conversational related extra
     * information will be returned from server side, including follow-up
     * question, answer options, etc.
     *
     * Generated from protobuf field <code>bool followup_conversation_requested = 1;</code>
     * @return bool
     */
    public function getFollowupConversationRequested()
    {
        return $this->followup_conversation_requested;
    }

    /**
     * This field specifies whether the customer would like to do conversational
     * search. If this field is set to true, conversational related extra
     * information will be returned from server side, including follow-up
     * question, answer options, etc.
     *
     * Generated from protobuf field <code>bool followup_conversation_requested = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setFollowupConversationRequested($var)
    {
        GPBUtil::checkBool($var);
        $this->followup_conversation_requested = $var;

        return $this;
    }

    /**
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     *
     * Generated from protobuf field <code>string conversation_id = 2;</code>
     * @return string
     */
    public function getConversationId()
    {
        return $this->conversation_id;
    }

    /**
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     *
     * Generated from protobuf field <code>string conversation_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setConversationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->conversation_id = $var;

        return $this;
    }

    /**
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec\UserAnswer|null
     */
    public function getUserAnswer()
    {
        return $this->user_answer;
    }

    public function hasUserAnswer()
    {
        return isset($this->user_answer);
    }

    public function clearUserAnswer()
    {
        unset($this->user_answer);
    }

    /**
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec\UserAnswer $var
     * @return $this
     */
    public function setUserAnswer($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec\UserAnswer::class);
        $this->user_answer = $var;

        return $this;
    }

}


