<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/pubsub/v1/pubsub.proto

namespace Google\Cloud\PubSub\V1\IngestionDataSourceSettings;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Ingestion settings for Cloud Storage.
 *
 * Generated from protobuf message <code>google.pubsub.v1.IngestionDataSourceSettings.CloudStorage</code>
 */
class CloudStorage extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     *
     * Generated from protobuf field <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $bucket = '';
    /**
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $minimum_object_create_time = null;
    /**
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     *
     * Generated from protobuf field <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $match_glob = '';
    protected $input_format;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $state
     *           Output only. An output-only field that indicates the state of the Cloud
     *           Storage ingestion source.
     *     @type string $bucket
     *           Optional. Cloud Storage bucket. The bucket name must be without any
     *           prefix like "gs://". See the [bucket naming requirements]
     *           (https://cloud.google.com/storage/docs/buckets#naming).
     *     @type \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\TextFormat $text_format
     *           Optional. Data from Cloud Storage will be interpreted as text.
     *     @type \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\AvroFormat $avro_format
     *           Optional. Data from Cloud Storage will be interpreted in Avro format.
     *     @type \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\PubSubAvroFormat $pubsub_avro_format
     *           Optional. It will be assumed data from Cloud Storage was written via
     *           [Cloud Storage
     *           subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     *     @type \Google\Protobuf\Timestamp $minimum_object_create_time
     *           Optional. Only objects with a larger or equal creation timestamp will be
     *           ingested.
     *     @type string $match_glob
     *           Optional. Glob pattern used to match objects that will be ingested. If
     *           unset, all objects will be ingested. See the [supported
     *           patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Pubsub\V1\Pubsub::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     *
     * Generated from protobuf field <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getBucket()
    {
        return $this->bucket;
    }

    /**
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     *
     * Generated from protobuf field <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setBucket($var)
    {
        GPBUtil::checkString($var, True);
        $this->bucket = $var;

        return $this;
    }

    /**
     * Optional. Data from Cloud Storage will be interpreted as text.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\TextFormat|null
     */
    public function getTextFormat()
    {
        return $this->readOneof(3);
    }

    public function hasTextFormat()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. Data from Cloud Storage will be interpreted as text.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\TextFormat $var
     * @return $this
     */
    public function setTextFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\TextFormat::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\AvroFormat|null
     */
    public function getAvroFormat()
    {
        return $this->readOneof(4);
    }

    public function hasAvroFormat()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\AvroFormat $var
     * @return $this
     */
    public function setAvroFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\AvroFormat::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\PubSubAvroFormat|null
     */
    public function getPubsubAvroFormat()
    {
        return $this->readOneof(5);
    }

    public function hasPubsubAvroFormat()
    {
        return $this->hasOneof(5);
    }

    /**
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\PubSubAvroFormat $var
     * @return $this
     */
    public function setPubsubAvroFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\IngestionDataSourceSettings\CloudStorage\PubSubAvroFormat::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getMinimumObjectCreateTime()
    {
        return $this->minimum_object_create_time;
    }

    public function hasMinimumObjectCreateTime()
    {
        return isset($this->minimum_object_create_time);
    }

    public function clearMinimumObjectCreateTime()
    {
        unset($this->minimum_object_create_time);
    }

    /**
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setMinimumObjectCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->minimum_object_create_time = $var;

        return $this;
    }

    /**
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     *
     * Generated from protobuf field <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getMatchGlob()
    {
        return $this->match_glob;
    }

    /**
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     *
     * Generated from protobuf field <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setMatchGlob($var)
    {
        GPBUtil::checkString($var, True);
        $this->match_glob = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getInputFormat()
    {
        return $this->whichOneof("input_format");
    }

}


