<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\PrivilegedAccessManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\PrivilegedAccessManager\V1\ApproveGrantRequest;
use Google\Cloud\PrivilegedAccessManager\V1\CheckOnboardingStatusRequest;
use Google\Cloud\PrivilegedAccessManager\V1\CheckOnboardingStatusResponse;
use Google\Cloud\PrivilegedAccessManager\V1\CreateEntitlementRequest;
use Google\Cloud\PrivilegedAccessManager\V1\CreateGrantRequest;
use Google\Cloud\PrivilegedAccessManager\V1\DeleteEntitlementRequest;
use Google\Cloud\PrivilegedAccessManager\V1\DenyGrantRequest;
use Google\Cloud\PrivilegedAccessManager\V1\Entitlement;
use Google\Cloud\PrivilegedAccessManager\V1\GetEntitlementRequest;
use Google\Cloud\PrivilegedAccessManager\V1\GetGrantRequest;
use Google\Cloud\PrivilegedAccessManager\V1\Grant;
use Google\Cloud\PrivilegedAccessManager\V1\ListEntitlementsRequest;
use Google\Cloud\PrivilegedAccessManager\V1\ListGrantsRequest;
use Google\Cloud\PrivilegedAccessManager\V1\RevokeGrantRequest;
use Google\Cloud\PrivilegedAccessManager\V1\SearchEntitlementsRequest;
use Google\Cloud\PrivilegedAccessManager\V1\SearchGrantsRequest;
use Google\Cloud\PrivilegedAccessManager\V1\UpdateEntitlementRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: This API allows customers to manage temporary, request based privileged
 * access to their resources.
 *
 * It defines the following resource model:
 *
 * * A collection of `Entitlement` resources. An entitlement allows configuring
 * (among other things):
 *
 * * Some kind of privileged access that users can request.
 * * A set of users called _requesters_ who can request this access.
 * * A maximum duration for which the access can be requested.
 * * An optional approval workflow which must be satisfied before access is
 * granted.
 *
 * * A collection of `Grant` resources. A grant is a request by a requester to
 * get the privileged access specified in an entitlement for some duration.
 *
 * After the approval workflow as specified in the entitlement is satisfied,
 * the specified access is given to the requester. The access is automatically
 * taken back after the requested duration is over.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Grant> approveGrantAsync(ApproveGrantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CheckOnboardingStatusResponse> checkOnboardingStatusAsync(CheckOnboardingStatusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEntitlementAsync(CreateEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Grant> createGrantAsync(CreateGrantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEntitlementAsync(DeleteEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Grant> denyGrantAsync(DenyGrantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entitlement> getEntitlementAsync(GetEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Grant> getGrantAsync(GetGrantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntitlementsAsync(ListEntitlementsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGrantsAsync(ListGrantsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> revokeGrantAsync(RevokeGrantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchEntitlementsAsync(SearchEntitlementsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchGrantsAsync(SearchGrantsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEntitlementAsync(UpdateEntitlementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class PrivilegedAccessManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'privilegedaccessmanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'privilegedaccessmanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/privileged_access_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/privileged_access_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/privileged_access_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/privileged_access_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entitlement
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entitlement
     *
     * @return string The formatted entitlement resource.
     */
    public static function entitlementName(string $project, string $location, string $entitlement): string
    {
        return self::getPathTemplate('entitlement')->render([
            'project' => $project,
            'location' => $location,
            'entitlement' => $entitlement,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_entitlement resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $entitlement
     *
     * @return string The formatted folder_location_entitlement resource.
     */
    public static function folderLocationEntitlementName(string $folder, string $location, string $entitlement): string
    {
        return self::getPathTemplate('folderLocationEntitlement')->render([
            'folder' => $folder,
            'location' => $location,
            'entitlement' => $entitlement,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_entitlement_grant resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $entitlement
     * @param string $grant
     *
     * @return string The formatted folder_location_entitlement_grant resource.
     */
    public static function folderLocationEntitlementGrantName(string $folder, string $location, string $entitlement, string $grant): string
    {
        return self::getPathTemplate('folderLocationEntitlementGrant')->render([
            'folder' => $folder,
            'location' => $location,
            'entitlement' => $entitlement,
            'grant' => $grant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a grant
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entitlement
     * @param string $grant
     *
     * @return string The formatted grant resource.
     */
    public static function grantName(string $project, string $location, string $entitlement, string $grant): string
    {
        return self::getPathTemplate('grant')->render([
            'project' => $project,
            'location' => $location,
            'entitlement' => $entitlement,
            'grant' => $grant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_entitlement resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $entitlement
     *
     * @return string The formatted organization_location_entitlement resource.
     */
    public static function organizationLocationEntitlementName(string $organization, string $location, string $entitlement): string
    {
        return self::getPathTemplate('organizationLocationEntitlement')->render([
            'organization' => $organization,
            'location' => $location,
            'entitlement' => $entitlement,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_entitlement_grant resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $entitlement
     * @param string $grant
     *
     * @return string The formatted organization_location_entitlement_grant resource.
     */
    public static function organizationLocationEntitlementGrantName(string $organization, string $location, string $entitlement, string $grant): string
    {
        return self::getPathTemplate('organizationLocationEntitlementGrant')->render([
            'organization' => $organization,
            'location' => $location,
            'entitlement' => $entitlement,
            'grant' => $grant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_entitlement resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entitlement
     *
     * @return string The formatted project_location_entitlement resource.
     */
    public static function projectLocationEntitlementName(string $project, string $location, string $entitlement): string
    {
        return self::getPathTemplate('projectLocationEntitlement')->render([
            'project' => $project,
            'location' => $location,
            'entitlement' => $entitlement,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_entitlement_grant resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entitlement
     * @param string $grant
     *
     * @return string The formatted project_location_entitlement_grant resource.
     */
    public static function projectLocationEntitlementGrantName(string $project, string $location, string $entitlement, string $grant): string
    {
        return self::getPathTemplate('projectLocationEntitlementGrant')->render([
            'project' => $project,
            'location' => $location,
            'entitlement' => $entitlement,
            'grant' => $grant,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entitlement: projects/{project}/locations/{location}/entitlements/{entitlement}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationEntitlement: folders/{folder}/locations/{location}/entitlements/{entitlement}
     * - folderLocationEntitlementGrant: folders/{folder}/locations/{location}/entitlements/{entitlement}/grants/{grant}
     * - grant: projects/{project}/locations/{location}/entitlements/{entitlement}/grants/{grant}
     * - location: projects/{project}/locations/{location}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationEntitlement: organizations/{organization}/locations/{location}/entitlements/{entitlement}
     * - organizationLocationEntitlementGrant: organizations/{organization}/locations/{location}/entitlements/{entitlement}/grants/{grant}
     * - projectLocationEntitlement: projects/{project}/locations/{location}/entitlements/{entitlement}
     * - projectLocationEntitlementGrant: projects/{project}/locations/{location}/entitlements/{entitlement}/grants/{grant}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'privilegedaccessmanager.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\PrivilegedAccessManager\V1\PrivilegedAccessManagerClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new PrivilegedAccessManagerClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * `ApproveGrant` is used to approve a grant. This method can only be called
     * on a grant when it's in the `APPROVAL_AWAITED` state. This operation can't
     * be undone.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::approveGrantAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/approve_grant.php
     *
     * @param ApproveGrantRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Grant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function approveGrant(ApproveGrantRequest $request, array $callOptions = []): Grant
    {
        return $this->startApiCall('ApproveGrant', $request, $callOptions)->wait();
    }

    /**
     * `CheckOnboardingStatus` reports the onboarding status for a
     * project/folder/organization. Any findings reported by this API need to be
     * fixed before PAM can be used on the resource.
     *
     * The async variant is
     * {@see PrivilegedAccessManagerClient::checkOnboardingStatusAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/check_onboarding_status.php
     *
     * @param CheckOnboardingStatusRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CheckOnboardingStatusResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function checkOnboardingStatus(CheckOnboardingStatusRequest $request, array $callOptions = []): CheckOnboardingStatusResponse
    {
        return $this->startApiCall('CheckOnboardingStatus', $request, $callOptions)->wait();
    }

    /**
     * Creates a new entitlement in a given project/folder/organization and
     * location.
     *
     * The async variant is
     * {@see PrivilegedAccessManagerClient::createEntitlementAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/create_entitlement.php
     *
     * @param CreateEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntitlement(CreateEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Creates a new grant in a given project/folder/organization and
     * location.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::createGrantAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/create_grant.php
     *
     * @param CreateGrantRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Grant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGrant(CreateGrantRequest $request, array $callOptions = []): Grant
    {
        return $this->startApiCall('CreateGrant', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single entitlement. This method can only be called when there
     * are no in-progress (`ACTIVE`/`ACTIVATING`/`REVOKING`) grants under the
     * entitlement.
     *
     * The async variant is
     * {@see PrivilegedAccessManagerClient::deleteEntitlementAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/delete_entitlement.php
     *
     * @param DeleteEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntitlement(DeleteEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEntitlement', $request, $callOptions)->wait();
    }

    /**
     * `DenyGrant` is used to deny a grant. This method can only be called on a
     * grant when it's in the `APPROVAL_AWAITED` state. This operation can't be
     * undone.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::denyGrantAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/deny_grant.php
     *
     * @param DenyGrantRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Grant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function denyGrant(DenyGrantRequest $request, array $callOptions = []): Grant
    {
        return $this->startApiCall('DenyGrant', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single entitlement.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::getEntitlementAsync()}
     * .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/get_entitlement.php
     *
     * @param GetEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entitlement
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntitlement(GetEntitlementRequest $request, array $callOptions = []): Entitlement
    {
        return $this->startApiCall('GetEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Get details of a single grant.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::getGrantAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/get_grant.php
     *
     * @param GetGrantRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Grant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGrant(GetGrantRequest $request, array $callOptions = []): Grant
    {
        return $this->startApiCall('GetGrant', $request, $callOptions)->wait();
    }

    /**
     * Lists entitlements in a given project/folder/organization and location.
     *
     * The async variant is
     * {@see PrivilegedAccessManagerClient::listEntitlementsAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/list_entitlements.php
     *
     * @param ListEntitlementsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntitlements(ListEntitlementsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntitlements', $request, $callOptions);
    }

    /**
     * Lists grants for a given entitlement.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::listGrantsAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/list_grants.php
     *
     * @param ListGrantsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGrants(ListGrantsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGrants', $request, $callOptions);
    }

    /**
     * `RevokeGrant` is used to immediately revoke access for a grant. This method
     * can be called when the grant is in a non-terminal state.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::revokeGrantAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/revoke_grant.php
     *
     * @param RevokeGrantRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Grant>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function revokeGrant(RevokeGrantRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RevokeGrant', $request, $callOptions)->wait();
    }

    /**
     * `SearchEntitlements` returns entitlements on which the caller has the
     * specified access.
     *
     * The async variant is
     * {@see PrivilegedAccessManagerClient::searchEntitlementsAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/search_entitlements.php
     *
     * @param SearchEntitlementsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchEntitlements(SearchEntitlementsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchEntitlements', $request, $callOptions);
    }

    /**
     * `SearchGrants` returns grants that are related to the calling user in the
     * specified way.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::searchGrantsAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/search_grants.php
     *
     * @param SearchGrantsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchGrants(SearchGrantsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchGrants', $request, $callOptions);
    }

    /**
     * Updates the entitlement specified in the request. Updated fields in the
     * entitlement need to be specified in an update mask. The changes made to an
     * entitlement are applicable only on future grants of the entitlement.
     * However, if new approvers are added or existing approvers are removed from
     * the approval workflow, the changes are effective on existing grants.
     *
     * The following fields are not supported for updates:
     *
     * * All immutable fields
     * * Entitlement name
     * * Resource name
     * * Resource type
     * * Adding an approval workflow in an entitlement which previously had no
     * approval workflow.
     * * Deleting the approval workflow from an entitlement.
     * * Adding or deleting a step in the approval workflow (only one step is
     * supported)
     *
     * Note that updates are allowed on the list of approvers in an approval
     * workflow step.
     *
     * The async variant is
     * {@see PrivilegedAccessManagerClient::updateEntitlementAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/update_entitlement.php
     *
     * @param UpdateEntitlementRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Entitlement>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEntitlement(UpdateEntitlementRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEntitlement', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::getLocationAsync()} .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see PrivilegedAccessManagerClient::listLocationsAsync()}
     * .
     *
     * @example samples/V1/PrivilegedAccessManagerClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
