<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/policysimulator/v1/orgpolicy.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\PolicySimulator\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\PolicySimulator\V1\CreateOrgPolicyViolationsPreviewRequest;
use Google\Cloud\PolicySimulator\V1\GetOrgPolicyViolationsPreviewRequest;
use Google\Cloud\PolicySimulator\V1\ListOrgPolicyViolationsPreviewsRequest;
use Google\Cloud\PolicySimulator\V1\ListOrgPolicyViolationsRequest;
use Google\Cloud\PolicySimulator\V1\OrgPolicyViolationsPreview;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Violations Preview API service for OrgPolicy.
 *
 * An
 * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview]
 * is a preview of the violations that will exist as soon as a proposed
 * OrgPolicy change is submitted. To create an
 * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview],
 * the API user specifies the changes they wish to make and requests the
 * generation of a preview via [GenerateViolationsPreview][]. the OrgPolicy
 * Simulator service then scans the API user's currently existing resources to
 * determine these resources violate the newly set OrgPolicy.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createOrgPolicyViolationsPreviewAsync(CreateOrgPolicyViolationsPreviewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OrgPolicyViolationsPreview> getOrgPolicyViolationsPreviewAsync(GetOrgPolicyViolationsPreviewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listOrgPolicyViolationsAsync(ListOrgPolicyViolationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listOrgPolicyViolationsPreviewsAsync(ListOrgPolicyViolationsPreviewsRequest $request, array $optionalArgs = [])
 */
final class OrgPolicyViolationsPreviewServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.policysimulator.v1.OrgPolicyViolationsPreviewService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'policysimulator.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'policysimulator.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/org_policy_violations_preview_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/org_policy_violations_preview_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/org_policy_violations_preview_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/org_policy_violations_preview_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_constraint resource.
     *
     * @param string $organization
     * @param string $customConstraint
     *
     * @return string The formatted custom_constraint resource.
     */
    public static function customConstraintName(string $organization, string $customConstraint): string
    {
        return self::getPathTemplate('customConstraint')->render([
            'organization' => $organization,
            'custom_constraint' => $customConstraint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_policy resource.
     *
     * @param string $folder
     * @param string $policy
     *
     * @return string The formatted folder_policy resource.
     */
    public static function folderPolicyName(string $folder, string $policy): string
    {
        return self::getPathTemplate('folderPolicy')->render([
            'folder' => $folder,
            'policy' => $policy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * org_policy_violations_preview resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $orgPolicyViolationsPreview
     *
     * @return string The formatted org_policy_violations_preview resource.
     */
    public static function orgPolicyViolationsPreviewName(string $organization, string $location, string $orgPolicyViolationsPreview): string
    {
        return self::getPathTemplate('orgPolicyViolationsPreview')->render([
            'organization' => $organization,
            'location' => $location,
            'org_policy_violations_preview' => $orgPolicyViolationsPreview,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_policy resource.
     *
     * @param string $organization
     * @param string $policy
     *
     * @return string The formatted organization_policy resource.
     */
    public static function organizationPolicyName(string $organization, string $policy): string
    {
        return self::getPathTemplate('organizationPolicy')->render([
            'organization' => $organization,
            'policy' => $policy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a policy
     * resource.
     *
     * @param string $project
     * @param string $policy
     *
     * @return string The formatted policy resource.
     */
    public static function policyName(string $project, string $policy): string
    {
        return self::getPathTemplate('policy')->render([
            'project' => $project,
            'policy' => $policy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_policy resource.
     *
     * @param string $project
     * @param string $policy
     *
     * @return string The formatted project_policy resource.
     */
    public static function projectPolicyName(string $project, string $policy): string
    {
        return self::getPathTemplate('projectPolicy')->render([
            'project' => $project,
            'policy' => $policy,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - customConstraint: organizations/{organization}/customConstraints/{custom_constraint}
     * - folder: folders/{folder}
     * - folderPolicy: folders/{folder}/policies/{policy}
     * - orgPolicyViolationsPreview: organizations/{organization}/locations/{location}/orgPolicyViolationsPreviews/{org_policy_violations_preview}
     * - organization: organizations/{organization}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationPolicy: organizations/{organization}/policies/{policy}
     * - policy: projects/{project}/policies/{policy}
     * - project: projects/{project}
     * - projectPolicy: projects/{project}/policies/{policy}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'policysimulator.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\PolicySimulator\V1\OrgPolicyViolationsPreviewServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new OrgPolicyViolationsPreviewServiceClient(['credentials' =>
     *           $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * CreateOrgPolicyViolationsPreview creates an
     * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview]
     * for the proposed changes in the provided
     * [OrgPolicyViolationsPreview.OrgPolicyOverlay][]. The changes to OrgPolicy
     * are specified by this `OrgPolicyOverlay`. The resources to scan are
     * inferred from these specified changes.
     *
     * The async variant is
     * {@see OrgPolicyViolationsPreviewServiceClient::createOrgPolicyViolationsPreviewAsync()}
     * .
     *
     * @example samples/V1/OrgPolicyViolationsPreviewServiceClient/create_org_policy_violations_preview.php
     *
     * @param CreateOrgPolicyViolationsPreviewRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<OrgPolicyViolationsPreview>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createOrgPolicyViolationsPreview(CreateOrgPolicyViolationsPreviewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateOrgPolicyViolationsPreview', $request, $callOptions)->wait();
    }

    /**
     * GetOrgPolicyViolationsPreview gets the specified
     * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview].
     * Each
     * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview]
     * is available for at least 7 days.
     *
     * The async variant is
     * {@see OrgPolicyViolationsPreviewServiceClient::getOrgPolicyViolationsPreviewAsync()}
     * .
     *
     * @example samples/V1/OrgPolicyViolationsPreviewServiceClient/get_org_policy_violations_preview.php
     *
     * @param GetOrgPolicyViolationsPreviewRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrgPolicyViolationsPreview
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getOrgPolicyViolationsPreview(GetOrgPolicyViolationsPreviewRequest $request, array $callOptions = []): OrgPolicyViolationsPreview
    {
        return $this->startApiCall('GetOrgPolicyViolationsPreview', $request, $callOptions)->wait();
    }

    /**
     * ListOrgPolicyViolations lists the [OrgPolicyViolations][] that are present
     * in an
     * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview].
     *
     * The async variant is
     * {@see OrgPolicyViolationsPreviewServiceClient::listOrgPolicyViolationsAsync()} .
     *
     * @example samples/V1/OrgPolicyViolationsPreviewServiceClient/list_org_policy_violations.php
     *
     * @param ListOrgPolicyViolationsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOrgPolicyViolations(ListOrgPolicyViolationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListOrgPolicyViolations', $request, $callOptions);
    }

    /**
     * ListOrgPolicyViolationsPreviews lists each
     * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview]
     * in an organization. Each
     * [OrgPolicyViolationsPreview][google.cloud.policysimulator.v1.OrgPolicyViolationsPreview]
     * is available for at least 7 days.
     *
     * The async variant is
     * {@see OrgPolicyViolationsPreviewServiceClient::listOrgPolicyViolationsPreviewsAsync()}
     * .
     *
     * @example samples/V1/OrgPolicyViolationsPreviewServiceClient/list_org_policy_violations_previews.php
     *
     * @param ListOrgPolicyViolationsPreviewsRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOrgPolicyViolationsPreviews(ListOrgPolicyViolationsPreviewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListOrgPolicyViolationsPreviews', $request, $callOptions);
    }
}
