<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/service.proto

namespace Google\Cloud\Monitoring\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `WindowsBasedSli` defines `good_service` as the count of time windows for
 * which the provided service was of good quality. Criteria for determining
 * if service was good are embedded in the `window_criterion`.
 *
 * Generated from protobuf message <code>google.monitoring.v3.WindowsBasedSli</code>
 */
class WindowsBasedSli extends \Google\Protobuf\Internal\Message
{
    /**
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration window_period = 4;</code>
     */
    protected $window_period = null;
    protected $window_criterion;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $good_bad_metric_filter
     *           A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     *           specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     *           any `true` values appear in the window.
     *     @type \Google\Cloud\Monitoring\V3\WindowsBasedSli\PerformanceThreshold $good_total_ratio_threshold
     *           A window is good if its `performance` is high enough.
     *     @type \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange $metric_mean_in_range
     *           A window is good if the metric's value is in a good range, averaged
     *           across returned streams.
     *     @type \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange $metric_sum_in_range
     *           A window is good if the metric's value is in a good range, summed across
     *           returned streams.
     *     @type \Google\Protobuf\Duration $window_period
     *           Duration over which window quality is evaluated. Must be an integer
     *           fraction of a day and at least `60s`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     *
     * Generated from protobuf field <code>string good_bad_metric_filter = 5;</code>
     * @return string
     */
    public function getGoodBadMetricFilter()
    {
        return $this->readOneof(5);
    }

    public function hasGoodBadMetricFilter()
    {
        return $this->hasOneof(5);
    }

    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     *
     * Generated from protobuf field <code>string good_bad_metric_filter = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setGoodBadMetricFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * A window is good if its `performance` is high enough.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;</code>
     * @return \Google\Cloud\Monitoring\V3\WindowsBasedSli\PerformanceThreshold|null
     */
    public function getGoodTotalRatioThreshold()
    {
        return $this->readOneof(2);
    }

    public function hasGoodTotalRatioThreshold()
    {
        return $this->hasOneof(2);
    }

    /**
     * A window is good if its `performance` is high enough.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;</code>
     * @param \Google\Cloud\Monitoring\V3\WindowsBasedSli\PerformanceThreshold $var
     * @return $this
     */
    public function setGoodTotalRatioThreshold($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\WindowsBasedSli\PerformanceThreshold::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     * @return \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange|null
     */
    public function getMetricMeanInRange()
    {
        return $this->readOneof(6);
    }

    public function hasMetricMeanInRange()
    {
        return $this->hasOneof(6);
    }

    /**
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     * @param \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange $var
     * @return $this
     */
    public function setMetricMeanInRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     * @return \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange|null
     */
    public function getMetricSumInRange()
    {
        return $this->readOneof(7);
    }

    public function hasMetricSumInRange()
    {
        return $this->hasOneof(7);
    }

    /**
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     * @param \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange $var
     * @return $this
     */
    public function setMetricSumInRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\WindowsBasedSli\MetricRange::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration window_period = 4;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getWindowPeriod()
    {
        return $this->window_period;
    }

    public function hasWindowPeriod()
    {
        return isset($this->window_period);
    }

    public function clearWindowPeriod()
    {
        unset($this->window_period);
    }

    /**
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration window_period = 4;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setWindowPeriod($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->window_period = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getWindowCriterion()
    {
        return $this->whichOneof("window_criterion");
    }

}

