<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/routeoptimization/v1/route_optimization_service.proto

namespace Google\Maps\RouteOptimization\V1\SkippedShipment;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * If we can explain why the shipment was skipped, reasons will be listed
 * here. If the reason is not the same for all vehicles, `reason` will have
 * more than 1 element. A skipped shipment cannot have duplicate reasons,
 * i.e. where all fields are the same except for `example_vehicle_index`.
 * Example:
 * ```
 * reasons {
 *   code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
 *   example_vehicle_index: 1
 *   example_exceeded_capacity_type: "Apples"
 * }
 * reasons {
 *   code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
 *   example_vehicle_index: 3
 *   example_exceeded_capacity_type: "Pears"
 * }
 * reasons {
 *   code: CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT
 *   example_vehicle_index: 1
 * }
 * ```
 * The skipped shipment is incompatible with all vehicles. The reasons may
 * be different for all vehicles but at least one vehicle's "Apples"
 * capacity would be exceeded (including vehicle 1), at least one vehicle's
 * "Pears" capacity would be exceeded (including vehicle 3) and at least one
 * vehicle's distance limit would be exceeded (including vehicle 1).
 *
 * Generated from protobuf message <code>google.maps.routeoptimization.v1.SkippedShipment.Reason</code>
 */
class Reason extends \Google\Protobuf\Internal\Message
{
    /**
     * Refer to the comments of Code.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     */
    protected $code = 0;
    /**
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     *
     * Generated from protobuf field <code>optional int32 example_vehicle_index = 2;</code>
     */
    protected $example_vehicle_index = null;
    /**
     * Same as
     * [example_vehicle_index][google.maps.routeoptimization.v1.SkippedShipment.Reason.example_vehicle_index]
     * except that we provide the list of multiple identified vehicles. This
     * list is not necessarily exhaustive. This is only filled if
     * [fill_example_vehicle_indices_in_skipped_reasons][] is true.
     * Experimental: This field's behavior or existence may change in future.
     *
     * Generated from protobuf field <code>repeated int32 example_vehicle_indices = 5;</code>
     */
    private $example_vehicle_indices;
    /**
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     *
     * Generated from protobuf field <code>string example_exceeded_capacity_type = 3;</code>
     */
    protected $example_exceeded_capacity_type = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $code
     *           Refer to the comments of Code.
     *     @type int $example_vehicle_index
     *           If the reason is related to a shipment-vehicle incompatibility, this
     *           field provides the index of one relevant vehicle.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $example_vehicle_indices
     *           Same as
     *           [example_vehicle_index][google.maps.routeoptimization.v1.SkippedShipment.Reason.example_vehicle_index]
     *           except that we provide the list of multiple identified vehicles. This
     *           list is not necessarily exhaustive. This is only filled if
     *           [fill_example_vehicle_indices_in_skipped_reasons][] is true.
     *           Experimental: This field's behavior or existence may change in future.
     *     @type string $example_exceeded_capacity_type
     *           If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     *           capacity type that is exceeded.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Routeoptimization\V1\RouteOptimizationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Refer to the comments of Code.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Refer to the comments of Code.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setCode($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\RouteOptimization\V1\SkippedShipment\Reason\Code::class);
        $this->code = $var;

        return $this;
    }

    /**
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     *
     * Generated from protobuf field <code>optional int32 example_vehicle_index = 2;</code>
     * @return int
     */
    public function getExampleVehicleIndex()
    {
        return isset($this->example_vehicle_index) ? $this->example_vehicle_index : 0;
    }

    public function hasExampleVehicleIndex()
    {
        return isset($this->example_vehicle_index);
    }

    public function clearExampleVehicleIndex()
    {
        unset($this->example_vehicle_index);
    }

    /**
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     *
     * Generated from protobuf field <code>optional int32 example_vehicle_index = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setExampleVehicleIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->example_vehicle_index = $var;

        return $this;
    }

    /**
     * Same as
     * [example_vehicle_index][google.maps.routeoptimization.v1.SkippedShipment.Reason.example_vehicle_index]
     * except that we provide the list of multiple identified vehicles. This
     * list is not necessarily exhaustive. This is only filled if
     * [fill_example_vehicle_indices_in_skipped_reasons][] is true.
     * Experimental: This field's behavior or existence may change in future.
     *
     * Generated from protobuf field <code>repeated int32 example_vehicle_indices = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExampleVehicleIndices()
    {
        return $this->example_vehicle_indices;
    }

    /**
     * Same as
     * [example_vehicle_index][google.maps.routeoptimization.v1.SkippedShipment.Reason.example_vehicle_index]
     * except that we provide the list of multiple identified vehicles. This
     * list is not necessarily exhaustive. This is only filled if
     * [fill_example_vehicle_indices_in_skipped_reasons][] is true.
     * Experimental: This field's behavior or existence may change in future.
     *
     * Generated from protobuf field <code>repeated int32 example_vehicle_indices = 5;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExampleVehicleIndices($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT32);
        $this->example_vehicle_indices = $arr;

        return $this;
    }

    /**
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     *
     * Generated from protobuf field <code>string example_exceeded_capacity_type = 3;</code>
     * @return string
     */
    public function getExampleExceededCapacityType()
    {
        return $this->example_exceeded_capacity_type;
    }

    /**
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     *
     * Generated from protobuf field <code>string example_exceeded_capacity_type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setExampleExceededCapacityType($var)
    {
        GPBUtil::checkString($var, True);
        $this->example_exceeded_capacity_type = $var;

        return $this;
    }

}


