<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/fleetengine/v1/trips.proto

namespace Google\Maps\FleetEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Trip metadata.
 *
 * Generated from protobuf message <code>maps.fleetengine.v1.Trip</code>
 */
class Trip extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. In the format "providers/{provider}/trips/{trip}"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * ID of the vehicle making this trip.
     *
     * Generated from protobuf field <code>string vehicle_id = 2;</code>
     */
    protected $vehicle_id = '';
    /**
     * Current status of the trip.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripStatus trip_status = 3;</code>
     */
    protected $trip_status = 0;
    /**
     * The type of the trip.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripType trip_type = 4;</code>
     */
    protected $trip_type = 0;
    /**
     * Location where customer indicates they will be picked up.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TerminalLocation pickup_point = 5;</code>
     */
    protected $pickup_point = null;
    /**
     * Input only. The actual location when and where customer was picked up.
     * This field is for provider to provide feedback on actual pickup
     * information.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_pickup_point = 22 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $actual_pickup_point = null;
    /**
     * Input only. The actual time and location of the driver arrival at
     * the pickup point.
     * This field is for provider to provide feedback on actual arrival
     * information at the pickup point.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_pickup_arrival_point = 32 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $actual_pickup_arrival_point = null;
    /**
     * Output only. Either the estimated future time when the rider(s) will be
     * picked up, or the actual time when they were picked up.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp pickup_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $pickup_time = null;
    /**
     * Intermediate stops in order that the trip requests (in addition
     * to pickup and dropoff). Initially this will not be supported for shared
     * trips.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TerminalLocation intermediate_destinations = 14;</code>
     */
    private $intermediate_destinations;
    /**
     * Indicates the last time the `intermediate_destinations` was modified.
     * Your server should cache this value and pass it in `UpdateTripRequest`
     * when update `intermediate_destination_index` to ensure the
     * `intermediate_destinations` is not changed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp intermediate_destinations_version = 25;</code>
     */
    protected $intermediate_destinations_version = null;
    /**
     * When `TripStatus` is `ENROUTE_TO_INTERMEDIATE_DESTINATION`, a number
     * between [0..N-1] indicating which intermediate destination the vehicle will
     * cross next. When `TripStatus` is `ARRIVED_AT_INTERMEDIATE_DESTINATION`, a
     * number between [0..N-1] indicating which intermediate destination the
     * vehicle is at. The provider sets this value. If there are no
     * `intermediate_destinations`, this field is ignored.
     *
     * Generated from protobuf field <code>int32 intermediate_destination_index = 15;</code>
     */
    protected $intermediate_destination_index = 0;
    /**
     * Input only. The actual time and location of the driver's arrival at
     * an intermediate destination.
     * This field is for provider to provide feedback on actual arrival
     * information at intermediate destinations.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.StopLocation actual_intermediate_destination_arrival_points = 33 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $actual_intermediate_destination_arrival_points;
    /**
     * Input only. The actual time and location when and where the customer was
     * picked up from an intermediate destination. This field is for provider to
     * provide feedback on actual pickup information at intermediate destinations.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.StopLocation actual_intermediate_destinations = 34 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $actual_intermediate_destinations;
    /**
     * Location where customer indicates they will be dropped off.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TerminalLocation dropoff_point = 7;</code>
     */
    protected $dropoff_point = null;
    /**
     * Input only. The actual time and location when and where customer was
     * dropped off. This field is for provider to provide feedback on actual
     * dropoff information.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_dropoff_point = 23 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $actual_dropoff_point = null;
    /**
     * Output only. Either the estimated future time when the rider(s) will be
     * dropped off at the final destination, or the actual time when they were
     * dropped off.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp dropoff_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $dropoff_time = null;
    /**
     * Output only. The full path from the current location to the dropoff point,
     * inclusive. This path could include waypoints from other trips.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint remaining_waypoints = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $remaining_waypoints;
    /**
     * This field supports manual ordering of the waypoints for the trip. It
     * contains all of the remaining waypoints for the assigned vehicle, as well
     * as the pickup and drop-off waypoints for this trip. If the trip hasn't been
     * assigned to a vehicle, then Fleet Engine ignores this field. For privacy
     * reasons, this field is only populated by the server on `UpdateTrip` and
     * `CreateTrip` calls, NOT on `GetTrip` calls.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint vehicle_waypoints = 20;</code>
     */
    private $vehicle_waypoints;
    /**
     * Output only. Anticipated route for this trip to the first entry in
     * remaining_waypoints. Note that the first waypoint may belong to a different
     * trip.
     *
     * Generated from protobuf field <code>repeated .google.type.LatLng route = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $route;
    /**
     * Output only. An encoded path to the next waypoint.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK. Decoding is not yet supported.
     *
     * Generated from protobuf field <code>string current_route_segment = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $current_route_segment = '';
    /**
     * Output only. Indicates the last time the route was modified.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_version = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $current_route_segment_version = null;
    /**
     * Output only. Indicates the traffic conditions along the
     * `current_route_segment` when they're available.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.ConsumableTrafficPolyline current_route_segment_traffic = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $current_route_segment_traffic = null;
    /**
     * Output only. Indicates the last time the `current_route_segment_traffic`
     * was modified.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_traffic_version = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $current_route_segment_traffic_version = null;
    /**
     * Output only. The waypoint where `current_route_segment` ends.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripWaypoint current_route_segment_end_point = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $current_route_segment_end_point = null;
    /**
     * Output only. The remaining driving distance in the `current_route_segment`
     * field. The value is unspecified if the trip is not assigned to a vehicle,
     * or the trip is completed or cancelled.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $remaining_distance_meters = null;
    /**
     * Output only. The ETA to the next waypoint (the first entry in the
     * `remaining_waypoints` field). The value is unspecified if the trip is not
     * assigned to a vehicle, or the trip is inactive (completed or cancelled).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp eta_to_first_waypoint = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $eta_to_first_waypoint = null;
    /**
     * Output only. The duration from when the Trip data is returned to the time
     * in `Trip.eta_to_first_waypoint`. The value is unspecified if the trip is
     * not assigned to a vehicle, or the trip is inactive (completed or
     * cancelled).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration remaining_time_to_first_waypoint = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $remaining_time_to_first_waypoint = null;
    /**
     * Output only. Indicates the last time that `remaining_waypoints` was changed
     * (a waypoint was added, removed, or changed).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp remaining_waypoints_version = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $remaining_waypoints_version = null;
    /**
     * Output only. Indicates the last time the
     * `remaining_waypoints.path_to_waypoint` and
     * `remaining_waypoints.traffic_to_waypoint` were modified. Your client app
     * should cache this value and pass it in `GetTripRequest` to ensure the
     * paths and traffic for `remaining_waypoints` are only returned if updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp remaining_waypoints_route_version = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $remaining_waypoints_route_version = null;
    /**
     * Immutable. Indicates the number of passengers on this trip and does not
     * include the driver. A vehicle must have available capacity to be returned
     * in a `SearchVehicles` response.
     *
     * Generated from protobuf field <code>int32 number_of_passengers = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $number_of_passengers = 0;
    /**
     * Output only. Indicates the last reported location of the vehicle along the
     * route.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleLocation last_location = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_location = null;
    /**
     * Output only. Indicates whether the vehicle's `last_location` can be snapped
     * to the current_route_segment. False if `last_location` or
     * `current_route_segment` doesn't exist.
     * It is computed by Fleet Engine. Any update from clients will be ignored.
     *
     * Generated from protobuf field <code>bool last_location_snappable = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_location_snappable = false;
    /**
     * The subset of Trip fields that are populated and how they should be
     * interpreted.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripView view = 31;</code>
     */
    protected $view = 0;
    /**
     * A list of custom Trip attributes. Each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripAttribute attributes = 35;</code>
     */
    private $attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. In the format "providers/{provider}/trips/{trip}"
     *     @type string $vehicle_id
     *           ID of the vehicle making this trip.
     *     @type int $trip_status
     *           Current status of the trip.
     *     @type int $trip_type
     *           The type of the trip.
     *     @type \Google\Maps\FleetEngine\V1\TerminalLocation $pickup_point
     *           Location where customer indicates they will be picked up.
     *     @type \Google\Maps\FleetEngine\V1\StopLocation $actual_pickup_point
     *           Input only. The actual location when and where customer was picked up.
     *           This field is for provider to provide feedback on actual pickup
     *           information.
     *     @type \Google\Maps\FleetEngine\V1\StopLocation $actual_pickup_arrival_point
     *           Input only. The actual time and location of the driver arrival at
     *           the pickup point.
     *           This field is for provider to provide feedback on actual arrival
     *           information at the pickup point.
     *     @type \Google\Protobuf\Timestamp $pickup_time
     *           Output only. Either the estimated future time when the rider(s) will be
     *           picked up, or the actual time when they were picked up.
     *     @type array<\Google\Maps\FleetEngine\V1\TerminalLocation>|\Google\Protobuf\Internal\RepeatedField $intermediate_destinations
     *           Intermediate stops in order that the trip requests (in addition
     *           to pickup and dropoff). Initially this will not be supported for shared
     *           trips.
     *     @type \Google\Protobuf\Timestamp $intermediate_destinations_version
     *           Indicates the last time the `intermediate_destinations` was modified.
     *           Your server should cache this value and pass it in `UpdateTripRequest`
     *           when update `intermediate_destination_index` to ensure the
     *           `intermediate_destinations` is not changed.
     *     @type int $intermediate_destination_index
     *           When `TripStatus` is `ENROUTE_TO_INTERMEDIATE_DESTINATION`, a number
     *           between [0..N-1] indicating which intermediate destination the vehicle will
     *           cross next. When `TripStatus` is `ARRIVED_AT_INTERMEDIATE_DESTINATION`, a
     *           number between [0..N-1] indicating which intermediate destination the
     *           vehicle is at. The provider sets this value. If there are no
     *           `intermediate_destinations`, this field is ignored.
     *     @type array<\Google\Maps\FleetEngine\V1\StopLocation>|\Google\Protobuf\Internal\RepeatedField $actual_intermediate_destination_arrival_points
     *           Input only. The actual time and location of the driver's arrival at
     *           an intermediate destination.
     *           This field is for provider to provide feedback on actual arrival
     *           information at intermediate destinations.
     *     @type array<\Google\Maps\FleetEngine\V1\StopLocation>|\Google\Protobuf\Internal\RepeatedField $actual_intermediate_destinations
     *           Input only. The actual time and location when and where the customer was
     *           picked up from an intermediate destination. This field is for provider to
     *           provide feedback on actual pickup information at intermediate destinations.
     *     @type \Google\Maps\FleetEngine\V1\TerminalLocation $dropoff_point
     *           Location where customer indicates they will be dropped off.
     *     @type \Google\Maps\FleetEngine\V1\StopLocation $actual_dropoff_point
     *           Input only. The actual time and location when and where customer was
     *           dropped off. This field is for provider to provide feedback on actual
     *           dropoff information.
     *     @type \Google\Protobuf\Timestamp $dropoff_time
     *           Output only. Either the estimated future time when the rider(s) will be
     *           dropped off at the final destination, or the actual time when they were
     *           dropped off.
     *     @type array<\Google\Maps\FleetEngine\V1\TripWaypoint>|\Google\Protobuf\Internal\RepeatedField $remaining_waypoints
     *           Output only. The full path from the current location to the dropoff point,
     *           inclusive. This path could include waypoints from other trips.
     *     @type array<\Google\Maps\FleetEngine\V1\TripWaypoint>|\Google\Protobuf\Internal\RepeatedField $vehicle_waypoints
     *           This field supports manual ordering of the waypoints for the trip. It
     *           contains all of the remaining waypoints for the assigned vehicle, as well
     *           as the pickup and drop-off waypoints for this trip. If the trip hasn't been
     *           assigned to a vehicle, then Fleet Engine ignores this field. For privacy
     *           reasons, this field is only populated by the server on `UpdateTrip` and
     *           `CreateTrip` calls, NOT on `GetTrip` calls.
     *     @type array<\Google\Type\LatLng>|\Google\Protobuf\Internal\RepeatedField $route
     *           Output only. Anticipated route for this trip to the first entry in
     *           remaining_waypoints. Note that the first waypoint may belong to a different
     *           trip.
     *     @type string $current_route_segment
     *           Output only. An encoded path to the next waypoint.
     *           Note: This field is intended only for use by the Driver SDK and Consumer
     *           SDK. Decoding is not yet supported.
     *     @type \Google\Protobuf\Timestamp $current_route_segment_version
     *           Output only. Indicates the last time the route was modified.
     *           Note: This field is intended only for use by the Driver SDK and Consumer
     *           SDK.
     *     @type \Google\Maps\FleetEngine\V1\ConsumableTrafficPolyline $current_route_segment_traffic
     *           Output only. Indicates the traffic conditions along the
     *           `current_route_segment` when they're available.
     *           Note: This field is intended only for use by the Driver SDK and Consumer
     *           SDK.
     *     @type \Google\Protobuf\Timestamp $current_route_segment_traffic_version
     *           Output only. Indicates the last time the `current_route_segment_traffic`
     *           was modified.
     *           Note: This field is intended only for use by the Driver SDK and Consumer
     *           SDK.
     *     @type \Google\Maps\FleetEngine\V1\TripWaypoint $current_route_segment_end_point
     *           Output only. The waypoint where `current_route_segment` ends.
     *     @type \Google\Protobuf\Int32Value $remaining_distance_meters
     *           Output only. The remaining driving distance in the `current_route_segment`
     *           field. The value is unspecified if the trip is not assigned to a vehicle,
     *           or the trip is completed or cancelled.
     *     @type \Google\Protobuf\Timestamp $eta_to_first_waypoint
     *           Output only. The ETA to the next waypoint (the first entry in the
     *           `remaining_waypoints` field). The value is unspecified if the trip is not
     *           assigned to a vehicle, or the trip is inactive (completed or cancelled).
     *     @type \Google\Protobuf\Duration $remaining_time_to_first_waypoint
     *           Output only. The duration from when the Trip data is returned to the time
     *           in `Trip.eta_to_first_waypoint`. The value is unspecified if the trip is
     *           not assigned to a vehicle, or the trip is inactive (completed or
     *           cancelled).
     *     @type \Google\Protobuf\Timestamp $remaining_waypoints_version
     *           Output only. Indicates the last time that `remaining_waypoints` was changed
     *           (a waypoint was added, removed, or changed).
     *     @type \Google\Protobuf\Timestamp $remaining_waypoints_route_version
     *           Output only. Indicates the last time the
     *           `remaining_waypoints.path_to_waypoint` and
     *           `remaining_waypoints.traffic_to_waypoint` were modified. Your client app
     *           should cache this value and pass it in `GetTripRequest` to ensure the
     *           paths and traffic for `remaining_waypoints` are only returned if updated.
     *     @type int $number_of_passengers
     *           Immutable. Indicates the number of passengers on this trip and does not
     *           include the driver. A vehicle must have available capacity to be returned
     *           in a `SearchVehicles` response.
     *     @type \Google\Maps\FleetEngine\V1\VehicleLocation $last_location
     *           Output only. Indicates the last reported location of the vehicle along the
     *           route.
     *     @type bool $last_location_snappable
     *           Output only. Indicates whether the vehicle's `last_location` can be snapped
     *           to the current_route_segment. False if `last_location` or
     *           `current_route_segment` doesn't exist.
     *           It is computed by Fleet Engine. Any update from clients will be ignored.
     *     @type int $view
     *           The subset of Trip fields that are populated and how they should be
     *           interpreted.
     *     @type array<\Google\Maps\FleetEngine\V1\TripAttribute>|\Google\Protobuf\Internal\RepeatedField $attributes
     *           A list of custom Trip attributes. Each attribute must have a unique key.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Fleetengine\V1\Trips::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. In the format "providers/{provider}/trips/{trip}"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. In the format "providers/{provider}/trips/{trip}"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * ID of the vehicle making this trip.
     *
     * Generated from protobuf field <code>string vehicle_id = 2;</code>
     * @return string
     */
    public function getVehicleId()
    {
        return $this->vehicle_id;
    }

    /**
     * ID of the vehicle making this trip.
     *
     * Generated from protobuf field <code>string vehicle_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setVehicleId($var)
    {
        GPBUtil::checkString($var, True);
        $this->vehicle_id = $var;

        return $this;
    }

    /**
     * Current status of the trip.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripStatus trip_status = 3;</code>
     * @return int
     */
    public function getTripStatus()
    {
        return $this->trip_status;
    }

    /**
     * Current status of the trip.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripStatus trip_status = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setTripStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\V1\TripStatus::class);
        $this->trip_status = $var;

        return $this;
    }

    /**
     * The type of the trip.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripType trip_type = 4;</code>
     * @return int
     */
    public function getTripType()
    {
        return $this->trip_type;
    }

    /**
     * The type of the trip.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripType trip_type = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setTripType($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\V1\TripType::class);
        $this->trip_type = $var;

        return $this;
    }

    /**
     * Location where customer indicates they will be picked up.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TerminalLocation pickup_point = 5;</code>
     * @return \Google\Maps\FleetEngine\V1\TerminalLocation|null
     */
    public function getPickupPoint()
    {
        return $this->pickup_point;
    }

    public function hasPickupPoint()
    {
        return isset($this->pickup_point);
    }

    public function clearPickupPoint()
    {
        unset($this->pickup_point);
    }

    /**
     * Location where customer indicates they will be picked up.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TerminalLocation pickup_point = 5;</code>
     * @param \Google\Maps\FleetEngine\V1\TerminalLocation $var
     * @return $this
     */
    public function setPickupPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\TerminalLocation::class);
        $this->pickup_point = $var;

        return $this;
    }

    /**
     * Input only. The actual location when and where customer was picked up.
     * This field is for provider to provide feedback on actual pickup
     * information.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_pickup_point = 22 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\StopLocation|null
     */
    public function getActualPickupPoint()
    {
        return $this->actual_pickup_point;
    }

    public function hasActualPickupPoint()
    {
        return isset($this->actual_pickup_point);
    }

    public function clearActualPickupPoint()
    {
        unset($this->actual_pickup_point);
    }

    /**
     * Input only. The actual location when and where customer was picked up.
     * This field is for provider to provide feedback on actual pickup
     * information.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_pickup_point = 22 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\StopLocation $var
     * @return $this
     */
    public function setActualPickupPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\StopLocation::class);
        $this->actual_pickup_point = $var;

        return $this;
    }

    /**
     * Input only. The actual time and location of the driver arrival at
     * the pickup point.
     * This field is for provider to provide feedback on actual arrival
     * information at the pickup point.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_pickup_arrival_point = 32 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\StopLocation|null
     */
    public function getActualPickupArrivalPoint()
    {
        return $this->actual_pickup_arrival_point;
    }

    public function hasActualPickupArrivalPoint()
    {
        return isset($this->actual_pickup_arrival_point);
    }

    public function clearActualPickupArrivalPoint()
    {
        unset($this->actual_pickup_arrival_point);
    }

    /**
     * Input only. The actual time and location of the driver arrival at
     * the pickup point.
     * This field is for provider to provide feedback on actual arrival
     * information at the pickup point.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_pickup_arrival_point = 32 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\StopLocation $var
     * @return $this
     */
    public function setActualPickupArrivalPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\StopLocation::class);
        $this->actual_pickup_arrival_point = $var;

        return $this;
    }

    /**
     * Output only. Either the estimated future time when the rider(s) will be
     * picked up, or the actual time when they were picked up.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp pickup_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPickupTime()
    {
        return $this->pickup_time;
    }

    public function hasPickupTime()
    {
        return isset($this->pickup_time);
    }

    public function clearPickupTime()
    {
        unset($this->pickup_time);
    }

    /**
     * Output only. Either the estimated future time when the rider(s) will be
     * picked up, or the actual time when they were picked up.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp pickup_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPickupTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->pickup_time = $var;

        return $this;
    }

    /**
     * Intermediate stops in order that the trip requests (in addition
     * to pickup and dropoff). Initially this will not be supported for shared
     * trips.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TerminalLocation intermediate_destinations = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIntermediateDestinations()
    {
        return $this->intermediate_destinations;
    }

    /**
     * Intermediate stops in order that the trip requests (in addition
     * to pickup and dropoff). Initially this will not be supported for shared
     * trips.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TerminalLocation intermediate_destinations = 14;</code>
     * @param array<\Google\Maps\FleetEngine\V1\TerminalLocation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIntermediateDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\TerminalLocation::class);
        $this->intermediate_destinations = $arr;

        return $this;
    }

    /**
     * Indicates the last time the `intermediate_destinations` was modified.
     * Your server should cache this value and pass it in `UpdateTripRequest`
     * when update `intermediate_destination_index` to ensure the
     * `intermediate_destinations` is not changed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp intermediate_destinations_version = 25;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getIntermediateDestinationsVersion()
    {
        return $this->intermediate_destinations_version;
    }

    public function hasIntermediateDestinationsVersion()
    {
        return isset($this->intermediate_destinations_version);
    }

    public function clearIntermediateDestinationsVersion()
    {
        unset($this->intermediate_destinations_version);
    }

    /**
     * Indicates the last time the `intermediate_destinations` was modified.
     * Your server should cache this value and pass it in `UpdateTripRequest`
     * when update `intermediate_destination_index` to ensure the
     * `intermediate_destinations` is not changed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp intermediate_destinations_version = 25;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setIntermediateDestinationsVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->intermediate_destinations_version = $var;

        return $this;
    }

    /**
     * When `TripStatus` is `ENROUTE_TO_INTERMEDIATE_DESTINATION`, a number
     * between [0..N-1] indicating which intermediate destination the vehicle will
     * cross next. When `TripStatus` is `ARRIVED_AT_INTERMEDIATE_DESTINATION`, a
     * number between [0..N-1] indicating which intermediate destination the
     * vehicle is at. The provider sets this value. If there are no
     * `intermediate_destinations`, this field is ignored.
     *
     * Generated from protobuf field <code>int32 intermediate_destination_index = 15;</code>
     * @return int
     */
    public function getIntermediateDestinationIndex()
    {
        return $this->intermediate_destination_index;
    }

    /**
     * When `TripStatus` is `ENROUTE_TO_INTERMEDIATE_DESTINATION`, a number
     * between [0..N-1] indicating which intermediate destination the vehicle will
     * cross next. When `TripStatus` is `ARRIVED_AT_INTERMEDIATE_DESTINATION`, a
     * number between [0..N-1] indicating which intermediate destination the
     * vehicle is at. The provider sets this value. If there are no
     * `intermediate_destinations`, this field is ignored.
     *
     * Generated from protobuf field <code>int32 intermediate_destination_index = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setIntermediateDestinationIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->intermediate_destination_index = $var;

        return $this;
    }

    /**
     * Input only. The actual time and location of the driver's arrival at
     * an intermediate destination.
     * This field is for provider to provide feedback on actual arrival
     * information at intermediate destinations.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.StopLocation actual_intermediate_destination_arrival_points = 33 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActualIntermediateDestinationArrivalPoints()
    {
        return $this->actual_intermediate_destination_arrival_points;
    }

    /**
     * Input only. The actual time and location of the driver's arrival at
     * an intermediate destination.
     * This field is for provider to provide feedback on actual arrival
     * information at intermediate destinations.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.StopLocation actual_intermediate_destination_arrival_points = 33 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param array<\Google\Maps\FleetEngine\V1\StopLocation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActualIntermediateDestinationArrivalPoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\StopLocation::class);
        $this->actual_intermediate_destination_arrival_points = $arr;

        return $this;
    }

    /**
     * Input only. The actual time and location when and where the customer was
     * picked up from an intermediate destination. This field is for provider to
     * provide feedback on actual pickup information at intermediate destinations.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.StopLocation actual_intermediate_destinations = 34 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActualIntermediateDestinations()
    {
        return $this->actual_intermediate_destinations;
    }

    /**
     * Input only. The actual time and location when and where the customer was
     * picked up from an intermediate destination. This field is for provider to
     * provide feedback on actual pickup information at intermediate destinations.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.StopLocation actual_intermediate_destinations = 34 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param array<\Google\Maps\FleetEngine\V1\StopLocation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActualIntermediateDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\StopLocation::class);
        $this->actual_intermediate_destinations = $arr;

        return $this;
    }

    /**
     * Location where customer indicates they will be dropped off.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TerminalLocation dropoff_point = 7;</code>
     * @return \Google\Maps\FleetEngine\V1\TerminalLocation|null
     */
    public function getDropoffPoint()
    {
        return $this->dropoff_point;
    }

    public function hasDropoffPoint()
    {
        return isset($this->dropoff_point);
    }

    public function clearDropoffPoint()
    {
        unset($this->dropoff_point);
    }

    /**
     * Location where customer indicates they will be dropped off.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TerminalLocation dropoff_point = 7;</code>
     * @param \Google\Maps\FleetEngine\V1\TerminalLocation $var
     * @return $this
     */
    public function setDropoffPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\TerminalLocation::class);
        $this->dropoff_point = $var;

        return $this;
    }

    /**
     * Input only. The actual time and location when and where customer was
     * dropped off. This field is for provider to provide feedback on actual
     * dropoff information.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_dropoff_point = 23 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\StopLocation|null
     */
    public function getActualDropoffPoint()
    {
        return $this->actual_dropoff_point;
    }

    public function hasActualDropoffPoint()
    {
        return isset($this->actual_dropoff_point);
    }

    public function clearActualDropoffPoint()
    {
        unset($this->actual_dropoff_point);
    }

    /**
     * Input only. The actual time and location when and where customer was
     * dropped off. This field is for provider to provide feedback on actual
     * dropoff information.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.StopLocation actual_dropoff_point = 23 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\StopLocation $var
     * @return $this
     */
    public function setActualDropoffPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\StopLocation::class);
        $this->actual_dropoff_point = $var;

        return $this;
    }

    /**
     * Output only. Either the estimated future time when the rider(s) will be
     * dropped off at the final destination, or the actual time when they were
     * dropped off.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp dropoff_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDropoffTime()
    {
        return $this->dropoff_time;
    }

    public function hasDropoffTime()
    {
        return isset($this->dropoff_time);
    }

    public function clearDropoffTime()
    {
        unset($this->dropoff_time);
    }

    /**
     * Output only. Either the estimated future time when the rider(s) will be
     * dropped off at the final destination, or the actual time when they were
     * dropped off.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp dropoff_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDropoffTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->dropoff_time = $var;

        return $this;
    }

    /**
     * Output only. The full path from the current location to the dropoff point,
     * inclusive. This path could include waypoints from other trips.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint remaining_waypoints = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRemainingWaypoints()
    {
        return $this->remaining_waypoints;
    }

    /**
     * Output only. The full path from the current location to the dropoff point,
     * inclusive. This path could include waypoints from other trips.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint remaining_waypoints = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Maps\FleetEngine\V1\TripWaypoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRemainingWaypoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\TripWaypoint::class);
        $this->remaining_waypoints = $arr;

        return $this;
    }

    /**
     * This field supports manual ordering of the waypoints for the trip. It
     * contains all of the remaining waypoints for the assigned vehicle, as well
     * as the pickup and drop-off waypoints for this trip. If the trip hasn't been
     * assigned to a vehicle, then Fleet Engine ignores this field. For privacy
     * reasons, this field is only populated by the server on `UpdateTrip` and
     * `CreateTrip` calls, NOT on `GetTrip` calls.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint vehicle_waypoints = 20;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVehicleWaypoints()
    {
        return $this->vehicle_waypoints;
    }

    /**
     * This field supports manual ordering of the waypoints for the trip. It
     * contains all of the remaining waypoints for the assigned vehicle, as well
     * as the pickup and drop-off waypoints for this trip. If the trip hasn't been
     * assigned to a vehicle, then Fleet Engine ignores this field. For privacy
     * reasons, this field is only populated by the server on `UpdateTrip` and
     * `CreateTrip` calls, NOT on `GetTrip` calls.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint vehicle_waypoints = 20;</code>
     * @param array<\Google\Maps\FleetEngine\V1\TripWaypoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVehicleWaypoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\TripWaypoint::class);
        $this->vehicle_waypoints = $arr;

        return $this;
    }

    /**
     * Output only. Anticipated route for this trip to the first entry in
     * remaining_waypoints. Note that the first waypoint may belong to a different
     * trip.
     *
     * Generated from protobuf field <code>repeated .google.type.LatLng route = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRoute()
    {
        return $this->route;
    }

    /**
     * Output only. Anticipated route for this trip to the first entry in
     * remaining_waypoints. Note that the first waypoint may belong to a different
     * trip.
     *
     * Generated from protobuf field <code>repeated .google.type.LatLng route = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Type\LatLng>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRoute($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Type\LatLng::class);
        $this->route = $arr;

        return $this;
    }

    /**
     * Output only. An encoded path to the next waypoint.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK. Decoding is not yet supported.
     *
     * Generated from protobuf field <code>string current_route_segment = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCurrentRouteSegment()
    {
        return $this->current_route_segment;
    }

    /**
     * Output only. An encoded path to the next waypoint.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK. Decoding is not yet supported.
     *
     * Generated from protobuf field <code>string current_route_segment = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentRouteSegment($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_route_segment = $var;

        return $this;
    }

    /**
     * Output only. Indicates the last time the route was modified.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_version = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCurrentRouteSegmentVersion()
    {
        return $this->current_route_segment_version;
    }

    public function hasCurrentRouteSegmentVersion()
    {
        return isset($this->current_route_segment_version);
    }

    public function clearCurrentRouteSegmentVersion()
    {
        unset($this->current_route_segment_version);
    }

    /**
     * Output only. Indicates the last time the route was modified.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_version = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCurrentRouteSegmentVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->current_route_segment_version = $var;

        return $this;
    }

    /**
     * Output only. Indicates the traffic conditions along the
     * `current_route_segment` when they're available.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.ConsumableTrafficPolyline current_route_segment_traffic = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\ConsumableTrafficPolyline|null
     */
    public function getCurrentRouteSegmentTraffic()
    {
        return $this->current_route_segment_traffic;
    }

    public function hasCurrentRouteSegmentTraffic()
    {
        return isset($this->current_route_segment_traffic);
    }

    public function clearCurrentRouteSegmentTraffic()
    {
        unset($this->current_route_segment_traffic);
    }

    /**
     * Output only. Indicates the traffic conditions along the
     * `current_route_segment` when they're available.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.ConsumableTrafficPolyline current_route_segment_traffic = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\ConsumableTrafficPolyline $var
     * @return $this
     */
    public function setCurrentRouteSegmentTraffic($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\ConsumableTrafficPolyline::class);
        $this->current_route_segment_traffic = $var;

        return $this;
    }

    /**
     * Output only. Indicates the last time the `current_route_segment_traffic`
     * was modified.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_traffic_version = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCurrentRouteSegmentTrafficVersion()
    {
        return $this->current_route_segment_traffic_version;
    }

    public function hasCurrentRouteSegmentTrafficVersion()
    {
        return isset($this->current_route_segment_traffic_version);
    }

    public function clearCurrentRouteSegmentTrafficVersion()
    {
        unset($this->current_route_segment_traffic_version);
    }

    /**
     * Output only. Indicates the last time the `current_route_segment_traffic`
     * was modified.
     * Note: This field is intended only for use by the Driver SDK and Consumer
     * SDK.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_traffic_version = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCurrentRouteSegmentTrafficVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->current_route_segment_traffic_version = $var;

        return $this;
    }

    /**
     * Output only. The waypoint where `current_route_segment` ends.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripWaypoint current_route_segment_end_point = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\TripWaypoint|null
     */
    public function getCurrentRouteSegmentEndPoint()
    {
        return $this->current_route_segment_end_point;
    }

    public function hasCurrentRouteSegmentEndPoint()
    {
        return isset($this->current_route_segment_end_point);
    }

    public function clearCurrentRouteSegmentEndPoint()
    {
        unset($this->current_route_segment_end_point);
    }

    /**
     * Output only. The waypoint where `current_route_segment` ends.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripWaypoint current_route_segment_end_point = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\TripWaypoint $var
     * @return $this
     */
    public function setCurrentRouteSegmentEndPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\TripWaypoint::class);
        $this->current_route_segment_end_point = $var;

        return $this;
    }

    /**
     * Output only. The remaining driving distance in the `current_route_segment`
     * field. The value is unspecified if the trip is not assigned to a vehicle,
     * or the trip is completed or cancelled.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Int32Value|null
     */
    public function getRemainingDistanceMeters()
    {
        return $this->remaining_distance_meters;
    }

    public function hasRemainingDistanceMeters()
    {
        return isset($this->remaining_distance_meters);
    }

    public function clearRemainingDistanceMeters()
    {
        unset($this->remaining_distance_meters);
    }

    /**
     * Returns the unboxed value from <code>getRemainingDistanceMeters()</code>

     * Output only. The remaining driving distance in the `current_route_segment`
     * field. The value is unspecified if the trip is not assigned to a vehicle,
     * or the trip is completed or cancelled.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|null
     */
    public function getRemainingDistanceMetersUnwrapped()
    {
        return $this->readWrapperValue("remaining_distance_meters");
    }

    /**
     * Output only. The remaining driving distance in the `current_route_segment`
     * field. The value is unspecified if the trip is not assigned to a vehicle,
     * or the trip is completed or cancelled.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setRemainingDistanceMeters($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->remaining_distance_meters = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Output only. The remaining driving distance in the `current_route_segment`
     * field. The value is unspecified if the trip is not assigned to a vehicle,
     * or the trip is completed or cancelled.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|null $var
     * @return $this
     */
    public function setRemainingDistanceMetersUnwrapped($var)
    {
        $this->writeWrapperValue("remaining_distance_meters", $var);
        return $this;}

    /**
     * Output only. The ETA to the next waypoint (the first entry in the
     * `remaining_waypoints` field). The value is unspecified if the trip is not
     * assigned to a vehicle, or the trip is inactive (completed or cancelled).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp eta_to_first_waypoint = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEtaToFirstWaypoint()
    {
        return $this->eta_to_first_waypoint;
    }

    public function hasEtaToFirstWaypoint()
    {
        return isset($this->eta_to_first_waypoint);
    }

    public function clearEtaToFirstWaypoint()
    {
        unset($this->eta_to_first_waypoint);
    }

    /**
     * Output only. The ETA to the next waypoint (the first entry in the
     * `remaining_waypoints` field). The value is unspecified if the trip is not
     * assigned to a vehicle, or the trip is inactive (completed or cancelled).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp eta_to_first_waypoint = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEtaToFirstWaypoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->eta_to_first_waypoint = $var;

        return $this;
    }

    /**
     * Output only. The duration from when the Trip data is returned to the time
     * in `Trip.eta_to_first_waypoint`. The value is unspecified if the trip is
     * not assigned to a vehicle, or the trip is inactive (completed or
     * cancelled).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration remaining_time_to_first_waypoint = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getRemainingTimeToFirstWaypoint()
    {
        return $this->remaining_time_to_first_waypoint;
    }

    public function hasRemainingTimeToFirstWaypoint()
    {
        return isset($this->remaining_time_to_first_waypoint);
    }

    public function clearRemainingTimeToFirstWaypoint()
    {
        unset($this->remaining_time_to_first_waypoint);
    }

    /**
     * Output only. The duration from when the Trip data is returned to the time
     * in `Trip.eta_to_first_waypoint`. The value is unspecified if the trip is
     * not assigned to a vehicle, or the trip is inactive (completed or
     * cancelled).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration remaining_time_to_first_waypoint = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setRemainingTimeToFirstWaypoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->remaining_time_to_first_waypoint = $var;

        return $this;
    }

    /**
     * Output only. Indicates the last time that `remaining_waypoints` was changed
     * (a waypoint was added, removed, or changed).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp remaining_waypoints_version = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRemainingWaypointsVersion()
    {
        return $this->remaining_waypoints_version;
    }

    public function hasRemainingWaypointsVersion()
    {
        return isset($this->remaining_waypoints_version);
    }

    public function clearRemainingWaypointsVersion()
    {
        unset($this->remaining_waypoints_version);
    }

    /**
     * Output only. Indicates the last time that `remaining_waypoints` was changed
     * (a waypoint was added, removed, or changed).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp remaining_waypoints_version = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRemainingWaypointsVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->remaining_waypoints_version = $var;

        return $this;
    }

    /**
     * Output only. Indicates the last time the
     * `remaining_waypoints.path_to_waypoint` and
     * `remaining_waypoints.traffic_to_waypoint` were modified. Your client app
     * should cache this value and pass it in `GetTripRequest` to ensure the
     * paths and traffic for `remaining_waypoints` are only returned if updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp remaining_waypoints_route_version = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRemainingWaypointsRouteVersion()
    {
        return $this->remaining_waypoints_route_version;
    }

    public function hasRemainingWaypointsRouteVersion()
    {
        return isset($this->remaining_waypoints_route_version);
    }

    public function clearRemainingWaypointsRouteVersion()
    {
        unset($this->remaining_waypoints_route_version);
    }

    /**
     * Output only. Indicates the last time the
     * `remaining_waypoints.path_to_waypoint` and
     * `remaining_waypoints.traffic_to_waypoint` were modified. Your client app
     * should cache this value and pass it in `GetTripRequest` to ensure the
     * paths and traffic for `remaining_waypoints` are only returned if updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp remaining_waypoints_route_version = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRemainingWaypointsRouteVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->remaining_waypoints_route_version = $var;

        return $this;
    }

    /**
     * Immutable. Indicates the number of passengers on this trip and does not
     * include the driver. A vehicle must have available capacity to be returned
     * in a `SearchVehicles` response.
     *
     * Generated from protobuf field <code>int32 number_of_passengers = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getNumberOfPassengers()
    {
        return $this->number_of_passengers;
    }

    /**
     * Immutable. Indicates the number of passengers on this trip and does not
     * include the driver. A vehicle must have available capacity to be returned
     * in a `SearchVehicles` response.
     *
     * Generated from protobuf field <code>int32 number_of_passengers = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setNumberOfPassengers($var)
    {
        GPBUtil::checkInt32($var);
        $this->number_of_passengers = $var;

        return $this;
    }

    /**
     * Output only. Indicates the last reported location of the vehicle along the
     * route.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleLocation last_location = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\VehicleLocation|null
     */
    public function getLastLocation()
    {
        return $this->last_location;
    }

    public function hasLastLocation()
    {
        return isset($this->last_location);
    }

    public function clearLastLocation()
    {
        unset($this->last_location);
    }

    /**
     * Output only. Indicates the last reported location of the vehicle along the
     * route.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleLocation last_location = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\VehicleLocation $var
     * @return $this
     */
    public function setLastLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\VehicleLocation::class);
        $this->last_location = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether the vehicle's `last_location` can be snapped
     * to the current_route_segment. False if `last_location` or
     * `current_route_segment` doesn't exist.
     * It is computed by Fleet Engine. Any update from clients will be ignored.
     *
     * Generated from protobuf field <code>bool last_location_snappable = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getLastLocationSnappable()
    {
        return $this->last_location_snappable;
    }

    /**
     * Output only. Indicates whether the vehicle's `last_location` can be snapped
     * to the current_route_segment. False if `last_location` or
     * `current_route_segment` doesn't exist.
     * It is computed by Fleet Engine. Any update from clients will be ignored.
     *
     * Generated from protobuf field <code>bool last_location_snappable = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setLastLocationSnappable($var)
    {
        GPBUtil::checkBool($var);
        $this->last_location_snappable = $var;

        return $this;
    }

    /**
     * The subset of Trip fields that are populated and how they should be
     * interpreted.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripView view = 31;</code>
     * @return int
     */
    public function getView()
    {
        return $this->view;
    }

    /**
     * The subset of Trip fields that are populated and how they should be
     * interpreted.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripView view = 31;</code>
     * @param int $var
     * @return $this
     */
    public function setView($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\V1\TripView::class);
        $this->view = $var;

        return $this;
    }

    /**
     * A list of custom Trip attributes. Each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripAttribute attributes = 35;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * A list of custom Trip attributes. Each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripAttribute attributes = 35;</code>
     * @param array<\Google\Maps\FleetEngine\V1\TripAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\TripAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

}

