<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/fleetengine/v1/vehicle_api.proto

namespace Google\Maps\FleetEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `ListVehicles` request message.
 *
 * Generated from protobuf message <code>maps.fleetengine.v1.ListVehiclesRequest</code>
 */
class ListVehiclesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * The standard Fleet Engine request header.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.RequestHeader header = 12;</code>
     */
    protected $header = null;
    /**
     * Required. Must be in the format `providers/{provider}`.
     * The provider must be the Project ID (for example, `sample-cloud-project`)
     * of the Google Cloud Project of which the service account making
     * this call is a member.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $parent = '';
    /**
     * The maximum number of vehicles to return.
     * Default value: 100.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     */
    protected $page_size = 0;
    /**
     * The value of the `next_page_token` provided by a previous call to
     * `ListVehicles` so that you can paginate through groups of vehicles. The
     * value is undefined if the filter criteria of the request is not the same as
     * the filter criteria for the previous call to `ListVehicles`.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     */
    protected $page_token = '';
    /**
     * Specifies the required minimum capacity of the vehicle. All vehicles
     * returned will have a `maximum_capacity` greater than or equal to this
     * value. If set, must be greater or equal to 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value minimum_capacity = 6;</code>
     */
    protected $minimum_capacity = null;
    /**
     * Restricts the response to vehicles that support at least one of the
     * specified trip types.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripType trip_types = 7;</code>
     */
    private $trip_types;
    /**
     * Restricts the response to vehicles that have sent location updates to Fleet
     * Engine within the specified duration. Stationary vehicles still
     * transmitting their locations are not considered stale. If present, must be
     * a valid positive duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration maximum_staleness = 8;</code>
     */
    protected $maximum_staleness = null;
    /**
     * Required. Restricts the response to vehicles with one of the specified type
     * categories. `UNKNOWN` is not allowed.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.Vehicle.VehicleType.Category vehicle_type_categories = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $vehicle_type_categories;
    /**
     * Callers can form complex logical operations using any combination of the
     * `required_attributes`, `required_one_of_attributes`, and
     * `required_one_of_attribute_sets` fields.
     * `required_attributes` is a list; `required_one_of_attributes` uses a
     * message which allows a list of lists. In combination, the two fields allow
     * the composition of this expression:
     * ```
     * (required_attributes[0] AND required_attributes[1] AND ...)
     * AND
     * (required_one_of_attributes[0][0] OR required_one_of_attributes[0][1] OR
     * ...)
     * AND
     * (required_one_of_attributes[1][0] OR required_one_of_attributes[1][1] OR
     * ...)
     * ```
     * Restricts the response to vehicles with the specified attributes. This
     * field is a conjunction/AND operation. A max of 50 required_attributes is
     * allowed. This matches the maximum number of attributes allowed on a
     * vehicle. Each repeated string should be of the format "key:value".
     *
     * Generated from protobuf field <code>repeated string required_attributes = 10;</code>
     */
    private $required_attributes;
    /**
     * Restricts the response to vehicles with at least one of the specified
     * attributes in each `VehicleAttributeList`. Within each list, a vehicle must
     * match at least one of the attributes. This field is an inclusive
     * disjunction/OR operation in each `VehicleAttributeList` and a
     * conjunction/AND operation across the collection of `VehicleAttributeList`.
     * Each repeated string should be of the format
     * "key1:value1|key2:value2|key3:value3".
     *
     * Generated from protobuf field <code>repeated string required_one_of_attributes = 13;</code>
     */
    private $required_one_of_attributes;
    /**
     * `required_one_of_attribute_sets` provides additional functionality.
     * Similar to `required_one_of_attributes`, `required_one_of_attribute_sets`
     * uses a message which allows a list of lists, allowing expressions such as
     * this one:
     * ```
     * (required_attributes[0] AND required_attributes[1] AND ...)
     * AND
     * (
     *   (required_one_of_attribute_sets[0][0] AND
     *   required_one_of_attribute_sets[0][1] AND
     *   ...)
     *   OR
     *   (required_one_of_attribute_sets[1][0] AND
     *   required_one_of_attribute_sets[1][1] AND
     *   ...)
     * )
     * ```
     * Restricts the response to vehicles that match all the attributes in a
     * `VehicleAttributeList`. Within each list, a vehicle must match all of the
     * attributes. This field is a conjunction/AND operation in each
     * `VehicleAttributeList` and inclusive disjunction/OR operation across the
     * collection of `VehicleAttributeList`. Each repeated string should be of the
     * format "key1:value1|key2:value2|key3:value3".
     *
     * Generated from protobuf field <code>repeated string required_one_of_attribute_sets = 15;</code>
     */
    private $required_one_of_attribute_sets;
    /**
     * Restricts the response to vehicles that have this vehicle state.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleState vehicle_state = 11;</code>
     */
    protected $vehicle_state = 0;
    /**
     * Only return the vehicles with current trip(s).
     *
     * Generated from protobuf field <code>bool on_trip_only = 14;</code>
     */
    protected $on_trip_only = false;
    /**
     * Optional. A filter query to apply when listing vehicles. See
     * http://aip.dev/160 for examples of the filter syntax.
     * This field is designed to replace the `required_attributes`,
     * `required_one_of_attributes`, and `required_one_of_attributes_sets` fields.
     * If a non-empty value is specified here, the following fields must be empty:
     * `required_attributes`, `required_one_of_attributes`, and
     * `required_one_of_attributes_sets`.
     * This filter functions as an AND clause with other constraints,
     * such as `vehicle_state` or `on_trip_only`.
     * Note that the only queries supported are on vehicle attributes (for
     * example, `attributes.<key> = <value>` or `attributes.<key1> = <value1> AND
     * attributes.<key2> = <value2>`). The maximum number of restrictions allowed
     * in a filter query is 50.
     * Also, all attributes are stored as strings, so the only supported
     * comparisons against attributes are string comparisons. In order to compare
     * against number or boolean values, the values must be explicitly quoted to
     * be treated as strings (for example, `attributes.<key> = "10"` or
     * `attributes.<key> = "true"`).
     *
     * Generated from protobuf field <code>string filter = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $filter = '';
    /**
     * Optional. A filter that limits the vehicles returned to those whose last
     * known location was in the rectangular area defined by the viewport.
     *
     * Generated from protobuf field <code>.google.geo.type.Viewport viewport = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $viewport = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Maps\FleetEngine\V1\RequestHeader $header
     *           The standard Fleet Engine request header.
     *     @type string $parent
     *           Required. Must be in the format `providers/{provider}`.
     *           The provider must be the Project ID (for example, `sample-cloud-project`)
     *           of the Google Cloud Project of which the service account making
     *           this call is a member.
     *     @type int $page_size
     *           The maximum number of vehicles to return.
     *           Default value: 100.
     *     @type string $page_token
     *           The value of the `next_page_token` provided by a previous call to
     *           `ListVehicles` so that you can paginate through groups of vehicles. The
     *           value is undefined if the filter criteria of the request is not the same as
     *           the filter criteria for the previous call to `ListVehicles`.
     *     @type \Google\Protobuf\Int32Value $minimum_capacity
     *           Specifies the required minimum capacity of the vehicle. All vehicles
     *           returned will have a `maximum_capacity` greater than or equal to this
     *           value. If set, must be greater or equal to 0.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $trip_types
     *           Restricts the response to vehicles that support at least one of the
     *           specified trip types.
     *     @type \Google\Protobuf\Duration $maximum_staleness
     *           Restricts the response to vehicles that have sent location updates to Fleet
     *           Engine within the specified duration. Stationary vehicles still
     *           transmitting their locations are not considered stale. If present, must be
     *           a valid positive duration.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $vehicle_type_categories
     *           Required. Restricts the response to vehicles with one of the specified type
     *           categories. `UNKNOWN` is not allowed.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $required_attributes
     *           Callers can form complex logical operations using any combination of the
     *           `required_attributes`, `required_one_of_attributes`, and
     *           `required_one_of_attribute_sets` fields.
     *           `required_attributes` is a list; `required_one_of_attributes` uses a
     *           message which allows a list of lists. In combination, the two fields allow
     *           the composition of this expression:
     *           ```
     *           (required_attributes[0] AND required_attributes[1] AND ...)
     *           AND
     *           (required_one_of_attributes[0][0] OR required_one_of_attributes[0][1] OR
     *           ...)
     *           AND
     *           (required_one_of_attributes[1][0] OR required_one_of_attributes[1][1] OR
     *           ...)
     *           ```
     *           Restricts the response to vehicles with the specified attributes. This
     *           field is a conjunction/AND operation. A max of 50 required_attributes is
     *           allowed. This matches the maximum number of attributes allowed on a
     *           vehicle. Each repeated string should be of the format "key:value".
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $required_one_of_attributes
     *           Restricts the response to vehicles with at least one of the specified
     *           attributes in each `VehicleAttributeList`. Within each list, a vehicle must
     *           match at least one of the attributes. This field is an inclusive
     *           disjunction/OR operation in each `VehicleAttributeList` and a
     *           conjunction/AND operation across the collection of `VehicleAttributeList`.
     *           Each repeated string should be of the format
     *           "key1:value1|key2:value2|key3:value3".
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $required_one_of_attribute_sets
     *           `required_one_of_attribute_sets` provides additional functionality.
     *           Similar to `required_one_of_attributes`, `required_one_of_attribute_sets`
     *           uses a message which allows a list of lists, allowing expressions such as
     *           this one:
     *           ```
     *           (required_attributes[0] AND required_attributes[1] AND ...)
     *           AND
     *           (
     *             (required_one_of_attribute_sets[0][0] AND
     *             required_one_of_attribute_sets[0][1] AND
     *             ...)
     *             OR
     *             (required_one_of_attribute_sets[1][0] AND
     *             required_one_of_attribute_sets[1][1] AND
     *             ...)
     *           )
     *           ```
     *           Restricts the response to vehicles that match all the attributes in a
     *           `VehicleAttributeList`. Within each list, a vehicle must match all of the
     *           attributes. This field is a conjunction/AND operation in each
     *           `VehicleAttributeList` and inclusive disjunction/OR operation across the
     *           collection of `VehicleAttributeList`. Each repeated string should be of the
     *           format "key1:value1|key2:value2|key3:value3".
     *     @type int $vehicle_state
     *           Restricts the response to vehicles that have this vehicle state.
     *     @type bool $on_trip_only
     *           Only return the vehicles with current trip(s).
     *     @type string $filter
     *           Optional. A filter query to apply when listing vehicles. See
     *           http://aip.dev/160 for examples of the filter syntax.
     *           This field is designed to replace the `required_attributes`,
     *           `required_one_of_attributes`, and `required_one_of_attributes_sets` fields.
     *           If a non-empty value is specified here, the following fields must be empty:
     *           `required_attributes`, `required_one_of_attributes`, and
     *           `required_one_of_attributes_sets`.
     *           This filter functions as an AND clause with other constraints,
     *           such as `vehicle_state` or `on_trip_only`.
     *           Note that the only queries supported are on vehicle attributes (for
     *           example, `attributes.<key> = <value>` or `attributes.<key1> = <value1> AND
     *           attributes.<key2> = <value2>`). The maximum number of restrictions allowed
     *           in a filter query is 50.
     *           Also, all attributes are stored as strings, so the only supported
     *           comparisons against attributes are string comparisons. In order to compare
     *           against number or boolean values, the values must be explicitly quoted to
     *           be treated as strings (for example, `attributes.<key> = "10"` or
     *           `attributes.<key> = "true"`).
     *     @type \Google\Geo\Type\Viewport $viewport
     *           Optional. A filter that limits the vehicles returned to those whose last
     *           known location was in the rectangular area defined by the viewport.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Fleetengine\V1\VehicleApi::initOnce();
        parent::__construct($data);
    }

    /**
     * The standard Fleet Engine request header.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.RequestHeader header = 12;</code>
     * @return \Google\Maps\FleetEngine\V1\RequestHeader|null
     */
    public function getHeader()
    {
        return $this->header;
    }

    public function hasHeader()
    {
        return isset($this->header);
    }

    public function clearHeader()
    {
        unset($this->header);
    }

    /**
     * The standard Fleet Engine request header.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.RequestHeader header = 12;</code>
     * @param \Google\Maps\FleetEngine\V1\RequestHeader $var
     * @return $this
     */
    public function setHeader($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\RequestHeader::class);
        $this->header = $var;

        return $this;
    }

    /**
     * Required. Must be in the format `providers/{provider}`.
     * The provider must be the Project ID (for example, `sample-cloud-project`)
     * of the Google Cloud Project of which the service account making
     * this call is a member.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. Must be in the format `providers/{provider}`.
     * The provider must be the Project ID (for example, `sample-cloud-project`)
     * of the Google Cloud Project of which the service account making
     * this call is a member.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The maximum number of vehicles to return.
     * Default value: 100.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of vehicles to return.
     * Default value: 100.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * The value of the `next_page_token` provided by a previous call to
     * `ListVehicles` so that you can paginate through groups of vehicles. The
     * value is undefined if the filter criteria of the request is not the same as
     * the filter criteria for the previous call to `ListVehicles`.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The value of the `next_page_token` provided by a previous call to
     * `ListVehicles` so that you can paginate through groups of vehicles. The
     * value is undefined if the filter criteria of the request is not the same as
     * the filter criteria for the previous call to `ListVehicles`.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Specifies the required minimum capacity of the vehicle. All vehicles
     * returned will have a `maximum_capacity` greater than or equal to this
     * value. If set, must be greater or equal to 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value minimum_capacity = 6;</code>
     * @return \Google\Protobuf\Int32Value|null
     */
    public function getMinimumCapacity()
    {
        return $this->minimum_capacity;
    }

    public function hasMinimumCapacity()
    {
        return isset($this->minimum_capacity);
    }

    public function clearMinimumCapacity()
    {
        unset($this->minimum_capacity);
    }

    /**
     * Returns the unboxed value from <code>getMinimumCapacity()</code>

     * Specifies the required minimum capacity of the vehicle. All vehicles
     * returned will have a `maximum_capacity` greater than or equal to this
     * value. If set, must be greater or equal to 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value minimum_capacity = 6;</code>
     * @return int|null
     */
    public function getMinimumCapacityUnwrapped()
    {
        return $this->readWrapperValue("minimum_capacity");
    }

    /**
     * Specifies the required minimum capacity of the vehicle. All vehicles
     * returned will have a `maximum_capacity` greater than or equal to this
     * value. If set, must be greater or equal to 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value minimum_capacity = 6;</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setMinimumCapacity($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->minimum_capacity = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Specifies the required minimum capacity of the vehicle. All vehicles
     * returned will have a `maximum_capacity` greater than or equal to this
     * value. If set, must be greater or equal to 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value minimum_capacity = 6;</code>
     * @param int|null $var
     * @return $this
     */
    public function setMinimumCapacityUnwrapped($var)
    {
        $this->writeWrapperValue("minimum_capacity", $var);
        return $this;}

    /**
     * Restricts the response to vehicles that support at least one of the
     * specified trip types.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripType trip_types = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTripTypes()
    {
        return $this->trip_types;
    }

    /**
     * Restricts the response to vehicles that support at least one of the
     * specified trip types.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripType trip_types = 7;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTripTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Maps\FleetEngine\V1\TripType::class);
        $this->trip_types = $arr;

        return $this;
    }

    /**
     * Restricts the response to vehicles that have sent location updates to Fleet
     * Engine within the specified duration. Stationary vehicles still
     * transmitting their locations are not considered stale. If present, must be
     * a valid positive duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration maximum_staleness = 8;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMaximumStaleness()
    {
        return $this->maximum_staleness;
    }

    public function hasMaximumStaleness()
    {
        return isset($this->maximum_staleness);
    }

    public function clearMaximumStaleness()
    {
        unset($this->maximum_staleness);
    }

    /**
     * Restricts the response to vehicles that have sent location updates to Fleet
     * Engine within the specified duration. Stationary vehicles still
     * transmitting their locations are not considered stale. If present, must be
     * a valid positive duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration maximum_staleness = 8;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaximumStaleness($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->maximum_staleness = $var;

        return $this;
    }

    /**
     * Required. Restricts the response to vehicles with one of the specified type
     * categories. `UNKNOWN` is not allowed.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.Vehicle.VehicleType.Category vehicle_type_categories = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVehicleTypeCategories()
    {
        return $this->vehicle_type_categories;
    }

    /**
     * Required. Restricts the response to vehicles with one of the specified type
     * categories. `UNKNOWN` is not allowed.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.Vehicle.VehicleType.Category vehicle_type_categories = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVehicleTypeCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Maps\FleetEngine\V1\Vehicle\VehicleType\Category::class);
        $this->vehicle_type_categories = $arr;

        return $this;
    }

    /**
     * Callers can form complex logical operations using any combination of the
     * `required_attributes`, `required_one_of_attributes`, and
     * `required_one_of_attribute_sets` fields.
     * `required_attributes` is a list; `required_one_of_attributes` uses a
     * message which allows a list of lists. In combination, the two fields allow
     * the composition of this expression:
     * ```
     * (required_attributes[0] AND required_attributes[1] AND ...)
     * AND
     * (required_one_of_attributes[0][0] OR required_one_of_attributes[0][1] OR
     * ...)
     * AND
     * (required_one_of_attributes[1][0] OR required_one_of_attributes[1][1] OR
     * ...)
     * ```
     * Restricts the response to vehicles with the specified attributes. This
     * field is a conjunction/AND operation. A max of 50 required_attributes is
     * allowed. This matches the maximum number of attributes allowed on a
     * vehicle. Each repeated string should be of the format "key:value".
     *
     * Generated from protobuf field <code>repeated string required_attributes = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequiredAttributes()
    {
        return $this->required_attributes;
    }

    /**
     * Callers can form complex logical operations using any combination of the
     * `required_attributes`, `required_one_of_attributes`, and
     * `required_one_of_attribute_sets` fields.
     * `required_attributes` is a list; `required_one_of_attributes` uses a
     * message which allows a list of lists. In combination, the two fields allow
     * the composition of this expression:
     * ```
     * (required_attributes[0] AND required_attributes[1] AND ...)
     * AND
     * (required_one_of_attributes[0][0] OR required_one_of_attributes[0][1] OR
     * ...)
     * AND
     * (required_one_of_attributes[1][0] OR required_one_of_attributes[1][1] OR
     * ...)
     * ```
     * Restricts the response to vehicles with the specified attributes. This
     * field is a conjunction/AND operation. A max of 50 required_attributes is
     * allowed. This matches the maximum number of attributes allowed on a
     * vehicle. Each repeated string should be of the format "key:value".
     *
     * Generated from protobuf field <code>repeated string required_attributes = 10;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequiredAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->required_attributes = $arr;

        return $this;
    }

    /**
     * Restricts the response to vehicles with at least one of the specified
     * attributes in each `VehicleAttributeList`. Within each list, a vehicle must
     * match at least one of the attributes. This field is an inclusive
     * disjunction/OR operation in each `VehicleAttributeList` and a
     * conjunction/AND operation across the collection of `VehicleAttributeList`.
     * Each repeated string should be of the format
     * "key1:value1|key2:value2|key3:value3".
     *
     * Generated from protobuf field <code>repeated string required_one_of_attributes = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequiredOneOfAttributes()
    {
        return $this->required_one_of_attributes;
    }

    /**
     * Restricts the response to vehicles with at least one of the specified
     * attributes in each `VehicleAttributeList`. Within each list, a vehicle must
     * match at least one of the attributes. This field is an inclusive
     * disjunction/OR operation in each `VehicleAttributeList` and a
     * conjunction/AND operation across the collection of `VehicleAttributeList`.
     * Each repeated string should be of the format
     * "key1:value1|key2:value2|key3:value3".
     *
     * Generated from protobuf field <code>repeated string required_one_of_attributes = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequiredOneOfAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->required_one_of_attributes = $arr;

        return $this;
    }

    /**
     * `required_one_of_attribute_sets` provides additional functionality.
     * Similar to `required_one_of_attributes`, `required_one_of_attribute_sets`
     * uses a message which allows a list of lists, allowing expressions such as
     * this one:
     * ```
     * (required_attributes[0] AND required_attributes[1] AND ...)
     * AND
     * (
     *   (required_one_of_attribute_sets[0][0] AND
     *   required_one_of_attribute_sets[0][1] AND
     *   ...)
     *   OR
     *   (required_one_of_attribute_sets[1][0] AND
     *   required_one_of_attribute_sets[1][1] AND
     *   ...)
     * )
     * ```
     * Restricts the response to vehicles that match all the attributes in a
     * `VehicleAttributeList`. Within each list, a vehicle must match all of the
     * attributes. This field is a conjunction/AND operation in each
     * `VehicleAttributeList` and inclusive disjunction/OR operation across the
     * collection of `VehicleAttributeList`. Each repeated string should be of the
     * format "key1:value1|key2:value2|key3:value3".
     *
     * Generated from protobuf field <code>repeated string required_one_of_attribute_sets = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequiredOneOfAttributeSets()
    {
        return $this->required_one_of_attribute_sets;
    }

    /**
     * `required_one_of_attribute_sets` provides additional functionality.
     * Similar to `required_one_of_attributes`, `required_one_of_attribute_sets`
     * uses a message which allows a list of lists, allowing expressions such as
     * this one:
     * ```
     * (required_attributes[0] AND required_attributes[1] AND ...)
     * AND
     * (
     *   (required_one_of_attribute_sets[0][0] AND
     *   required_one_of_attribute_sets[0][1] AND
     *   ...)
     *   OR
     *   (required_one_of_attribute_sets[1][0] AND
     *   required_one_of_attribute_sets[1][1] AND
     *   ...)
     * )
     * ```
     * Restricts the response to vehicles that match all the attributes in a
     * `VehicleAttributeList`. Within each list, a vehicle must match all of the
     * attributes. This field is a conjunction/AND operation in each
     * `VehicleAttributeList` and inclusive disjunction/OR operation across the
     * collection of `VehicleAttributeList`. Each repeated string should be of the
     * format "key1:value1|key2:value2|key3:value3".
     *
     * Generated from protobuf field <code>repeated string required_one_of_attribute_sets = 15;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequiredOneOfAttributeSets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->required_one_of_attribute_sets = $arr;

        return $this;
    }

    /**
     * Restricts the response to vehicles that have this vehicle state.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleState vehicle_state = 11;</code>
     * @return int
     */
    public function getVehicleState()
    {
        return $this->vehicle_state;
    }

    /**
     * Restricts the response to vehicles that have this vehicle state.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleState vehicle_state = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setVehicleState($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\V1\VehicleState::class);
        $this->vehicle_state = $var;

        return $this;
    }

    /**
     * Only return the vehicles with current trip(s).
     *
     * Generated from protobuf field <code>bool on_trip_only = 14;</code>
     * @return bool
     */
    public function getOnTripOnly()
    {
        return $this->on_trip_only;
    }

    /**
     * Only return the vehicles with current trip(s).
     *
     * Generated from protobuf field <code>bool on_trip_only = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setOnTripOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->on_trip_only = $var;

        return $this;
    }

    /**
     * Optional. A filter query to apply when listing vehicles. See
     * http://aip.dev/160 for examples of the filter syntax.
     * This field is designed to replace the `required_attributes`,
     * `required_one_of_attributes`, and `required_one_of_attributes_sets` fields.
     * If a non-empty value is specified here, the following fields must be empty:
     * `required_attributes`, `required_one_of_attributes`, and
     * `required_one_of_attributes_sets`.
     * This filter functions as an AND clause with other constraints,
     * such as `vehicle_state` or `on_trip_only`.
     * Note that the only queries supported are on vehicle attributes (for
     * example, `attributes.<key> = <value>` or `attributes.<key1> = <value1> AND
     * attributes.<key2> = <value2>`). The maximum number of restrictions allowed
     * in a filter query is 50.
     * Also, all attributes are stored as strings, so the only supported
     * comparisons against attributes are string comparisons. In order to compare
     * against number or boolean values, the values must be explicitly quoted to
     * be treated as strings (for example, `attributes.<key> = "10"` or
     * `attributes.<key> = "true"`).
     *
     * Generated from protobuf field <code>string filter = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Optional. A filter query to apply when listing vehicles. See
     * http://aip.dev/160 for examples of the filter syntax.
     * This field is designed to replace the `required_attributes`,
     * `required_one_of_attributes`, and `required_one_of_attributes_sets` fields.
     * If a non-empty value is specified here, the following fields must be empty:
     * `required_attributes`, `required_one_of_attributes`, and
     * `required_one_of_attributes_sets`.
     * This filter functions as an AND clause with other constraints,
     * such as `vehicle_state` or `on_trip_only`.
     * Note that the only queries supported are on vehicle attributes (for
     * example, `attributes.<key> = <value>` or `attributes.<key1> = <value1> AND
     * attributes.<key2> = <value2>`). The maximum number of restrictions allowed
     * in a filter query is 50.
     * Also, all attributes are stored as strings, so the only supported
     * comparisons against attributes are string comparisons. In order to compare
     * against number or boolean values, the values must be explicitly quoted to
     * be treated as strings (for example, `attributes.<key> = "10"` or
     * `attributes.<key> = "true"`).
     *
     * Generated from protobuf field <code>string filter = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Optional. A filter that limits the vehicles returned to those whose last
     * known location was in the rectangular area defined by the viewport.
     *
     * Generated from protobuf field <code>.google.geo.type.Viewport viewport = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Geo\Type\Viewport|null
     */
    public function getViewport()
    {
        return $this->viewport;
    }

    public function hasViewport()
    {
        return isset($this->viewport);
    }

    public function clearViewport()
    {
        unset($this->viewport);
    }

    /**
     * Optional. A filter that limits the vehicles returned to those whose last
     * known location was in the rectangular area defined by the viewport.
     *
     * Generated from protobuf field <code>.google.geo.type.Viewport viewport = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Geo\Type\Viewport $var
     * @return $this
     */
    public function setViewport($var)
    {
        GPBUtil::checkMessage($var, \Google\Geo\Type\Viewport::class);
        $this->viewport = $var;

        return $this;
    }

}

