<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/schemaregistry/v1/schema_registry.proto

namespace Google\Cloud\ManagedKafka\SchemaRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for LookupVersion.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.schemaregistry.v1.LookupVersionRequest</code>
 */
class LookupVersionRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The subject to lookup the schema in. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The schema type of the schema.
     *
     * Generated from protobuf field <code>optional .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaType schema_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $schema_type = null;
    /**
     * Required. The schema payload
     *
     * Generated from protobuf field <code>string schema = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $schema = '';
    /**
     * Optional. The schema references used by the schema.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaReference references = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $references;
    /**
     * Optional. If true, the schema will be normalized before being looked up.
     * The default is false.
     *
     * Generated from protobuf field <code>optional bool normalize = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $normalize = null;
    /**
     * Optional. If true, soft-deleted versions will be included in lookup, no
     * matter if the subject is active or soft-deleted. If false, soft-deleted
     * versions will be excluded. The default is false.
     *
     * Generated from protobuf field <code>optional bool deleted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $deleted = null;

    /**
     * @param string $parent Required. The subject to lookup the schema in. Structured like:
     *                       `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     *                       or
     *                       `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *                       Please see {@see ManagedSchemaRegistryClient::schemaSubjectName()} for help formatting this field.
     * @param string $schema Required. The schema payload
     *
     * @return \Google\Cloud\ManagedKafka\SchemaRegistry\V1\LookupVersionRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $schema): self
    {
        return (new self())
            ->setParent($parent)
            ->setSchema($schema);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The subject to lookup the schema in. Structured like:
     *           `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     *           or
     *           `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *     @type int $schema_type
     *           Optional. The schema type of the schema.
     *     @type string $schema
     *           Required. The schema payload
     *     @type array<\Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference>|\Google\Protobuf\Internal\RepeatedField $references
     *           Optional. The schema references used by the schema.
     *     @type bool $normalize
     *           Optional. If true, the schema will be normalized before being looked up.
     *           The default is false.
     *     @type bool $deleted
     *           Optional. If true, soft-deleted versions will be included in lookup, no
     *           matter if the subject is active or soft-deleted. If false, soft-deleted
     *           versions will be excluded. The default is false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\Schemaregistry\V1\SchemaRegistry::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The subject to lookup the schema in. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The subject to lookup the schema in. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The schema type of the schema.
     *
     * Generated from protobuf field <code>optional .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaType schema_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getSchemaType()
    {
        return isset($this->schema_type) ? $this->schema_type : 0;
    }

    public function hasSchemaType()
    {
        return isset($this->schema_type);
    }

    public function clearSchemaType()
    {
        unset($this->schema_type);
    }

    /**
     * Optional. The schema type of the schema.
     *
     * Generated from protobuf field <code>optional .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaType schema_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setSchemaType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaType::class);
        $this->schema_type = $var;

        return $this;
    }

    /**
     * Required. The schema payload
     *
     * Generated from protobuf field <code>string schema = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSchema()
    {
        return $this->schema;
    }

    /**
     * Required. The schema payload
     *
     * Generated from protobuf field <code>string schema = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSchema($var)
    {
        GPBUtil::checkString($var, True);
        $this->schema = $var;

        return $this;
    }

    /**
     * Optional. The schema references used by the schema.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaReference references = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferences()
    {
        return $this->references;
    }

    /**
     * Optional. The schema references used by the schema.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaReference references = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference::class);
        $this->references = $arr;

        return $this;
    }

    /**
     * Optional. If true, the schema will be normalized before being looked up.
     * The default is false.
     *
     * Generated from protobuf field <code>optional bool normalize = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getNormalize()
    {
        return isset($this->normalize) ? $this->normalize : false;
    }

    public function hasNormalize()
    {
        return isset($this->normalize);
    }

    public function clearNormalize()
    {
        unset($this->normalize);
    }

    /**
     * Optional. If true, the schema will be normalized before being looked up.
     * The default is false.
     *
     * Generated from protobuf field <code>optional bool normalize = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setNormalize($var)
    {
        GPBUtil::checkBool($var);
        $this->normalize = $var;

        return $this;
    }

    /**
     * Optional. If true, soft-deleted versions will be included in lookup, no
     * matter if the subject is active or soft-deleted. If false, soft-deleted
     * versions will be excluded. The default is false.
     *
     * Generated from protobuf field <code>optional bool deleted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDeleted()
    {
        return isset($this->deleted) ? $this->deleted : false;
    }

    public function hasDeleted()
    {
        return isset($this->deleted);
    }

    public function clearDeleted()
    {
        unset($this->deleted);
    }

    /**
     * Optional. If true, soft-deleted versions will be included in lookup, no
     * matter if the subject is active or soft-deleted. If false, soft-deleted
     * versions will be excluded. The default is false.
     *
     * Generated from protobuf field <code>optional bool deleted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDeleted($var)
    {
        GPBUtil::checkBool($var);
        $this->deleted = $var;

        return $this;
    }

}

