<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/schemaregistry/v1/schema_registry.proto

namespace Google\Cloud\ManagedKafka\SchemaRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for CreateVersion.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.schemaregistry.v1.CreateVersionRequest</code>
 */
class CreateVersionRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The subject to create the version for. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The version to create. It is optional. If not specified, the
     * version will be created with the max version ID of the subject increased
     * by 1. If the version ID is specified, it will be used as the new version ID
     * and must not be used by an existing version of the subject.
     *
     * Generated from protobuf field <code>optional int32 version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $version = null;
    /**
     * Optional. The schema ID of the schema. If not specified, the schema ID will
     * be generated by the server. If the schema ID is specified, it must not be
     * used by an existing schema that is different from the schema to be created.
     *
     * Generated from protobuf field <code>optional int32 id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $id = null;
    /**
     * Optional. The type of the schema. It is optional. If not specified, the
     * schema type will be AVRO.
     *
     * Generated from protobuf field <code>optional .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaType schema_type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $schema_type = null;
    /**
     * Required. The schema payload
     *
     * Generated from protobuf field <code>string schema = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $schema = '';
    /**
     * Optional. The schema references used by the schema.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaReference references = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $references;
    /**
     * Optional. If true, the schema will be normalized before being stored. The
     * default is false.
     *
     * Generated from protobuf field <code>optional bool normalize = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $normalize = null;

    /**
     * @param string                                                                $parent     Required. The subject to create the version for. Structured like:
     *                                                                                          `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     *                                                                                          or
     *                                                                                          `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *                                                                                          Please see {@see ManagedSchemaRegistryClient::schemaSubjectName()} for help formatting this field.
     * @param int                                                                   $version    Optional. The version to create. It is optional. If not specified, the
     *                                                                                          version will be created with the max version ID of the subject increased
     *                                                                                          by 1. If the version ID is specified, it will be used as the new version ID
     *                                                                                          and must not be used by an existing version of the subject.
     * @param int                                                                   $id         Optional. The schema ID of the schema. If not specified, the schema ID will
     *                                                                                          be generated by the server. If the schema ID is specified, it must not be
     *                                                                                          used by an existing schema that is different from the schema to be created.
     * @param int                                                                   $schemaType Optional. The type of the schema. It is optional. If not specified, the
     *                                                                                          schema type will be AVRO.
     *                                                                                          For allowed values, use constants defined on {@see \Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaType}
     * @param string                                                                $schema     Required. The schema payload
     * @param \Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference[] $references Optional. The schema references used by the schema.
     * @param bool                                                                  $normalize  Optional. If true, the schema will be normalized before being stored. The
     *                                                                                          default is false.
     *
     * @return \Google\Cloud\ManagedKafka\SchemaRegistry\V1\CreateVersionRequest
     *
     * @experimental
     */
    public static function build(string $parent, int $version, int $id, int $schemaType, string $schema, array $references, bool $normalize): self
    {
        return (new self())
            ->setParent($parent)
            ->setVersion($version)
            ->setId($id)
            ->setSchemaType($schemaType)
            ->setSchema($schema)
            ->setReferences($references)
            ->setNormalize($normalize);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The subject to create the version for. Structured like:
     *           `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     *           or
     *           `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *     @type int $version
     *           Optional. The version to create. It is optional. If not specified, the
     *           version will be created with the max version ID of the subject increased
     *           by 1. If the version ID is specified, it will be used as the new version ID
     *           and must not be used by an existing version of the subject.
     *     @type int $id
     *           Optional. The schema ID of the schema. If not specified, the schema ID will
     *           be generated by the server. If the schema ID is specified, it must not be
     *           used by an existing schema that is different from the schema to be created.
     *     @type int $schema_type
     *           Optional. The type of the schema. It is optional. If not specified, the
     *           schema type will be AVRO.
     *     @type string $schema
     *           Required. The schema payload
     *     @type array<\Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference>|\Google\Protobuf\Internal\RepeatedField $references
     *           Optional. The schema references used by the schema.
     *     @type bool $normalize
     *           Optional. If true, the schema will be normalized before being stored. The
     *           default is false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\Schemaregistry\V1\SchemaRegistry::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The subject to create the version for. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The subject to create the version for. Structured like:
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
     * or
     * `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The version to create. It is optional. If not specified, the
     * version will be created with the max version ID of the subject increased
     * by 1. If the version ID is specified, it will be used as the new version ID
     * and must not be used by an existing version of the subject.
     *
     * Generated from protobuf field <code>optional int32 version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getVersion()
    {
        return isset($this->version) ? $this->version : 0;
    }

    public function hasVersion()
    {
        return isset($this->version);
    }

    public function clearVersion()
    {
        unset($this->version);
    }

    /**
     * Optional. The version to create. It is optional. If not specified, the
     * version will be created with the max version ID of the subject increased
     * by 1. If the version ID is specified, it will be used as the new version ID
     * and must not be used by an existing version of the subject.
     *
     * Generated from protobuf field <code>optional int32 version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkInt32($var);
        $this->version = $var;

        return $this;
    }

    /**
     * Optional. The schema ID of the schema. If not specified, the schema ID will
     * be generated by the server. If the schema ID is specified, it must not be
     * used by an existing schema that is different from the schema to be created.
     *
     * Generated from protobuf field <code>optional int32 id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * Optional. The schema ID of the schema. If not specified, the schema ID will
     * be generated by the server. If the schema ID is specified, it must not be
     * used by an existing schema that is different from the schema to be created.
     *
     * Generated from protobuf field <code>optional int32 id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkInt32($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Optional. The type of the schema. It is optional. If not specified, the
     * schema type will be AVRO.
     *
     * Generated from protobuf field <code>optional .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaType schema_type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getSchemaType()
    {
        return isset($this->schema_type) ? $this->schema_type : 0;
    }

    public function hasSchemaType()
    {
        return isset($this->schema_type);
    }

    public function clearSchemaType()
    {
        unset($this->schema_type);
    }

    /**
     * Optional. The type of the schema. It is optional. If not specified, the
     * schema type will be AVRO.
     *
     * Generated from protobuf field <code>optional .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaType schema_type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setSchemaType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaType::class);
        $this->schema_type = $var;

        return $this;
    }

    /**
     * Required. The schema payload
     *
     * Generated from protobuf field <code>string schema = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSchema()
    {
        return $this->schema;
    }

    /**
     * Required. The schema payload
     *
     * Generated from protobuf field <code>string schema = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSchema($var)
    {
        GPBUtil::checkString($var, True);
        $this->schema = $var;

        return $this;
    }

    /**
     * Optional. The schema references used by the schema.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaReference references = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferences()
    {
        return $this->references;
    }

    /**
     * Optional. The schema references used by the schema.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.schemaregistry.v1.Schema.SchemaReference references = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema\SchemaReference::class);
        $this->references = $arr;

        return $this;
    }

    /**
     * Optional. If true, the schema will be normalized before being stored. The
     * default is false.
     *
     * Generated from protobuf field <code>optional bool normalize = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getNormalize()
    {
        return isset($this->normalize) ? $this->normalize : false;
    }

    public function hasNormalize()
    {
        return isset($this->normalize);
    }

    public function clearNormalize()
    {
        unset($this->normalize);
    }

    /**
     * Optional. If true, the schema will be normalized before being stored. The
     * default is false.
     *
     * Generated from protobuf field <code>optional bool normalize = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setNormalize($var)
    {
        GPBUtil::checkBool($var);
        $this->normalize = $var;

        return $this;
    }

}

