<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/iam/v3/policy_bindings_service.proto

namespace Google\Cloud\Iam\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for CreatePolicyBinding method.
 *
 * Generated from protobuf message <code>google.iam.v3.CreatePolicyBindingRequest</code>
 */
class CreatePolicyBindingRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource where this policy binding will be created.
     * The binding parent is the closest Resource Manager resource (project,
     * folder or organization) to the binding target.
     * Format:
     * * `projects/{project_id}/locations/{location}`
     * * `projects/{project_number}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `organizations/{organization_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The ID to use for the policy binding, which will become the final
     * component of the policy binding's resource name.
     * This value must start with a lowercase letter followed by up to 62
     * lowercase letters, numbers, hyphens, or dots. Pattern,
     * /[a-z][a-z0-9-\.]{2,62}/.
     *
     * Generated from protobuf field <code>string policy_binding_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $policy_binding_id = '';
    /**
     * Required. The policy binding to create.
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding policy_binding = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $policy_binding = null;
    /**
     * Optional. If set, validate the request and preview the creation, but do not
     * actually post it.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $validate_only = false;

    /**
     * @param string                             $parent          Required. The parent resource where this policy binding will be created.
     *                                                            The binding parent is the closest Resource Manager resource (project,
     *                                                            folder or organization) to the binding target.
     *
     *                                                            Format:
     *
     *                                                            * `projects/{project_id}/locations/{location}`
     *                                                            * `projects/{project_number}/locations/{location}`
     *                                                            * `folders/{folder_id}/locations/{location}`
     *                                                            * `organizations/{organization_id}/locations/{location}`
     *                                                            Please see {@see PolicyBindingsClient::organizationLocationName()} for help formatting this field.
     * @param \Google\Cloud\Iam\V3\PolicyBinding $policyBinding   Required. The policy binding to create.
     * @param string                             $policyBindingId Required. The ID to use for the policy binding, which will become the final
     *                                                            component of the policy binding's resource name.
     *
     *                                                            This value must start with a lowercase letter followed by up to 62
     *                                                            lowercase letters, numbers, hyphens, or dots. Pattern,
     *                                                            /[a-z][a-z0-9-\.]{2,62}/.
     *
     * @return \Google\Cloud\Iam\V3\CreatePolicyBindingRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Iam\V3\PolicyBinding $policyBinding, string $policyBindingId): self
    {
        return (new self())
            ->setParent($parent)
            ->setPolicyBinding($policyBinding)
            ->setPolicyBindingId($policyBindingId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource where this policy binding will be created.
     *           The binding parent is the closest Resource Manager resource (project,
     *           folder or organization) to the binding target.
     *           Format:
     *           * `projects/{project_id}/locations/{location}`
     *           * `projects/{project_number}/locations/{location}`
     *           * `folders/{folder_id}/locations/{location}`
     *           * `organizations/{organization_id}/locations/{location}`
     *     @type string $policy_binding_id
     *           Required. The ID to use for the policy binding, which will become the final
     *           component of the policy binding's resource name.
     *           This value must start with a lowercase letter followed by up to 62
     *           lowercase letters, numbers, hyphens, or dots. Pattern,
     *           /[a-z][a-z0-9-\.]{2,62}/.
     *     @type \Google\Cloud\Iam\V3\PolicyBinding $policy_binding
     *           Required. The policy binding to create.
     *     @type bool $validate_only
     *           Optional. If set, validate the request and preview the creation, but do not
     *           actually post it.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Iam\V3\PolicyBindingsService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource where this policy binding will be created.
     * The binding parent is the closest Resource Manager resource (project,
     * folder or organization) to the binding target.
     * Format:
     * * `projects/{project_id}/locations/{location}`
     * * `projects/{project_number}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `organizations/{organization_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource where this policy binding will be created.
     * The binding parent is the closest Resource Manager resource (project,
     * folder or organization) to the binding target.
     * Format:
     * * `projects/{project_id}/locations/{location}`
     * * `projects/{project_number}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `organizations/{organization_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The ID to use for the policy binding, which will become the final
     * component of the policy binding's resource name.
     * This value must start with a lowercase letter followed by up to 62
     * lowercase letters, numbers, hyphens, or dots. Pattern,
     * /[a-z][a-z0-9-\.]{2,62}/.
     *
     * Generated from protobuf field <code>string policy_binding_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPolicyBindingId()
    {
        return $this->policy_binding_id;
    }

    /**
     * Required. The ID to use for the policy binding, which will become the final
     * component of the policy binding's resource name.
     * This value must start with a lowercase letter followed by up to 62
     * lowercase letters, numbers, hyphens, or dots. Pattern,
     * /[a-z][a-z0-9-\.]{2,62}/.
     *
     * Generated from protobuf field <code>string policy_binding_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPolicyBindingId($var)
    {
        GPBUtil::checkString($var, True);
        $this->policy_binding_id = $var;

        return $this;
    }

    /**
     * Required. The policy binding to create.
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding policy_binding = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Iam\V3\PolicyBinding|null
     */
    public function getPolicyBinding()
    {
        return $this->policy_binding;
    }

    public function hasPolicyBinding()
    {
        return isset($this->policy_binding);
    }

    public function clearPolicyBinding()
    {
        unset($this->policy_binding);
    }

    /**
     * Required. The policy binding to create.
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding policy_binding = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Iam\V3\PolicyBinding $var
     * @return $this
     */
    public function setPolicyBinding($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iam\V3\PolicyBinding::class);
        $this->policy_binding = $var;

        return $this;
    }

    /**
     * Optional. If set, validate the request and preview the creation, but do not
     * actually post it.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. If set, validate the request and preview the creation, but do not
     * actually post it.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

}

