<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/storage.proto

namespace Google\Cloud\Dlp\V2;

use UnexpectedValueException;

/**
 * Coarse-grained confidence level of how well a particular finding
 * satisfies the criteria to match a particular infoType.
 * Likelihood is calculated based on the number of signals a
 * finding has that implies that the finding matches the infoType. For
 * example, a string that has an '&#64;' and a '.com' is more likely to be a
 * match for an email address than a string that only has an '&#64;'.
 * In general, the highest likelihood level has the strongest signals that
 * indicate a match. That is, a finding with a high likelihood has a low chance
 * of being a false positive.
 * For more information about each likelihood level
 * and how likelihood works, see [Match
 * likelihood](https://cloud.google.com/sensitive-data-protection/docs/likelihood).
 *
 * Protobuf type <code>google.privacy.dlp.v2.Likelihood</code>
 */
class Likelihood
{
    /**
     * Default value; same as POSSIBLE.
     *
     * Generated from protobuf enum <code>LIKELIHOOD_UNSPECIFIED = 0;</code>
     */
    const LIKELIHOOD_UNSPECIFIED = 0;
    /**
     * Highest chance of a false positive.
     *
     * Generated from protobuf enum <code>VERY_UNLIKELY = 1;</code>
     */
    const VERY_UNLIKELY = 1;
    /**
     * High chance of a false positive.
     *
     * Generated from protobuf enum <code>UNLIKELY = 2;</code>
     */
    const UNLIKELY = 2;
    /**
     * Some matching signals. The default value.
     *
     * Generated from protobuf enum <code>POSSIBLE = 3;</code>
     */
    const POSSIBLE = 3;
    /**
     * Low chance of a false positive.
     *
     * Generated from protobuf enum <code>LIKELY = 4;</code>
     */
    const LIKELY = 4;
    /**
     * Confidence level is high. Lowest chance of a false positive.
     *
     * Generated from protobuf enum <code>VERY_LIKELY = 5;</code>
     */
    const VERY_LIKELY = 5;

    private static $valueToName = [
        self::LIKELIHOOD_UNSPECIFIED => 'LIKELIHOOD_UNSPECIFIED',
        self::VERY_UNLIKELY => 'VERY_UNLIKELY',
        self::UNLIKELY => 'UNLIKELY',
        self::POSSIBLE => 'POSSIBLE',
        self::LIKELY => 'LIKELY',
        self::VERY_LIKELY => 'VERY_LIKELY',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

