<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/context.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Dialogflow contexts are similar to natural language context. If a person says
 * to you "they are orange", you need context in order to understand what "they"
 * is referring to. Similarly, for Dialogflow to handle an end-user expression
 * like that, it needs to be provided with context in order to correctly match
 * an intent.
 * Using contexts, you can control the flow of a conversation. You can configure
 * contexts for an intent by setting input and output contexts, which are
 * identified by string names. When an intent is matched, any configured output
 * contexts for that intent become active. While any contexts are active,
 * Dialogflow is more likely to match intents that are configured with input
 * contexts that correspond to the currently active contexts.
 * For more information about context, see the
 * [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.Context</code>
 */
class Context extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique identifier of the context. Format:
     * `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`,
     * or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
     * ID>/sessions/<Session ID>/contexts/<Context ID>`.
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in `a-zA-Z0-9_-%` and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Optional. The number of conversational query requests after which the
     * context expires. The default is `0`. If set to `0`, the context expires
     * immediately. Contexts expire automatically after 20 minutes if there
     * are no matching queries.
     *
     * Generated from protobuf field <code>int32 lifespan_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $lifespan_count = 0;
    /**
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $parameters = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The unique identifier of the context. Format:
     *           `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`,
     *           or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
     *           ID>/sessions/<Session ID>/contexts/<Context ID>`.
     *           The `Context ID` is always converted to lowercase, may only contain
     *           characters in `a-zA-Z0-9_-%` and may be at most 250 bytes long.
     *           If `Environment ID` is not specified, we assume default 'draft'
     *           environment. If `User ID` is not specified, we assume default '-' user.
     *           The following context names are reserved for internal use by Dialogflow.
     *           You should not use these contexts or create contexts with these names:
     *           * `__system_counters__`
     *           * `*_id_dialog_context`
     *           * `*_dialog_params_size`
     *     @type int $lifespan_count
     *           Optional. The number of conversational query requests after which the
     *           context expires. The default is `0`. If set to `0`, the context expires
     *           immediately. Contexts expire automatically after 20 minutes if there
     *           are no matching queries.
     *     @type \Google\Protobuf\Struct $parameters
     *           Optional. The collection of parameters associated with this context.
     *           Depending on your protocol or client library language, this is a
     *           map, associative array, symbol table, dictionary, or JSON object
     *           composed of a collection of (MapKey, MapValue) pairs:
     *           * MapKey type: string
     *           * MapKey value: parameter name
     *           * MapValue type: If parameter's entity type is a composite entity then use
     *           map, otherwise, depending on the parameter value type, it could be one of
     *           string, number, boolean, null, list or map.
     *           * MapValue value: If parameter's entity type is a composite entity then use
     *           map from composite entity property names to property values, otherwise,
     *           use parameter value.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\Context::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique identifier of the context. Format:
     * `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`,
     * or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
     * ID>/sessions/<Session ID>/contexts/<Context ID>`.
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in `a-zA-Z0-9_-%` and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The unique identifier of the context. Format:
     * `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`,
     * or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
     * ID>/sessions/<Session ID>/contexts/<Context ID>`.
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in `a-zA-Z0-9_-%` and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The number of conversational query requests after which the
     * context expires. The default is `0`. If set to `0`, the context expires
     * immediately. Contexts expire automatically after 20 minutes if there
     * are no matching queries.
     *
     * Generated from protobuf field <code>int32 lifespan_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getLifespanCount()
    {
        return $this->lifespan_count;
    }

    /**
     * Optional. The number of conversational query requests after which the
     * context expires. The default is `0`. If set to `0`, the context expires
     * immediately. Contexts expire automatically after 20 minutes if there
     * are no matching queries.
     *
     * Generated from protobuf field <code>int32 lifespan_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setLifespanCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->lifespan_count = $var;

        return $this;
    }

    /**
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    public function hasParameters()
    {
        return isset($this->parameters);
    }

    public function clearParameters()
    {
        unset($this->parameters);
    }

    /**
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->parameters = $var;

        return $this;
    }

}

