<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/catalog.proto

namespace Google\Cloud\Dataplex\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information related to the source system of the data resource that is
 * represented by the entry.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.EntrySource</code>
 */
class EntrySource extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the resource in the source system.
     * Maximum length is 4,000 characters.
     *
     * Generated from protobuf field <code>string resource = 1;</code>
     */
    protected $resource = '';
    /**
     * The name of the source system.
     * Maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string system = 2;</code>
     */
    protected $system = '';
    /**
     * The platform containing the source system.
     * Maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string platform = 3;</code>
     */
    protected $platform = '';
    /**
     * A user-friendly display name.
     * Maximum length is 500 characters.
     *
     * Generated from protobuf field <code>string display_name = 5;</code>
     */
    protected $display_name = '';
    /**
     * A description of the data resource.
     * Maximum length is 2,000 characters.
     *
     * Generated from protobuf field <code>string description = 6;</code>
     */
    protected $description = '';
    /**
     * User-defined labels.
     * The maximum size of keys and values is 128 characters each.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    /**
     * Immutable. The entries representing the ancestors of the data resource in
     * the source system.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dataplex.v1.EntrySource.Ancestor ancestors = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $ancestors;
    /**
     * The time when the resource was created in the source system.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    protected $create_time = null;
    /**
     * The time when the resource was last updated in the source system. If the
     * entry exists in the system and its `EntrySource` has `update_time`
     * populated, further updates to the `EntrySource` of the entry must provide
     * incremental updates to its `update_time`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    protected $update_time = null;
    /**
     * Output only. Location of the resource in the source system. You can search
     * the entry by this location. By default, this should match the location of
     * the entry group containing this entry. A different value allows capturing
     * the source location for data external to Google Cloud.
     *
     * Generated from protobuf field <code>string location = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $location = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource
     *           The name of the resource in the source system.
     *           Maximum length is 4,000 characters.
     *     @type string $system
     *           The name of the source system.
     *           Maximum length is 64 characters.
     *     @type string $platform
     *           The platform containing the source system.
     *           Maximum length is 64 characters.
     *     @type string $display_name
     *           A user-friendly display name.
     *           Maximum length is 500 characters.
     *     @type string $description
     *           A description of the data resource.
     *           Maximum length is 2,000 characters.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined labels.
     *           The maximum size of keys and values is 128 characters each.
     *     @type array<\Google\Cloud\Dataplex\V1\EntrySource\Ancestor>|\Google\Protobuf\Internal\RepeatedField $ancestors
     *           Immutable. The entries representing the ancestors of the data resource in
     *           the source system.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The time when the resource was created in the source system.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           The time when the resource was last updated in the source system. If the
     *           entry exists in the system and its `EntrySource` has `update_time`
     *           populated, further updates to the `EntrySource` of the entry must provide
     *           incremental updates to its `update_time`.
     *     @type string $location
     *           Output only. Location of the resource in the source system. You can search
     *           the entry by this location. By default, this should match the location of
     *           the entry group containing this entry. A different value allows capturing
     *           the source location for data external to Google Cloud.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the resource in the source system.
     * Maximum length is 4,000 characters.
     *
     * Generated from protobuf field <code>string resource = 1;</code>
     * @return string
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * The name of the resource in the source system.
     * Maximum length is 4,000 characters.
     *
     * Generated from protobuf field <code>string resource = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource = $var;

        return $this;
    }

    /**
     * The name of the source system.
     * Maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string system = 2;</code>
     * @return string
     */
    public function getSystem()
    {
        return $this->system;
    }

    /**
     * The name of the source system.
     * Maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string system = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSystem($var)
    {
        GPBUtil::checkString($var, True);
        $this->system = $var;

        return $this;
    }

    /**
     * The platform containing the source system.
     * Maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string platform = 3;</code>
     * @return string
     */
    public function getPlatform()
    {
        return $this->platform;
    }

    /**
     * The platform containing the source system.
     * Maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string platform = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->platform = $var;

        return $this;
    }

    /**
     * A user-friendly display name.
     * Maximum length is 500 characters.
     *
     * Generated from protobuf field <code>string display_name = 5;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A user-friendly display name.
     * Maximum length is 500 characters.
     *
     * Generated from protobuf field <code>string display_name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * A description of the data resource.
     * Maximum length is 2,000 characters.
     *
     * Generated from protobuf field <code>string description = 6;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A description of the data resource.
     * Maximum length is 2,000 characters.
     *
     * Generated from protobuf field <code>string description = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * User-defined labels.
     * The maximum size of keys and values is 128 characters each.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined labels.
     * The maximum size of keys and values is 128 characters each.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Immutable. The entries representing the ancestors of the data resource in
     * the source system.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dataplex.v1.EntrySource.Ancestor ancestors = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAncestors()
    {
        return $this->ancestors;
    }

    /**
     * Immutable. The entries representing the ancestors of the data resource in
     * the source system.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dataplex.v1.EntrySource.Ancestor ancestors = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<\Google\Cloud\Dataplex\V1\EntrySource\Ancestor>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAncestors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dataplex\V1\EntrySource\Ancestor::class);
        $this->ancestors = $arr;

        return $this;
    }

    /**
     * The time when the resource was created in the source system.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The time when the resource was created in the source system.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The time when the resource was last updated in the source system. If the
     * entry exists in the system and its `EntrySource` has `update_time`
     * populated, further updates to the `EntrySource` of the entry must provide
     * incremental updates to its `update_time`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 11;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * The time when the resource was last updated in the source system. If the
     * entry exists in the system and its `EntrySource` has `update_time`
     * populated, further updates to the `EntrySource` of the entry must provide
     * incremental updates to its `update_time`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 11;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Location of the resource in the source system. You can search
     * the entry by this location. By default, this should match the location of
     * the entry group containing this entry. A different value allows capturing
     * the source location for data external to Google Cloud.
     *
     * Generated from protobuf field <code>string location = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Output only. Location of the resource in the source system. You can search
     * the entry by this location. By default, this should match the location of
     * the entry group containing this entry. A different value allows capturing
     * the source location for data external to Google Cloud.
     *
     * Generated from protobuf field <code>string location = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

}

