<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/jobs.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a job to be run by the Cloud Dataflow service. Do not enter
 * confidential information when you supply string values using the API.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.Job</code>
 */
class Job extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique ID of this job.
     * This field is set by the Dataflow service when the job is
     * created, and is immutable for the life of the job.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    protected $id = '';
    /**
     * The ID of the Google Cloud project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     */
    protected $project_id = '';
    /**
     * Optional. The user-specified Dataflow job name.
     * Only one active job with a given name can exist in a project within one
     * region at
     * any given time. Jobs in different regions can have the same name.
     * If a caller attempts to create a job with the same
     * name as an active job that already exists, the attempt returns the
     * existing job.
     * The name must match the regular expression
     * `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
     *
     * Generated from protobuf field <code>string name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $name = '';
    /**
     * Optional. The type of Dataflow job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobType type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $type = 0;
    /**
     * Optional. The environment for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.Environment environment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $environment = null;
    /**
     * Exactly one of step or steps_location should be specified.
     * The top-level steps that constitute the entire job. Only retrieved with
     * JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.Step steps = 6;</code>
     */
    private $steps;
    /**
     * The Cloud Storage location where the steps are stored.
     *
     * Generated from protobuf field <code>string steps_location = 24;</code>
     */
    protected $steps_location = '';
    /**
     * The current state of the job.
     * Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise
     * specified.
     * A job in the `JOB_STATE_RUNNING` state may asynchronously enter a
     * terminal state. After a job has reached a terminal state, no
     * further state updates may be made.
     * This field might be mutated by the Dataflow service;
     * callers cannot mutate it.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobState current_state = 7;</code>
     */
    protected $current_state = 0;
    /**
     * The timestamp associated with the current state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_state_time = 8;</code>
     */
    protected $current_state_time = null;
    /**
     * The job's requested state. Applies to `UpdateJob` requests.
     * Set `requested_state` with `UpdateJob` requests to switch between the
     * states `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING`. You can also use
     * `UpdateJob` requests to change a job's
     * state from `JOB_STATE_RUNNING` to `JOB_STATE_CANCELLED`,
     * `JOB_STATE_DONE`,  or `JOB_STATE_DRAINED`. These states irrevocably
     * terminate the job if it hasn't already reached a terminal state.
     * This field has no effect on `CreateJob` requests.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobState requested_state = 9;</code>
     */
    protected $requested_state = 0;
    /**
     * Deprecated.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobExecutionInfo execution_info = 10;</code>
     */
    protected $execution_info = null;
    /**
     * The timestamp when the job was initially created. Immutable and set by the
     * Cloud Dataflow service.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    protected $create_time = null;
    /**
     * If this job is an update of an existing job, this field is the job ID
     * of the job it replaced.
     * When sending a `CreateJobRequest`, you can update a job by specifying it
     * here. The job named here is stopped, and its intermediate state is
     * transferred to this job.
     *
     * Generated from protobuf field <code>string replace_job_id = 12;</code>
     */
    protected $replace_job_id = '';
    /**
     * Optional. The map of transform name prefixes of the job to be replaced to
     * the corresponding name prefixes of the new job.
     *
     * Generated from protobuf field <code>map<string, string> transform_name_mapping = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $transform_name_mapping;
    /**
     * The client's unique identifier of the job, re-used across retried attempts.
     * If this field is set, the service will ensure its uniqueness.
     * The request to create a job will fail if the service has knowledge of a
     * previously submitted job with the same client's ID and job name.
     * The caller may use this field to ensure idempotence of job
     * creation across retried attempts to create a job.
     * By default, the field is empty and, in that case, the service ignores it.
     *
     * Generated from protobuf field <code>string client_request_id = 14;</code>
     */
    protected $client_request_id = '';
    /**
     * If another job is an update of this job (and thus, this job is in
     * `JOB_STATE_UPDATED`), this field contains the ID of that job.
     *
     * Generated from protobuf field <code>string replaced_by_job_id = 15;</code>
     */
    protected $replaced_by_job_id = '';
    /**
     * A set of files the system should be aware of that are used
     * for temporary storage. These temporary files will be
     * removed on job completion.
     * No duplicates are allowed.
     * No file patterns are supported.
     * The supported files are:
     * Google Cloud Storage:
     *    storage.googleapis.com/{bucket}/{object}
     *    bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>repeated string temp_files = 16;</code>
     */
    private $temp_files;
    /**
     * User-defined labels for this job.
     * The labels map can contain no more than 64 entries.  Entries of the labels
     * map are UTF8 strings that comply with the following restrictions:
     * * Keys must conform to regexp:  [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     * * Values must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     * * Both keys and values are additionally constrained to be <= 128 bytes in
     * size.
     *
     * Generated from protobuf field <code>map<string, string> labels = 17;</code>
     */
    private $labels;
    /**
     * Optional. The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
     * contains this job.
     *
     * Generated from protobuf field <code>string location = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $location = '';
    /**
     * Preliminary field: The format of this data may change at any time.
     * A description of the user pipeline and stages through which it is executed.
     * Created by Cloud Dataflow service.  Only retrieved with
     * JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.PipelineDescription pipeline_description = 19;</code>
     */
    protected $pipeline_description = null;
    /**
     * This field may be mutated by the Cloud Dataflow service;
     * callers cannot mutate it.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.ExecutionStageState stage_states = 20;</code>
     */
    private $stage_states;
    /**
     * This field is populated by the Dataflow service to support filtering jobs
     * by the metadata values provided here. Populated for ListJobs and all GetJob
     * views SUMMARY and higher.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobMetadata job_metadata = 21;</code>
     */
    protected $job_metadata = null;
    /**
     * The timestamp when the job was started (transitioned to JOB_STATE_PENDING).
     * Flexible resource scheduling jobs are started with some delay after job
     * creation, so start_time is unset before start and is updated when the
     * job is started by the Cloud Dataflow service. For other jobs, start_time
     * always equals to create_time and is immutable and set by the Cloud Dataflow
     * service.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 22;</code>
     */
    protected $start_time = null;
    /**
     * If this is specified, the job's initial state is populated from the given
     * snapshot.
     *
     * Generated from protobuf field <code>string created_from_snapshot_id = 23;</code>
     */
    protected $created_from_snapshot_id = '';
    /**
     * Reserved for future use. This field is set only in responses from the
     * server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 25;</code>
     */
    protected $satisfies_pzs = false;
    /**
     * This field may ONLY be modified at runtime using the projects.jobs.update
     * method to adjust job behavior. This field has no effect when specified at
     * job creation.
     *
     * Generated from protobuf field <code>optional .google.dataflow.v1beta3.RuntimeUpdatableParams runtime_updatable_params = 26;</code>
     */
    protected $runtime_updatable_params = null;
    /**
     * Output only. Reserved for future use. This field is set only in responses
     * from the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = null;
    /**
     * Output only. Resources used by the Dataflow Service to run the job.
     *
     * Generated from protobuf field <code>optional .google.dataflow.v1beta3.ServiceResources service_resources = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $service_resources = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           The unique ID of this job.
     *           This field is set by the Dataflow service when the job is
     *           created, and is immutable for the life of the job.
     *     @type string $project_id
     *           The ID of the Google Cloud project that the job belongs to.
     *     @type string $name
     *           Optional. The user-specified Dataflow job name.
     *           Only one active job with a given name can exist in a project within one
     *           region at
     *           any given time. Jobs in different regions can have the same name.
     *           If a caller attempts to create a job with the same
     *           name as an active job that already exists, the attempt returns the
     *           existing job.
     *           The name must match the regular expression
     *           `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
     *     @type int $type
     *           Optional. The type of Dataflow job.
     *     @type \Google\Cloud\Dataflow\V1beta3\Environment $environment
     *           Optional. The environment for the job.
     *     @type array<\Google\Cloud\Dataflow\V1beta3\Step>|\Google\Protobuf\Internal\RepeatedField $steps
     *           Exactly one of step or steps_location should be specified.
     *           The top-level steps that constitute the entire job. Only retrieved with
     *           JOB_VIEW_ALL.
     *     @type string $steps_location
     *           The Cloud Storage location where the steps are stored.
     *     @type int $current_state
     *           The current state of the job.
     *           Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise
     *           specified.
     *           A job in the `JOB_STATE_RUNNING` state may asynchronously enter a
     *           terminal state. After a job has reached a terminal state, no
     *           further state updates may be made.
     *           This field might be mutated by the Dataflow service;
     *           callers cannot mutate it.
     *     @type \Google\Protobuf\Timestamp $current_state_time
     *           The timestamp associated with the current state.
     *     @type int $requested_state
     *           The job's requested state. Applies to `UpdateJob` requests.
     *           Set `requested_state` with `UpdateJob` requests to switch between the
     *           states `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING`. You can also use
     *           `UpdateJob` requests to change a job's
     *           state from `JOB_STATE_RUNNING` to `JOB_STATE_CANCELLED`,
     *           `JOB_STATE_DONE`,  or `JOB_STATE_DRAINED`. These states irrevocably
     *           terminate the job if it hasn't already reached a terminal state.
     *           This field has no effect on `CreateJob` requests.
     *     @type \Google\Cloud\Dataflow\V1beta3\JobExecutionInfo $execution_info
     *           Deprecated.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The timestamp when the job was initially created. Immutable and set by the
     *           Cloud Dataflow service.
     *     @type string $replace_job_id
     *           If this job is an update of an existing job, this field is the job ID
     *           of the job it replaced.
     *           When sending a `CreateJobRequest`, you can update a job by specifying it
     *           here. The job named here is stopped, and its intermediate state is
     *           transferred to this job.
     *     @type array|\Google\Protobuf\Internal\MapField $transform_name_mapping
     *           Optional. The map of transform name prefixes of the job to be replaced to
     *           the corresponding name prefixes of the new job.
     *     @type string $client_request_id
     *           The client's unique identifier of the job, re-used across retried attempts.
     *           If this field is set, the service will ensure its uniqueness.
     *           The request to create a job will fail if the service has knowledge of a
     *           previously submitted job with the same client's ID and job name.
     *           The caller may use this field to ensure idempotence of job
     *           creation across retried attempts to create a job.
     *           By default, the field is empty and, in that case, the service ignores it.
     *     @type string $replaced_by_job_id
     *           If another job is an update of this job (and thus, this job is in
     *           `JOB_STATE_UPDATED`), this field contains the ID of that job.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $temp_files
     *           A set of files the system should be aware of that are used
     *           for temporary storage. These temporary files will be
     *           removed on job completion.
     *           No duplicates are allowed.
     *           No file patterns are supported.
     *           The supported files are:
     *           Google Cloud Storage:
     *              storage.googleapis.com/{bucket}/{object}
     *              bucket.storage.googleapis.com/{object}
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined labels for this job.
     *           The labels map can contain no more than 64 entries.  Entries of the labels
     *           map are UTF8 strings that comply with the following restrictions:
     *           * Keys must conform to regexp:  [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *           * Values must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *           * Both keys and values are additionally constrained to be <= 128 bytes in
     *           size.
     *     @type string $location
     *           Optional. The [regional endpoint]
     *           (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
     *           contains this job.
     *     @type \Google\Cloud\Dataflow\V1beta3\PipelineDescription $pipeline_description
     *           Preliminary field: The format of this data may change at any time.
     *           A description of the user pipeline and stages through which it is executed.
     *           Created by Cloud Dataflow service.  Only retrieved with
     *           JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
     *     @type array<\Google\Cloud\Dataflow\V1beta3\ExecutionStageState>|\Google\Protobuf\Internal\RepeatedField $stage_states
     *           This field may be mutated by the Cloud Dataflow service;
     *           callers cannot mutate it.
     *     @type \Google\Cloud\Dataflow\V1beta3\JobMetadata $job_metadata
     *           This field is populated by the Dataflow service to support filtering jobs
     *           by the metadata values provided here. Populated for ListJobs and all GetJob
     *           views SUMMARY and higher.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           The timestamp when the job was started (transitioned to JOB_STATE_PENDING).
     *           Flexible resource scheduling jobs are started with some delay after job
     *           creation, so start_time is unset before start and is updated when the
     *           job is started by the Cloud Dataflow service. For other jobs, start_time
     *           always equals to create_time and is immutable and set by the Cloud Dataflow
     *           service.
     *     @type string $created_from_snapshot_id
     *           If this is specified, the job's initial state is populated from the given
     *           snapshot.
     *     @type bool $satisfies_pzs
     *           Reserved for future use. This field is set only in responses from the
     *           server; it is ignored if it is set in any requests.
     *     @type \Google\Cloud\Dataflow\V1beta3\RuntimeUpdatableParams $runtime_updatable_params
     *           This field may ONLY be modified at runtime using the projects.jobs.update
     *           method to adjust job behavior. This field has no effect when specified at
     *           job creation.
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use. This field is set only in responses
     *           from the server; it is ignored if it is set in any requests.
     *     @type \Google\Cloud\Dataflow\V1beta3\ServiceResources $service_resources
     *           Output only. Resources used by the Dataflow Service to run the job.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Jobs::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique ID of this job.
     * This field is set by the Dataflow service when the job is
     * created, and is immutable for the life of the job.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The unique ID of this job.
     * This field is set by the Dataflow service when the job is
     * created, and is immutable for the life of the job.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The ID of the Google Cloud project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * The ID of the Google Cloud project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Optional. The user-specified Dataflow job name.
     * Only one active job with a given name can exist in a project within one
     * region at
     * any given time. Jobs in different regions can have the same name.
     * If a caller attempts to create a job with the same
     * name as an active job that already exists, the attempt returns the
     * existing job.
     * The name must match the regular expression
     * `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
     *
     * Generated from protobuf field <code>string name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Optional. The user-specified Dataflow job name.
     * Only one active job with a given name can exist in a project within one
     * region at
     * any given time. Jobs in different regions can have the same name.
     * If a caller attempts to create a job with the same
     * name as an active job that already exists, the attempt returns the
     * existing job.
     * The name must match the regular expression
     * `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
     *
     * Generated from protobuf field <code>string name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The type of Dataflow job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobType type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Optional. The type of Dataflow job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobType type = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\JobType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Optional. The environment for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.Environment environment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataflow\V1beta3\Environment|null
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    public function hasEnvironment()
    {
        return isset($this->environment);
    }

    public function clearEnvironment()
    {
        unset($this->environment);
    }

    /**
     * Optional. The environment for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.Environment environment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataflow\V1beta3\Environment $var
     * @return $this
     */
    public function setEnvironment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\Environment::class);
        $this->environment = $var;

        return $this;
    }

    /**
     * Exactly one of step or steps_location should be specified.
     * The top-level steps that constitute the entire job. Only retrieved with
     * JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.Step steps = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSteps()
    {
        return $this->steps;
    }

    /**
     * Exactly one of step or steps_location should be specified.
     * The top-level steps that constitute the entire job. Only retrieved with
     * JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.Step steps = 6;</code>
     * @param array<\Google\Cloud\Dataflow\V1beta3\Step>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSteps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dataflow\V1beta3\Step::class);
        $this->steps = $arr;

        return $this;
    }

    /**
     * The Cloud Storage location where the steps are stored.
     *
     * Generated from protobuf field <code>string steps_location = 24;</code>
     * @return string
     */
    public function getStepsLocation()
    {
        return $this->steps_location;
    }

    /**
     * The Cloud Storage location where the steps are stored.
     *
     * Generated from protobuf field <code>string steps_location = 24;</code>
     * @param string $var
     * @return $this
     */
    public function setStepsLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->steps_location = $var;

        return $this;
    }

    /**
     * The current state of the job.
     * Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise
     * specified.
     * A job in the `JOB_STATE_RUNNING` state may asynchronously enter a
     * terminal state. After a job has reached a terminal state, no
     * further state updates may be made.
     * This field might be mutated by the Dataflow service;
     * callers cannot mutate it.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobState current_state = 7;</code>
     * @return int
     */
    public function getCurrentState()
    {
        return $this->current_state;
    }

    /**
     * The current state of the job.
     * Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise
     * specified.
     * A job in the `JOB_STATE_RUNNING` state may asynchronously enter a
     * terminal state. After a job has reached a terminal state, no
     * further state updates may be made.
     * This field might be mutated by the Dataflow service;
     * callers cannot mutate it.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobState current_state = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setCurrentState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\JobState::class);
        $this->current_state = $var;

        return $this;
    }

    /**
     * The timestamp associated with the current state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_state_time = 8;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCurrentStateTime()
    {
        return $this->current_state_time;
    }

    public function hasCurrentStateTime()
    {
        return isset($this->current_state_time);
    }

    public function clearCurrentStateTime()
    {
        unset($this->current_state_time);
    }

    /**
     * The timestamp associated with the current state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_state_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCurrentStateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->current_state_time = $var;

        return $this;
    }

    /**
     * The job's requested state. Applies to `UpdateJob` requests.
     * Set `requested_state` with `UpdateJob` requests to switch between the
     * states `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING`. You can also use
     * `UpdateJob` requests to change a job's
     * state from `JOB_STATE_RUNNING` to `JOB_STATE_CANCELLED`,
     * `JOB_STATE_DONE`,  or `JOB_STATE_DRAINED`. These states irrevocably
     * terminate the job if it hasn't already reached a terminal state.
     * This field has no effect on `CreateJob` requests.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobState requested_state = 9;</code>
     * @return int
     */
    public function getRequestedState()
    {
        return $this->requested_state;
    }

    /**
     * The job's requested state. Applies to `UpdateJob` requests.
     * Set `requested_state` with `UpdateJob` requests to switch between the
     * states `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING`. You can also use
     * `UpdateJob` requests to change a job's
     * state from `JOB_STATE_RUNNING` to `JOB_STATE_CANCELLED`,
     * `JOB_STATE_DONE`,  or `JOB_STATE_DRAINED`. These states irrevocably
     * terminate the job if it hasn't already reached a terminal state.
     * This field has no effect on `CreateJob` requests.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobState requested_state = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setRequestedState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\JobState::class);
        $this->requested_state = $var;

        return $this;
    }

    /**
     * Deprecated.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobExecutionInfo execution_info = 10;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\JobExecutionInfo|null
     */
    public function getExecutionInfo()
    {
        return $this->execution_info;
    }

    public function hasExecutionInfo()
    {
        return isset($this->execution_info);
    }

    public function clearExecutionInfo()
    {
        unset($this->execution_info);
    }

    /**
     * Deprecated.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobExecutionInfo execution_info = 10;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\JobExecutionInfo $var
     * @return $this
     */
    public function setExecutionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\JobExecutionInfo::class);
        $this->execution_info = $var;

        return $this;
    }

    /**
     * The timestamp when the job was initially created. Immutable and set by the
     * Cloud Dataflow service.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The timestamp when the job was initially created. Immutable and set by the
     * Cloud Dataflow service.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * If this job is an update of an existing job, this field is the job ID
     * of the job it replaced.
     * When sending a `CreateJobRequest`, you can update a job by specifying it
     * here. The job named here is stopped, and its intermediate state is
     * transferred to this job.
     *
     * Generated from protobuf field <code>string replace_job_id = 12;</code>
     * @return string
     */
    public function getReplaceJobId()
    {
        return $this->replace_job_id;
    }

    /**
     * If this job is an update of an existing job, this field is the job ID
     * of the job it replaced.
     * When sending a `CreateJobRequest`, you can update a job by specifying it
     * here. The job named here is stopped, and its intermediate state is
     * transferred to this job.
     *
     * Generated from protobuf field <code>string replace_job_id = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setReplaceJobId($var)
    {
        GPBUtil::checkString($var, True);
        $this->replace_job_id = $var;

        return $this;
    }

    /**
     * Optional. The map of transform name prefixes of the job to be replaced to
     * the corresponding name prefixes of the new job.
     *
     * Generated from protobuf field <code>map<string, string> transform_name_mapping = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getTransformNameMapping()
    {
        return $this->transform_name_mapping;
    }

    /**
     * Optional. The map of transform name prefixes of the job to be replaced to
     * the corresponding name prefixes of the new job.
     *
     * Generated from protobuf field <code>map<string, string> transform_name_mapping = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setTransformNameMapping($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->transform_name_mapping = $arr;

        return $this;
    }

    /**
     * The client's unique identifier of the job, re-used across retried attempts.
     * If this field is set, the service will ensure its uniqueness.
     * The request to create a job will fail if the service has knowledge of a
     * previously submitted job with the same client's ID and job name.
     * The caller may use this field to ensure idempotence of job
     * creation across retried attempts to create a job.
     * By default, the field is empty and, in that case, the service ignores it.
     *
     * Generated from protobuf field <code>string client_request_id = 14;</code>
     * @return string
     */
    public function getClientRequestId()
    {
        return $this->client_request_id;
    }

    /**
     * The client's unique identifier of the job, re-used across retried attempts.
     * If this field is set, the service will ensure its uniqueness.
     * The request to create a job will fail if the service has knowledge of a
     * previously submitted job with the same client's ID and job name.
     * The caller may use this field to ensure idempotence of job
     * creation across retried attempts to create a job.
     * By default, the field is empty and, in that case, the service ignores it.
     *
     * Generated from protobuf field <code>string client_request_id = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setClientRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_request_id = $var;

        return $this;
    }

    /**
     * If another job is an update of this job (and thus, this job is in
     * `JOB_STATE_UPDATED`), this field contains the ID of that job.
     *
     * Generated from protobuf field <code>string replaced_by_job_id = 15;</code>
     * @return string
     */
    public function getReplacedByJobId()
    {
        return $this->replaced_by_job_id;
    }

    /**
     * If another job is an update of this job (and thus, this job is in
     * `JOB_STATE_UPDATED`), this field contains the ID of that job.
     *
     * Generated from protobuf field <code>string replaced_by_job_id = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setReplacedByJobId($var)
    {
        GPBUtil::checkString($var, True);
        $this->replaced_by_job_id = $var;

        return $this;
    }

    /**
     * A set of files the system should be aware of that are used
     * for temporary storage. These temporary files will be
     * removed on job completion.
     * No duplicates are allowed.
     * No file patterns are supported.
     * The supported files are:
     * Google Cloud Storage:
     *    storage.googleapis.com/{bucket}/{object}
     *    bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>repeated string temp_files = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTempFiles()
    {
        return $this->temp_files;
    }

    /**
     * A set of files the system should be aware of that are used
     * for temporary storage. These temporary files will be
     * removed on job completion.
     * No duplicates are allowed.
     * No file patterns are supported.
     * The supported files are:
     * Google Cloud Storage:
     *    storage.googleapis.com/{bucket}/{object}
     *    bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>repeated string temp_files = 16;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTempFiles($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->temp_files = $arr;

        return $this;
    }

    /**
     * User-defined labels for this job.
     * The labels map can contain no more than 64 entries.  Entries of the labels
     * map are UTF8 strings that comply with the following restrictions:
     * * Keys must conform to regexp:  [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     * * Values must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     * * Both keys and values are additionally constrained to be <= 128 bytes in
     * size.
     *
     * Generated from protobuf field <code>map<string, string> labels = 17;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined labels for this job.
     * The labels map can contain no more than 64 entries.  Entries of the labels
     * map are UTF8 strings that comply with the following restrictions:
     * * Keys must conform to regexp:  [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     * * Values must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     * * Both keys and values are additionally constrained to be <= 128 bytes in
     * size.
     *
     * Generated from protobuf field <code>map<string, string> labels = 17;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
     * contains this job.
     *
     * Generated from protobuf field <code>string location = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Optional. The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
     * contains this job.
     *
     * Generated from protobuf field <code>string location = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Preliminary field: The format of this data may change at any time.
     * A description of the user pipeline and stages through which it is executed.
     * Created by Cloud Dataflow service.  Only retrieved with
     * JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.PipelineDescription pipeline_description = 19;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\PipelineDescription|null
     */
    public function getPipelineDescription()
    {
        return $this->pipeline_description;
    }

    public function hasPipelineDescription()
    {
        return isset($this->pipeline_description);
    }

    public function clearPipelineDescription()
    {
        unset($this->pipeline_description);
    }

    /**
     * Preliminary field: The format of this data may change at any time.
     * A description of the user pipeline and stages through which it is executed.
     * Created by Cloud Dataflow service.  Only retrieved with
     * JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.PipelineDescription pipeline_description = 19;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\PipelineDescription $var
     * @return $this
     */
    public function setPipelineDescription($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\PipelineDescription::class);
        $this->pipeline_description = $var;

        return $this;
    }

    /**
     * This field may be mutated by the Cloud Dataflow service;
     * callers cannot mutate it.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.ExecutionStageState stage_states = 20;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStageStates()
    {
        return $this->stage_states;
    }

    /**
     * This field may be mutated by the Cloud Dataflow service;
     * callers cannot mutate it.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.ExecutionStageState stage_states = 20;</code>
     * @param array<\Google\Cloud\Dataflow\V1beta3\ExecutionStageState>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStageStates($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dataflow\V1beta3\ExecutionStageState::class);
        $this->stage_states = $arr;

        return $this;
    }

    /**
     * This field is populated by the Dataflow service to support filtering jobs
     * by the metadata values provided here. Populated for ListJobs and all GetJob
     * views SUMMARY and higher.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobMetadata job_metadata = 21;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\JobMetadata|null
     */
    public function getJobMetadata()
    {
        return $this->job_metadata;
    }

    public function hasJobMetadata()
    {
        return isset($this->job_metadata);
    }

    public function clearJobMetadata()
    {
        unset($this->job_metadata);
    }

    /**
     * This field is populated by the Dataflow service to support filtering jobs
     * by the metadata values provided here. Populated for ListJobs and all GetJob
     * views SUMMARY and higher.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.JobMetadata job_metadata = 21;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\JobMetadata $var
     * @return $this
     */
    public function setJobMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\JobMetadata::class);
        $this->job_metadata = $var;

        return $this;
    }

    /**
     * The timestamp when the job was started (transitioned to JOB_STATE_PENDING).
     * Flexible resource scheduling jobs are started with some delay after job
     * creation, so start_time is unset before start and is updated when the
     * job is started by the Cloud Dataflow service. For other jobs, start_time
     * always equals to create_time and is immutable and set by the Cloud Dataflow
     * service.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 22;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * The timestamp when the job was started (transitioned to JOB_STATE_PENDING).
     * Flexible resource scheduling jobs are started with some delay after job
     * creation, so start_time is unset before start and is updated when the
     * job is started by the Cloud Dataflow service. For other jobs, start_time
     * always equals to create_time and is immutable and set by the Cloud Dataflow
     * service.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 22;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * If this is specified, the job's initial state is populated from the given
     * snapshot.
     *
     * Generated from protobuf field <code>string created_from_snapshot_id = 23;</code>
     * @return string
     */
    public function getCreatedFromSnapshotId()
    {
        return $this->created_from_snapshot_id;
    }

    /**
     * If this is specified, the job's initial state is populated from the given
     * snapshot.
     *
     * Generated from protobuf field <code>string created_from_snapshot_id = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setCreatedFromSnapshotId($var)
    {
        GPBUtil::checkString($var, True);
        $this->created_from_snapshot_id = $var;

        return $this;
    }

    /**
     * Reserved for future use. This field is set only in responses from the
     * server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 25;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Reserved for future use. This field is set only in responses from the
     * server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 25;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * This field may ONLY be modified at runtime using the projects.jobs.update
     * method to adjust job behavior. This field has no effect when specified at
     * job creation.
     *
     * Generated from protobuf field <code>optional .google.dataflow.v1beta3.RuntimeUpdatableParams runtime_updatable_params = 26;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\RuntimeUpdatableParams|null
     */
    public function getRuntimeUpdatableParams()
    {
        return $this->runtime_updatable_params;
    }

    public function hasRuntimeUpdatableParams()
    {
        return isset($this->runtime_updatable_params);
    }

    public function clearRuntimeUpdatableParams()
    {
        unset($this->runtime_updatable_params);
    }

    /**
     * This field may ONLY be modified at runtime using the projects.jobs.update
     * method to adjust job behavior. This field has no effect when specified at
     * job creation.
     *
     * Generated from protobuf field <code>optional .google.dataflow.v1beta3.RuntimeUpdatableParams runtime_updatable_params = 26;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\RuntimeUpdatableParams $var
     * @return $this
     */
    public function setRuntimeUpdatableParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\RuntimeUpdatableParams::class);
        $this->runtime_updatable_params = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use. This field is set only in responses
     * from the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. Reserved for future use. This field is set only in responses
     * from the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Output only. Resources used by the Dataflow Service to run the job.
     *
     * Generated from protobuf field <code>optional .google.dataflow.v1beta3.ServiceResources service_resources = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Dataflow\V1beta3\ServiceResources|null
     */
    public function getServiceResources()
    {
        return $this->service_resources;
    }

    public function hasServiceResources()
    {
        return isset($this->service_resources);
    }

    public function clearServiceResources()
    {
        unset($this->service_resources);
    }

    /**
     * Output only. Resources used by the Dataflow Service to run the job.
     *
     * Generated from protobuf field <code>optional .google.dataflow.v1beta3.ServiceResources service_resources = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Dataflow\V1beta3\ServiceResources $var
     * @return $this
     */
    public function setServiceResources($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\ServiceResources::class);
        $this->service_resources = $var;

        return $this;
    }

}

