<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/configdelivery/v1/config_delivery.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ConfigDelivery\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ConfigDelivery\V1\AbortRolloutRequest;
use Google\Cloud\ConfigDelivery\V1\CreateFleetPackageRequest;
use Google\Cloud\ConfigDelivery\V1\CreateReleaseRequest;
use Google\Cloud\ConfigDelivery\V1\CreateResourceBundleRequest;
use Google\Cloud\ConfigDelivery\V1\CreateVariantRequest;
use Google\Cloud\ConfigDelivery\V1\DeleteFleetPackageRequest;
use Google\Cloud\ConfigDelivery\V1\DeleteReleaseRequest;
use Google\Cloud\ConfigDelivery\V1\DeleteResourceBundleRequest;
use Google\Cloud\ConfigDelivery\V1\DeleteVariantRequest;
use Google\Cloud\ConfigDelivery\V1\FleetPackage;
use Google\Cloud\ConfigDelivery\V1\GetFleetPackageRequest;
use Google\Cloud\ConfigDelivery\V1\GetReleaseRequest;
use Google\Cloud\ConfigDelivery\V1\GetResourceBundleRequest;
use Google\Cloud\ConfigDelivery\V1\GetRolloutRequest;
use Google\Cloud\ConfigDelivery\V1\GetVariantRequest;
use Google\Cloud\ConfigDelivery\V1\ListFleetPackagesRequest;
use Google\Cloud\ConfigDelivery\V1\ListReleasesRequest;
use Google\Cloud\ConfigDelivery\V1\ListResourceBundlesRequest;
use Google\Cloud\ConfigDelivery\V1\ListRolloutsRequest;
use Google\Cloud\ConfigDelivery\V1\ListVariantsRequest;
use Google\Cloud\ConfigDelivery\V1\Release;
use Google\Cloud\ConfigDelivery\V1\ResourceBundle;
use Google\Cloud\ConfigDelivery\V1\ResumeRolloutRequest;
use Google\Cloud\ConfigDelivery\V1\Rollout;
use Google\Cloud\ConfigDelivery\V1\SuspendRolloutRequest;
use Google\Cloud\ConfigDelivery\V1\UpdateFleetPackageRequest;
use Google\Cloud\ConfigDelivery\V1\UpdateReleaseRequest;
use Google\Cloud\ConfigDelivery\V1\UpdateResourceBundleRequest;
use Google\Cloud\ConfigDelivery\V1\UpdateVariantRequest;
use Google\Cloud\ConfigDelivery\V1\Variant;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: ConfigDelivery service manages the deployment of kubernetes configuration to
 * a fleet of kubernetes clusters.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> abortRolloutAsync(AbortRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createFleetPackageAsync(CreateFleetPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createReleaseAsync(CreateReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createResourceBundleAsync(CreateResourceBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createVariantAsync(CreateVariantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteFleetPackageAsync(DeleteFleetPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteReleaseAsync(DeleteReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteResourceBundleAsync(DeleteResourceBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteVariantAsync(DeleteVariantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FleetPackage> getFleetPackageAsync(GetFleetPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Release> getReleaseAsync(GetReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ResourceBundle> getResourceBundleAsync(GetResourceBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rollout> getRolloutAsync(GetRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Variant> getVariantAsync(GetVariantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFleetPackagesAsync(ListFleetPackagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReleasesAsync(ListReleasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listResourceBundlesAsync(ListResourceBundlesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRolloutsAsync(ListRolloutsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listVariantsAsync(ListVariantsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> resumeRolloutAsync(ResumeRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> suspendRolloutAsync(SuspendRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateFleetPackageAsync(UpdateFleetPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateReleaseAsync(UpdateReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateResourceBundleAsync(UpdateResourceBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateVariantAsync(UpdateVariantRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ConfigDeliveryClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.configdelivery.v1.ConfigDelivery';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'configdelivery.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'configdelivery.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/config_delivery_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/config_delivery_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/config_delivery_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/config_delivery_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * fleet_package resource.
     *
     * @param string $project
     * @param string $location
     * @param string $fleetPackage
     *
     * @return string The formatted fleet_package resource.
     */
    public static function fleetPackageName(string $project, string $location, string $fleetPackage): string
    {
        return self::getPathTemplate('fleetPackage')->render([
            'project' => $project,
            'location' => $location,
            'fleet_package' => $fleetPackage,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a release
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $resourceBundle
     * @param string $release
     *
     * @return string The formatted release resource.
     */
    public static function releaseName(
        string $project,
        string $location,
        string $resourceBundle,
        string $release
    ): string {
        return self::getPathTemplate('release')->render([
            'project' => $project,
            'location' => $location,
            'resource_bundle' => $resourceBundle,
            'release' => $release,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     * @param string $repository
     *
     * @return string The formatted repository resource.
     */
    public static function repositoryName(
        string $project,
        string $location,
        string $connection,
        string $repository
    ): string {
        return self::getPathTemplate('repository')->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * resource_bundle resource.
     *
     * @param string $project
     * @param string $location
     * @param string $resourceBundle
     *
     * @return string The formatted resource_bundle resource.
     */
    public static function resourceBundleName(string $project, string $location, string $resourceBundle): string
    {
        return self::getPathTemplate('resourceBundle')->render([
            'project' => $project,
            'location' => $location,
            'resource_bundle' => $resourceBundle,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a rollout
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $fleetPackage
     * @param string $rollout
     *
     * @return string The formatted rollout resource.
     */
    public static function rolloutName(string $project, string $location, string $fleetPackage, string $rollout): string
    {
        return self::getPathTemplate('rollout')->render([
            'project' => $project,
            'location' => $location,
            'fleet_package' => $fleetPackage,
            'rollout' => $rollout,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a variant
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $resourceBundle
     * @param string $release
     * @param string $variant
     *
     * @return string The formatted variant resource.
     */
    public static function variantName(
        string $project,
        string $location,
        string $resourceBundle,
        string $release,
        string $variant
    ): string {
        return self::getPathTemplate('variant')->render([
            'project' => $project,
            'location' => $location,
            'resource_bundle' => $resourceBundle,
            'release' => $release,
            'variant' => $variant,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - fleetPackage: projects/{project}/locations/{location}/fleetPackages/{fleet_package}
     * - location: projects/{project}/locations/{location}
     * - project: projects/{project}
     * - release: projects/{project}/locations/{location}/resourceBundles/{resource_bundle}/releases/{release}
     * - repository: projects/{project}/locations/{location}/connections/{connection}/repositories/{repository}
     * - resourceBundle: projects/{project}/locations/{location}/resourceBundles/{resource_bundle}
     * - rollout: projects/{project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/{rollout}
     * - variant: projects/{project}/locations/{location}/resourceBundles/{resource_bundle}/releases/{release}/variants/{variant}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'configdelivery.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\ConfigDelivery\V1\ConfigDeliveryClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ConfigDeliveryClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Abort a Rollout.
     *
     * The async variant is {@see ConfigDeliveryClient::abortRolloutAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/abort_rollout.php
     *
     * @param AbortRolloutRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Rollout>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function abortRollout(AbortRolloutRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AbortRollout', $request, $callOptions)->wait();
    }

    /**
     * Creates a new FleetPackage in a given project and location.
     *
     * The async variant is {@see ConfigDeliveryClient::createFleetPackageAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/create_fleet_package.php
     *
     * @param CreateFleetPackageRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<FleetPackage>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFleetPackage(CreateFleetPackageRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateFleetPackage', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Release in a given project, location and resource bundle.
     *
     * The async variant is {@see ConfigDeliveryClient::createReleaseAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/create_release.php
     *
     * @param CreateReleaseRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Release>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRelease(CreateReleaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRelease', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ResourceBundle in a given project and location.
     *
     * The async variant is {@see ConfigDeliveryClient::createResourceBundleAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/create_resource_bundle.php
     *
     * @param CreateResourceBundleRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ResourceBundle>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createResourceBundle(
        CreateResourceBundleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateResourceBundle', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Variant in a given project, location, resource bundle, and
     * release.
     *
     * The async variant is {@see ConfigDeliveryClient::createVariantAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/create_variant.php
     *
     * @param CreateVariantRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Variant>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVariant(CreateVariantRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateVariant', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single FleetPackage.
     *
     * The async variant is {@see ConfigDeliveryClient::deleteFleetPackageAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/delete_fleet_package.php
     *
     * @param DeleteFleetPackageRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFleetPackage(DeleteFleetPackageRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteFleetPackage', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Release.
     *
     * The async variant is {@see ConfigDeliveryClient::deleteReleaseAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/delete_release.php
     *
     * @param DeleteReleaseRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRelease(DeleteReleaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRelease', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ResourceBundle.
     *
     * The async variant is {@see ConfigDeliveryClient::deleteResourceBundleAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/delete_resource_bundle.php
     *
     * @param DeleteResourceBundleRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteResourceBundle(
        DeleteResourceBundleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteResourceBundle', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Variant.
     *
     * The async variant is {@see ConfigDeliveryClient::deleteVariantAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/delete_variant.php
     *
     * @param DeleteVariantRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVariant(DeleteVariantRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteVariant', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single FleetPackage.
     *
     * The async variant is {@see ConfigDeliveryClient::getFleetPackageAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/get_fleet_package.php
     *
     * @param GetFleetPackageRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FleetPackage
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFleetPackage(GetFleetPackageRequest $request, array $callOptions = []): FleetPackage
    {
        return $this->startApiCall('GetFleetPackage', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Release.
     *
     * The async variant is {@see ConfigDeliveryClient::getReleaseAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/get_release.php
     *
     * @param GetReleaseRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Release
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRelease(GetReleaseRequest $request, array $callOptions = []): Release
    {
        return $this->startApiCall('GetRelease', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ResourceBundle.
     *
     * The async variant is {@see ConfigDeliveryClient::getResourceBundleAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/get_resource_bundle.php
     *
     * @param GetResourceBundleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResourceBundle
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getResourceBundle(GetResourceBundleRequest $request, array $callOptions = []): ResourceBundle
    {
        return $this->startApiCall('GetResourceBundle', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Rollout.
     *
     * The async variant is {@see ConfigDeliveryClient::getRolloutAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/get_rollout.php
     *
     * @param GetRolloutRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rollout
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRollout(GetRolloutRequest $request, array $callOptions = []): Rollout
    {
        return $this->startApiCall('GetRollout', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Variant.
     *
     * The async variant is {@see ConfigDeliveryClient::getVariantAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/get_variant.php
     *
     * @param GetVariantRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Variant
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVariant(GetVariantRequest $request, array $callOptions = []): Variant
    {
        return $this->startApiCall('GetVariant', $request, $callOptions)->wait();
    }

    /**
     * Lists FleetPackages in a given project and location.
     *
     * The async variant is {@see ConfigDeliveryClient::listFleetPackagesAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/list_fleet_packages.php
     *
     * @param ListFleetPackagesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFleetPackages(ListFleetPackagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFleetPackages', $request, $callOptions);
    }

    /**
     * Lists Releases in a given project and location.
     *
     * The async variant is {@see ConfigDeliveryClient::listReleasesAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/list_releases.php
     *
     * @param ListReleasesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReleases(ListReleasesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReleases', $request, $callOptions);
    }

    /**
     * Lists ResourceBundles in a given project and location.
     *
     * The async variant is {@see ConfigDeliveryClient::listResourceBundlesAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/list_resource_bundles.php
     *
     * @param ListResourceBundlesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listResourceBundles(ListResourceBundlesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListResourceBundles', $request, $callOptions);
    }

    /**
     * Lists Rollouts in a given project, location, and Fleet Package.
     *
     * The async variant is {@see ConfigDeliveryClient::listRolloutsAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/list_rollouts.php
     *
     * @param ListRolloutsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRollouts(ListRolloutsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRollouts', $request, $callOptions);
    }

    /**
     * Lists Variants in a given project and location.
     *
     * The async variant is {@see ConfigDeliveryClient::listVariantsAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/list_variants.php
     *
     * @param ListVariantsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVariants(ListVariantsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVariants', $request, $callOptions);
    }

    /**
     * Resume a Rollout.
     *
     * The async variant is {@see ConfigDeliveryClient::resumeRolloutAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/resume_rollout.php
     *
     * @param ResumeRolloutRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Rollout>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeRollout(ResumeRolloutRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResumeRollout', $request, $callOptions)->wait();
    }

    /**
     * Suspend a Rollout.
     *
     * The async variant is {@see ConfigDeliveryClient::suspendRolloutAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/suspend_rollout.php
     *
     * @param SuspendRolloutRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Rollout>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function suspendRollout(SuspendRolloutRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SuspendRollout', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single FleetPackage.
     *
     * The async variant is {@see ConfigDeliveryClient::updateFleetPackageAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/update_fleet_package.php
     *
     * @param UpdateFleetPackageRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<FleetPackage>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFleetPackage(UpdateFleetPackageRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateFleetPackage', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Release.
     *
     * The async variant is {@see ConfigDeliveryClient::updateReleaseAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/update_release.php
     *
     * @param UpdateReleaseRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Release>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRelease(UpdateReleaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateRelease', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single ResourceBundle.
     *
     * The async variant is {@see ConfigDeliveryClient::updateResourceBundleAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/update_resource_bundle.php
     *
     * @param UpdateResourceBundleRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ResourceBundle>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateResourceBundle(
        UpdateResourceBundleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateResourceBundle', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Variant.
     *
     * The async variant is {@see ConfigDeliveryClient::updateVariantAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/update_variant.php
     *
     * @param UpdateVariantRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Variant>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVariant(UpdateVariantRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateVariant', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ConfigDeliveryClient::getLocationAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ConfigDeliveryClient::listLocationsAsync()} .
     *
     * @example samples/V1/ConfigDeliveryClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
