<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/confidentialcomputing/v1/service.proto

namespace Google\Cloud\ConfidentialComputing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request for an attestation token, providing all the necessary information
 * needed for this service to verify Confidential GKE platform state of the
 * requestor.
 *
 * Generated from protobuf message <code>google.cloud.confidentialcomputing.v1.VerifyConfidentialGkeRequest</code>
 */
class VerifyConfidentialGkeRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $challenge = '';
    protected $tee_attestation;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\ConfidentialComputing\V1\TpmAttestation $tpm_attestation
     *           The TPM-specific data provided by the attesting platform, used to
     *           populate any of the claims regarding platform state.
     *     @type string $challenge
     *           Required. The name of the Challenge whose nonce was used to generate the
     *           attestation, in the format projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;. The
     *           provided Challenge will be consumed, and cannot be used again.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Confidentialcomputing\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * The TPM-specific data provided by the attesting platform, used to
     * populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 2;</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\TpmAttestation|null
     */
    public function getTpmAttestation()
    {
        return $this->readOneof(2);
    }

    public function hasTpmAttestation()
    {
        return $this->hasOneof(2);
    }

    /**
     * The TPM-specific data provided by the attesting platform, used to
     * populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 2;</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\TpmAttestation $var
     * @return $this
     */
    public function setTpmAttestation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\TpmAttestation::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getChallenge()
    {
        return $this->challenge;
    }

    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setChallenge($var)
    {
        GPBUtil::checkString($var, True);
        $this->challenge = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeeAttestation()
    {
        return $this->whichOneof("tee_attestation");
    }

}

