<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Persistent Disk Snapshot resource. You can use snapshots to back up data on a regular interval. For more information, read Creating persistent disk snapshots.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Snapshot</code>
 */
class Snapshot extends \Google\Protobuf\Internal\Message
{
    /**
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     */
    protected $architecture = null;
    /**
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *
     * Generated from protobuf field <code>optional bool auto_created = 463922264;</code>
     */
    protected $auto_created = null;
    /**
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *
     * Generated from protobuf field <code>optional string chain_name = 68644169;</code>
     */
    protected $chain_name = null;
    /**
     * [Output Only] Size in bytes of the snapshot at creation time.
     *
     * Generated from protobuf field <code>optional int64 creation_size_bytes = 125400077;</code>
     */
    protected $creation_size_bytes = null;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    protected $creation_timestamp = null;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * [Output Only] Size of the source disk, specified in GB.
     *
     * Generated from protobuf field <code>optional int64 disk_size_gb = 316263735;</code>
     */
    protected $disk_size_gb = null;
    /**
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *
     * Generated from protobuf field <code>optional int64 download_bytes = 435054068;</code>
     */
    protected $download_bytes = null;
    /**
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     */
    protected $enable_confidential_compute = null;
    /**
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     *
     * Generated from protobuf field <code>optional bool guest_flush = 385550813;</code>
     */
    protected $guest_flush = null;
    /**
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    private $guest_os_features;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    protected $id = null;
    /**
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    protected $kind = null;
    /**
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     */
    protected $label_fingerprint = null;
    /**
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     */
    private $labels;
    /**
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     */
    private $license_codes;
    /**
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     */
    private $licenses;
    /**
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     */
    protected $location_hint = null;
    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SnapshotParams params = 78313862;</code>
     */
    protected $params = null;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     */
    protected $satisfies_pzi = null;
    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     */
    protected $satisfies_pzs = null;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    protected $self_link = null;
    /**
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;</code>
     */
    protected $snapshot_encryption_key = null;
    /**
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string snapshot_type = 124349653;</code>
     */
    protected $snapshot_type = null;
    /**
     * The source disk used to create this snapshot.
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     */
    protected $source_disk = null;
    /**
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;</code>
     */
    protected $source_disk_encryption_key = null;
    /**
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     *
     * Generated from protobuf field <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     */
    protected $source_disk_for_recovery_checkpoint = null;
    /**
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     */
    protected $source_disk_id = null;
    /**
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot = 219202054;</code>
     */
    protected $source_instant_snapshot = null;
    /**
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;</code>
     */
    protected $source_instant_snapshot_encryption_key = null;
    /**
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot_id = 287582708;</code>
     */
    protected $source_instant_snapshot_id = null;
    /**
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     *
     * Generated from protobuf field <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     */
    protected $source_snapshot_schedule_policy = null;
    /**
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     *
     * Generated from protobuf field <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     */
    protected $source_snapshot_schedule_policy_id = null;
    /**
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     */
    protected $status = null;
    /**
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *
     * Generated from protobuf field <code>optional int64 storage_bytes = 424631719;</code>
     */
    protected $storage_bytes = null;
    /**
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string storage_bytes_status = 490739082;</code>
     */
    protected $storage_bytes_status = null;
    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 328005274;</code>
     */
    private $storage_locations;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $architecture
     *           [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     *           Check the Architecture enum for the list of possible values.
     *     @type bool $auto_created
     *           [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *     @type string $chain_name
     *           Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *     @type int|string $creation_size_bytes
     *           [Output Only] Size in bytes of the snapshot at creation time.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type int|string $disk_size_gb
     *           [Output Only] Size of the source disk, specified in GB.
     *     @type int|string $download_bytes
     *           [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *     @type bool $enable_confidential_compute
     *           Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     *     @type bool $guest_flush
     *           [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     *     @type array<\Google\Cloud\Compute\V1\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $guest_os_features
     *           [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *     @type array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $license_codes
     *           [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $licenses
     *           [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *     @type string $location_hint
     *           An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     *     @type string $name
     *           Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type \Google\Cloud\Compute\V1\SnapshotParams $params
     *           Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use.
     *     @type bool $satisfies_pzs
     *           [Output Only] Reserved for future use.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $snapshot_encryption_key
     *           Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *     @type string $snapshot_type
     *           Indicates the type of the snapshot.
     *           Check the SnapshotType enum for the list of possible values.
     *     @type string $source_disk
     *           The source disk used to create this snapshot.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_disk_encryption_key
     *           The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *     @type string $source_disk_for_recovery_checkpoint
     *           The source disk whose recovery checkpoint will be used to create this snapshot.
     *     @type string $source_disk_id
     *           [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *     @type string $source_instant_snapshot
     *           The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_instant_snapshot_encryption_key
     *           Customer provided encryption key when creating Snapshot from Instant Snapshot.
     *     @type string $source_instant_snapshot_id
     *           [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     *     @type string $source_snapshot_schedule_policy
     *           [Output Only] URL of the resource policy which created this scheduled snapshot.
     *     @type string $source_snapshot_schedule_policy_id
     *           [Output Only] ID of the resource policy which created this scheduled snapshot.
     *     @type string $status
     *           [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     *           Check the Status enum for the list of possible values.
     *     @type int|string $storage_bytes
     *           [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *     @type string $storage_bytes_status
     *           [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     *           Check the StorageBytesStatus enum for the list of possible values.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $storage_locations
     *           Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     * @return string
     */
    public function getArchitecture()
    {
        return isset($this->architecture) ? $this->architecture : '';
    }

    public function hasArchitecture()
    {
        return isset($this->architecture);
    }

    public function clearArchitecture()
    {
        unset($this->architecture);
    }

    /**
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     * @param string $var
     * @return $this
     */
    public function setArchitecture($var)
    {
        GPBUtil::checkString($var, True);
        $this->architecture = $var;

        return $this;
    }

    /**
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *
     * Generated from protobuf field <code>optional bool auto_created = 463922264;</code>
     * @return bool
     */
    public function getAutoCreated()
    {
        return isset($this->auto_created) ? $this->auto_created : false;
    }

    public function hasAutoCreated()
    {
        return isset($this->auto_created);
    }

    public function clearAutoCreated()
    {
        unset($this->auto_created);
    }

    /**
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *
     * Generated from protobuf field <code>optional bool auto_created = 463922264;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoCreated($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_created = $var;

        return $this;
    }

    /**
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *
     * Generated from protobuf field <code>optional string chain_name = 68644169;</code>
     * @return string
     */
    public function getChainName()
    {
        return isset($this->chain_name) ? $this->chain_name : '';
    }

    public function hasChainName()
    {
        return isset($this->chain_name);
    }

    public function clearChainName()
    {
        unset($this->chain_name);
    }

    /**
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *
     * Generated from protobuf field <code>optional string chain_name = 68644169;</code>
     * @param string $var
     * @return $this
     */
    public function setChainName($var)
    {
        GPBUtil::checkString($var, True);
        $this->chain_name = $var;

        return $this;
    }

    /**
     * [Output Only] Size in bytes of the snapshot at creation time.
     *
     * Generated from protobuf field <code>optional int64 creation_size_bytes = 125400077;</code>
     * @return int|string
     */
    public function getCreationSizeBytes()
    {
        return isset($this->creation_size_bytes) ? $this->creation_size_bytes : 0;
    }

    public function hasCreationSizeBytes()
    {
        return isset($this->creation_size_bytes);
    }

    public function clearCreationSizeBytes()
    {
        unset($this->creation_size_bytes);
    }

    /**
     * [Output Only] Size in bytes of the snapshot at creation time.
     *
     * Generated from protobuf field <code>optional int64 creation_size_bytes = 125400077;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCreationSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->creation_size_bytes = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] Size of the source disk, specified in GB.
     *
     * Generated from protobuf field <code>optional int64 disk_size_gb = 316263735;</code>
     * @return int|string
     */
    public function getDiskSizeGb()
    {
        return isset($this->disk_size_gb) ? $this->disk_size_gb : 0;
    }

    public function hasDiskSizeGb()
    {
        return isset($this->disk_size_gb);
    }

    public function clearDiskSizeGb()
    {
        unset($this->disk_size_gb);
    }

    /**
     * [Output Only] Size of the source disk, specified in GB.
     *
     * Generated from protobuf field <code>optional int64 disk_size_gb = 316263735;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *
     * Generated from protobuf field <code>optional int64 download_bytes = 435054068;</code>
     * @return int|string
     */
    public function getDownloadBytes()
    {
        return isset($this->download_bytes) ? $this->download_bytes : 0;
    }

    public function hasDownloadBytes()
    {
        return isset($this->download_bytes);
    }

    public function clearDownloadBytes()
    {
        unset($this->download_bytes);
    }

    /**
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *
     * Generated from protobuf field <code>optional int64 download_bytes = 435054068;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDownloadBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->download_bytes = $var;

        return $this;
    }

    /**
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     * @return bool
     */
    public function getEnableConfidentialCompute()
    {
        return isset($this->enable_confidential_compute) ? $this->enable_confidential_compute : false;
    }

    public function hasEnableConfidentialCompute()
    {
        return isset($this->enable_confidential_compute);
    }

    public function clearEnableConfidentialCompute()
    {
        unset($this->enable_confidential_compute);
    }

    /**
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableConfidentialCompute($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_confidential_compute = $var;

        return $this;
    }

    /**
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     *
     * Generated from protobuf field <code>optional bool guest_flush = 385550813;</code>
     * @return bool
     */
    public function getGuestFlush()
    {
        return isset($this->guest_flush) ? $this->guest_flush : false;
    }

    public function hasGuestFlush()
    {
        return isset($this->guest_flush);
    }

    public function clearGuestFlush()
    {
        unset($this->guest_flush);
    }

    /**
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     *
     * Generated from protobuf field <code>optional bool guest_flush = 385550813;</code>
     * @param bool $var
     * @return $this
     */
    public function setGuestFlush($var)
    {
        GPBUtil::checkBool($var);
        $this->guest_flush = $var;

        return $this;
    }

    /**
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestOsFeatures()
    {
        return $this->guest_os_features;
    }

    /**
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @param array<\Google\Cloud\Compute\V1\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestOsFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\GuestOsFeature::class);
        $this->guest_os_features = $arr;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return isset($this->label_fingerprint) ? $this->label_fingerprint : '';
    }

    public function hasLabelFingerprint()
    {
        return isset($this->label_fingerprint);
    }

    public function clearLabelFingerprint()
    {
        unset($this->label_fingerprint);
    }

    /**
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenseCodes()
    {
        return $this->license_codes;
    }

    /**
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     * @param array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenseCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT64);
        $this->license_codes = $arr;

        return $this;
    }

    /**
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     * @return string
     */
    public function getLocationHint()
    {
        return isset($this->location_hint) ? $this->location_hint : '';
    }

    public function hasLocationHint()
    {
        return isset($this->location_hint);
    }

    public function clearLocationHint()
    {
        unset($this->location_hint);
    }

    /**
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     * @param string $var
     * @return $this
     */
    public function setLocationHint($var)
    {
        GPBUtil::checkString($var, True);
        $this->location_hint = $var;

        return $this;
    }

    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SnapshotParams params = 78313862;</code>
     * @return \Google\Cloud\Compute\V1\SnapshotParams|null
     */
    public function getParams()
    {
        return $this->params;
    }

    public function hasParams()
    {
        return isset($this->params);
    }

    public function clearParams()
    {
        unset($this->params);
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SnapshotParams params = 78313862;</code>
     * @param \Google\Cloud\Compute\V1\SnapshotParams $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\SnapshotParams::class);
        $this->params = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSnapshotEncryptionKey()
    {
        return $this->snapshot_encryption_key;
    }

    public function hasSnapshotEncryptionKey()
    {
        return isset($this->snapshot_encryption_key);
    }

    public function clearSnapshotEncryptionKey()
    {
        unset($this->snapshot_encryption_key);
    }

    /**
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->snapshot_encryption_key = $var;

        return $this;
    }

    /**
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string snapshot_type = 124349653;</code>
     * @return string
     */
    public function getSnapshotType()
    {
        return isset($this->snapshot_type) ? $this->snapshot_type : '';
    }

    public function hasSnapshotType()
    {
        return isset($this->snapshot_type);
    }

    public function clearSnapshotType()
    {
        unset($this->snapshot_type);
    }

    /**
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string snapshot_type = 124349653;</code>
     * @param string $var
     * @return $this
     */
    public function setSnapshotType($var)
    {
        GPBUtil::checkString($var, True);
        $this->snapshot_type = $var;

        return $this;
    }

    /**
     * The source disk used to create this snapshot.
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     * @return string
     */
    public function getSourceDisk()
    {
        return isset($this->source_disk) ? $this->source_disk : '';
    }

    public function hasSourceDisk()
    {
        return isset($this->source_disk);
    }

    public function clearSourceDisk()
    {
        unset($this->source_disk);
    }

    /**
     * The source disk used to create this snapshot.
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDisk($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceDiskEncryptionKey()
    {
        return $this->source_disk_encryption_key;
    }

    public function hasSourceDiskEncryptionKey()
    {
        return isset($this->source_disk_encryption_key);
    }

    public function clearSourceDiskEncryptionKey()
    {
        unset($this->source_disk_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceDiskEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_disk_encryption_key = $var;

        return $this;
    }

    /**
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     *
     * Generated from protobuf field <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     * @return string
     */
    public function getSourceDiskForRecoveryCheckpoint()
    {
        return isset($this->source_disk_for_recovery_checkpoint) ? $this->source_disk_for_recovery_checkpoint : '';
    }

    public function hasSourceDiskForRecoveryCheckpoint()
    {
        return isset($this->source_disk_for_recovery_checkpoint);
    }

    public function clearSourceDiskForRecoveryCheckpoint()
    {
        unset($this->source_disk_for_recovery_checkpoint);
    }

    /**
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     *
     * Generated from protobuf field <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDiskForRecoveryCheckpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk_for_recovery_checkpoint = $var;

        return $this;
    }

    /**
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     * @return string
     */
    public function getSourceDiskId()
    {
        return isset($this->source_disk_id) ? $this->source_disk_id : '';
    }

    public function hasSourceDiskId()
    {
        return isset($this->source_disk_id);
    }

    public function clearSourceDiskId()
    {
        unset($this->source_disk_id);
    }

    /**
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDiskId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk_id = $var;

        return $this;
    }

    /**
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot = 219202054;</code>
     * @return string
     */
    public function getSourceInstantSnapshot()
    {
        return isset($this->source_instant_snapshot) ? $this->source_instant_snapshot : '';
    }

    public function hasSourceInstantSnapshot()
    {
        return isset($this->source_instant_snapshot);
    }

    public function clearSourceInstantSnapshot()
    {
        unset($this->source_instant_snapshot);
    }

    /**
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot = 219202054;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceInstantSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_instant_snapshot = $var;

        return $this;
    }

    /**
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceInstantSnapshotEncryptionKey()
    {
        return $this->source_instant_snapshot_encryption_key;
    }

    public function hasSourceInstantSnapshotEncryptionKey()
    {
        return isset($this->source_instant_snapshot_encryption_key);
    }

    public function clearSourceInstantSnapshotEncryptionKey()
    {
        unset($this->source_instant_snapshot_encryption_key);
    }

    /**
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceInstantSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_instant_snapshot_encryption_key = $var;

        return $this;
    }

    /**
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot_id = 287582708;</code>
     * @return string
     */
    public function getSourceInstantSnapshotId()
    {
        return isset($this->source_instant_snapshot_id) ? $this->source_instant_snapshot_id : '';
    }

    public function hasSourceInstantSnapshotId()
    {
        return isset($this->source_instant_snapshot_id);
    }

    public function clearSourceInstantSnapshotId()
    {
        unset($this->source_instant_snapshot_id);
    }

    /**
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot_id = 287582708;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceInstantSnapshotId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_instant_snapshot_id = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     *
     * Generated from protobuf field <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     * @return string
     */
    public function getSourceSnapshotSchedulePolicy()
    {
        return isset($this->source_snapshot_schedule_policy) ? $this->source_snapshot_schedule_policy : '';
    }

    public function hasSourceSnapshotSchedulePolicy()
    {
        return isset($this->source_snapshot_schedule_policy);
    }

    public function clearSourceSnapshotSchedulePolicy()
    {
        unset($this->source_snapshot_schedule_policy);
    }

    /**
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     *
     * Generated from protobuf field <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshotSchedulePolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot_schedule_policy = $var;

        return $this;
    }

    /**
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     *
     * Generated from protobuf field <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     * @return string
     */
    public function getSourceSnapshotSchedulePolicyId()
    {
        return isset($this->source_snapshot_schedule_policy_id) ? $this->source_snapshot_schedule_policy_id : '';
    }

    public function hasSourceSnapshotSchedulePolicyId()
    {
        return isset($this->source_snapshot_schedule_policy_id);
    }

    public function clearSourceSnapshotSchedulePolicyId()
    {
        unset($this->source_snapshot_schedule_policy_id);
    }

    /**
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     *
     * Generated from protobuf field <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshotSchedulePolicyId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot_schedule_policy_id = $var;

        return $this;
    }

    /**
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @return string
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : '';
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @param string $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->status = $var;

        return $this;
    }

    /**
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *
     * Generated from protobuf field <code>optional int64 storage_bytes = 424631719;</code>
     * @return int|string
     */
    public function getStorageBytes()
    {
        return isset($this->storage_bytes) ? $this->storage_bytes : 0;
    }

    public function hasStorageBytes()
    {
        return isset($this->storage_bytes);
    }

    public function clearStorageBytes()
    {
        unset($this->storage_bytes);
    }

    /**
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *
     * Generated from protobuf field <code>optional int64 storage_bytes = 424631719;</code>
     * @param int|string $var
     * @return $this
     */
    public function setStorageBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->storage_bytes = $var;

        return $this;
    }

    /**
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string storage_bytes_status = 490739082;</code>
     * @return string
     */
    public function getStorageBytesStatus()
    {
        return isset($this->storage_bytes_status) ? $this->storage_bytes_status : '';
    }

    public function hasStorageBytesStatus()
    {
        return isset($this->storage_bytes_status);
    }

    public function clearStorageBytesStatus()
    {
        unset($this->storage_bytes_status);
    }

    /**
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string storage_bytes_status = 490739082;</code>
     * @param string $var
     * @return $this
     */
    public function setStorageBytesStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->storage_bytes_status = $var;

        return $this;
    }

    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 328005274;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStorageLocations()
    {
        return $this->storage_locations;
    }

    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 328005274;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStorageLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->storage_locations = $arr;

        return $this;
    }

}

